/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.config.ConfigVars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class Matcher {
    private static final int MIN_MATCH_PERCENTAGE = 70;
    private final ArrayList<String> bestMatchList = new ArrayList();
    private int[] stack = new int[32];
    private int stackIndex = 0;
    private int maxConsecutiveMatch = 0;
    private int maxTotalMatch = 0;
    private int minTotalMatch;
    private int currentTotalMatch;
    private int currentConsecutiveMatch;
    private int minMatchPercent;

    public String getBestMatch(CMNamedNodeMap map, String name, List<String> excludeList) {
        return this.getBestMatch(map, name, excludeList, 70);
    }

    public String getBestMatch(CMNamedNodeMap map, String name, List<String> excludeList, int minMatchPercent) {
        CMNode node;
        String choice;
        if (map == null || name == null) {
            return null;
        }
        this.minMatchPercent = minMatchPercent;
        this.reset();
        for (int i = 0; i < map.getLength() && this.match(name, choice = (node = map.item(i)).getNodeName()) != MatchStatus.EXACT_MATCH; ++i) {
        }
        return this.getBestMatchString(excludeList);
    }

    public String getBestMatch(ConfigVars vars, String toMatch, String type) {
        List<String> choiceList = vars.getSortedVars(type, true);
        return this.getBestMatch(choiceList, toMatch, null, 70);
    }

    public String getBestMatch(ConfigVars vars, String toMatch, String type, int minMatchPercent) {
        List<String> choiceList = vars.getSortedVars(type, true);
        return this.getBestMatch(choiceList, toMatch, null, minMatchPercent);
    }

    public String getBestMatch(Collection<String> choices, String toMatch, List<String> excludeList) {
        return this.getBestMatch(choices, toMatch, excludeList, 70);
    }

    public String getBestMatch(Collection<String> choices, String toMatch, List<String> excludeList, int minMatchPercent) {
        if (choices == null || choices.size() == 0 || toMatch == null) {
            return null;
        }
        this.minMatchPercent = minMatchPercent;
        this.reset();
        for (String choice : choices) {
            if (this.match(toMatch, choice) == MatchStatus.EXACT_MATCH) break;
        }
        return this.getBestMatchString(excludeList);
    }

    private void reset() {
        this.bestMatchList.clear();
        this.maxConsecutiveMatch = 0;
        this.maxTotalMatch = 0;
    }

    private String getBestMatchString(List<String> excludeList) {
        if (excludeList != null && !excludeList.isEmpty()) {
            this.bestMatchList.removeAll(excludeList);
        }
        if (this.bestMatchList.size() == 0) {
            return null;
        }
        if (this.bestMatchList.size() == 1) {
            return this.bestMatchList.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.bestMatchList.get(0));
        for (int i = 1; i < this.bestMatchList.size(); ++i) {
            sb.append(',');
            sb.append(this.bestMatchList.get(i));
        }
        return sb.toString();
    }

    private MatchStatus match(String toMatch, String choice) {
        int len2;
        int len1 = toMatch.length();
        if (!this.boundaryMatch(len1, len2 = choice.length())) {
            return MatchStatus.NO_MATCH;
        }
        int offset1 = 0;
        int offset2 = 0;
        int totalMatch = 0;
        int consecutiveMatch = 0;
        this.resetState(len1 > len2 ? len1 : len2);
        while (true) {
            boolean toBacktrack = true;
            for (int i = offset2; offset1 < len1 && i < len2 && this.currentTotalMatch <= totalMatch + len1 - offset1; ++i) {
                if (this.matchChar(toMatch.charAt(offset1), choice.charAt(i))) {
                    ++offset1;
                    ++totalMatch;
                    ++consecutiveMatch;
                    toBacktrack = true;
                    continue;
                }
                if (!toBacktrack) continue;
                toBacktrack = false;
                if (this.currentTotalMatch > totalMatch + len1 - offset1 - 1) continue;
                if (consecutiveMatch > this.currentConsecutiveMatch) {
                    this.currentConsecutiveMatch = consecutiveMatch;
                }
                consecutiveMatch = 0;
                this.ensureStackCapacity(3);
                this.stack[this.stackIndex++] = offset1 + 1;
                this.stack[this.stackIndex++] = i;
                this.stack[this.stackIndex++] = totalMatch;
            }
            if (totalMatch > this.currentTotalMatch) {
                this.currentTotalMatch = totalMatch;
            }
            if (consecutiveMatch > this.currentConsecutiveMatch) {
                this.currentConsecutiveMatch = consecutiveMatch;
            }
            if (this.stackIndex == 0) break;
            totalMatch = this.stack[--this.stackIndex];
            offset2 = this.stack[--this.stackIndex];
            offset1 = this.stack[--this.stackIndex];
        }
        return this.checkMatch(choice);
    }

    private void resetState(int length) {
        this.stackIndex = 0;
        this.currentTotalMatch = 0;
        this.currentConsecutiveMatch = 0;
        this.minTotalMatch = this.getMinimumMatch(length);
    }

    private MatchStatus checkMatch(String choice) {
        if (this.currentTotalMatch < this.minTotalMatch || this.currentTotalMatch < this.maxTotalMatch || this.currentTotalMatch == this.maxTotalMatch && this.currentConsecutiveMatch < this.maxConsecutiveMatch) {
            return MatchStatus.NO_MATCH;
        }
        if (this.currentTotalMatch > this.maxTotalMatch || this.currentConsecutiveMatch > this.maxConsecutiveMatch) {
            this.bestMatchList.clear();
            this.maxTotalMatch = this.currentTotalMatch;
            this.maxConsecutiveMatch = this.currentConsecutiveMatch;
        }
        this.bestMatchList.add(choice);
        if (this.maxTotalMatch == choice.length()) {
            return MatchStatus.EXACT_MATCH;
        }
        return MatchStatus.BEST_MATCH;
    }

    private boolean matchChar(int c1, int c2) {
        char uc2;
        if (c1 == c2) {
            return true;
        }
        if (c1 > 65535 || c2 > 65535) {
            return false;
        }
        char uc1 = Character.toUpperCase((char)c1);
        if (uc1 == (uc2 = Character.toUpperCase((char)c2))) {
            return true;
        }
        return Character.toLowerCase(uc1) == Character.toLowerCase(uc2);
    }

    private int getMinimumMatch(int length) {
        int value = length * this.minMatchPercent;
        int count = value / 100;
        if (value % 100 > 0) {
            ++count;
        }
        return count;
    }

    private boolean boundaryMatch(int toMatchLen, int choiceLen) {
        if (toMatchLen * 100 < choiceLen * this.minMatchPercent) {
            return false;
        }
        return toMatchLen * this.minMatchPercent <= choiceLen * 100;
    }

    private void ensureStackCapacity(int count) {
        if (this.stackIndex + count > this.stack.length) {
            int newLen = this.stack.length << 1;
            int[] newStack = new int[newLen];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackIndex);
            this.stack = newStack;
        }
    }

    private static enum MatchStatus {
        NO_MATCH,
        BEST_MATCH,
        EXACT_MATCH;

    }
}

