/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.IncludeConflictResolution;
import com.ibm.ws.st.core.internal.config.validation.ValidationContext;
import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;

public class DOMValidationContext
extends ValidationContext {
    private final Document document;
    private final IResource resource;
    private final WebSphereServerInfo server;
    private final UserDirectory userDirectory;

    public DOMValidationContext(Document document, IResource resource, WebSphereServerInfo server, UserDirectory userDirectory, ValidationContext parent, IncludeConflictResolution conflictResolution) {
        super(parent, conflictResolution);
        this.document = document;
        this.resource = resource;
        this.server = server;
        this.userDirectory = userDirectory;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public URI getURI() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getLocation().toFile().toURI();
    }

    @Override
    public WebSphereServerInfo getServer() {
        return this.server;
    }

    @Override
    public UserDirectory getUserDirectory() {
        return this.userDirectory;
    }

    @Override
    public ConfigurationFile getConfigFile() {
        if (this.resource == null) {
            return null;
        }
        return ConfigUtils.getConfigFile(this.resource);
    }

    public String toString() {
        return "DOM Validation Context: " + this.getURI();
    }
}

