/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.IncludeConflictResolution;
import com.ibm.ws.st.core.internal.config.validation.ValidationContext;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class DOMModelValidationContext
extends ValidationContext {
    private final IDOMModel domModel;
    private final IFile resource;
    private final WebSphereServerInfo server;
    private final UserDirectory userDirectory;

    public DOMModelValidationContext(IFile resource, WebSphereServerInfo server, UserDirectory userDirectory, ValidationContext parent, IncludeConflictResolution conflictResolution) throws Exception {
        super(parent, conflictResolution);
        this.resource = resource;
        this.server = server;
        this.userDirectory = userDirectory;
        this.domModel = this.getDOMModel(resource);
        if (this.domModel == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", "Failed to create DOMModel."));
        }
    }

    @Override
    public Document getDocument() {
        return this.domModel.getDocument();
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public URI getURI() {
        return this.resource.getLocation().toFile().toURI();
    }

    @Override
    public WebSphereServerInfo getServer() {
        return this.server;
    }

    @Override
    public UserDirectory getUserDirectory() {
        return this.userDirectory;
    }

    @Override
    public ConfigurationFile getConfigFile() {
        ConfigurationFile configFile;
        block3: {
            configFile = ConfigUtils.getConfigFile((IResource)this.resource);
            if (configFile == null) {
                try {
                    WebSphereServerInfo wsInfo = ConfigUtils.getServer(this.resource.getLocationURI());
                    configFile = wsInfo != null ? wsInfo.getConfigRoot() : new ConfigurationFile(this.resource.getLocationURI(), this.userDirectory);
                }
                catch (IOException e) {
                    if (!Trace.ENABLED) break block3;
                    Trace.trace((byte)1, "Could not create configuration file: " + this.resource.getLocationURI());
                }
            }
        }
        return configFile;
    }

    @Override
    public void dispose() {
        this.domModel.releaseFromRead();
    }

    private IDOMModel getDOMModel(IFile file) throws Exception {
        IModelManager manager = StructuredModelManager.getModelManager();
        IStructuredModel model = manager.getExistingModelForRead(file);
        if (model == null) {
            model = manager.getModelForRead(file);
        }
        if (model == null || !(model instanceof IDOMModel)) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Validation failed. Unable to create DOM Model");
            }
            return null;
        }
        return (IDOMModel)model;
    }

    public String toString() {
        return "DOM Model Validation Context: " + this.getURI();
    }
}

