/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.validation.ICustomServerVariablesHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class CustomServerVariablesManager {
    private static final String EXTENSION_ID = "com.ibm.ws.st.core.customServerVariables";
    private static final String HANDLER_ELEMENT = "handler";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final CustomServerVariablesManager customServerVariablesManager = new CustomServerVariablesManager();
    private final List<ICustomServerVariablesHandler> handlers = new ArrayList<ICustomServerVariablesHandler>();

    private CustomServerVariablesManager() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement configurationElement = extensions[i];
            if (!HANDLER_ELEMENT.equals(configurationElement.getName())) continue;
            try {
                Object object = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                this.handlers.add((ICustomServerVariablesHandler)object);
                continue;
            }
            catch (Exception exception) {
                Trace.logError((String)"Error while creating custom server variables extension.", (Throwable)exception);
            }
        }
    }

    public static CustomServerVariablesManager getInstance() {
        return customServerVariablesManager;
    }

    public void addCustomServerVariables(ConfigVars globalVars, IProject project) {
        for (ICustomServerVariablesHandler customServerVariablesHandler : this.handlers) {
            customServerVariablesHandler.addCustomServerVariables(globalVars, project);
        }
    }

    public void addCustomServerVariables(ConfigVars globalVars, WebSphereServerInfo wsInfo) {
        for (ICustomServerVariablesHandler customServerVariablesHandler : this.handlers) {
            customServerVariablesHandler.addCustomServerVariables(globalVars, wsInfo);
        }
    }
}

