/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.core.internal.config.validation.AbstractConfigurationValidator;
import com.ibm.ws.st.core.internal.config.validation.AbstractTextFileParser;
import com.ibm.ws.st.core.internal.config.validation.BootstrapPropsValidator;
import com.ibm.ws.st.core.internal.config.validation.JVMOptionsValidator;
import com.ibm.ws.st.core.internal.config.validation.ResourceConfigurationValidator;
import com.ibm.ws.st.core.internal.config.validation.ServerEnvValidator;
import java.io.EOFException;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;

public class ConfigurationValidator
extends AbstractValidator {
    public static final String MARKER_TYPE = "com.ibm.ws.st.core.configmarker";
    private static final ValidationResult EMPTY_RESULT = new ValidationResult();
    private static final String[] CONTENT_TYPES = new String[]{"bootstrap.properties", "server.env", "jvm.options"};

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        WebSphereServerInfo[] servers;
        IFile file;
        block19: {
            if (!(resource instanceof IFile)) {
                return EMPTY_RESULT;
            }
            file = (IFile)resource;
            try {
                file.deleteMarkers(MARKER_TYPE, true, 2);
            }
            catch (CoreException e) {
                Trace.logError("Error removing markers", e);
            }
            IPath fileLocation = file.getLocation();
            IPath fileFullPath = file.getFullPath();
            for (WebSphereRuntime runtime : WebSphereUtil.getWebSphereRuntimes()) {
                IPath runtimeLocation = runtime.getRuntimeLocation();
                if (!runtimeLocation.append("templates").isPrefixOf(fileLocation)) continue;
                return EMPTY_RESULT;
            }
            boolean hasTemplates = fileFullPath.toString().contains("templates");
            if (hasTemplates) {
                for (IContainer parent = file.getParent(); parent != null; parent = parent.getParent()) {
                    boolean validLocation;
                    if (!"templates".equals(parent.getName())) continue;
                    IContainer parentOfTemplates = parent.getParent();
                    if (parentOfTemplates == null || !(validLocation = WebSphereRuntime.isValidLocation(parentOfTemplates.getLocation()))) break;
                    return EMPTY_RESULT;
                }
            }
            String contentType = null;
            try {
                IContentDescription contentDesc = file.getContentDescription();
                contentType = contentDesc.getContentType().getId();
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.logError("Could not determine content type", e);
                }
                return EMPTY_RESULT;
            }
            try {
                AbstractTextFileParser parser = null;
                if (CONTENT_TYPES[0].equals(contentType)) {
                    parser = new BootstrapPropsValidator(file);
                } else if (CONTENT_TYPES[1].equals(contentType)) {
                    parser = new ServerEnvValidator(file);
                } else if (CONTENT_TYPES[2].equals(contentType)) {
                    parser = new JVMOptionsValidator(file);
                }
                if (parser != null) {
                    ValidationResult result = new ValidationResult();
                    parser.parse(result, monitor);
                    result.setValidated(new IResource[]{file});
                    return result;
                }
            }
            catch (EOFException parser) {
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block19;
                Trace.logError("Error validating file", e);
            }
        }
        ResourceConfigurationValidator validator = new ResourceConfigurationValidator();
        validator.validate((IResource)file);
        ValidationResult valResult = validator.getValidationResult();
        URI uri = file.getLocationURI();
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
            if (configFile == null) continue;
            this.updateResultDependencies(configFile, valResult, server);
            if (server.getConfigRoot() != configFile) break;
            this.checkPublishedApps(file, configFile, server);
            break;
        }
        return valResult;
    }

    private void updateResultDependencies(ConfigurationFile configFile, ValidationResult valResult, WebSphereServerInfo serverInfo) {
        ConfigurationFile[] includes = configFile.getAllIncludedFiles();
        String[] unresolvedIncludes = configFile.getAllUnresolvedIncludes();
        ArrayList<Object> resourceList = new ArrayList<Object>(4);
        if (includes.length > 0) {
            for (ConfigurationFile cf : includes) {
                IFile file = cf.getIFile();
                if (file == null) continue;
                resourceList.add(file);
            }
        }
        if (serverInfo != null) {
            ExtendedConfigFile serverEnv;
            Bootstrap bootstrap = serverInfo.getBootstrap();
            if (bootstrap != null && bootstrap.getIFile() != null) {
                resourceList.add(bootstrap.getIFile());
            }
            if ((serverEnv = serverInfo.getServerEnv()) != null && serverEnv.getIFile() != null) {
                resourceList.add(serverEnv.getIFile());
            }
        }
        if (unresolvedIncludes.length > 0) {
            URI baseURI = configFile.getURI();
            if (serverInfo != null) {
                ConfigVars vars = new ConfigVars();
                serverInfo.getVariables(vars);
                for (String include : unresolvedIncludes) {
                    IFile file;
                    URI resolvedURI = this.resolveURI(baseURI, include, vars);
                    if (resolvedURI == null || (file = serverInfo.getIFile(resolvedURI)) == null) continue;
                    resourceList.add(file);
                }
            }
        }
        if (serverInfo != null) {
            IFolder dropinsFolder = serverInfo.getConfigDefaultDropinsFolder();
            if (dropinsFolder != null) {
                resourceList.add(dropinsFolder);
            }
            if ((dropinsFolder = serverInfo.getConfigOverrideDropinsFolder()) != null) {
                resourceList.add(dropinsFolder);
            }
        }
        if (resourceList.size() > 0) {
            IResource[] dependsOn = resourceList.toArray(new IResource[resourceList.size()]);
            valResult.setDependsOn(dependsOn);
        }
    }

    private URI resolveURI(URI baseURI, String location, ConfigVars vars) {
        String resolvedLocation = vars.resolve(location);
        File f = new File(resolvedLocation);
        if (!f.isAbsolute()) {
            try {
                URI result = baseURI.resolve(resolvedLocation);
                return result;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return f.toURI();
    }

    private void checkPublishedApps(IFile file, ConfigurationFile configFile, WebSphereServerInfo serverInfo) {
        WebSphereServer server = WebSphereUtil.getWebSphereServer(serverInfo);
        if (server != null) {
            IModule[] modules = server.getServer().getModules();
            WebSphereServerBehaviour wsBehaviour = server.getWebSphereServerBehaviour();
            if (wsBehaviour == null) {
                return;
            }
            for (IModule m : modules) {
                OutOfSyncModuleInfo info;
                if (m.isExternal() || (info = wsBehaviour.checkModuleConfigOutOfSync(m)) == null) continue;
                this.createOutOfSyncMarker(file, m, info.getType());
            }
        }
    }

    protected static ValidatorMessage createMessage(IFile file, String message, int lineNum, int start, int end) {
        ValidatorMessage vm = ValidatorMessage.create((String)message, (IResource)file);
        vm.setType(MARKER_TYPE);
        vm.setAttribute("severity", 2);
        vm.setAttribute("lineNumber", lineNum);
        if (start >= 0) {
            vm.setAttribute("charStart", start + 1);
            vm.setAttribute("charEnd", end + 1);
        }
        return vm;
    }

    protected static ValidatorMessage createInvalidWhitespaceMessage(IFile file, int lineNum, int start, int end) {
        ValidatorMessage vm = ValidatorMessage.create((String)Messages.invalidWhitespace, (IResource)file);
        vm.setType(MARKER_TYPE);
        vm.setAttribute("severity", 2);
        vm.setAttribute("lineNumber", lineNum);
        if (start >= 0) {
            vm.setAttribute("charStart", start + 1);
            vm.setAttribute("charEnd", end + 1);
        }
        vm.setAttribute("quickFixTypeAttr", AbstractConfigurationValidator.QuickFixType.INVALID_WHITESPACE.ordinal());
        return vm;
    }

    private void createOutOfSyncMarker(IFile file, IModule module, OutOfSyncModuleInfo.Type type) {
        block4: {
            try {
                String label = type == OutOfSyncModuleInfo.Type.SHARED_LIB_ENTRY_MISSING ? Messages.sharedLibraryLabel : Messages.applicationLabel;
                IMarker marker = file.createMarker(MARKER_TYPE);
                marker.setAttribute("severity", 1);
                marker.setAttribute("lineNumber", 1);
                if (type == OutOfSyncModuleInfo.Type.SHARED_LIB_REF_MISMATCH) {
                    marker.setAttribute("message", (Object)NLS.bind((String)Messages.publishedModuleSharedLibRefMismatchInConfig, (Object[])new String[]{module.getName(), label}));
                    marker.setAttribute("quickFixTypeAttr", AbstractConfigurationValidator.QuickFixType.OUT_OF_SYNC_SHARED_LIB_REF_MISMATCH.ordinal());
                } else {
                    marker.setAttribute("message", (Object)NLS.bind((String)Messages.publishedModuleNotInConfig, (Object[])new String[]{module.getName(), label}));
                    marker.setAttribute("quickFixTypeAttr", AbstractConfigurationValidator.QuickFixType.OUT_OF_SYNC_APP.ordinal());
                }
                marker.setAttribute("applicationName", (Object)module.getName());
            }
            catch (CoreException ce) {
                if (!Trace.ENABLED) break block4;
                Trace.logError("Failed to create a configuration marker for application element: " + module.getName(), ce);
            }
        }
    }
}

