/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.IncludeConflictResolution;
import com.ibm.ws.st.core.internal.config.validation.ValidationContext;
import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;

public class ConfigFileValidationContext
extends ValidationContext {
    private final ConfigurationFile configFile;

    public ConfigFileValidationContext(ConfigurationFile configFile, ValidationContext parent, IncludeConflictResolution conflictResolution) {
        super(parent, conflictResolution);
        this.configFile = configFile;
    }

    @Override
    public Document getDocument() {
        return this.configFile.getDomDocument();
    }

    @Override
    public IResource getResource() {
        return this.configFile.getIFile();
    }

    @Override
    public URI getURI() {
        return URIUtil.getCanonicalURI(this.configFile.getURI());
    }

    @Override
    public WebSphereServerInfo getServer() {
        return this.configFile.getWebSphereServer();
    }

    @Override
    public UserDirectory getUserDirectory() {
        return this.configFile.getUserDirectory();
    }

    @Override
    public ConfigurationFile getConfigFile() {
        return this.configFile;
    }

    public String toString() {
        return "Configuration File Validation Context: " + this.getURI();
    }
}

