/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.config.validation.FilterItem;
import com.ibm.ws.st.core.internal.config.validation.MatchFilterItem;
import java.util.HashSet;

public class ConfigFileFilterItem
implements FilterItem {
    private final FilterItem parent;
    private final String path;
    private final HashSet<MatchFilterItem> children = new HashSet();

    protected ConfigFileFilterItem(FilterItem parent, String path) {
        this.parent = parent;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    protected MatchFilterItem[] getMatchItems() {
        MatchFilterItem[] items = new MatchFilterItem[this.children.size()];
        return this.children.toArray(items);
    }

    protected void addMatchItem(MatchFilterItem item) {
        this.children.add(item);
    }

    protected boolean removeMatchItem(MatchFilterItem item) {
        return this.children.remove(item);
    }

    protected void removeAllChildren() {
        this.children.clear();
    }

    protected boolean containsMatchItem(MatchFilterItem item) {
        return this.children.contains(item);
    }

    @Override
    public FilterItem getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public Object[] getChildren() {
        return this.children.toArray();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConfigFileFilterItem)) {
            return false;
        }
        return this.path.equals(((ConfigFileFilterItem)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

