/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class URILocation {
    private final URI uri;

    public URILocation(URI uri) {
        this.uri = uri;
    }

    public String getLocationString() {
        IResource resource = this.getResource();
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        File file = new File(this.uri);
        return file.getAbsolutePath();
    }

    public URI getURI() {
        return this.uri;
    }

    public IResource getResource() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(this.uri);
        if (files.length > 0 && files[0].exists()) {
            return files[0];
        }
        IContainer[] containers = root.findContainersForLocationURI(this.uri);
        if (containers.length > 0 && containers[0].exists()) {
            return containers[0];
        }
        return null;
    }
}

