/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.FeatureUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.generation.Feature;
import com.ibm.ws.st.core.internal.generation.FeatureListCoreMetadata;
import com.ibm.ws.st.core.internal.generation.FeatureListExtMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureList {
    public static boolean isValidFeature(String feature, WebSphereRuntime wsRuntime) {
        return FeatureList.getFeature(feature, wsRuntime) != null;
    }

    public static String getCanonicalFeatureName(String featureName, WebSphereRuntime wsRuntime) {
        Feature feature = FeatureList.getFeature(featureName, wsRuntime);
        if (feature != null) {
            return feature.getName();
        }
        return null;
    }

    public static List<String> getCanonicalFeatures(List<String> features, WebSphereRuntime wsRuntime) {
        if (wsRuntime == null) {
            return features;
        }
        HashMap<String, Feature> featureMap = FeatureList.getFeatureMap(wsRuntime);
        ArrayList<String> canonicalFeatures = new ArrayList<String>();
        for (String feature : features) {
            String featureName = feature;
            Feature featureObj = FeatureList.getFeature(featureName, featureMap);
            if (featureObj != null) {
                featureName = featureObj.getName();
            }
            if (canonicalFeatures.contains(featureName)) continue;
            canonicalFeatures.add(featureName);
        }
        return canonicalFeatures;
    }

    public static List<String> getFeatures(boolean sort, WebSphereRuntime wsRuntime) {
        Set<String> features = FeatureList.getRuntimeFeatureSet(wsRuntime);
        ArrayList<String> featureList = new ArrayList<String>(features.size());
        featureList.addAll(features);
        if (sort) {
            Collections.sort(featureList);
        }
        return featureList;
    }

    public static List<String> getSymbolicNameFeatures(boolean sort, WebSphereRuntime wsRuntime) {
        Collection<Feature> features = FeatureList.getFeatureMap(wsRuntime).values();
        ArrayList<String> featureList = new ArrayList<String>(features.size());
        for (Feature f : features) {
            if (f.getSymbolicName() == null) continue;
            featureList.add(f.getSymbolicName());
        }
        if (sort) {
            Collections.sort(featureList);
        }
        return featureList;
    }

    public static Set<String> getRuntimeFeatureSet(WebSphereRuntime wsRuntime) {
        return FeatureList.getFeatureMap(wsRuntime).keySet();
    }

    public static Set<String> getFeatureChildren(String feature, WebSphereRuntime wsRuntime) {
        HashSet<String> children = new HashSet<String>();
        HashMap<String, Feature> map = FeatureList.getFeatureMap(wsRuntime);
        FeatureList.getFeatureChildren(children, feature, map);
        return children;
    }

    private static void getFeatureChildren(Set<String> set, String featureName, HashMap<String, Feature> map) {
        Feature f = FeatureList.getFeature(featureName, map);
        if (f == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unrecognized feature:" + featureName);
            }
            return;
        }
        Set<String> children = f.getEnables();
        if (children != null) {
            for (String child : children) {
                if (FeatureList.containsIgnoreCase(set, child) || featureName.equalsIgnoreCase(child)) continue;
                set.add(child);
                FeatureList.getFeatureChildren(set, child, map);
            }
        }
    }

    public static String getFeatureDisplayName(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        return f == null ? null : f.getDisplayName();
    }

    public static String getFeatureDescription(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        return f == null ? null : f.getDescription();
    }

    public static boolean isFeatureSuperseded(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        return f == null ? false : f.isSuperseded();
    }

    public static Set<String> getFeatureSupersededBy(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        return f == null ? null : f.getSupersededBy();
    }

    public static Set<String> getFeatureParents(String featureName, WebSphereRuntime wsRuntime) {
        HashSet<String> set = new HashSet<String>();
        HashMap<String, Feature> map = FeatureList.getFeatureMap(wsRuntime);
        FeatureList.getFeatureParents(set, featureName, map);
        return set;
    }

    private static void getFeatureParents(Set<String> set, String featureName, HashMap<String, Feature> map) {
        Set<Map.Entry<String, Feature>> entries = map.entrySet();
        for (Map.Entry<String, Feature> entry : entries) {
            String key = entry.getKey();
            Feature f = entry.getValue();
            if (key == null || f == null || !FeatureList.containsIgnoreCase(f.getEnables(), featureName) || FeatureList.containsIgnoreCase(set, key) || featureName.equalsIgnoreCase(key)) continue;
            set.add(key);
            FeatureList.getFeatureParents(set, key, map);
        }
    }

    public static Set<String> getFeatureAPIJars(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        if (f == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unrecognized feature:" + feature);
            }
            return new HashSet<String>();
        }
        return f.getApiJars();
    }

    public static Set<String> getFeatureAPIPackages(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        if (f == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unrecognized feature:" + feature);
            }
            return new HashSet<String>();
        }
        return f.getApiPackages();
    }

    public static Set<String> getFeatureConfigElements(String feature, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(feature, wsRuntime);
        return f == null ? null : f.getConfigElements();
    }

    public static boolean isEnabledBy(String feature1, String feature2, WebSphereRuntime wsRuntime) {
        if (feature1.equalsIgnoreCase(feature2) || FeatureUtil.isSupportedBy(feature1, feature2)) {
            return true;
        }
        return FeatureList.isContainedBy(feature1, feature2, wsRuntime);
    }

    public static boolean featuresEnabled(List<String> featuresToCheck, List<String> allFeatures, WebSphereRuntime wsRuntime) {
        for (String feature : featuresToCheck) {
            if (FeatureList.featureEnabled(feature, allFeatures, wsRuntime)) continue;
            return false;
        }
        return true;
    }

    public static boolean featureEnabled(String featureToCheck, List<String> allFeatures, WebSphereRuntime wsRuntime) {
        for (String feature : allFeatures) {
            if (!FeatureList.isEnabledBy(featureToCheck, feature, wsRuntime)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(String feature1, String feature2, WebSphereRuntime wsRuntime) {
        Set<String> children = FeatureList.getFeatureChildren(feature2, wsRuntime);
        return FeatureList.isSupportedBy(children, feature1);
    }

    public static HashMap<String, Feature> getFeatureMap(WebSphereRuntime wsRuntime) {
        HashMap<String, Feature> allInclusiveFeatureMap = new HashMap<String, Feature>();
        allInclusiveFeatureMap.putAll((Map)FeatureListCoreMetadata.getInstance().getFeatureListMaps(wsRuntime).get((Object)FeatureMapType.PUBLIC_FEATURES_KEYED_BY_NAME));
        for (FeatureListExtMetadata ext : FeatureListExtMetadata.getInstances(wsRuntime)) {
            HashMap<String, Feature> extMap = ext.getFeatureListMaps(wsRuntime).get((Object)FeatureMapType.PUBLIC_FEATURES_KEYED_BY_NAME);
            if (extMap == null) continue;
            allInclusiveFeatureMap.putAll(extMap);
        }
        return allInclusiveFeatureMap;
    }

    public static HashMap<String, Feature> getAllFeaturesKeyedBySymbolicName(WebSphereRuntime wsRuntime) {
        HashMap<String, Feature> allInclusiveFeatureMap = new HashMap<String, Feature>();
        allInclusiveFeatureMap.putAll((Map)FeatureListCoreMetadata.getInstance().getFeatureListMaps(wsRuntime).get((Object)FeatureMapType.ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME));
        for (FeatureListExtMetadata ext : FeatureListExtMetadata.getInstances(wsRuntime)) {
            HashMap<String, Feature> extMap = ext.getFeatureListMaps(wsRuntime).get((Object)FeatureMapType.ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME);
            if (extMap == null) continue;
            allInclusiveFeatureMap.putAll(extMap);
        }
        return allInclusiveFeatureMap;
    }

    private static Feature getFeature(String featureName, WebSphereRuntime wsRuntime) {
        return FeatureList.getFeature(featureName, FeatureList.getFeatureMap(wsRuntime));
    }

    private static Feature getFeature(String featureName, Map<String, Feature> featureMap) {
        if (featureMap != null) {
            Set<Map.Entry<String, Feature>> entrySet = featureMap.entrySet();
            for (Map.Entry<String, Feature> entry : entrySet) {
                String key = entry.getKey();
                if (!key.equalsIgnoreCase(featureName)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsIgnoreCase(Set<String> set, String val) {
        for (String entry : set) {
            if (!val.equalsIgnoreCase(entry)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSupportedBy(Set<String> set, String val) {
        for (String entry : set) {
            if (!val.equalsIgnoreCase(entry) && !FeatureUtil.isSupportedBy(val, entry)) continue;
            return true;
        }
        return false;
    }

    public static String getPublicFeatureName(String symbolicName, WebSphereRuntime wsRuntime) {
        Feature feature = FeatureList.getAllFeaturesKeyedBySymbolicName(wsRuntime).get(symbolicName);
        if (feature != null) {
            String name = feature.getName();
            if (name != null) {
                return name;
            }
        } else {
            return null;
        }
        return symbolicName;
    }

    public static String getFeatureSymbolicName(String publicFeatureName, WebSphereRuntime wsRuntime) {
        HashMap<String, Feature> featureMap = FeatureList.getFeatureMap(wsRuntime);
        Feature feature = featureMap.get(publicFeatureName);
        if (feature != null) {
            return feature.getSymbolicName();
        }
        return null;
    }

    public static Set<String> getFeatureCategory(String featureName, WebSphereRuntime wsRuntime) {
        Feature f = FeatureList.getFeature(featureName, wsRuntime);
        return f == null ? null : f.getCategoryElements();
    }

    public static enum FeatureMapType {
        PUBLIC_FEATURES_KEYED_BY_NAME,
        ALL_FEATURES_KEYED_BY_SYMBOLIC_NAME;

    }
}

