/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationIncludeFilter;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.IncludeFilter;
import com.ibm.ws.st.core.internal.config.URILocation;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtils {
    private static DocumentBuilder builder = null;

    public static Element getFirstChildElement(Node start) {
        Node node;
        if (start == null) {
            return null;
        }
        for (node = start.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start) {
        Node node;
        for (node = start.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static List<Element> getAllElements(Node parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Element elem = DOMUtils.getFirstChildElement(parent, name);
        while (elem != null) {
            elements.add(elem);
            elem = DOMUtils.getNextElement(elem, name);
        }
        return elements;
    }

    public static Element getFirstChildElement(Node start, String name) {
        Node node;
        if (start == null) {
            return null;
        }
        for (node = start.getFirstChild(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start, String name) {
        Node node;
        for (node = start.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getFirstChildElement(Node start, String ns, String name) {
        Node node;
        if (ns == null) {
            return DOMUtils.getFirstChildElement(start, name);
        }
        for (node = start.getFirstChild(); !(node == null || node.getNodeType() == 1 && node.getLocalName().equals(name) && ns.equals(node.getNamespaceURI())); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start, String ns, String name) {
        Node node;
        if (ns == null) {
            return DOMUtils.getNextElement(start, name);
        }
        for (node = start.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getLocalName().equals(name) && ns.equals(node.getNamespaceURI())); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static String getAttributeValue(Element element, String name) {
        Attr attr = element.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public static String getTextContent(Node parent) {
        Node textNode = DOMUtils.getTextNode(parent);
        if (textNode != null) {
            return textNode.getNodeValue();
        }
        return null;
    }

    public static Node getTextNode(Node parent) {
        Node node;
        for (node = parent.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
        }
        return node;
    }

    public static boolean isServerElement(Element element) {
        return element.getNodeName().equals("server");
    }

    public static boolean isInclude(Element element) {
        return element.getNodeName().equals("include");
    }

    public static String createXPath(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 9: {
                return "";
            }
            case 2: {
                String xpath = DOMUtils.createXPath(((Attr)node).getOwnerElement());
                return xpath + "/@" + node.getNodeName();
            }
            case 1: {
                String xpath = DOMUtils.createXPath(node.getParentNode());
                int count = 1;
                for (Node sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
                    if (!sibling.getNodeName().equals(node.getNodeName())) continue;
                    ++count;
                }
                return xpath + "/" + node.getNodeName() + "[" + count + "]";
            }
        }
        return null;
    }

    public static Node getNode(Document doc, String xpathStr) {
        return DOMUtils.getNode(doc, xpathStr, false);
    }

    public static Node getSchemaNode(Document doc, String xpathStr) {
        return DOMUtils.getNode(doc, xpathStr, true);
    }

    private static Node getNode(Document doc, String xpathStr, boolean isSchema) {
        if (xpathStr == null || xpathStr.isEmpty()) {
            return null;
        }
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            if (isSchema) {
                xpath.setNamespaceContext(new SchemaNamespaceContext());
            }
            XPathExpression xpathExpr = xpath.compile(xpathStr);
            Object result = xpathExpr.evaluate(doc, XPathConstants.NODE);
            return (Node)result;
        }
        catch (XPathExpressionException e) {
            Trace.logError("Failed to evaluate xpath expression: " + xpathStr, e);
            return null;
        }
    }

    public static Element getElement(Document doc, String xpathStr) {
        Node node = DOMUtils.getNode(doc, xpathStr);
        if (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            if (node.getNodeType() == 2) {
                return ((Attr)node).getOwnerElement();
            }
        }
        return doc.getDocumentElement();
    }

    public static String[] getIds(Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory context, String elemName) {
        HashMap<String, URILocation> idMap = new HashMap<String, URILocation>();
        DOMUtils.addIds(idMap, doc, uri, serverInfo, context, elemName);
        return idMap.keySet().toArray(new String[idMap.size()]);
    }

    public static void addIds(Map<String, URILocation> idMap, Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory context, String elemName) {
        List<Element> elements = ConfigUtils.getResolvedElements(doc, uri, serverInfo, context, elemName, "id", true);
        for (Element elem : elements) {
            String id = DOMUtils.getAttributeValue(elem, "id");
            if (id == null || id.isEmpty()) continue;
            DocumentLocation location = (DocumentLocation)elem.getUserData("documentLocationKey");
            idMap.put(id, location);
        }
    }

    public static Map<String, Set<String>> getAllIds(Document doc, URI uri, UserDirectory context) {
        HashMap<String, Set<String>> ids = new HashMap<String, Set<String>>();
        ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
        includeFilter.accept(uri);
        DOMUtils.getIds(ids, doc, uri, context, includeFilter);
        return ids;
    }

    private static void getIds(Map<String, Set<String>> ids, Document doc, URI uri, UserDirectory context, IncludeFilter includeFilter) {
        ConfigurationFile configFile = ConfigUtils.getConfigFile(uri);
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getDefaultDropins()) {
                DOMUtils.getIds(ids, dropin.getDomDocument(), dropin.getURI(), context, includeFilter);
            }
        }
        Element elem = DOMUtils.getFirstChildElement(doc.getDocumentElement());
        while (elem != null) {
            String id;
            if (DOMUtils.isInclude(elem) && context != null && uri != null) {
                Document include;
                URI includeURI;
                String includePath = DOMUtils.getAttributeValue(elem, "location");
                if (includePath != null && (includeURI = ConfigUtils.resolve(uri, includePath, context)) != null && includeFilter.accept(includeURI) && (include = ConfigUtils.getDOM(includeURI, context.getWebSphereRuntime())) != null) {
                    DOMUtils.getIds(ids, include, includeURI, context, includeFilter);
                }
            } else if (elem.hasAttribute("id") && (id = DOMUtils.getAttributeValue(elem, "id")) != null) {
                Set<String> set = ids.get(elem.getNodeName());
                if (set == null) {
                    set = new HashSet<String>();
                    ids.put(elem.getNodeName(), set);
                }
                set.add(id);
            }
            elem = DOMUtils.getNextElement(elem);
        }
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getOverrideDropins()) {
                DOMUtils.getIds(ids, dropin.getDomDocument(), dropin.getURI(), context, includeFilter);
            }
        }
    }

    public static List<String> getAllFeatures(Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory context) {
        ArrayList<String> list = new ArrayList<String>();
        List<Element> elements = ConfigUtils.getResolvedElements(doc, uri, serverInfo, context, "featureManager", null);
        for (Element elem : elements) {
            Element child = DOMUtils.getFirstChildElement(elem, "feature");
            while (child != null) {
                String name = DOMUtils.getTextContent(child);
                if (name != null && !name.isEmpty() && !list.contains(name)) {
                    list.add(name);
                }
                child = DOMUtils.getNextElement(child, "feature");
            }
        }
        return list;
    }

    public static Map<String, Element> getFeatureElementMap(Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory context) {
        HashMap<String, Element> map = new HashMap<String, Element>();
        List<Element> elements = ConfigUtils.getResolvedElements(doc, uri, serverInfo, context, "featureManager", null, true);
        for (Element elem : elements) {
            Element child = DOMUtils.getFirstChildElement(elem, "feature");
            while (child != null) {
                String name = DOMUtils.getTextContent(child);
                if (name != null && !name.isEmpty() && !map.containsKey(name)) {
                    map.put(name, child);
                }
                child = DOMUtils.getNextElement(child, "feature");
            }
        }
        return map;
    }

    public static List<Element> getApplicationElements(Document doc) {
        ArrayList<Element> list = new ArrayList<Element>();
        Element appElem = DOMUtils.getFirstChildElement(doc.getDocumentElement(), "application");
        while (appElem != null) {
            list.add(appElem);
            appElem = DOMUtils.getNextElement(appElem, "application");
        }
        return list;
    }

    public static Document getTmpDoc() {
        Document tmpDoc = null;
        try {
            if (builder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
            }
            tmpDoc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not create a temporary document.", e);
            }
            throw new RuntimeException(e);
        }
        return tmpDoc;
    }

    static class SchemaNamespaceContext
    implements NamespaceContext {
        private static HashMap<String, String> namespaces = new HashMap();

        SchemaNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return namespaces.get(prefix);
        }

        @Override
        public String getPrefix(String namespace) {
            Set<Map.Entry<String, String>> entries = namespaces.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (!entry.getValue().equals(namespace)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespace) {
            ArrayList<String> prefixes = new ArrayList<String>();
            Set<Map.Entry<String, String>> entries = namespaces.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (!entry.getValue().equals(namespace)) continue;
                prefixes.add(entry.getKey());
            }
            return prefixes.iterator();
        }

        static {
            namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
            namespaces.put("ext", "http://www.ibm.com/xmlns/dde/schema/annotation/ext");
        }
    }
}

