/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.APIVisibility;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ServerExtensionWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationIncludeFilter;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.IConfigurationElement;
import com.ibm.ws.st.core.internal.config.IncludeFilter;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.validation.CustomServerVariablesManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationFile
implements IAdaptable,
IConfigurationElement {
    public static final String USER_DATA_URI = "uri";
    public static final String USER_DATA_USER_DIRECTORY = "userDirectory";
    private static final String XML_EXTENSION = ".xml";
    private static final String COMMENT_TEXT1 = "Enablefeatures";
    private static final String COMMENT_TEXT2 = "<featureManager><feature>servlet-3.0</feature></featureManager>";
    protected URI uri;
    protected long lastModified = -1L;
    protected Document document;
    protected Element serverElement;
    protected IDOMDocument domDocument;
    protected UserDirectory userDir;
    protected final WebSphereServerInfo server;
    protected IdentityHashMap<Element, ConfigurationFile> includes;
    protected List<String> unresolvedIncludes;
    protected List<ConfigurationFile> defaultDropins;
    protected List<ConfigurationFile> overrideDropins;
    protected ConfigVars configVars;
    protected final Object configLock;

    public ConfigurationFile(URI uri, UserDirectory userDir) throws IOException {
        this(uri, userDir, null);
    }

    public ConfigurationFile(URI uri, UserDirectory userDir, WebSphereServerInfo server) throws IOException {
        this.uri = uri;
        this.userDir = userDir;
        this.server = server;
        this.configLock = server == null ? this : server.getWebSphereRuntime();
        this.load();
    }

    public Document getDomDocument() {
        if (this.domDocument != null) {
            return this.domDocument;
        }
        this.domDocument = (IDOMDocument)ConfigUtils.getDOMFromModel(this.getURI());
        if (this.domDocument != null) {
            this.domDocument.setUserData(USER_DATA_URI, (Object)this.getURI().toString(), null);
            this.domDocument.setUserData(USER_DATA_USER_DIRECTORY, (Object)this.getUserDirectory(), null);
        }
        return this.domDocument;
    }

    private Map<String, Boolean> getAppLabelMap() {
        HashMap<String, Boolean> appLabelMap = new HashMap<String, Boolean>();
        URL schemaURL = this.server == null ? SchemaUtil.getSchemaURL(this.uri) : this.server.getConfigurationSchemaURL();
        Document doc = this.getDomDocument();
        for (String appLabel : ServerExtensionWrapper.getAllApplicationElements()) {
            boolean isAppLabelHasNameAttr = SchemaUtil.getAttribute(doc, new String[]{"server", appLabel}, "name", schemaURL) != null;
            appLabelMap.put(appLabel, isAppLabelHasNameAttr ? Boolean.TRUE : Boolean.FALSE);
        }
        return appLabelMap;
    }

    private void load() throws IOException {
        InputStream in = null;
        long time = System.currentTimeMillis();
        try {
            File file = new File(this.uri);
            this.lastModified = file.lastModified();
            in = new BufferedInputStream(new FileInputStream(file));
            this.document = ConfigurationFile.documentLoad(in);
            this.serverElement = this.document.getDocumentElement();
            if (this.serverElement == null) {
                throw new IOException("Could not read config file");
            }
        }
        catch (FileNotFoundException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Invalid file: " + this.uri, e);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Invalid path: " + this.uri, e);
            }
            throw new IOException("Could not read config file", e);
        }
        catch (IOException e) {
            Trace.logError("Could not load configuration file: " + this.uri, e);
            throw e;
        }
        catch (Exception e) {
            Trace.logError("Could not load configuration file: " + this.uri, e);
            throw new IOException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            if (Trace.ENABLED) {
                Trace.tracePerf("Configuration file load", time);
            }
        }
    }

    public static Document documentLoad(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Warning while reading configuration file.\nReason: " + e.getMessage());
                }
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                Trace.logError("Error while reading configuration file.", e);
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Error while reading configuration file.\nReason: " + e.getMessage());
                }
            }
        });
        return parser.parse(new InputSource(in));
    }

    public LOCATION_TYPE getLocationType() {
        if (this.server != null && this.server.getServerURI() != null && !URIUtil.canonicalRelativize(this.server.getServerURI(), this.uri).isAbsolute()) {
            return LOCATION_TYPE.SERVER;
        }
        if (this.userDir.getSharedConfigURI() != null && !URIUtil.canonicalRelativize(this.userDir.getSharedConfigURI(), this.uri).isAbsolute()) {
            return LOCATION_TYPE.SHARED;
        }
        return LOCATION_TYPE.FILE_SYSTEM;
    }

    public ConfigurationFile[] getLocalIncludedFiles() {
        Collection<ConfigurationFile> includes = this.getIncludes().values();
        ConfigurationFile[] configFiles = new ConfigurationFile[includes.size()];
        int i = 0;
        for (ConfigurationFile include : includes) {
            configFiles[i++] = include;
        }
        return configFiles;
    }

    public boolean hasIncludes() {
        return !this.getIncludes().isEmpty();
    }

    public ConfigurationFile[] getAllIncludedFiles() {
        ArrayList<ConfigurationFile> includedList = new ArrayList<ConfigurationFile>(5);
        ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
        includeFilter.accept(this.getURI());
        for (ConfigurationFile dropin : this.getDefaultDropins()) {
            dropin.getAllConfigFiles(includedList, includeFilter);
        }
        Collection<ConfigurationFile> includes = this.getIncludes().values();
        for (ConfigurationFile include : includes) {
            include.getAllConfigFiles(includedList, includeFilter);
        }
        for (ConfigurationFile dropin : this.getOverrideDropins()) {
            dropin.getAllConfigFiles(includedList, includeFilter);
        }
        return includedList.toArray(new ConfigurationFile[includedList.size()]);
    }

    public void getAllConfigFiles(List<ConfigurationFile> found, IncludeFilter includeFilter) {
        if (!includeFilter.accept(this.getURI())) {
            return;
        }
        found.add(this);
        for (ConfigurationFile dropin : this.getDefaultDropins()) {
            dropin.getAllConfigFiles(found, includeFilter);
        }
        Collection<ConfigurationFile> includes = this.getIncludes().values();
        for (ConfigurationFile include : includes) {
            include.getAllConfigFiles(found, includeFilter);
        }
        for (ConfigurationFile dropin : this.getOverrideDropins()) {
            dropin.getAllConfigFiles(found, includeFilter);
        }
    }

    public String[] getAllUnresolvedIncludes() {
        ArrayList<String> includeList = new ArrayList<String>(5);
        ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
        this.getAllUnresolvedIncludes(includeList, includeFilter);
        return includeList.toArray(new String[includeList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllUnresolvedIncludes(List<String> list, IncludeFilter includeFilter) {
        Object object = this.configLock;
        synchronized (object) {
            if (!includeFilter.accept(this.getURI())) {
                return;
            }
            Collection<ConfigurationFile> includes = this.getIncludes().values();
            for (String include : this.unresolvedIncludes) {
                list.add(include);
            }
            for (ConfigurationFile config : includes) {
                config.getAllUnresolvedIncludes(list, includeFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOutOfSyncLocalIncludes() {
        Object object = this.configLock;
        synchronized (object) {
            Collection<ConfigurationFile> includes = this.getIncludes().values();
            for (ConfigurationFile config : includes) {
                File file = new File(config.getURI());
                if (file.exists() && (config.getIFile() != null || file.lastModified() == config.lastModified)) continue;
                return true;
            }
            for (String location : this.unresolvedIncludes) {
                URI includeURI = this.server != null ? this.server.resolve(this.getURI(), location) : this.getUserDirectory().resolve(this.getURI(), location);
                if (includeURI == null || !new File(includeURI).exists()) continue;
                return true;
            }
            return this.hasOutOfSyncDropins();
            {
            }
        }
    }

    public UserDirectory getUserDirectory() {
        return this.userDir;
    }

    public WebSphereServerInfo getWebSphereServer() {
        return this.server;
    }

    public Document getDocument() {
        return this.document;
    }

    public URI getURI() {
        return this.uri;
    }

    public IFile getIFile() {
        return this.getIFile((IContainer)this.userDir.getProject());
    }

    private IFile getIFile(IContainer folder) {
        if (folder == null || !folder.exists()) {
            return null;
        }
        URI workspaceURI = folder.getLocation().toFile().toURI();
        URI relativeURI = URIUtil.canonicalRelativize(workspaceURI, this.uri);
        if (relativeURI.isAbsolute()) {
            return null;
        }
        Path relativePath = new Path(relativeURI.getPath());
        return folder.getFile((IPath)relativePath);
    }

    @Override
    public IPath getPath() {
        return new Path(new File(this.uri).getAbsolutePath());
    }

    @Override
    public String getName() {
        Path path = new Path(this.uri.getPath());
        return path.lastSegment();
    }

    public String getServerDescription() {
        Element elem = this.getServerElement();
        if (elem != null) {
            return elem.getAttribute("description");
        }
        return "";
    }

    public Element addElement(String name) {
        return this.addElement(this.getServerElement(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element addElement(Element parent, String name) {
        if (parent == null) {
            return null;
        }
        Object object = this.configLock;
        synchronized (object) {
            boolean hasChildren;
            Document doc = this.getDocument();
            boolean isTopLevel = DOMUtils.isServerElement(parent);
            NodeList childNodes = parent.getChildNodes();
            boolean bl = hasChildren = childNodes != null && childNodes.getLength() != 0 && (childNodes.getLength() != 1 || childNodes.item(0).getNodeType() != 3 || childNodes.item(0).getNodeValue().trim().length() != 0);
            if (isTopLevel && name.equals("featureManager")) {
                this.removeInitialComments();
            }
            this.addPreElementText(parent, isTopLevel, hasChildren);
            Element elem = doc.createElement(name);
            parent.appendChild(elem);
            this.addPostElementText(parent);
            if (isTopLevel && name.equals("include")) {
                this.resetIncludes();
            }
            return elem;
        }
    }

    private boolean hasSignificantChildren(Element elem) {
        NodeList childNodes = elem.getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            return false;
        }
        block4: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            short type = node.getNodeType();
            switch (type) {
                case 3: {
                    if (node.getNodeValue().trim().length() == 0) continue block4;
                    return true;
                }
                case 1: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private void addPreElementText(Element parent, boolean isTopLevel, boolean hasChildren) {
        if (parent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (isTopLevel || !hasChildren) {
            builder.append("\n    ");
        }
        for (Node node = parent.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            builder.append("    ");
        }
        Text text = this.getDocument().createTextNode(builder.toString());
        parent.appendChild(text);
    }

    private void addPostElementText(Element parent) {
        if (parent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (Node node = parent.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            builder.append("    ");
        }
        Text text = this.getDocument().createTextNode(builder.toString());
        parent.appendChild(text);
    }

    public boolean hasElement(String name) {
        if (name == null) {
            return false;
        }
        return this.getFirstChildElement(this.getServerElement(), name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String elementName, String name, String value) {
        if (elementName == null || name == null) {
            return;
        }
        Object object = this.configLock;
        synchronized (object) {
            Element element = this.getFirstChildElement(this.getServerElement(), elementName);
            if (element == null) {
                return;
            }
            element.setAttribute(name, value);
        }
    }

    public boolean hasFeature(String feature) {
        if (feature == null) {
            return false;
        }
        Element fManager = this.getFirstChildElement(this.getServerElement(), "featureManager");
        while (fManager != null) {
            Element fElem = this.getFirstChildElement(fManager);
            while (fElem != null) {
                if (feature.equalsIgnoreCase(fElem.getTextContent())) {
                    return true;
                }
                fElem = this.getNextElement(fElem);
            }
            fManager = this.getNextElement(fManager, "featureManager");
        }
        return false;
    }

    public List<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        Element fManager = this.getFirstChildElement(this.getServerElement(), "featureManager");
        while (fManager != null) {
            Element fElem = this.getFirstChildElement(fManager);
            while (fElem != null) {
                String feature = fElem.getTextContent();
                if (feature != null && !feature.isEmpty() && !features.contains(feature)) {
                    features.add(feature);
                }
                fElem = this.getNextElement(fElem);
            }
            fManager = this.getNextElement(fManager, "featureManager");
        }
        return features;
    }

    public List<String> getAllFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        List<Element> elements = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), "featureManager", null);
        for (Element elem : elements) {
            Element fElem = this.getFirstChildElement(elem, "feature");
            while (fElem != null) {
                String feature = fElem.getTextContent();
                if (feature != null && !feature.isEmpty() && !features.contains(feature)) {
                    features.add(feature);
                }
                fElem = this.getNextElement(fElem, "feature");
            }
        }
        return features;
    }

    public void addFeatures(Collection<String> features) {
        for (String feature : features) {
            this.addFeature(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        Object object = this.configLock;
        synchronized (object) {
            Element fManager;
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "ConfigurationFile adding feature: " + feature);
            }
            if ((fManager = this.getFirstChildElement(this.getServerElement(), "featureManager")) == null) {
                this.addElement("featureManager");
                fManager = this.getFirstChildElement(this.getServerElement(), "featureManager");
                if (fManager == null) {
                    if (Trace.ENABLED) {
                        Trace.logError("Failed to add feature manager to configuration file: " + this.uri, null);
                    }
                    return;
                }
            }
            Element child = this.addElement(fManager, "feature");
            Document doc = fManager.getOwnerDocument();
            Text text = doc.createTextNode(feature);
            child.appendChild(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFeature(String feature1, String feature2) {
        Object object = this.configLock;
        synchronized (object) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "ConfigurationFile replacing feature: " + feature1 + " -> " + feature2);
            }
            Element fManager = this.getFirstChildElement(this.getServerElement(), "featureManager");
            while (fManager != null) {
                Element fElem = this.getFirstChildElement(fManager);
                while (fElem != null) {
                    if (feature1.equals(fElem.getTextContent())) {
                        fElem.setTextContent(feature2);
                        return;
                    }
                    fElem = this.getNextElement(fElem);
                }
                fManager = this.getNextElement(fManager, "featureManager");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInclude(boolean optional, String include) {
        Object object = this.configLock;
        synchronized (object) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "ConfigurationFile adding include: " + include + " " + optional);
            }
            Element includeElement = this.addElement("include");
            if (optional) {
                includeElement.setAttribute("optional", "true");
            }
            includeElement.setAttribute("location", include);
            this.resetIncludes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application[] getApplications() {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "getApplications() - before synchronized block");
        }
        ArrayList<Application> list = new ArrayList<Application>();
        Map<String, Boolean> appLabelMap = this.getAppLabelMap();
        Object object = this.configLock;
        synchronized (object) {
            for (String appLabel : ServerExtensionWrapper.getAllApplicationElements()) {
                List<Element> elements = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), appLabel, "id");
                for (Element appElem : elements) {
                    Application app = this.createApplication(appElem, appLabel, appLabelMap);
                    list.add(app);
                }
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "getApplications() - after synchronized block");
        }
        return list.toArray(new Application[list.size()]);
    }

    private Application createApplication(Element appElem, String appLabel, Map<String, Boolean> appLabelMap) {
        String apiVisibilityAttributeValue;
        String appId = this.getAppId(appElem, appLabelMap);
        EnumSet<APIVisibility> apiVisibility = APIVisibility.getDefaults();
        Element classLoaderElement = this.getFirstChildElement(appElem, "classloader");
        if (classLoaderElement != null && (apiVisibilityAttributeValue = classLoaderElement.getAttribute("apiTypeVisibility")) != null && apiVisibilityAttributeValue.trim().length() > 0) {
            apiVisibility = APIVisibility.parseFromAttribute(apiVisibilityAttributeValue);
        }
        String appName = this.getAppName(appElem, appId);
        String appLocation = this.resolveValue(appElem.getAttribute("location"));
        String appAutostart = this.resolveValue(appElem.getAttribute("autoStart"));
        String contextRoot = null;
        if ("application".equals(appElem.getNodeName())) {
            contextRoot = this.resolveValue(appElem.getAttribute("context-root"));
        } else if ("webApplication".equals(appElem.getNodeName()) && ((contextRoot = this.resolveValue(appElem.getAttribute("contextRoot"))) == null || contextRoot.isEmpty())) {
            contextRoot = this.resolveValue(appElem.getAttribute("context-root"));
        }
        if (contextRoot != null && contextRoot.isEmpty()) {
            contextRoot = null;
        }
        Application app = new Application(appName, ServerExtensionWrapper.getAppTypeFromAppElement(appLabel), appLocation, appAutostart, this.getSharedLibRefs(appElem), apiVisibility, contextRoot);
        return app;
    }

    private List<LibRef> getSharedLibRefs(Element appElem) {
        ArrayList<LibRef> libRefs = new ArrayList<LibRef>(2);
        this.addLibRefs(this.getSharedLibIds(appElem, LibraryRefType.COMMON), LibraryRefType.COMMON, libRefs);
        this.addLibRefs(this.getSharedLibIds(appElem, LibraryRefType.PRIVATE), LibraryRefType.PRIVATE, libRefs);
        if (libRefs.isEmpty()) {
            return null;
        }
        return libRefs;
    }

    private void addLibRefs(List<String> ids, LibraryRefType type, List<LibRef> libRefs) {
        for (String id : ids) {
            libRefs.add(new LibRef(id, type));
        }
    }

    private List<String> getSharedLibIds(Element appElem, LibraryRefType type) {
        ArrayList<String> idList = new ArrayList<String>();
        Element child = this.getFirstChildElement(appElem, "classloader");
        while (child != null) {
            String ids = child.getAttribute(type.getElementName());
            if (ids != null && !ids.isEmpty()) {
                ids = this.resolveValue(ids);
                StringTokenizer st = new StringTokenizer(ids, ",");
                while (st.hasMoreTokens()) {
                    String id = st.nextToken().trim();
                    if (id.isEmpty() || idList.contains(id)) continue;
                    idList.add(id);
                }
            }
            child = this.getNextElement(child, "classloader");
        }
        return idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplication(String name, String applicationElement, String location, Map<String, String> attributes, List<LibRef> sharedLibRefs, EnumSet<APIVisibility> apiVisibility) {
        Map<String, Boolean> appLabelMap = this.getAppLabelMap();
        Object object = this.configLock;
        synchronized (object) {
            Element appElement;
            String type;
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "ConfigurationFile adding application: " + name);
            }
            if (name == null) {
                return;
            }
            boolean isSupportAppElement = this.server.getSchemaHelper().isSupportedApplicationElement(applicationElement);
            if (isSupportAppElement) {
                Element appElem = this.getFirstChildElement(this.getServerElement(), applicationElement);
                while (appElem != null) {
                    String appId = this.getAppId(appElem, appLabelMap);
                    if (name.equals(this.getAppName(appElem, appId))) {
                        String appLocation = this.resolveValue(appElem.getAttribute("location"));
                        if (location != null && location.equals(appLocation)) {
                            this.addSharedLibRefs(appElem, sharedLibRefs, apiVisibility);
                            return;
                        }
                        appElem.setAttribute("location", location);
                        this.addAppAttributes(appElem, attributes);
                        this.addSharedLibRefs(appElem, sharedLibRefs, apiVisibility);
                        return;
                    }
                    appElem = this.getNextElement(appElem, applicationElement);
                }
            }
            if ((type = ServerExtensionWrapper.getAppTypeFromAppElement(applicationElement)) != null) {
                Element appElem = this.getFirstChildElement(this.getServerElement(), "application");
                while (appElem != null) {
                    String appId = this.getAppId(appElem, appLabelMap);
                    if (name.equals(this.getAppName(appElem, appId))) {
                        String appLocation = this.resolveValue(appElem.getAttribute("location"));
                        if (location != null && location.equals(appLocation)) {
                            this.addSharedLibRefs(appElem, sharedLibRefs, apiVisibility);
                            return;
                        }
                        appElem.setAttribute("type", type);
                        appElem.setAttribute("location", location);
                        this.addAppAttributes(appElem, attributes);
                        this.addSharedLibRefs(appElem, sharedLibRefs, apiVisibility);
                        return;
                    }
                    appElem = this.getNextElement(appElem, "application");
                }
            }
            if (!isSupportAppElement) {
                appElement = this.addElement("application");
                appElement.setAttribute("type", type);
            } else {
                appElement = this.addElement(applicationElement);
            }
            appElement.setAttribute("id", name);
            if (this.appHasNameAttr(appElement, appLabelMap)) {
                appElement.setAttribute("name", name);
            }
            appElement.setAttribute("location", location);
            this.addAppAttributes(appElement, attributes);
            if (sharedLibRefs != null) {
                this.addSharedLibRefs(appElement, sharedLibRefs, apiVisibility);
            }
        }
    }

    private boolean appHasNameAttr(Element appElem, Map<String, Boolean> appLabelMap) {
        return Boolean.TRUE == appLabelMap.get(appElem.getNodeName());
    }

    public String getAppName(Element appElem) {
        Map<String, Boolean> appLabelMap = this.getAppLabelMap();
        String appId = this.getAppId(appElem, appLabelMap);
        return this.getAppName(appElem, appId);
    }

    private String getAppId(Element appElem, Map<String, Boolean> appLabelMap) {
        if (this.appHasNameAttr(appElem, appLabelMap)) {
            return "name";
        }
        return "id";
    }

    private String getAppName(Element appElem, String appId) {
        String name = appElem.getAttribute(appId);
        if (name == null || name.isEmpty()) {
            String location = appElem.getAttribute("location");
            if ((location = this.resolveValue(location)) != null && !location.isEmpty()) {
                Path path = new Path(location);
                path = path.removeFileExtension();
                name = path.lastSegment();
            }
        } else {
            name = this.resolveValue(name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAppAttributes(Element appElem, Map<String, String> attributes) {
        Object object = this.configLock;
        synchronized (object) {
            if (attributes != null && !attributes.isEmpty()) {
                Set<Map.Entry<String, String>> set = attributes.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    appElem.setAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSharedLibRefs(Element parent, List<String> refIds, LibraryRefType type) {
        if (parent == null) {
            return;
        }
        List<String> currentIds = this.getSharedLibIds(parent, type);
        ArrayList<String> newIds = new ArrayList<String>();
        ArrayList<String> oldIds = new ArrayList<String>();
        if (refIds == null || refIds.isEmpty()) {
            if (currentIds == null || currentIds.isEmpty()) {
                return;
            }
            oldIds.addAll(currentIds);
        } else {
            newIds.addAll(refIds);
            if (currentIds != null) {
                for (String id : currentIds) {
                    if (newIds.contains(id)) {
                        newIds.remove(id);
                        continue;
                    }
                    oldIds.add(id);
                }
            }
        }
        if (newIds.isEmpty() && oldIds.isEmpty()) {
            return;
        }
        Object object = this.configLock;
        synchronized (object) {
            String ids;
            Element child;
            if (!newIds.isEmpty()) {
                child = this.getFirstChildElement(parent, "classloader");
                if (child == null) {
                    child = this.addElement(parent, "classloader");
                    child.setAttribute(type.getElementName(), this.listToString(newIds));
                } else {
                    ids = child.getAttribute(type.getElementName());
                    StringBuilder sb = new StringBuilder();
                    if (ids != null && ids.length() > 0) {
                        sb.append(ids);
                        sb.append(',');
                    }
                    sb.append(this.listToString(newIds));
                    child.setAttribute(type.getElementName(), sb.toString());
                }
            }
            if (!oldIds.isEmpty()) {
                child = this.getFirstChildElement(parent, "classloader");
                while (child != null) {
                    ids = child.getAttribute(type.getElementName());
                    if (ids != null && !ids.isEmpty()) {
                        ArrayList<String> libRefIds = new ArrayList<String>();
                        StringTokenizer st = new StringTokenizer(ids, ",");
                        while (st.hasMoreTokens()) {
                            String s = st.nextToken().trim();
                            if (s.isEmpty() || oldIds.contains(s)) continue;
                            libRefIds.add(s);
                        }
                        if (!libRefIds.isEmpty()) {
                            child.setAttribute(type.getElementName(), this.listToString(libRefIds));
                        } else {
                            child.removeAttribute(type.getElementName());
                        }
                    }
                    child = this.getNextElement(child, "classloader");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSharedLibRefs(Element parent, List<LibRef> refs, EnumSet<APIVisibility> apiVisibility) {
        String apiVisibilityAttributeValue;
        if (parent == null) {
            return;
        }
        ArrayList<String> commonRefIds = new ArrayList<String>();
        ArrayList<String> privateRefIds = new ArrayList<String>();
        if (refs != null) {
            for (LibRef ref : refs) {
                switch (ref.type) {
                    case COMMON: {
                        commonRefIds.add(ref.id);
                        break;
                    }
                    case PRIVATE: {
                        privateRefIds.add(ref.id);
                    }
                }
            }
        }
        this.addSharedLibRefs(parent, commonRefIds, LibraryRefType.COMMON);
        this.addSharedLibRefs(parent, privateRefIds, LibraryRefType.PRIVATE);
        EnumSet<APIVisibility> currentAPIVisibility = APIVisibility.getDefaults();
        Element classLoaderElement = this.getFirstChildElement(parent, "classloader");
        if (classLoaderElement != null && (apiVisibilityAttributeValue = classLoaderElement.getAttribute("apiTypeVisibility")) != null && apiVisibilityAttributeValue.trim().length() > 0) {
            currentAPIVisibility = APIVisibility.parseFromAttribute(classLoaderElement.getAttribute("apiTypeVisibility"));
        }
        boolean apiVisibilityChanged = !currentAPIVisibility.equals(apiVisibility);
        Object object = this.configLock;
        synchronized (object) {
            Element child;
            if (apiVisibilityChanged && (child = this.getFirstChildElement(parent, "classloader")) != null) {
                child.setAttribute("apiTypeVisibility", APIVisibility.generateAttributeValue(apiVisibility));
            }
            child = this.getFirstChildElement(parent, "classloader");
            while (child != null) {
                if (child.getAttributes().getLength() == 0) {
                    this.removeElement(child);
                }
                child = this.getNextElement(child, "classloader");
            }
        }
    }

    private String listToString(List<String> items) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : items) {
            if (item.trim().isEmpty()) continue;
            if (first) {
                sb.append(item);
                first = false;
                continue;
            }
            sb.append(',').append(item);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSharedLibrary(String libraryId, String directory, String jarName, EnumSet<APIVisibility> apiVisibility) {
        if (libraryId == null || directory == null || jarName == null) {
            Trace.logError("Null parameters are passed in addSharedLibrary() " + libraryId + " " + directory + " " + jarName, null);
            return;
        }
        Object object = this.configLock;
        synchronized (object) {
            Element serverElem = this.getServerElement();
            Element libElem = this.getFirstChildElement(serverElem, "library");
            while (libElem != null) {
                if (libraryId.equals(libElem.getAttribute("id"))) {
                    String sharedLibAttribute = libElem.getAttribute("apiTypeVisibility");
                    if (!(APIVisibility.getDefaults().equals(apiVisibility) || sharedLibAttribute != null && sharedLibAttribute.trim().length() != 0)) {
                        libElem.setAttribute("apiTypeVisibility", APIVisibility.generateAttributeValue(apiVisibility));
                    }
                    Element filesetElem = this.getFirstChildElement(libElem, "fileset");
                    while (filesetElem != null) {
                        String includeName = filesetElem.getAttribute("includes");
                        if (includeName != null && directory.equals(filesetElem.getAttribute("dir")) && (includeName.equals("*.jar") || includeName.equals("*") || jarName.equals(includeName))) {
                            return;
                        }
                        filesetElem = this.getNextElement(filesetElem, "fileset");
                    }
                    this.addFileset(libElem, directory, jarName);
                    return;
                }
                libElem = this.getNextElement(libElem, "library");
            }
            Element e = this.addElement("library");
            e.setAttribute("id", libraryId);
            if (!APIVisibility.getDefaults().equals(apiVisibility)) {
                e.setAttribute("apiTypeVisibility", APIVisibility.generateAttributeValue(apiVisibility));
            }
            this.addFileset(e, directory, jarName);
        }
    }

    public String[] getSharedLibraryIds() {
        ArrayList<String> idList = new ArrayList<String>();
        List<Element> elements = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), "library", "id");
        for (Element elem : elements) {
            String value = elem.getAttribute("id");
            if (value == null || value.isEmpty() || idList.contains(value = this.resolveValue(value))) continue;
            idList.add(value);
        }
        return idList.toArray(new String[idList.size()]);
    }

    public String getLogDirectoryAttribute() {
        List<Element> elements = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), "logging", null);
        for (Element elem : elements) {
            String logDir;
            if (elem == null || (logDir = elem.getAttribute("logDirectory")) == null || logDir.isEmpty()) continue;
            return logDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedLibrary(String libraryId, String directory, String jarName) {
        if (libraryId == null || directory == null || jarName == null) {
            Trace.logError("Null parameters are passed in removeSharedLibrary() " + libraryId + " " + directory + " " + jarName, null);
            return;
        }
        Object object = this.configLock;
        synchronized (object) {
            Element serverElem = this.getServerElement();
            Element libElem = this.getFirstChildElement(serverElem, "library");
            while (libElem != null) {
                if (libraryId.equals(libElem.getAttribute("id"))) {
                    Element filesetElem = this.getFirstChildElement(libElem, "fileset");
                    while (filesetElem != null) {
                        if (directory.equals(filesetElem.getAttribute("dir")) && jarName.equals(filesetElem.getAttribute("includes"))) {
                            this.removeElement(filesetElem);
                        }
                        filesetElem = this.getNextElement(filesetElem, "fileset");
                    }
                    if (!this.hasSignificantChildren(libElem)) {
                        this.removeElement(libElem);
                    }
                }
                libElem = this.getNextElement(libElem, "library");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeElement(Element element) {
        Object object = this.configLock;
        synchronized (object) {
            Node parentNode = element.getParentNode();
            for (Node previous = element.getPreviousSibling(); previous != null && previous.getNodeType() == 3 && previous.getNodeValue().trim().length() == 0; previous = previous.getPreviousSibling()) {
                Node nodeToRemove = previous;
                parentNode.removeChild(nodeToRemove);
            }
            parentNode.removeChild(element);
            NodeList childNodes = parentNode.getChildNodes();
            if (childNodes != null && childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0) {
                parentNode.removeChild(childNodes.item(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileset(Element libElem, String directory, String jarName) {
        Object object = this.configLock;
        synchronized (object) {
            Element e = this.addElement(libElem, "fileset");
            e.setAttribute("dir", directory);
            e.setAttribute("includes", jarName);
        }
    }

    public boolean removeApplication(String name) {
        if (name == null) {
            return false;
        }
        for (String appLabel : ServerExtensionWrapper.getAllApplicationElements()) {
            Element appElem = this.getFirstChildElement(this.getServerElement(), appLabel);
            while (appElem != null) {
                if (name.equals(this.getAppName(appElem))) {
                    this.removeElement(appElem);
                    return true;
                }
                appElem = this.getNextElement(appElem, appLabel);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(String name) {
        if (name == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Element appElem = this.getFirstChildElement(this.getServerElement(), name);
            if (appElem != null) {
                this.removeElement(appElem);
                return true;
            }
            return false;
        }
    }

    private void touch() {
        block3: {
            IFile ifile = this.getIFile();
            if (ifile != null) {
                try {
                    ifile.touch((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    if (!Trace.ENABLED) break block3;
                    Trace.trace((byte)1, "Could not refresh local file", ce);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(IProgressMonitor progressMonitor) throws IOException {
        if (this.document == null) {
            this.touch();
            return;
        }
        FilterOutputStream w = null;
        try {
            w = new BufferedOutputStream(new FileOutputStream(new File(this.uri)));
            this.save(w);
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new IOException(e2.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    if (w != null) {
                        w.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getIFile() == null) throw throwable;
                try {
                    IProgressMonitor monitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
                    this.getIFile().refreshLocal(2, monitor);
                    throw throwable;
                }
                catch (CoreException ce) {
                    if (!Trace.ENABLED) throw throwable;
                    Trace.trace((byte)1, "Could not refresh local file", ce);
                }
                throw throwable;
            }
        }
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getIFile() == null) return;
        try {
            IProgressMonitor monitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
            this.getIFile().refreshLocal(2, monitor);
            return;
        }
        catch (CoreException ce) {
            if (!Trace.ENABLED) return;
            Trace.trace((byte)1, "Could not refresh local file", ce);
            return;
        }
    }

    private void save(OutputStream os) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(this.document);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public List<ServerPort> getPorts(List<ServerPort> portList) {
        int httpsPort;
        int httpPort = this.getHTTPPort();
        if (httpPort != -1) {
            ServerPort sp = new ServerPort("httpEndpoint/httpPort", "httpPort", httpPort, "http");
            portList.add(sp);
        }
        if ((httpsPort = this.getHTTPSPort()) != -1) {
            ServerPort sp = new ServerPort("httpEndpoint/httpsPort", "httpsPort", httpsPort, "https");
            portList.add(sp);
        }
        return portList;
    }

    public List<Integer> getAllPorts(boolean secure) {
        ArrayList<Integer> allPorts = new ArrayList<Integer>();
        List<Element> httpEndpoints = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), "httpEndpoint", "id");
        for (Element elem : httpEndpoints) {
            String port = elem.getAttribute(secure ? "httpsPort" : "httpPort");
            if (port == null || port.isEmpty()) continue;
            port = this.resolveValue(port);
            try {
                allPorts.add(new Integer(port));
            }
            catch (NumberFormatException numberFormatException) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "HTTP endpoint had invalid port", numberFormatException);
            }
        }
        return allPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document flatten(File file) {
        try {
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = this.getServerElement();
            Node cloneNode = newDocument.importNode(node, false);
            ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
            CMElementDeclaration includeDecl = null;
            Document domDocument = this.getDomDocument();
            if (domDocument != null) {
                includeDecl = SchemaUtil.getElement(this.getDomDocument(), new String[]{"server", "include"}, this.getURI());
            }
            newDocument.appendChild(cloneNode);
            this.flattenImpl(newDocument, cloneNode, includeFilter, includeDecl);
            FilterOutputStream w = null;
            try {
                w = new BufferedOutputStream(new FileOutputStream(file));
                StreamResult result = new StreamResult(w);
                DOMSource source = new DOMSource(newDocument);
                try {
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
            catch (IOException e) {
                Trace.logError("Error flattening config", e);
            }
            catch (Exception e) {
                Trace.logError("Error flattening config", e);
            }
            finally {
                try {
                    if (w != null) {
                        w.close();
                    }
                }
                catch (Exception e) {}
            }
            return this.document;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private void flattenImpl(Document newDocument, Node newNode, IncludeFilter includeFilter, CMElementDeclaration includeDecl) {
        Comment comment;
        String location;
        IFile ifile;
        if (!includeFilter.accept(this.getURI())) {
            return;
        }
        Element root = this.getServerElement();
        if (root == null) {
            return;
        }
        for (ConfigurationFile dropin : this.getDefaultDropins()) {
            ifile = dropin.getIFile();
            location = ifile != null ? ifile.getFullPath().toString() : dropin.getPath().toString();
            comment = newDocument.createComment(NLS.bind((String)Messages.mergedConfigBeginDropin, (Object)location));
            newNode.appendChild(comment);
            dropin.flattenImpl(newDocument, newNode, includeFilter, includeDecl);
            comment = newDocument.createComment(NLS.bind((String)Messages.mergedConfigEndDropin, (Object)location));
            newNode.appendChild(comment);
        }
        Element elem = this.getFirstChildElement(root);
        while (elem != null) {
            if (this.isInclude(elem)) {
                ConfigurationFile configFile = this.getIncludes().get(elem);
                if (configFile != null) {
                    ifile = configFile.getIFile();
                    location = ifile != null ? ifile.getFullPath().toString() : configFile.getPath().toString();
                    comment = newDocument.createComment(NLS.bind((String)Messages.mergedConfigBeginInclude, (Object[])new String[]{location, this.formatAttributes(elem, includeDecl)}));
                    newNode.appendChild(comment);
                    configFile.flattenImpl(newDocument, newNode, includeFilter, includeDecl);
                    comment = newDocument.createComment(NLS.bind((String)Messages.mergedConfigEndInclude, (Object)location));
                    newNode.appendChild(comment);
                }
            } else {
                Node cloneNode = newDocument.importNode(elem, true);
                newNode.appendChild(cloneNode);
            }
            elem = this.getNextElement(elem);
        }
        for (ConfigurationFile dropin : this.getOverrideDropins()) {
            ifile = dropin.getIFile();
            location = ifile != null ? ifile.getFullPath().toString() : dropin.getPath().toString();
            comment = newDocument.createComment(NLS.bind((String)Messages.mergedConfigBeginDropin, (Object)location));
            newNode.appendChild(comment);
            dropin.flattenImpl(newDocument, newNode, includeFilter, includeDecl);
            comment = newDocument.createComment(NLS.bind((String)Messages.mergedConfigEndDropin, (Object)location));
            newNode.appendChild(comment);
        }
    }

    private String formatAttributes(Element elem, CMElementDeclaration elemDecl) {
        StringBuilder builder = new StringBuilder();
        if (elemDecl == null) {
            NamedNodeMap attrs = elem.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(attr.getLocalName() + "='" + attr.getValue() + "'");
            }
            return builder.toString();
        }
        CMNamedNodeMap attrs = elemDecl.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String value;
            CMAttributeDeclaration attr = (CMAttributeDeclaration)attrs.item(i);
            String name = attr.getAttrName();
            String string = value = elem.hasAttribute(name) ? elem.getAttribute(name) : attr.getDefaultValue();
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(name + "='" + value + "'");
        }
        return builder.toString();
    }

    public Object getAdapter(Class adapter) {
        if (IResource.class.equals((Object)adapter)) {
            return this.getIFile();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigurationFile)) {
            return false;
        }
        ConfigurationFile cf = (ConfigurationFile)obj;
        if (this.uri == null && cf.uri != null || this.uri != null && !this.uri.equals(cf.uri)) {
            return false;
        }
        if (this.userDir == null && cf.userDir != null || this.userDir != null && !this.userDir.equals(cf.userDir)) {
            return false;
        }
        return this.lastModified == cf.lastModified;
    }

    public int hashCode() {
        int hash = 0;
        if (this.uri != null) {
            hash += this.uri.hashCode();
        }
        if (this.userDir != null) {
            hash += this.userDir.hashCode();
        }
        return hash;
    }

    public String toString() {
        long lastModified = new File(this.uri).lastModified();
        return "WAS Configuration File [" + this.uri.toASCIIString() + ":" + lastModified + "]";
    }

    public int getHTTPPort() {
        return this.getHTTPPort("httpPort", 9080);
    }

    public int getHTTPSPort() {
        return this.getHTTPPort("httpsPort", 9443);
    }

    private int getHTTPPort(String portAttr, int defaultPortNum) {
        List<Element> httpEndpoints = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), "httpEndpoint", "id");
        for (Element elem : httpEndpoints) {
            String port;
            if (!"defaultHttpEndpoint".equals(elem.getAttribute("id")) || (port = elem.getAttribute(portAttr)) == null || port.isEmpty()) continue;
            port = this.resolveValue(port);
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "HttpEndpoint had invalid HttpPort", e);
            }
        }
        String[] tags = new String[]{"server", "httpEndpoint"};
        String defaultPort = SchemaUtil.getAttributeDefault(this.getDomDocument(), tags, portAttr, this.uri);
        if (defaultPort != null) {
            try {
                return Integer.parseInt(defaultPort);
            }
            catch (NumberFormatException e) {
                Trace.logError("Could not parse the schema default port number: " + defaultPort, e);
            }
        }
        return defaultPortNum;
    }

    public String getResolvedAttributeValue(String element, String attribute) {
        String value;
        List<Element> elements = ConfigUtils.getResolvedElements(this.getDocument(), this.getURI(), this.server, this.getUserDirectory(), element, null);
        if (elements.size() > 0 && (value = elements.get(0).getAttribute(attribute)) != null && !value.isEmpty()) {
            return this.resolveValue(value);
        }
        return null;
    }

    private String resolveValue(String value) {
        String envValue;
        if (value == null || value.isEmpty()) {
            return value;
        }
        ConfigVars vars = this.getConfigVars();
        String resolvedEnvValue = vars.resolve(envValue = value.replace("${", "${env."));
        if (resolvedEnvValue != null && !resolvedEnvValue.equals(envValue)) {
            return resolvedEnvValue;
        }
        return vars.resolve(value.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigVars getConfigVars() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.configVars == null) {
                this.configVars = new ConfigVars();
                if (this.server != null) {
                    this.server.getVariables(this.configVars);
                } else if (this.userDir != null) {
                    this.userDir.getVariables(this.configVars);
                }
                if (this.server != null) {
                    CustomServerVariablesManager customServerVariablesManager = CustomServerVariablesManager.getInstance();
                    customServerVariablesManager.addCustomServerVariables(this.configVars, this.server);
                }
                ConfigUtils.getVariables(this, this.configVars);
            }
            return this.configVars;
        }
    }

    public boolean hasChanged() {
        File file = new File(this.uri);
        long timestamp = file.lastModified();
        return timestamp != this.lastModified;
    }

    public boolean isNewerThan(long timestamp, boolean recurse) {
        if (recurse) {
            ArrayList<ConfigurationFile> configFiles = new ArrayList<ConfigurationFile>();
            ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
            this.getAllConfigFiles(configFiles, includeFilter);
            for (ConfigurationFile configFile : configFiles) {
                if (!configFile.isNewerThan(timestamp, false)) continue;
                return true;
            }
            return false;
        }
        File file = new File(this.uri);
        long lastModified = file.lastModified();
        return lastModified > timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Element, ConfigurationFile> getIncludes() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.includes == null) {
                this.includes = new IdentityHashMap();
                this.unresolvedIncludes = new ArrayList<String>();
                Element includeElem = this.getFirstChildElement(this.getServerElement(), "include");
                while (includeElem != null) {
                    String location = this.getAttributeValue(includeElem, "location");
                    if (location != null) {
                        boolean referenceInInclude = ConfigVarsUtils.containsReference(location);
                        URI includeURI = referenceInInclude && this.server != null ? this.server.resolve(this.getURI(), location) : this.getUserDirectory().resolve(this.getURI(), location);
                        try {
                            if (includeURI != null && new File(includeURI).exists()) {
                                if (!includeURI.equals(this.getURI())) {
                                    ConfigurationFile config = new ConfigurationFile(includeURI, this.getUserDirectory(), this.server);
                                    this.includes.put(includeElem, config);
                                }
                            } else {
                                this.unresolvedIncludes.add(location);
                            }
                        }
                        catch (FileNotFoundException e) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)1, "Invalid file: " + includeURI);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)1, "Invalid uri: " + includeURI);
                            }
                        }
                        catch (Exception e) {
                            Trace.logError("Error loading config file " + includeURI, e);
                        }
                    }
                    includeElem = this.getNextElement(includeElem, "include");
                }
            }
            return this.includes;
        }
    }

    private boolean hasOutOfSyncDropins() {
        if (this.server == null || !this.isConfigRoot()) {
            return false;
        }
        List<File> dropins = this.getDropinFiles(this.server.getConfigDefaultDropinsPath());
        if (this.checkDropins(this.defaultDropins, dropins)) {
            return true;
        }
        dropins = this.getDropinFiles(this.server.getConfigOverrideDropinsPath());
        return this.checkDropins(this.overrideDropins, dropins);
    }

    private boolean checkDropins(List<ConfigurationFile> oldDropins, List<File> newDropins) {
        if (oldDropins == null) {
            return newDropins != null && newDropins.size() > 0;
        }
        if (newDropins == null) {
            return oldDropins.size() > 0;
        }
        if (oldDropins.size() != newDropins.size()) {
            return true;
        }
        for (ConfigurationFile dropin : oldDropins) {
            File file = new File(dropin.getURI());
            if (file.exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationFile> getDefaultDropins() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.defaultDropins == null) {
                this.defaultDropins = this.server != null && this.isConfigRoot() ? this.getDropins(this.server.getConfigDefaultDropinsPath()) : Collections.emptyList();
            }
            return this.defaultDropins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationFile> getOverrideDropins() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.overrideDropins == null) {
                this.overrideDropins = this.server != null && this.isConfigRoot() ? this.getDropins(this.server.getConfigOverrideDropinsPath()) : Collections.emptyList();
            }
            return this.overrideDropins;
        }
    }

    private List<File> getDropinFiles(IPath path) {
        ArrayList<File> dropins = new ArrayList<File>();
        if (path != null && path.toFile().isDirectory()) {
            File[] files;
            for (File file : files = path.toFile().listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(XML_EXTENSION)) continue;
                dropins.add(file);
            }
        }
        return dropins;
    }

    private List<ConfigurationFile> getDropins(IPath path) {
        File[] files;
        ArrayList<ConfigurationFile> dropins = new ArrayList<ConfigurationFile>();
        for (File file : files = FileUtil.getSortedFiles(path.toFile(), true)) {
            try {
                if (!file.getName().endsWith(XML_EXTENSION)) continue;
                ConfigurationFile config = new ConfigurationFile(file.toURI(), this.getUserDirectory(), this.server);
                dropins.add(config);
            }
            catch (Exception e) {
                Trace.logError("Error loading config file " + file.toURI(), e);
            }
        }
        return dropins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIncludes() {
        Object object = this.configLock;
        synchronized (object) {
            this.includes = null;
            this.unresolvedIncludes = null;
            this.defaultDropins = null;
            this.overrideDropins = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encodePassword(String xpath) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node node = DOMUtils.getNode(doc, xpath);
            if (node != null && node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                String value = attr.getValue();
                WebSphereRuntime wsRuntime = null;
                if (this.server != null) {
                    wsRuntime = this.server.getWebSphereRuntime();
                }
                if ((value = ConfigUtils.encodePassword(value, wsRuntime)) != null) {
                    attr.setValue(value);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVariable(String name, String value) {
        Object object = this.configLock;
        synchronized (object) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "ConfigurationFile adding variable name: " + name + " value: " + value);
            }
            try {
                Element variableElement = this.addElement("variable");
                variableElement.setAttribute("name", name);
                variableElement.setAttribute("value", value);
                return true;
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.logError("Failed to add a variable element", e);
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceVariableReference(String xpath, String reference, int referenceOffset, String replacement) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node node = DOMUtils.getNode(doc, xpath);
            if (node != null && node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                String value = attr.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append(value.substring(0, referenceOffset));
                sb.append(replacement);
                sb.append(value.substring(referenceOffset + reference.length(), value.length()));
                attr.setValue(sb.toString());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePropertyName(String xpath, String name) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node node = DOMUtils.getNode(doc, xpath);
            if (node != null && node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                String value = attr.getValue();
                Element elem = attr.getOwnerElement();
                elem.removeAttribute(attr.getNodeName());
                elem.setAttribute(name, value);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeElementName(String xpath, String name) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node node = DOMUtils.getNode(doc, xpath);
            if (node != null && node.getNodeType() == 1) {
                Element elem = doc.createElement(name);
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node attr = attrs.item(i);
                        elem.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    }
                }
                Node child = node.getFirstChild();
                while (child != null) {
                    Node next = child.getNextSibling();
                    elem.appendChild(child);
                    child = next;
                }
                Node parent = node.getParentNode();
                Node sibling = node.getNextSibling();
                parent.removeChild(node);
                if (sibling == null) {
                    parent.appendChild(elem);
                } else {
                    parent.insertBefore(elem, sibling);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeFeature(String xpath, String feature) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node oldTextNode;
            Node node = DOMUtils.getNode(doc, xpath);
            if (node != null && "feature".equals(node.getNodeName()) && (oldTextNode = DOMUtils.getTextNode(node)) != null) {
                Text newTextNode = doc.createTextNode(feature);
                node.replaceChild(newTextNode, oldTextNode);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeFactoryRef(String xpath, String newRef, String oldRef, int index) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node node = DOMUtils.getNode(doc, xpath);
            boolean found = false;
            if (node != null && node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                String oldValue = attr.getValue();
                String[] items = oldValue.split("[, ]+");
                StringBuilder builder = new StringBuilder();
                boolean first = true;
                for (int i = 0; i < items.length; ++i) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    if (i == index && oldRef.equals(items[i])) {
                        builder.append(newRef);
                        found = true;
                        continue;
                    }
                    builder.append(items[i]);
                }
                attr.setValue(builder.toString());
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDupFactoryRef(String xpath, String ref, int index) {
        Document doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        Object object = this.configLock;
        synchronized (object) {
            Node node = DOMUtils.getNode(doc, xpath);
            boolean found = false;
            if (node != null && node.getNodeType() == 2) {
                Attr attr = (Attr)node;
                String oldValue = attr.getValue();
                String[] items = oldValue.split("[, ]+");
                StringBuilder builder = new StringBuilder();
                boolean first = true;
                for (int i = 0; i < items.length; ++i) {
                    if (i == index && ref.equals(items[i])) {
                        found = true;
                        continue;
                    }
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(items[i]);
                }
                attr.setValue(builder.toString());
            }
            return found;
        }
    }

    private Element getServerElement() {
        return this.serverElement;
    }

    private Element getFirstChildElement(Element element) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private Element getNextElement(Element element) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private Element getFirstChildElement(Element element, String name) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getFirstChild(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private Element getNextElement(Element element, String name) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private String getAttributeValue(Element element, String name) {
        if (element == null) {
            return null;
        }
        Attr attr = element.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private boolean isInclude(Element element) {
        return element.getNodeName().equals("include");
    }

    private void removeInitialComments() {
        Node node = this.serverElement.getFirstChild();
        while (node != null) {
            String value;
            Node current = node;
            node = node.getNextSibling();
            if (current.getNodeType() != 8 || !this.isInitialComment(value = current.getNodeValue().replaceAll("\\s", ""))) continue;
            Node previous = current.getPreviousSibling();
            if (previous != null && previous.getNodeType() == 3 && node != null && node.getNodeType() == 3) {
                this.serverElement.removeChild(previous);
            }
            this.serverElement.removeChild(current);
        }
    }

    private boolean isInitialComment(String value) {
        return COMMENT_TEXT1.equals(value) || COMMENT_TEXT2.equals(value);
    }

    public Element getApplicationElement(String appElementLabel, String appName) {
        String type;
        if (appElementLabel == null || appName == null) {
            return null;
        }
        boolean isSupportAppElement = this.server.getSchemaHelper().isSupportedApplicationElement(appElementLabel);
        if (isSupportAppElement) {
            Element appElem = this.getFirstChildElement(this.getServerElement(), appElementLabel);
            while (appElem != null) {
                if (appName.equals(this.getAppName(appElem))) {
                    return appElem;
                }
                appElem = this.getNextElement(appElem, appElementLabel);
            }
        }
        if ((type = ServerExtensionWrapper.getAppTypeFromAppElement(appElementLabel)) != null) {
            Element appElem = this.getFirstChildElement(this.getServerElement(), "application");
            while (appElem != null) {
                if (appName.equals(this.getAppName(appElem))) {
                    return appElem;
                }
                appElem = this.getNextElement(appElem, "application");
            }
        }
        return null;
    }

    public String getAppMonitorUpdateTrigger() {
        Element monitor = this.getFirstChildElement(this.getServerElement(), "applicationMonitor");
        if (monitor != null) {
            return monitor.getAttribute("updateTrigger");
        }
        return null;
    }

    public void removeFeatures(Collection<String> features) {
        for (String feature : features) {
            this.removeFeature(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        Object object = this.configLock;
        synchronized (object) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "ConfigurationFile removing feature: " + feature);
            }
            Element fManager = this.getFirstChildElement(this.getServerElement(), "featureManager");
            while (fManager != null) {
                Element fElem = this.getFirstChildElement(fManager);
                while (fElem != null) {
                    if (feature.equals(fElem.getTextContent())) {
                        this.removeElement(fElem);
                        return;
                    }
                    fElem = this.getNextElement(fElem);
                }
                fManager = this.getNextElement(fManager, "featureManager");
            }
        }
    }

    public boolean isConfigRoot() {
        if (this.uri == null || this.userDir == null) {
            return false;
        }
        URI relative = URIUtil.canonicalRelativize(this.userDir.getServersPath().toFile().toURI(), this.uri);
        if (relative.isAbsolute()) {
            return false;
        }
        String path = relative.getPath();
        String[] splitPath = path.split("/");
        return splitPath.length == 2 && "server.xml".equals(splitPath[1]);
    }

    public static enum LOCATION_TYPE {
        SERVER,
        SHARED,
        URL,
        FILE_SYSTEM;

    }

    public static class Application {
        private final String name;
        private final String type;
        private final String location;
        private final String autoStart;
        private final List<LibRef> sharedLibRefs;
        EnumSet<APIVisibility> apiVisibility;
        private final String contextRoot;

        public Application(String name, String type, String location, String autoStart, List<LibRef> sharedLibRefs, EnumSet<APIVisibility> apiVisibility, String contextRoot) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.autoStart = autoStart;
            this.sharedLibRefs = sharedLibRefs;
            this.apiVisibility = apiVisibility;
            this.contextRoot = contextRoot;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAutoStart() {
            return this.autoStart;
        }

        public List<LibRef> getSharedLibRefs() {
            return this.sharedLibRefs;
        }

        public EnumSet<APIVisibility> getAPIVisibility() {
            return this.apiVisibility;
        }

        public String getContextRoot() {
            return this.contextRoot;
        }

        public String toString() {
            return "Application[" + this.getName() + "]";
        }
    }

    public static enum LibraryRefType {
        COMMON("common", "commonLibraryRef"),
        PRIVATE("private", "privateLibraryRef");

        private final String name;
        private final String elementName;

        private LibraryRefType(String name, String elementName) {
            this.name = name;
            this.elementName = elementName;
        }

        public String getName() {
            return this.name;
        }

        public String getElementName() {
            return this.elementName;
        }

        public static LibraryRefType getLibraryRefType(String name) {
            for (LibraryRefType type : LibraryRefType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return COMMON;
        }
    }

    public static class LibRef {
        public final String id;
        public final LibraryRefType type;

        public LibRef(String id, LibraryRefType type) {
            this.id = id;
            this.type = type;
        }

        public static int getListIndex(List<LibRef> refs, String id) {
            if (refs == null || id == null) {
                return -1;
            }
            for (int i = 0; i < refs.size(); ++i) {
                if (!id.equals(refs.get((int)i).id)) continue;
                return i;
            }
            return -1;
        }

        public static boolean listContains(List<LibRef> refs, String id) {
            return LibRef.getListIndex(refs, id) >= 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LibRef)) {
                return false;
            }
            LibRef ref = (LibRef)obj;
            return this.id.equals(ref.id) && this.type == ref.type;
        }

        public int hashCode() {
            return (this.id + "_" + this.type.getElementName()).hashCode();
        }

        public String toString() {
            return this.id + " (" + (Object)((Object)this.type) + ")";
        }
    }
}

