/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.expression.Expression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;

public class ConfigVars {
    private static final String DURATION_EXPR = "(\\d+)(\\D+)";
    private static final Pattern durationPattern = Pattern.compile("(\\d+)(\\D+)");
    private static final Set<String> durationUnits;
    private static final Set<String> englishDurationUnits;
    public static final String WLP_INSTALL_DIR = "wlp.install.dir";
    public static final String WLP_USER_DIR = "wlp.user.dir";
    public static final String WLP_SERVER_NAME = "wlp.server.name";
    public static final String SHARED_APP_DIR = "shared.app.dir";
    public static final String SHARED_CONFIG_DIR = "shared.config.dir";
    public static final String SHARED_RESOURCE_DIR = "shared.resource.dir";
    public static final String SERVER_CONFIG_DIR = "server.config.dir";
    public static final String SERVER_OUTPUT_DIR = "server.output.dir";
    public static final String USR_EXTENSION_DIR = "usr.extension.dir";
    public static final Type STRING_TYPE;
    public static final Type LOCATION_TYPE;
    public static final EnumSet<Type> BOOLEAN_TYPES;
    public static final EnumSet<Type> SHORT_TYPES;
    public static final EnumSet<Type> INT_TYPES;
    public static final EnumSet<Type> LONG_TYPES;
    public static final EnumSet<Type> LOCATION_TYPES;
    public static final EnumSet<Type> DURATION_TYPES;
    public static final EnumSet<Type> REFERENCE_TYPES;
    public static final EnumSet<Type> STRING_TYPES;
    public static final HashMap<String, EnumSet<Type>> TYPE_MAP;
    public static final HashMap<EnumSet<Type>, String> TYPE_NAME_MAP;
    public static final HashSet<String> PREDEFINED_VARS;
    public static final String LIST_START = "list(";
    public static final String LIST_END = ")";
    private final HashMap<String, String> varValues = new HashMap();
    private final HashMap<String, Type> varTypes = new HashMap();
    private final HashMap<String, DocumentLocation> varLocations = new HashMap();
    private final ConfigVarsContext context = new ConfigVarsContext();

    public boolean isGlobalScope() {
        return true;
    }

    public void startContext() {
        this.context.start();
    }

    public void endContext() {
        this.context.end();
    }

    public void add(String name, String value, DocumentLocation location) {
        this.add(name, value, null, location);
    }

    public void add(String name, String value, Type type) {
        this.add(name, value, type, null);
    }

    public void add(String name, String value, Type type, DocumentLocation location) {
        String resolvedValue;
        boolean needToResolveValue = ConfigVarsUtils.containsReference(value);
        if (needToResolveValue) {
            if (this.context.isActive()) {
                this.context.addUnresolved(name, value, type);
                return;
            }
            resolvedValue = this.resolve(value);
        } else {
            resolvedValue = value;
        }
        this.addResolved(name, resolvedValue, type, location);
    }

    public void addResolved(String name, String value, Type type, DocumentLocation location) {
        if (location != null) {
            this.varLocations.put(name, location);
        }
        Type resolvedType = type == null ? this.computeType(value) : type;
        this.addResolved(name, value, resolvedType);
    }

    protected void addResolved(String name, String value, Type type) {
        this.varValues.put(name, value);
        this.varTypes.put(name, type);
    }

    public String getValue(String name) {
        return this.varValues.get(name);
    }

    public Type getType(String name) {
        return this.varTypes.get(name);
    }

    public boolean isDefined(String name) {
        return this.varValues.containsKey(name);
    }

    public String getTypeName(CMDataType type) {
        EnumSet<Type> typeSet = ConfigVars.getTypeSet(type);
        return TYPE_NAME_MAP.get(typeSet);
    }

    public String getTypeName(String type) {
        EnumSet<Type> typeSet = ConfigVars.getTypeSet(type);
        return TYPE_NAME_MAP.get(typeSet);
    }

    public DocumentLocation getDocumentLocation(String name) {
        return this.varLocations.get(name);
    }

    public List<String> getVars(EnumSet<Type> types, boolean includeUnresolvedPredefined) {
        return this.getScopedVars(types, includeUnresolvedPredefined, false);
    }

    public List<String> getSortedVars(EnumSet<Type> types, boolean includeUnresolvedPredefined) {
        List<String> vars = this.getVars(types, includeUnresolvedPredefined);
        Collections.sort(vars);
        return vars;
    }

    public List<String> getVars(CMDataType type, boolean includeUnresolvedPredefined) {
        return this.getVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined);
    }

    public List<String> getVars(String type, boolean includeUnresolvedPredefined) {
        return this.getVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined);
    }

    public List<String> getSortedVars(String type, boolean includeUnresolvedPredefined) {
        return this.getSortedVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined);
    }

    public List<String> getGlobalVars(EnumSet<Type> types, boolean includeUnresolvedPredefined, boolean sort) {
        return this.getScopedVars(types, includeUnresolvedPredefined, sort);
    }

    public List<String> getGlobalVars(CMDataType type, boolean includeUnresolvedPredefined, boolean sort) {
        return this.getGlobalVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined, sort);
    }

    public List<String> getGlobalVars(String type, boolean includeUnresolvedPredefined, boolean sort) {
        return this.getGlobalVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined, sort);
    }

    public List<String> getScopedVars(EnumSet<Type> types, boolean includeUnresolvedPredefined, boolean sort) {
        ArrayList<String> vars = new ArrayList<String>();
        for (Map.Entry<String, Type> entry : this.varTypes.entrySet()) {
            if (!types.contains((Object)entry.getValue())) continue;
            vars.add(entry.getKey());
        }
        if (this.isGlobalScope() && includeUnresolvedPredefined && types.contains((Object)Type.LOCATION)) {
            vars.addAll(this.getUnresolvedPredefinedVars());
        }
        if (sort) {
            Collections.sort(vars);
        }
        return vars;
    }

    public List<String> getScopedVars(CMDataType type, boolean includeUnresolvedPredefined, boolean sort) {
        return this.getScopedVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined, sort);
    }

    public List<String> getScopedVars(String type, boolean includeUnresolvedPredefined, boolean sort) {
        return this.getScopedVars(ConfigVars.getTypeSet(type), includeUnresolvedPredefined, sort);
    }

    public static EnumSet<Type> getTypeSet(CMDataType type) {
        EnumSet<Type> types = null;
        if (type != null) {
            String typeName = type.getDataTypeName();
            types = TYPE_MAP.get(typeName);
        }
        if (types == null) {
            types = STRING_TYPES;
        }
        return types;
    }

    public static EnumSet<Type> getTypeSet(String typeName) {
        EnumSet<Type> types = TYPE_MAP.get(typeName);
        if (types == null) {
            types = STRING_TYPES;
        }
        return types;
    }

    public static boolean isAtomic(CMDataType type) {
        return TYPE_MAP.containsKey(type.getDataTypeName());
    }

    public boolean isPredefinedVar(String name) {
        return PREDEFINED_VARS.contains(name);
    }

    private List<String> getUnresolvedPredefinedVars() {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : PREDEFINED_VARS) {
            if (this.isDefined(name)) continue;
            list.add(name);
        }
        return list;
    }

    protected Type computeType(String value) {
        try {
            long l = Long.parseLong(value);
            if (l <= 32767L && l >= -32768L) {
                return Type.SHORT;
            }
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return Type.INT;
            }
            return Type.LONG;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.isBooleanType(value)) {
                return Type.BOOLEAN;
            }
            if (ConfigVars.isDurationType(value)) {
                return Type.DURATION;
            }
            return Type.STRING;
        }
    }

    private boolean isBooleanType(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    public static boolean isDurationType(String value) {
        if (ConfigVars.isDurationType(value, durationUnits)) {
            return true;
        }
        return ConfigVars.isDurationType(value, englishDurationUnits);
    }

    private static boolean isDurationType(String value, Set<String> durationUnits) {
        Matcher matcher = durationPattern.matcher(value);
        while (matcher.find()) {
            String unitStr = matcher.group(2);
            if (unitStr == null || !durationUnits.contains(unitStr)) {
                return false;
            }
            if (!matcher.hitEnd()) continue;
            return true;
        }
        return false;
    }

    public String resolve(String value) {
        ResolvedValueInfo info = new ResolvedValueInfo();
        this.resolve(value, info);
        return info.getResolvedValue();
    }

    public void resolve(String value, ResolvedValueInfo info) {
        this.resolve(value, info, null);
    }

    public void resolve(String value, ResolvedValueInfo info, String expectedTypeName) {
        int end;
        StringBuilder builder = new StringBuilder();
        int offset = 0;
        int start = value.indexOf("${");
        info.reset();
        while (start >= 0 && (end = value.indexOf("}", start)) >= 0) {
            builder.append(value, offset, start);
            String varName = value.substring(start + 2, end);
            int varOffset = start + 2;
            Expression expression = null;
            if (varName.startsWith(LIST_START) && varName.endsWith(LIST_END)) {
                varName = varName.substring(LIST_START.length(), varName.length() - 1);
                varOffset += LIST_START.length();
            } else {
                expression = new Expression(varName);
            }
            if (expression != null && expression.getOperator() != null) {
                Expression chainedExpression = new Expression(expression.getRightOperand());
                if (chainedExpression.getOperator() != null) {
                    info.setInvalidExpression(true);
                } else {
                    String expressionResult = this.calculateExpression(expression, info);
                    if (expressionResult != null) {
                        builder.append(expressionResult);
                    } else {
                        builder.append(varName);
                    }
                }
            } else {
                String varValue = this.getValue(varName);
                if (varValue != null) {
                    builder.append(varValue);
                    if (expectedTypeName != null && !this.checkType(this.getType(varName), expectedTypeName)) {
                        info.setTypeMismatch(true);
                    }
                } else {
                    info.addUndefinedReference(varName, varOffset);
                    builder.append(value, start, end + 1);
                }
            }
            offset = end + 1;
            start = value.indexOf("${", offset);
        }
        if (offset < value.length()) {
            builder.append(value, offset, value.length());
        }
        info.setResolvedValue(builder.toString());
    }

    private String calculateExpression(Expression expression, ResolvedValueInfo info) {
        long leftOperandLongValue = 0L;
        long rightOperandLongValue = 0L;
        String leftOperand = expression.getLeftOperand();
        if (leftOperand.length() > 0) {
            if (!LONG_TYPES.contains((Object)this.computeType(leftOperand))) {
                leftOperand = this.getValue(leftOperand);
            }
            if (leftOperand == null) {
                info.setExpressionLeftOperandError(ExpressionOperandError.UNDEFINED);
            } else {
                try {
                    leftOperandLongValue = Long.parseLong(leftOperand);
                }
                catch (NumberFormatException numberFormatException) {
                    info.setExpressionLeftOperandError(ExpressionOperandError.INVALID_VALUE);
                }
            }
        } else {
            info.setExpressionLeftOperandError(ExpressionOperandError.MISSING);
        }
        String rightOperand = expression.getRightOperand();
        if (rightOperand.length() > 0) {
            if (!LONG_TYPES.contains((Object)this.computeType(rightOperand))) {
                rightOperand = this.getValue(rightOperand);
            }
            if (rightOperand == null) {
                info.setExpressionRightOperandError(ExpressionOperandError.UNDEFINED);
            } else {
                try {
                    rightOperandLongValue = Long.parseLong(rightOperand);
                }
                catch (NumberFormatException numberFormatException) {
                    info.setExpressionRightOperandError(ExpressionOperandError.INVALID_VALUE);
                }
            }
        } else {
            info.setExpressionRightOperandError(ExpressionOperandError.MISSING);
        }
        if (info.getExpressionLeftOperandError() == null && info.getExpressionRightOperandError() == null) {
            switch (expression.getOperator()) {
                case ADDITION: {
                    return Long.toString(leftOperandLongValue + rightOperandLongValue);
                }
                case SUBTRACTION: {
                    return Long.toString(leftOperandLongValue - rightOperandLongValue);
                }
                case MULTIPLICATION: {
                    return Long.toString(leftOperandLongValue * rightOperandLongValue);
                }
                case DIVISION: {
                    return Long.toString(leftOperandLongValue / rightOperandLongValue);
                }
            }
        }
        return null;
    }

    public boolean checkType(String value, String expectedTypeName) {
        EnumSet<Type> types = ConfigVars.getTypeSet(expectedTypeName);
        if (types.equals(STRING_TYPES)) {
            return true;
        }
        Type type = this.computeType(value);
        return this.checkType(type, expectedTypeName);
    }

    protected boolean checkType(Type actualType, String expectedTypeName) {
        EnumSet<Type> types = ConfigVars.getTypeSet(expectedTypeName);
        return types.contains((Object)actualType);
    }

    public void copyInto(ConfigVars vars) {
        vars.varValues.putAll(this.varValues);
        vars.varTypes.putAll(this.varTypes);
        vars.varLocations.putAll(this.varLocations);
    }

    public String toString() {
        return "Values: " + this.varValues.toString() + "\nTypes: " + this.varTypes.toString();
    }

    static {
        HashSet<String> set = new HashSet<String>(5);
        set.add(Messages.durationDayAbbreviation);
        set.add(Messages.durationHourAbbreviation);
        set.add(Messages.durationMinuteAbbreviation);
        set.add(Messages.durationSecondAbbreviation);
        set.add(Messages.durationMillisecondAbbreviation);
        durationUnits = Collections.unmodifiableSet(set);
        set = new HashSet(5);
        set.add("d");
        set.add("h");
        set.add("m");
        set.add("s");
        set.add("ms");
        englishDurationUnits = Collections.unmodifiableSet(set);
        STRING_TYPE = Type.STRING;
        LOCATION_TYPE = Type.LOCATION;
        BOOLEAN_TYPES = EnumSet.of(Type.BOOLEAN);
        SHORT_TYPES = EnumSet.of(Type.SHORT);
        INT_TYPES = EnumSet.of(Type.INT, Type.SHORT);
        LONG_TYPES = EnumSet.of(Type.LONG, Type.INT, Type.SHORT);
        LOCATION_TYPES = EnumSet.allOf(Type.class);
        DURATION_TYPES = EnumSet.of(Type.DURATION, Type.LONG, Type.INT, Type.SHORT);
        REFERENCE_TYPES = EnumSet.allOf(Type.class);
        STRING_TYPES = EnumSet.allOf(Type.class);
        TYPE_MAP = new HashMap();
        TYPE_NAME_MAP = new HashMap();
        PREDEFINED_VARS = new HashSet();
        TYPE_MAP.put("boolean", BOOLEAN_TYPES);
        TYPE_MAP.put("booleanType", BOOLEAN_TYPES);
        TYPE_MAP.put("short", SHORT_TYPES);
        TYPE_MAP.put("shortType", SHORT_TYPES);
        TYPE_MAP.put("int", INT_TYPES);
        TYPE_MAP.put("intType", INT_TYPES);
        TYPE_MAP.put("long", LONG_TYPES);
        TYPE_MAP.put("longType", LONG_TYPES);
        TYPE_MAP.put("duration", DURATION_TYPES);
        TYPE_MAP.put("minuteDuration", DURATION_TYPES);
        TYPE_MAP.put("secondDuration", DURATION_TYPES);
        TYPE_MAP.put("location", STRING_TYPES);
        TYPE_MAP.put("pidType", REFERENCE_TYPES);
        TYPE_MAP.put("pidListType", REFERENCE_TYPES);
        TYPE_MAP.put("string", STRING_TYPES);
        TYPE_MAP.put("token", STRING_TYPES);
        TYPE_NAME_MAP.put(BOOLEAN_TYPES, "boolean");
        TYPE_NAME_MAP.put(SHORT_TYPES, "short");
        TYPE_NAME_MAP.put(INT_TYPES, "int");
        TYPE_NAME_MAP.put(LONG_TYPES, "long");
        TYPE_NAME_MAP.put(LOCATION_TYPES, "string");
        TYPE_NAME_MAP.put(DURATION_TYPES, "duration");
        TYPE_NAME_MAP.put(REFERENCE_TYPES, "string");
        TYPE_NAME_MAP.put(STRING_TYPES, "string");
        PREDEFINED_VARS.add(WLP_INSTALL_DIR);
        PREDEFINED_VARS.add(WLP_USER_DIR);
        PREDEFINED_VARS.add(WLP_SERVER_NAME);
        PREDEFINED_VARS.add(SHARED_APP_DIR);
        PREDEFINED_VARS.add(SHARED_CONFIG_DIR);
        PREDEFINED_VARS.add(SHARED_RESOURCE_DIR);
        PREDEFINED_VARS.add(SERVER_CONFIG_DIR);
        PREDEFINED_VARS.add(SERVER_OUTPUT_DIR);
        PREDEFINED_VARS.add(USR_EXTENSION_DIR);
    }

    protected class ConfigVarsContext {
        private final HashMap<String, String> unresolvedVarValues = new HashMap();
        private final HashMap<String, Type> unresolvedVarTypes = new HashMap();
        private final HashMap<String, ArrayList<String>> unresolvedVarReferences = new HashMap();
        private final HashMap<String, Boolean> unresolvedVarFlags = new HashMap();
        private final Stack<String> varStack = new Stack();
        private int activeCounter = 0;

        protected ConfigVarsContext() {
        }

        protected boolean isActive() {
            return this.activeCounter > 0;
        }

        protected void addUnresolved(String name, String value, Type type) {
            ArrayList<String> refs = this.getReferences(value);
            this.unresolvedVarValues.put(name, value);
            if (type != null) {
                this.unresolvedVarTypes.put(name, type);
            }
            this.unresolvedVarReferences.put(name, refs);
        }

        private ArrayList<String> getReferences(String value) {
            int end;
            ArrayList<String> refs = new ArrayList<String>(2);
            int offset = 0;
            int start = value.indexOf("${");
            while (start >= 0 && (end = value.indexOf("}", start)) >= 0) {
                refs.add(value.substring(start + 2, end));
                offset = end + 1;
                start = value.indexOf("${", offset);
            }
            return refs;
        }

        protected void start() {
            if (++this.activeCounter > 1) {
                return;
            }
            if (this.unresolvedVarValues.size() > 0) {
                this.unresolvedVarValues.clear();
            }
            if (this.unresolvedVarTypes.size() > 0) {
                this.unresolvedVarTypes.clear();
            }
            if (this.unresolvedVarFlags.size() > 0) {
                this.unresolvedVarFlags.clear();
            }
            if (this.unresolvedVarReferences.size() > 0) {
                this.unresolvedVarReferences.clear();
            }
        }

        protected void end() {
            if (this.activeCounter == 0) {
                return;
            }
            if (--this.activeCounter == 0) {
                Set<Map.Entry<String, String>> entries = this.unresolvedVarValues.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    String name = entry.getKey();
                    if (this.isResolved(name)) continue;
                    this.resolveAndAdd(name, entry.getValue(), this.unresolvedVarTypes.get(name));
                }
            }
        }

        private void resolveAndAdd(String name, String value, Type type) {
            this.varStack.push(name);
            ArrayList<String> refs = this.unresolvedVarReferences.get(name);
            for (String varRef : refs) {
                String varRefValue = this.unresolvedVarValues.get(varRef);
                if (varRefValue == null || this.varStack.contains(varRef) || this.isResolved(varRef)) continue;
                this.resolveAndAdd(varRef, varRefValue, this.unresolvedVarTypes.get(varRef));
            }
            String resolvedValue = ConfigVars.this.resolve(value);
            Type resolvedType = type == null ? ConfigVars.this.computeType(resolvedValue) : type;
            ConfigVars.this.addResolved(name, resolvedValue, resolvedType);
            this.unresolvedVarFlags.put(name, Boolean.TRUE);
            this.varStack.pop();
        }

        private boolean isResolved(String name) {
            return Boolean.TRUE.equals(this.unresolvedVarFlags.get(name));
        }
    }

    public static enum Type {
        BOOLEAN("boolean"),
        SHORT("short"),
        INT("int"),
        LONG("long"),
        LOCATION("string"),
        DURATION("duration"),
        STRING("string"),
        TOKEN("token");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ResolvedValueInfo {
        private static int UNDEFINED_THRESHOLD = 4;
        private String resolvedValue;
        private boolean typeMismatch;
        private boolean invalidExpression;
        private ExpressionOperandError expressionLeftOperandError;
        private ExpressionOperandError expressionRightOperandError;
        private final ArrayList<UndefinedReference> undefinedList = new ArrayList(2);

        protected void reset() {
            this.resolvedValue = null;
            this.typeMismatch = false;
            this.invalidExpression = false;
            this.expressionLeftOperandError = null;
            this.expressionRightOperandError = null;
            this.undefinedList.clear();
        }

        public String getResolvedValue() {
            return this.resolvedValue;
        }

        public boolean isFullyResolved() {
            return this.undefinedList.size() == 0;
        }

        public boolean isTypeMismatch() {
            return this.typeMismatch;
        }

        public boolean isInvalidExpression() {
            return this.invalidExpression;
        }

        public ExpressionOperandError getExpressionLeftOperandError() {
            return this.expressionLeftOperandError;
        }

        public ExpressionOperandError getExpressionRightOperandError() {
            return this.expressionRightOperandError;
        }

        public UndefinedReference[] getUndefinedReferences() {
            if (this.undefinedList.size() == 0) {
                return null;
            }
            UndefinedReference[] refArray = new UndefinedReference[this.undefinedList.size()];
            this.undefinedList.toArray(refArray);
            return refArray;
        }

        protected void setResolvedValue(String value) {
            this.resolvedValue = value;
        }

        protected void setTypeMismatch(boolean value) {
            this.typeMismatch = value;
        }

        protected void setInvalidExpression(boolean invalidExpression) {
            this.invalidExpression = invalidExpression;
        }

        protected void setExpressionLeftOperandError(ExpressionOperandError expressionLeftOperandError) {
            this.expressionLeftOperandError = expressionLeftOperandError;
        }

        protected void setExpressionRightOperandError(ExpressionOperandError expressionRightOperandError) {
            this.expressionRightOperandError = expressionRightOperandError;
        }

        protected void addUndefinedReference(String name, int offset) {
            if (this.undefinedList.size() < UNDEFINED_THRESHOLD) {
                UndefinedReference ref = new UndefinedReference(name, offset);
                this.undefinedList.add(ref);
            }
        }
    }

    public static enum ExpressionOperandError {
        MISSING,
        UNDEFINED,
        INVALID_VALUE;

    }

    public static class UndefinedReference {
        private final String name;
        private final int startOffset;

        protected UndefinedReference(String reference, int offset) {
            this.name = reference;
            this.startOffset = offset;
        }

        public String getReferenceName() {
            return this.name;
        }

        public int getReferenceOffset() {
            return this.startOffset;
        }
    }
}

