/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.LibertyRuntimeProvider;
import com.ibm.ws.st.core.internal.LibertyRuntimeProviderExtension;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationIncludeFilter;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.config.IncludeConflictResolution;
import com.ibm.ws.st.core.internal.config.IncludeFilter;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.URILocation;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

public class ConfigUtils {
    private static final String CONTENT_TYPE_ID = "com.ibm.ws.st.configuration";
    public static final int PASSWORD_OK = 0;
    public static final int PASSWORD_PLAIN_TEXT = 1;
    public static final int PASSWORD_NOT_SUPPORT_AES = 2;
    public static final int PASSWORD_NOT_SUPPORT_HASH = 3;
    public static final int PASSWORD_NOT_SUPPORT_CUSTOM = 4;
    private static final String VARIABLE_TYPE = "variableType";
    public static final String MERGED_FOLDER = "mergedFolder";
    public static final String DOCUMENT_LOCATION_KEY = "documentLocationKey";
    private static final UserDataHandler docLocationDataHandler = new DocLocationDataHandler();

    public static String encodePassword(String password, WebSphereRuntime wsRuntime) {
        block7: {
            if (password == null || password.length() == 0 || ConfigUtils.validatePassword(password, null, wsRuntime) != 1) {
                return password;
            }
            try {
                return PasswordUtil.encode((String)password);
            }
            catch (InvalidPasswordEncodingException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not encode password", e);
                }
            }
            catch (UnsupportedCryptoAlgorithmException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not encode password", e);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block7;
                Trace.trace((byte)1, "Caught unexpected exception while encoding password", e);
            }
        }
        return null;
    }

    public static int validatePassword(String password, String passwordType, WebSphereRuntime wsRuntime) {
        boolean isVersion850;
        if (password == null) {
            return 1;
        }
        String data = password;
        if (data.length() < 2 || data.charAt(0) != '{') {
            return 1;
        }
        int end = data.indexOf(125, 1);
        if (end < 1) {
            return 1;
        }
        String algorithm = password.substring(1, end);
        if ("xor".equals(algorithm)) {
            return 0;
        }
        boolean bl = isVersion850 = wsRuntime != null && wsRuntime.getRuntimeVersion().startsWith("8.5.0");
        if ("aes".equals(algorithm)) {
            if (isVersion850) {
                return 2;
            }
            return 0;
        }
        if ("hash".equals(algorithm)) {
            if (passwordType != null && !"passwordHash".equals(passwordType)) {
                return 3;
            }
            return 0;
        }
        if (wsRuntime != null && !algorithm.isEmpty()) {
            List<String> supportedCustomEncryption = wsRuntime.getSupportedCustomEncryption();
            if (supportedCustomEncryption != null && supportedCustomEncryption.contains(algorithm)) {
                return 0;
            }
            if (algorithm.contains("custom")) {
                return 0;
            }
            return 4;
        }
        return 1;
    }

    public static String getEncryptionAlgorithm(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() < 2 || value.charAt(0) != '{') {
            return null;
        }
        int end = value.indexOf(125, 1);
        if (end < 1) {
            return null;
        }
        String algorithm = value.substring(1, end);
        return algorithm;
    }

    public static boolean isServerConfigFile(URI uri) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(uri);
        if (files.length > 0) {
            return ConfigUtils.isServerConfigFile(files[0]);
        }
        File file = new File(uri);
        if (file.exists()) {
            return ConfigUtils.isServerConfigFile(file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerConfigFile(IFile file) {
        InputStream in = null;
        try {
            in = file.getContents();
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType contentType = contentTypeManager.findContentTypeFor(in, file.getName());
            if (contentType == null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "The content type is null for the following file: " + (file.getLocation() == null ? file.getFullPath().toOSString() : file.getLocation().toOSString()));
                }
            } else if (CONTENT_TYPE_ID.equals(contentType.getId())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not determine content type from file: " + (file.getLocation() == null ? file.getFullPath().toOSString() : file.getLocation().toOSString()), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerConfigFile(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType contentType = contentTypeManager.findContentTypeFor((InputStream)in, file.getName());
            if (contentType == null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "The content type is null for the following file: " + file.getAbsolutePath());
                }
            } else if (CONTENT_TYPE_ID.equals(contentType.getId())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not determine content type from file: " + file.getAbsolutePath(), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static WebSphereServerInfo getServer(IResource resource) {
        WebSphereServerInfo[] servers;
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            if (ConfigUtils.isContainedIn(resource, (IContainer)server.getServerFolder())) {
                return server;
            }
            if (!ConfigUtils.isContainedIn(resource, (IContainer)server.getUserDirectory().getSharedConfigFolder())) continue;
            return server;
        }
        return null;
    }

    private static boolean isContainedIn(IResource resource, IContainer container) {
        if (container == null) {
            return false;
        }
        for (IContainer parent = resource.getParent(); parent != null && parent instanceof IFolder; parent = parent.getParent()) {
            if (!container.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static WebSphereServerInfo getServer(String uriString) {
        try {
            URI uri = new URI(uriString);
            return ConfigUtils.getServer(uri);
        }
        catch (URISyntaxException e) {
            Trace.logError("Invalid URI: " + uriString, e);
            return null;
        }
    }

    public static WebSphereServerInfo getServer(URI uri) {
        WebSphereServerInfo[] servers;
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
            if (configFile == null) continue;
            return server;
        }
        WebSphereServerInfo wsInfo = ConfigUtils.getServerFromRuntimeProviders(uri, servers);
        if (wsInfo != null) {
            return wsInfo;
        }
        return null;
    }

    private static ConfigurationFile getConfigFromRuntimeProviders(URI uri, WebSphereServerInfo server) {
        List<LibertyRuntimeProvider> list = LibertyRuntimeProviderExtension.getLibertyRuntimeProviders();
        for (LibertyRuntimeProvider provider : list) {
            ConfigurationFile configFile;
            URI targetConfigURI = provider.getTargetConfigFileLocation(uri, server);
            if (targetConfigURI == null || (configFile = server.getConfigurationFileFromURI(targetConfigURI)) == null) continue;
            return configFile;
        }
        return null;
    }

    private static WebSphereServerInfo getServerFromRuntimeProviders(URI uri, WebSphereServerInfo[] servers) {
        List<LibertyRuntimeProvider> list = LibertyRuntimeProviderExtension.getLibertyRuntimeProviders();
        for (LibertyRuntimeProvider provider : list) {
            for (WebSphereServerInfo server : servers) {
                URI alternateUri = provider.getTargetConfigFileLocation(uri, server);
                if (alternateUri == null) continue;
                return server;
            }
        }
        for (LibertyRuntimeProvider provider : list) {
            WebSphereServerInfo temporaryWSInfo = provider.getWebSphereServerInfo(uri);
            if (temporaryWSInfo == null) continue;
            return temporaryWSInfo;
        }
        return null;
    }

    public static ConfigurationFile getConfigFile(IResource resource) {
        URI uri = resource.getLocation().toFile().toURI();
        return ConfigUtils.getConfigFile(uri);
    }

    public static ConfigurationFile getConfigFile(String uriString) {
        try {
            URI uri = new URI(uriString);
            return ConfigUtils.getConfigFile(uri);
        }
        catch (URISyntaxException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Failed to locate configuration file because of invalid uri: " + uriString, e);
            }
            return null;
        }
    }

    public static ConfigurationFile getConfigFile(URI uri) {
        WebSphereServerInfo[] servers;
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
            if (configFile == null) continue;
            return configFile;
        }
        return null;
    }

    public static ConfigurationFile getMappedConfigFile(URI uri) {
        WebSphereServerInfo[] servers;
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = ConfigUtils.getConfigFromRuntimeProviders(uri, server);
            if (configFile == null) continue;
            return configFile;
        }
        return null;
    }

    public static IFile getMappedConfigIFile(URI uri) {
        IContainer container;
        IProject project;
        IResource file;
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri);
        if (containers != null && containers.length == 1 && (file = (project = (container = containers[0]).getProject()).findMember(container.getProjectRelativePath())) instanceof IFile && file.exists()) {
            return (IFile)file;
        }
        return null;
    }

    public static WebSphereServerInfo getServerInfo(URI docURI) {
        WebSphereServerInfo[] servers;
        if (docURI == null) {
            return null;
        }
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(docURI);
            if (configFile == null) continue;
            switch (configFile.getLocationType()) {
                case SERVER: {
                    return server;
                }
            }
            return null;
        }
        WebSphereServerInfo wsInfo = ConfigUtils.getServerFromRuntimeProviders(docURI, servers);
        if (wsInfo != null) {
            return wsInfo;
        }
        for (WebSphereServerInfo server : servers) {
            URI serverURI = server.getServerURI();
            if (URIUtil.canonicalRelativize(serverURI, docURI).isAbsolute()) continue;
            return server;
        }
        return null;
    }

    public static IFolder getMappedConfigFolder(IResource resource) {
        List<LibertyRuntimeProvider> list = LibertyRuntimeProviderExtension.getLibertyRuntimeProviders();
        for (LibertyRuntimeProvider provider : list) {
            IFolder configFolder = provider.getConfigFolder(resource);
            if (configFolder == null) continue;
            return configFolder;
        }
        return null;
    }

    public static UserDirectory getUserDirectory(URI docURI) {
        WebSphereRuntime[] runtimes;
        WebSphereServerInfo[] servers;
        if (docURI == null) {
            return null;
        }
        for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(docURI);
            if (configFile == null) continue;
            switch (configFile.getLocationType()) {
                case SERVER: {
                    return server.getUserDirectory();
                }
                case SHARED: {
                    return server.getUserDirectory();
                }
            }
        }
        for (WebSphereRuntime runtime : runtimes = WebSphereUtil.getWebSphereRuntimes()) {
            for (UserDirectory userDir : runtime.getUserDirectories()) {
                URI userDirURI = userDir.getPath().toFile().toURI();
                if (URIUtil.canonicalRelativize(userDirURI, docURI).isAbsolute()) continue;
                return userDir;
            }
        }
        WebSphereServerInfo wsInfo = ConfigUtils.getServerFromRuntimeProviders(docURI, servers);
        if (wsInfo != null) {
            return wsInfo.getUserDirectory();
        }
        return null;
    }

    public static void getVariables(ConfigurationFile cf, ConfigVars vars) {
        ConfigUtils.getVariables(cf, cf.getDomDocument(), cf.getURI(), cf.getWebSphereServer(), cf.getUserDirectory(), vars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getVariables(ConfigurationFile configFile, Document document, URI uri, WebSphereServerInfo serverInfo, UserDirectory userDir, ConfigVars vars) {
        if (document == null) {
            return;
        }
        Stack<URI> includeFilter = new Stack<URI>();
        VarsContext varsContext = new VarsContext();
        try {
            includeFilter.push(uri);
            vars.startContext();
            ConfigUtils.getVariables(configFile, document, uri, serverInfo, userDir, vars, includeFilter, varsContext);
            vars.endContext();
        }
        finally {
            includeFilter.clear();
            varsContext.clear();
        }
    }

    public static void getLocalVariables(Element elem, String attrExclude, URI uri, ConfigVars vars) {
        String value;
        String name;
        int i;
        CMElementDeclaration elemDecl = SchemaUtil.getElement(elem.getOwnerDocument(), ConfigUtils.getElementTags(elem), uri);
        if (elemDecl == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not find declaration for element: " + elem.getLocalName() + ", from URI: " + uri);
            }
            return;
        }
        CMNamedNodeMap attrDecls = elemDecl.getAttributes();
        NamedNodeMap attrs = elem.getAttributes();
        vars.startContext();
        for (i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            name = attr.getName();
            if (name.equals(attrExclude)) continue;
            value = attr.getValue();
            ConfigVars.Type type = null;
            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(name);
            if (attrDecl != null) {
                type = vars.getType(ConfigUtils.getTypeName((CMNode)attrDecl));
            }
            DocumentLocation location = DocumentLocation.createDocumentLocation(uri, attr);
            vars.add(name, value, type, location);
        }
        for (i = 0; i < attrDecls.getLength(); ++i) {
            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attrDecls.item(i);
            name = attrDecl.getAttrName();
            if (attrs.getNamedItem(name) != null || name.equals(attrExclude) || (value = attrDecl.getDefaultValue()) == null || value.isEmpty()) continue;
            String typeName = vars.getTypeName(ConfigUtils.getTypeName((CMNode)attrDecl));
            vars.add(name, value, vars.getType(typeName), null);
        }
        vars.endContext();
    }

    private static String[] getElementTags(Element elem) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Node current = elem; current != null && current.getNodeType() == 1; current = current.getParentNode()) {
            tags.add(0, current.getNodeName());
        }
        return tags.toArray(new String[tags.size()]);
    }

    private static void getVariables(ConfigurationFile configFile, Document document, URI uri, WebSphereServerInfo serverInfo, UserDirectory userDir, ConfigVars vars, Stack<URI> includeFilter, VarsContext varsContext) {
        Element elem;
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getDefaultDropins()) {
                ConfigUtils.processDropinForVars(dropin, serverInfo, userDir, vars, includeFilter, varsContext);
            }
        }
        if ((elem = document.getDocumentElement()) != null) {
            Element child = DOMUtils.getFirstChildElement(elem);
            while (child != null) {
                String name = child.getNodeName();
                if (name.equals("include")) {
                    ConfigUtils.processIncludeForVars(child, uri, serverInfo, userDir, vars, includeFilter, varsContext);
                } else if (name.equals("variable")) {
                    ConfigUtils.processVariableElement(child, uri, vars, varsContext);
                }
                child = DOMUtils.getNextElement(child);
            }
        }
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getOverrideDropins()) {
                ConfigUtils.processDropinForVars(dropin, serverInfo, userDir, vars, includeFilter, varsContext);
            }
        }
    }

    private static void processIncludeForVars(Element elem, URI uri, WebSphereServerInfo serverInfo, UserDirectory userDir, ConfigVars vars, Stack<URI> includeFilter, VarsContext varsContext) {
        Document document;
        URI includeURI;
        IResource includeFile;
        IFolder mappedConfigFolder;
        String location = elem.getAttribute("location");
        if (location == null) {
            return;
        }
        IProject project = userDir.getProject();
        String mappedLocation = null;
        if (project != null && (mappedConfigFolder = ConfigUtils.getMappedConfigFolder((IResource)project)) != null && (includeFile = mappedConfigFolder.findMember(location)) != null && includeFile.exists()) {
            mappedLocation = includeFile.getLocation().toString();
        }
        if ((includeURI = ConfigUtils.resolve(uri, mappedLocation != null ? mappedLocation : location, serverInfo, userDir)) != null && !includeFilter.contains(includeURI) && new File(includeURI).exists() && (document = ConfigUtils.getDOM(includeURI, userDir.getWebSphereRuntime())) != null) {
            String attrValue = DOMUtils.getAttributeValue(elem, "onConflict");
            if (attrValue != null) {
                IncludeConflictResolution conflictResolution = IncludeConflictResolution.getConflictResolution(attrValue);
                varsContext.pushIgnore(conflictResolution == IncludeConflictResolution.IGNORE);
            } else {
                varsContext.pushIgnore();
            }
            includeFilter.push(includeURI);
            ConfigurationFile configFile = null;
            if (serverInfo != null) {
                configFile = serverInfo.getConfigurationFileFromURI(includeURI);
            }
            ConfigUtils.getVariables(configFile, document, includeURI, serverInfo, userDir, vars, includeFilter, varsContext);
            includeFilter.pop();
            varsContext.popIgnore();
        }
    }

    private static void processDropinForVars(ConfigurationFile dropin, WebSphereServerInfo serverInfo, UserDirectory userDir, ConfigVars vars, Stack<URI> includeFilter, VarsContext varsContext) {
        includeFilter.push(dropin.getURI());
        ConfigUtils.getVariables(dropin, dropin.getDomDocument(), dropin.getURI(), serverInfo, userDir, vars, includeFilter, varsContext);
        includeFilter.pop();
    }

    private static void processVariableElement(Element elem, URI uri, ConfigVars vars, VarsContext varsContext) {
        String varName = elem.getAttribute("name");
        String varValue = null;
        String defaultValue = null;
        if (elem.hasAttribute("value")) {
            varValue = elem.getAttribute("value");
        } else if (elem.hasAttribute("defaultValue")) {
            defaultValue = elem.getAttribute("defaultValue");
        }
        if (varName != null) {
            if (varValue != null) {
                if (!varsContext.isDeclared(varName) || !varsContext.isIgnore()) {
                    varsContext.addDeclared(varName, false);
                    vars.add(varName, varValue, DocumentLocation.createDocumentLocation(uri, elem));
                }
            } else if (defaultValue != null && (!vars.isDefined(varName) || varsContext.isDefault(varName) && !varsContext.isIgnore())) {
                varsContext.addDeclared(varName, true);
                vars.add(varName, defaultValue, DocumentLocation.createDocumentLocation(uri, elem));
            }
        }
    }

    public static Document getDOM(URI uri) {
        return ConfigUtils.getDOM(uri, null);
    }

    public static Document getDOM(URI uri, WebSphereRuntime runtime) {
        WebSphereServerInfo[] servers = null;
        if (runtime != null) {
            List<WebSphereServerInfo> serverList = runtime.getWebSphereServerInfos();
            servers = serverList.toArray(new WebSphereServerInfo[serverList.size()]);
        } else {
            servers = WebSphereUtil.getWebSphereServerInfos();
        }
        for (WebSphereServerInfo server : servers) {
            ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
            if (configFile == null) continue;
            return configFile.getDomDocument();
        }
        return ConfigUtils.getDOMFromModel(uri);
    }

    /*
     * Exception decompiling
     */
    protected static Document getDOMFromModel(URI uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Document getDOMFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IFile getWorkspaceFile(UserDirectory userDir, URI uri) {
        IFile file = ConfigUtils.getWorkspaceFile(userDir.getSharedConfigFolder(), uri);
        return file;
    }

    private static IFile getWorkspaceFile(IFolder folder, URI uri) {
        if (folder == null) {
            return null;
        }
        URI workspaceURI = folder.getLocation().toFile().toURI();
        URI relativeURI = URIUtil.canonicalRelativize(workspaceURI, uri);
        if (relativeURI.isAbsolute()) {
            return null;
        }
        Path relativePath = new Path(relativeURI.getPath());
        IFile file = folder.getFile((IPath)relativePath);
        return file;
    }

    public static URI resolve(URI baseUri, String include, WebSphereServerInfo serverInfo, UserDirectory userDir) {
        if (include == null) {
            return null;
        }
        if (ConfigVarsUtils.containsReference(include) && serverInfo != null) {
            return serverInfo.resolve(baseUri, include);
        }
        return userDir == null ? null : userDir.resolve(baseUri, include);
    }

    public static URI resolve(URI baseUri, String include, UserDirectory userDir) {
        if (include == null) {
            return null;
        }
        return ConfigUtils.resolve(baseUri, include, ConfigUtils.getServer(baseUri), userDir);
    }

    public static String[] getSharedLibraryIds(ConfigurationFile configFile) {
        String[] dropinIds;
        String[] configIds;
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : configIds = configFile.getSharedLibraryIds()) {
            ids.add(id);
        }
        for (String id : dropinIds = ConfigUtils.getDropInLibIds(configFile.getWebSphereServer(), configFile.getUserDirectory())) {
            ids.add(id);
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static String[] getDropInLibIds(WebSphereServerInfo serverInfo, UserDirectory userDir) {
        HashMap<String, URILocation> ids = new HashMap<String, URILocation>();
        ConfigUtils.addDropInLibIds(ids, serverInfo, userDir);
        return ids.keySet().toArray(new String[ids.size()]);
    }

    public static void addDropInLibIds(Map<String, URILocation> ids, WebSphereServerInfo serverInfo, UserDirectory userDir) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        if (serverInfo != null) {
            serverInfo.addDropInLibPaths(paths);
        } else if (userDir != null) {
            userDir.addDropInLibPaths(paths);
        }
        for (IPath path : paths) {
            ConfigUtils.addDropInLibIds(ids, path);
        }
    }

    private static void addDropInLibIds(Map<String, URILocation> ids, IPath path) {
        File file = path.toFile();
        if (file.exists()) {
            File[] dirs;
            for (File dir : dirs = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && "global".equals(file.getName());
                }
            })) {
                ids.put(dir.getName(), new URILocation(dir.toURI()));
            }
        }
    }

    public static Element addElement(Element parentElement, CMElementDeclaration cmElementDeclaration) {
        return ConfigUtils.addElement(parentElement, cmElementDeclaration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element addElement(Element parentElement, CMElementDeclaration cmElementDeclaration, String content) {
        if (parentElement == null || cmElementDeclaration == null) {
            if (Trace.ENABLED) {
                Trace.logError("The addElement method was called with null parent or null element declaration.", null);
            }
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)parentElement.getOwnerDocument());
        boolean append = false;
        Node element = null;
        Node refChild = parentElement.getLastChild();
        if (modelQuery.canInsert(parentElement, (CMNode)cmElementDeclaration, parentElement.getChildNodes().getLength(), 2)) {
            append = true;
        } else {
            for (int i = parentElement.getChildNodes().getLength(); !modelQuery.canInsert(parentElement, (CMNode)cmElementDeclaration, i, 2) && i > 0; --i) {
                refChild = refChild.getPreviousSibling();
            }
            if (refChild == null) {
                refChild = parentElement.getFirstChild();
            }
        }
        Document document = parentElement.getNodeType() == 9 ? (Document)((Object)parentElement) : parentElement.getOwnerDocument();
        DOMContentBuilderImpl domContentBuilder = new DOMContentBuilderImpl(document);
        boolean parentNodeFormatRequired = false;
        if (document.getDocumentElement() != parentElement) {
            NodeList childNodes = parentElement.getChildNodes();
            parentNodeFormatRequired = childNodes == null || childNodes.getLength() == 0 || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0;
        }
        IDOMModel model = null;
        if (parentElement instanceof IDOMNode) {
            model = ((IDOMNode)parentElement).getModel();
            model.aboutToChangeModel();
        }
        try {
            Object object;
            domContentBuilder.setBuildPolicy(0);
            domContentBuilder.build((Node)parentElement, (CMNode)cmElementDeclaration);
            List list = domContentBuilder.getResult();
            boolean newLineRequired = false;
            for (Node newNode : list) {
                if (newNode.getNodeType() == 2) {
                    parentElement.setAttributeNode((Attr)newNode);
                    continue;
                }
                if (append) {
                    parentElement.appendChild(newNode);
                    newLineRequired = true;
                    continue;
                }
                parentElement.insertBefore(newNode, refChild);
            }
            if (list.size() > 0 && (object = list.get(0)) instanceof Element) {
                element = (Element)object;
            }
            if (element != null) {
                Text textNode;
                if (newLineRequired) {
                    textNode = parentElement.getOwnerDocument().createTextNode(System.getProperty("line.separator"));
                    parentElement.appendChild(textNode);
                }
                if (content != null) {
                    textNode = element.getOwnerDocument().createTextNode(content);
                    element.appendChild(textNode);
                }
                if (parentNodeFormatRequired) {
                    ConfigUtils.formatXMLNode(parentElement);
                } else {
                    ConfigUtils.formatXMLNode(element);
                }
            }
        }
        finally {
            if (model != null) {
                model.changedModel();
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatXMLNode(Node node) {
        DocumentRewriteSession rewriteSession = null;
        if (node instanceof IDOMNode) {
            rewriteSession = ((IDocumentExtension4)((IDOMNode)node).getModel().getStructuredDocument()).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        FormatProcessorXML formatProcessor = new FormatProcessorXML();
        try {
            formatProcessor.formatNode(node);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Format failed for node: " + node.getNodeName(), e);
            }
        }
        finally {
            if (node instanceof IDOMNode && rewriteSession != null) {
                ((IDocumentExtension4)((IDOMNode)node).getModel().getStructuredDocument()).stopRewriteSession(rewriteSession);
            }
        }
    }

    public static List<String> getFeaturesToEnable(String elemName, List<String> enabledFeatures, WebSphereRuntime wsRuntime) {
        if (wsRuntime == null) {
            return null;
        }
        String runtimeVersion = wsRuntime.getRuntimeVersion();
        if (runtimeVersion == null || runtimeVersion.startsWith("8.5.0")) {
            return null;
        }
        List<String> allFeatures = FeatureList.getFeatures(false, wsRuntime);
        ArrayList<String> containingFeatures = new ArrayList<String>();
        for (String feature : allFeatures) {
            Set<String> configElements = FeatureList.getFeatureConfigElements(feature, wsRuntime);
            if (!configElements.contains(elemName)) continue;
            for (String f : enabledFeatures) {
                if (!f.equalsIgnoreCase(feature)) continue;
                return null;
            }
            containingFeatures.add(feature);
        }
        if (containingFeatures.isEmpty()) {
            return null;
        }
        for (String feature : containingFeatures) {
            Set<String> parents = FeatureList.getFeatureParents(feature, wsRuntime);
            for (String feature2 : enabledFeatures) {
                for (String f : parents) {
                    if (!f.equalsIgnoreCase(feature2)) continue;
                    return null;
                }
            }
        }
        return containingFeatures;
    }

    public static XSDSimpleTypeDefinition getBaseType(CMNode node) {
        if (node == null) {
            return null;
        }
        List<XSDSimpleTypeDefinition> memberTypes = SchemaUtil.getMemberTypesFromUnion(node);
        if (memberTypes == null || memberTypes.isEmpty()) {
            return null;
        }
        boolean hasVariableType = false;
        XSDSimpleTypeDefinition type = null;
        for (XSDSimpleTypeDefinition memberType : memberTypes) {
            if (VARIABLE_TYPE.equals(memberType.getName())) {
                hasVariableType = true;
                continue;
            }
            type = memberType;
        }
        if (hasVariableType && memberTypes.size() == 2) {
            return type;
        }
        return null;
    }

    public static String getBaseTypeName(XSDSimpleTypeDefinition baseType) {
        if (baseType != null) {
            XSDSimpleTypeDefinition std = baseType;
            String baseTypeName = std.getName();
            while ((baseTypeName == null || baseTypeName.length() == 0) && std.getBaseTypeDefinition() != null) {
                std = std.getBaseTypeDefinition();
                baseTypeName = std.getName();
            }
            return baseTypeName;
        }
        return null;
    }

    public static String getTypeName(CMNode nodeDecl) {
        XSDSimpleTypeDefinition baseType;
        CMDataType dataType = null;
        if (nodeDecl instanceof CMAttributeDeclaration) {
            dataType = ((CMAttributeDeclaration)nodeDecl).getAttrType();
        } else if (nodeDecl instanceof CMElementDeclaration) {
            dataType = ((CMElementDeclaration)nodeDecl).getDataType();
        }
        String typeName = null;
        if (dataType != null && (typeName = ConfigUtils.getBaseTypeName(baseType = ConfigUtils.getBaseType(nodeDecl))) == null) {
            typeName = dataType.getDataTypeName();
        }
        return typeName;
    }

    public static IPath getMergedConfigLocation(IResource resource) {
        IPath location = Activator.getInstance().getStateLocation().append(MERGED_FOLDER);
        IPath resourcePath = resource.getFullPath();
        location = location.append(resourcePath);
        return location;
    }

    public static void mergeElement(Element mainElem, Element mergeElem, URI uri, boolean saveLocations) {
        NamedNodeMap attrs = mergeElem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            mainElem.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
        Element child = DOMUtils.getFirstChildElement(mergeElem);
        while (child != null) {
            Node node = mainElem.getOwnerDocument().importNode(child, true);
            mainElem.appendChild(node);
            if (saveLocations) {
                ConfigUtils.setDocumentLocation(node, child, uri);
            }
            child = DOMUtils.getNextElement(child);
        }
    }

    public static List<Element> getResolvedElements(Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory userDir, String elementName, String idAttr) {
        return ConfigUtils.getResolvedElements(doc, uri, serverInfo, userDir, elementName, idAttr, false);
    }

    public static List<Element> getResolvedElements(Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory userDir, String elementName, String idAttr, boolean saveLocations) {
        ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
        Document resultDoc = ConfigUtils.getResolvedElements(doc, uri, serverInfo, userDir, elementName, idAttr, includeFilter, saveLocations);
        ArrayList<Element> elems = new ArrayList<Element>();
        if (resultDoc != null) {
            Element resultRoot = resultDoc.getDocumentElement();
            Element elem = DOMUtils.getFirstChildElement(resultRoot, elementName);
            while (elem != null) {
                elems.add(elem);
                elem = DOMUtils.getNextElement(elem, elementName);
            }
        }
        return elems;
    }

    private static Document getResolvedElements(Document doc, URI uri, WebSphereServerInfo serverInfo, UserDirectory userDir, String elementName, String idAttr, IncludeFilter includeFilter, boolean saveLocations) {
        Document dropinsDoc;
        if (!includeFilter.accept(uri)) {
            return null;
        }
        Document mainDoc = DOMUtils.getTmpDoc();
        if (mainDoc == null) {
            return null;
        }
        Element mainRoot = mainDoc.createElement("server");
        mainDoc.appendChild(mainRoot);
        ConfigurationFile configFile = null;
        if (serverInfo != null && uri != null) {
            configFile = serverInfo.getConfigurationFileFromURI(uri);
        }
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getDefaultDropins()) {
                dropinsDoc = ConfigUtils.getResolvedElements(dropin.getDomDocument(), dropin.getURI(), serverInfo, userDir, elementName, idAttr, includeFilter, saveLocations);
                if (dropinsDoc == null) continue;
                ConfigUtils.mergeDocs(mainDoc, dropinsDoc, elementName, idAttr, IncludeConflictResolution.MERGE, dropin.getURI(), saveLocations);
            }
        }
        Element elem = DOMUtils.getFirstChildElement(doc.getDocumentElement());
        while (elem != null) {
            if (DOMUtils.isInclude(elem)) {
                Document mergeDoc;
                Document includeDoc;
                URI includeURI;
                String location = elem.getAttribute("location");
                if (location != null && (includeURI = ConfigUtils.resolve(uri, location, serverInfo, userDir)) != null && new File(includeURI).exists() && (includeDoc = ConfigUtils.getDOM(includeURI, userDir != null ? userDir.getWebSphereRuntime() : null)) != null && (mergeDoc = ConfigUtils.getResolvedElements(includeDoc, includeURI, serverInfo, userDir, elementName, idAttr, includeFilter, saveLocations)) != null) {
                    String onConflict = elem.getAttribute("onConflict");
                    ConfigUtils.mergeDocs(mainDoc, mergeDoc, elementName, idAttr, IncludeConflictResolution.getConflictResolution(onConflict), includeURI, saveLocations);
                }
            } else if (elem.getNodeName().equals(elementName)) {
                Element mainElem = ConfigUtils.findElement(mainRoot, elementName, idAttr, idAttr != null ? elem.getAttribute(idAttr) : null);
                if (mainElem == null) {
                    Node node = mainDoc.importNode(elem, true);
                    mainRoot.appendChild(node);
                    if (saveLocations) {
                        node.setUserData(DOCUMENT_LOCATION_KEY, DocumentLocation.createDocumentLocation(uri, elem), docLocationDataHandler);
                    }
                } else {
                    ConfigUtils.mergeElement(mainElem, elem, uri, saveLocations);
                }
            }
            elem = DOMUtils.getNextElement(elem);
        }
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getOverrideDropins()) {
                dropinsDoc = ConfigUtils.getResolvedElements(dropin.getDomDocument(), dropin.getURI(), serverInfo, userDir, elementName, idAttr, includeFilter, saveLocations);
                if (dropinsDoc == null) continue;
                ConfigUtils.mergeDocs(mainDoc, dropinsDoc, elementName, idAttr, IncludeConflictResolution.MERGE, dropin.getURI(), saveLocations);
            }
        }
        return mainDoc;
    }

    private static void mergeDocs(Document mainDoc, Document mergeDoc, String elementName, String idAttr, IncludeConflictResolution conflictRes, URI uri, boolean saveLocations) {
        Element mainServer = mainDoc.getDocumentElement();
        Element mergeServer = mergeDoc.getDocumentElement();
        Element mergeElem = DOMUtils.getFirstChildElement(mergeServer, elementName);
        while (mergeElem != null) {
            Node node;
            Element mainElem = ConfigUtils.findElement(mainServer, elementName, idAttr, idAttr != null ? mergeElem.getAttribute(idAttr) : null);
            if (mainElem != null) {
                switch (conflictRes) {
                    case MERGE: {
                        ConfigUtils.mergeElement(mainElem, mergeElem, uri, saveLocations);
                        break;
                    }
                    case REPLACE: {
                        node = mainDoc.importNode(mergeElem, true);
                        mainServer.replaceChild(node, mainElem);
                        if (!saveLocations) break;
                        ConfigUtils.setDocumentLocation(node, mergeElem, uri);
                        break;
                    }
                }
            } else {
                node = mainDoc.importNode(mergeElem, true);
                mainServer.appendChild(node);
                if (saveLocations) {
                    ConfigUtils.setDocumentLocation(node, mergeElem, uri);
                }
            }
            mergeElem = DOMUtils.getNextElement(mergeElem, elementName);
        }
    }

    public static void setDocumentLocation(Node node, Element mergeElem, URI uri) {
        DocumentLocation mergeLocation = (DocumentLocation)mergeElem.getUserData(DOCUMENT_LOCATION_KEY);
        if (mergeLocation == null) {
            mergeLocation = DocumentLocation.createDocumentLocation(uri, mergeElem);
        }
        node.setUserData(DOCUMENT_LOCATION_KEY, mergeLocation, docLocationDataHandler);
    }

    public static Element findElement(Element parent, String elementName, String idAttr, String id) {
        if (idAttr != null && (id == null || id.isEmpty())) {
            return null;
        }
        Element elem = DOMUtils.getFirstChildElement(parent, elementName);
        while (elem != null) {
            if (idAttr == null) {
                return elem;
            }
            String idValue = elem.getAttribute(idAttr);
            if (id.equals(idValue)) {
                return elem;
            }
            elem = DOMUtils.getNextElement(elem, elementName);
        }
        return null;
    }

    public static Document documentLoad(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(file);
    }

    public static int getHTTPPort(Document doc, String portAttr) {
        ArrayList<Element> httpEndpoints = new ArrayList<Element>();
        if (doc != null) {
            Element root = doc.getDocumentElement();
            Element elem = ConfigUtils.getFirstChildElement(root, "httpEndpoint");
            while (elem != null) {
                httpEndpoints.add(elem);
                elem = ConfigUtils.getNextElement(elem, "httpEndpoint");
            }
        }
        for (Element elem : httpEndpoints) {
            String port;
            if (!"defaultHttpEndpoint".equals(elem.getAttribute("id")) || (port = elem.getAttribute(portAttr)) == null || port.isEmpty()) continue;
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "HttpEndpoint had invalid HttpPort", e);
            }
        }
        return -1;
    }

    public static File createBasicRegConfig(String user, String pw) {
        File tempFile = null;
        String encryptedPW = pw;
        try {
            encryptedPW = PasswordUtil.encode((String)pw);
        }
        catch (Exception e) {
            Trace.logError("Error encoding password", e);
        }
        try {
            tempFile = File.createTempFile("defaultBasicReg", "xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element serverElem = doc.createElement("server");
            doc.appendChild(serverElem);
            ConfigUtils.addPreElementText(doc, serverElem, true, true);
            Element basicReg = doc.createElement("basicRegistry");
            basicReg.setAttribute("id", "basic");
            basicReg.setAttribute("realm", "BasicRealm");
            serverElem.appendChild(basicReg);
            ConfigUtils.addPostElementText(doc, serverElem);
            ConfigUtils.addPreElementText(doc, basicReg, false, false);
            Element usr = doc.createElement("user");
            usr.setAttribute("name", user);
            usr.setAttribute("password", encryptedPW);
            basicReg.appendChild(usr);
            ConfigUtils.addPostElementText(doc, basicReg);
            ConfigUtils.addPreElementText(doc, serverElem, true, true);
            Element admin = doc.createElement("administrator-role");
            serverElem.appendChild(admin);
            ConfigUtils.addPostElementText(doc, serverElem);
            ConfigUtils.addPreElementText(doc, admin, false, false);
            Element adminUser = doc.createElement("user");
            adminUser.setTextContent(user);
            admin.appendChild(adminUser);
            ConfigUtils.addPostElementText(doc, admin);
            ConfigUtils.save(doc, tempFile);
        }
        catch (Exception e) {
            Trace.logError("Error creating the basicRegistry config file", e);
        }
        return tempFile;
    }

    public static int validateRemoteSecurity(Document doc, String user, String pw) {
        int result = 1;
        Element root = doc.getDocumentElement();
        Element basicReg = ConfigUtils.getFirstChildElement(root, "basicRegistry");
        Element usr = ConfigUtils.getFirstChildElement(basicReg);
        while (usr != null) {
            String unFRXML = usr.getAttribute("name");
            String pwFRXML = usr.getAttribute("password");
            if (PasswordUtil.isEncrypted((String)pwFRXML)) {
                try {
                    pwFRXML = PasswordUtil.decode((String)pwFRXML);
                }
                catch (Exception e) {
                    Trace.logError("Error decoding password", e);
                }
            }
            if (unFRXML != null && unFRXML.equals(user)) {
                if (pwFRXML != null && pwFRXML.equals(pw)) {
                    if (ConfigUtils.isAdmin(doc, user)) {
                        result = 0;
                        break;
                    }
                    result = 8;
                    break;
                }
                result = 4;
                break;
            }
            result = 2;
            usr = ConfigUtils.getNextElement(usr);
        }
        return result;
    }

    public static void updateRemoteFileAccess(Document doc, File xml, String logdir, String restConnectorFeature) {
        Element elem;
        Element remoteFileAccess;
        if (logdir == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        if (restConnectorFeature != null) {
            Element featureManager = ConfigUtils.getFirstChildElement(root, "featureManager");
            Element feature = ConfigUtils.getFirstChildElement(featureManager);
            boolean found = false;
            while (feature != null && !found) {
                if (feature.getTextContent().toLowerCase().startsWith("restconnector-")) {
                    found = true;
                    continue;
                }
                feature = ConfigUtils.getNextElement(feature);
            }
            if (feature != null) {
                feature.setTextContent(restConnectorFeature);
            }
        }
        if ((remoteFileAccess = ConfigUtils.getFirstChildElement(root, "remoteFileAccess")) == null) {
            ConfigUtils.addPreElementText(doc, root, true, true);
            elem = doc.createElement("remoteFileAccess");
            root.appendChild(elem);
            ConfigUtils.addPostElementText(doc, root);
            remoteFileAccess = elem;
        }
        Element fElem = ConfigUtils.getFirstChildElement(remoteFileAccess);
        while (fElem != null) {
            String dir = fElem.getTextContent();
            if (dir != null && !dir.isEmpty() && dir.equalsIgnoreCase(logdir)) {
                return;
            }
            fElem = ConfigUtils.getNextElement(fElem);
        }
        elem = doc.createElement("writeDir");
        elem.setTextContent(logdir);
        remoteFileAccess.appendChild(elem);
        ConfigUtils.addPostElementText(doc, remoteFileAccess);
        ConfigUtils.save(doc, xml);
    }

    public static void updateRemoteSecurity(Document doc, File xml, String user, String pw, int code) {
        Element root = doc.getDocumentElement();
        Element basicReg = ConfigUtils.getFirstChildElement(root, "basicRegistry");
        if (basicReg == null) {
            ConfigUtils.addPreElementText(doc, root, true, true);
            Element elem = doc.createElement("basicRegistry");
            root.appendChild(elem);
            ConfigUtils.addPostElementText(doc, root);
            basicReg = elem;
        }
        if (code == 1) {
            String encryptedPW = pw;
            try {
                encryptedPW = PasswordUtil.encode((String)pw);
            }
            catch (Exception e) {
                Trace.logError("Error encoding password", e);
            }
            ConfigUtils.addPreElementText(doc, basicReg, false, false);
            Element elem = doc.createElement("user");
            elem.setAttribute("name", user);
            elem.setAttribute("password", encryptedPW);
            basicReg.appendChild(elem);
            ConfigUtils.addPostElementText(doc, basicReg);
            ConfigUtils.addAdminRole(doc, user);
        }
        if (code == 8) {
            ConfigUtils.addAdminRole(doc, user);
        }
        ConfigUtils.save(doc, xml);
    }

    private static void addAdminRole(Document doc, String user) {
        Element root = doc.getDocumentElement();
        Element admin = ConfigUtils.getFirstChildElement(root, "administrator-role");
        if (admin == null) {
            ConfigUtils.addPreElementText(doc, root, true, true);
            admin = doc.createElement("administrator-role");
            root.appendChild(admin);
            ConfigUtils.addPostElementText(doc, root);
        }
        ConfigUtils.addPreElementText(doc, admin, false, false);
        Element usr = doc.createElement("user");
        usr.setTextContent(user);
        admin.appendChild(usr);
        ConfigUtils.addPostElementText(doc, admin);
    }

    public static boolean isAdmin(Document doc, String user) {
        Element root = doc.getDocumentElement();
        Element admin = ConfigUtils.getFirstChildElement(root, "administrator-role");
        Element usr = ConfigUtils.getFirstChildElement(admin, "user");
        while (usr != null) {
            if (usr.getTextContent().equals(user)) {
                return true;
            }
            usr = ConfigUtils.getNextElement(usr);
        }
        return false;
    }

    public static Element getFirstChildElement(Node start, String name) {
        Node node;
        if (start == null) {
            return null;
        }
        for (node = start.getFirstChild(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start, String name) {
        Node node;
        for (node = start.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private static Element getFirstChildElement(Element element) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private static Element getNextElement(Element element) {
        Node node;
        if (element == null) {
            return null;
        }
        for (node = element.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static void save(Document doc, File xml) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(xml);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, streamResult);
        }
        catch (Exception e) {
            Trace.logError("Error saving the document", e);
        }
    }

    public static ArrayList<String> getIncludes(Document doc) {
        ArrayList<String> includeFiles = new ArrayList<String>();
        Element root = doc.getDocumentElement();
        Element e = ConfigUtils.getFirstChildElement(root, "include");
        while (e != null) {
            String fileLoc = e.getAttribute("location");
            if (fileLoc != null && fileLoc != "") {
                includeFiles.add(fileLoc);
            }
            e = ConfigUtils.getNextElement(e, "include");
        }
        return includeFiles;
    }

    public static void addPreElementText(Document doc, Element parent, boolean isTopLevel, boolean hasChildren) {
        if (parent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (isTopLevel || !hasChildren) {
            builder.append("\n    ");
        }
        for (Node node = parent.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            builder.append("    ");
        }
        Text text = doc.createTextNode(builder.toString());
        parent.appendChild(text);
    }

    public static void addPostElementText(Document doc, Element parent) {
        if (parent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (Node node = parent.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            builder.append("    ");
        }
        Text text = doc.createTextNode(builder.toString());
        parent.appendChild(text);
    }

    private static class VarsContext {
        private final List<Boolean> ignoreList = new ArrayList<Boolean>();
        private final Map<String, Boolean> declaredVars = new HashMap<String, Boolean>();

        protected VarsContext() {
        }

        protected void pushIgnore(boolean value) {
            this.ignoreList.add(value ? Boolean.TRUE : Boolean.FALSE);
        }

        protected void pushIgnore() {
            if (!this.ignoreList.isEmpty()) {
                Boolean value = this.ignoreList.get(this.ignoreList.size() - 1);
                this.ignoreList.add(value);
            } else {
                this.ignoreList.add(Boolean.FALSE);
            }
        }

        protected void popIgnore() {
            if (!this.ignoreList.isEmpty()) {
                this.ignoreList.remove(this.ignoreList.size() - 1);
            }
        }

        protected boolean isIgnore() {
            return !this.ignoreList.isEmpty() && this.ignoreList.get(this.ignoreList.size() - 1) != false;
        }

        protected void addDeclared(String name, boolean isDefault) {
            this.declaredVars.put(name, isDefault ? Boolean.TRUE : Boolean.FALSE);
        }

        protected boolean isDeclared(String name) {
            return this.declaredVars.containsKey(name);
        }

        protected boolean isDefault(String name) {
            Boolean isDefault = this.declaredVars.get(name);
            if (isDefault != null) {
                return isDefault;
            }
            return false;
        }

        protected void clear() {
            this.ignoreList.clear();
            this.declaredVars.clear();
        }
    }

    private static class DocLocationDataHandler
    implements UserDataHandler {
        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (dst != null) {
                dst.setUserData(key, data, this);
            }
        }
    }
}

