/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ProjectPrefs;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;

public class WebSphereUtil {
    private static final String VALIDATOR_BUILDER = "org.eclipse.wst.validation.validationbuilder";
    private static final String[] VALIDATORS = new String[]{"org.eclipse.wst.xsd.core.xsd", "org.eclipse.wst.xml.core.xml", "com.ibm.ws.st"};
    private static final String[] SERVER_EXCLUDE_FOLDERS = new String[]{"apps", "logs", "workarea", "dropins"};
    private static final String[] SERVERS_EXCLUDE_FOLDERS = new String[]{".classCache", ".logs"};

    public static WebSphereServer[] getWebSphereServers() {
        IServer[] servers = ServerCore.getServers();
        ArrayList<WebSphereServer> list = new ArrayList<WebSphereServer>(3);
        for (IServer server : servers) {
            WebSphereServer serv;
            IServerType st = server.getServerType();
            if (st == null || !st.getId().startsWith("com.ibm.ws.st.server") || (serv = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null))) == null) continue;
            list.add(serv);
        }
        return list.toArray(new WebSphereServer[list.size()]);
    }

    public static WebSphereRuntime[] getWebSphereRuntimes() {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        ArrayList<WebSphereRuntime> list = new ArrayList<WebSphereRuntime>(3);
        for (IRuntime runtime : runtimes) {
            WebSphereRuntime wrt;
            if (!WebSphereUtil.isWebSphereRuntime(runtime) || (wrt = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null)) == null) continue;
            list.add(wrt);
        }
        return list.toArray(new WebSphereRuntime[list.size()]);
    }

    public static WebSphereRuntime getWebSphereRuntime(String id) {
        WebSphereRuntime wrt;
        IRuntime runtime = ServerCore.findRuntime((String)id);
        if (runtime == null) {
            return null;
        }
        if (WebSphereUtil.isWebSphereRuntime(runtime) && (wrt = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null)) != null) {
            return wrt;
        }
        return null;
    }

    public static WebSphereServerInfo[] getWebSphereServerInfos() {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        ArrayList<WebSphereServerInfo> list = new ArrayList<WebSphereServerInfo>(5);
        for (IRuntime runtime : runtimes) {
            WebSphereRuntime wr;
            if (!WebSphereUtil.isWebSphereRuntime(runtime) || (wr = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null)) == null) continue;
            list.addAll(wr.getWebSphereServerInfos());
        }
        return list.toArray(new WebSphereServerInfo[list.size()]);
    }

    public static IPath getServerPath(IServer server) {
        if (server == null) {
            return null;
        }
        WebSphereServer wsServer = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null));
        if (wsServer == null) {
            return null;
        }
        return wsServer.getServerPath();
    }

    public static WebSphereServer getWebSphereServer(WebSphereServerInfo serverInfo) {
        WebSphereServer[] servers;
        if (serverInfo == null) {
            return null;
        }
        WebSphereRuntime wsRuntime = serverInfo.getWebSphereRuntime();
        if (wsRuntime == null) {
            return null;
        }
        IRuntime runtime = wsRuntime.getRuntime();
        for (WebSphereServer server : servers = WebSphereUtil.getWebSphereServers()) {
            if (!runtime.equals(server.getServer().getRuntime()) || !serverInfo.getServerName().equals(server.getServerName()) || !serverInfo.getUserDirectory().equals(server.getUserDirectory())) continue;
            return server;
        }
        return null;
    }

    public static File createUserProject(File file, IProgressMonitor monitor) throws IOException {
        Object f;
        if (file.exists()) {
            f = file.listFiles();
            if (f != null && ((File[])f).length > 0) {
                throw new IOException("Folder not empty");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Could not create folders");
        }
        if (!((File)(f = new File(file, "servers"))).mkdir()) {
            throw new IOException("Could not create folders");
        }
        File sharedFile = new File(file, "shared");
        if (!((File)f).mkdir()) {
            throw new IOException("Could not create folders");
        }
        f = new File(sharedFile, "config");
        if (!((File)f).mkdir()) {
            throw new IOException("Could not create folders");
        }
        f = new File(sharedFile, "apps");
        if (!((File)f).mkdir()) {
            throw new IOException("Could not create folders");
        }
        f = new File(sharedFile, "resources");
        if (!((File)f).mkdir()) {
            throw new IOException("Could not create folders");
        }
        return file;
    }

    public static IProject createUserProject(String name, IPath path, IProgressMonitor monitor) throws CoreException {
        IFolder sharedFolder;
        IFolder folder;
        IResourceFilterDescription[] filter;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            if (!project.isOpen()) {
                project.open(monitor);
            }
            return project;
        }
        if (!ServerPlugin.getProjectProperties((IProject)project).isServerProject()) {
            ServerPlugin.getProjectProperties((IProject)project).setServerProject(true, monitor);
        }
        IProjectDescription pd = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (path != null) {
            pd.setLocation(path);
        }
        ICommand[] buildSpec = pd.getBuildSpec();
        boolean hasValidator = false;
        if (buildSpec != null) {
            for (ICommand command : buildSpec) {
                if (!VALIDATOR_BUILDER.equals(command.getBuilderName())) continue;
                hasValidator = true;
            }
        }
        if (!hasValidator) {
            ICommand command = pd.newCommand();
            command.setBuilderName(VALIDATOR_BUILDER);
            if (buildSpec == null || buildSpec.length == 0) {
                buildSpec = new ICommand[]{command};
            } else {
                int size = buildSpec.length;
                ICommand[] newSpec = new ICommand[size + 1];
                System.arraycopy(buildSpec, 0, newSpec, 0, size);
                newSpec[size] = command;
                buildSpec = newSpec;
            }
            pd.setBuildSpec(buildSpec);
        }
        project.create(pd, monitor);
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if ((filter = project.getFilters()) == null || filter.length == 0) {
            FileInfoMatcherDescription workareaFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-workarea");
            project.createFilter(26, workareaFilter, 128, monitor);
            FileInfoMatcherDescription dotSettingsFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-.settings");
            FileInfoMatcherDescription notDotSettingsFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.notFilterMatcher", (Object)new FileInfoMatcherDescription[]{dotSettingsFilter});
            FileInfoMatcherDescription dotProjectFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-.project");
            FileInfoMatcherDescription notDotProjectFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.notFilterMatcher", (Object)new FileInfoMatcherDescription[]{dotProjectFilter});
            FileInfoMatcherDescription dotJavaOverlayFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-.java-overlay");
            FileInfoMatcherDescription notDotJavaOverlayFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.notFilterMatcher", (Object)new FileInfoMatcherDescription[]{dotJavaOverlayFilter});
            FileInfoMatcherDescription dotStarFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-.*");
            FileInfoMatcherDescription andFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.andFilterMatcher", (Object)new FileInfoMatcherDescription[]{notDotSettingsFilter, notDotProjectFilter, notDotJavaOverlayFilter, dotStarFilter});
            project.createFilter(30, andFilter, 128, monitor);
            FileInfoMatcherDescription messageStoreFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-messageStore");
            project.createFilter(26, messageStoreFilter, 128, monitor);
            FileInfoMatcherDescription messagesLogFilter = new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)"1.0-name-matches-false-false-messages*.log");
            project.createFilter(22, messagesLogFilter, 128, monitor);
        }
        if (!(folder = project.getFolder("servers")).exists()) {
            folder.create(true, true, monitor);
        }
        if (!(sharedFolder = project.getFolder("shared")).exists()) {
            sharedFolder.create(true, true, monitor);
        }
        if (!(folder = sharedFolder.getFolder("config")).exists()) {
            folder.create(true, true, monitor);
        }
        if (!(folder = sharedFolder.getFolder("apps")).exists()) {
            folder.create(true, true, monitor);
        }
        if (!(folder = sharedFolder.getFolder("resources")).exists()) {
            folder.create(true, true, monitor);
        }
        return project;
    }

    public static IFile createFile(IFolder folder, String name, IProgressMonitor monitor) throws CoreException {
        IFile file;
        block7: {
            IProject project = folder.getProject();
            if (project == null || !project.exists()) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", "Project does not exist"));
            }
            if (!project.isOpen()) {
                project.open(monitor);
            }
            if ((file = folder.getFile(name)).exists()) {
                return file;
            }
            URL url = Activator.getInstance().getBundle().getEntry("template/" + name);
            if (url == null) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
            } else {
                try {
                    file.create(url.openStream(), true, monitor);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block7;
                    Trace.trace((byte)1, "Could not create file", e);
                }
            }
        }
        return file;
    }

    public static File createFile(File folder, String name, IProgressMonitor monitor) throws IOException {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            throw new IOException("Folder does not exist or is not a directory");
        }
        File f = new File(folder, name);
        if (f.exists()) {
            return f;
        }
        URL url = Activator.getInstance().getBundle().getEntry("template/" + name);
        if (url == null) {
            if (!f.createNewFile()) {
                throw new IOException("Could not create file");
            }
        } else {
            BufferedReader br = null;
            PrintWriter pw = null;
            try {
                br = new BufferedReader(new InputStreamReader(url.openStream()));
                pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
                String s = br.readLine();
                while (s != null) {
                    pw.println(s);
                    s = br.readLine();
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not create file", e);
                }
                throw new IOException("Could not create file");
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return f;
    }

    public static boolean isGreaterOrEqualVersion(String baseVersion, String compareVersion) {
        if (compareVersion == null || baseVersion == null) {
            return false;
        }
        if (compareVersion.endsWith("-preview")) {
            return true;
        }
        StringTokenizer baseTokenizer = new StringTokenizer(baseVersion, ".");
        StringTokenizer compareTokenizer = new StringTokenizer(compareVersion, ".");
        int curBaseVersion = 0;
        int curCompareVersion = 0;
        while (baseTokenizer.hasMoreElements() && compareTokenizer.hasMoreElements()) {
            try {
                curCompareVersion = Integer.parseInt(compareTokenizer.nextToken());
            }
            catch (NumberFormatException e) {
                curCompareVersion = Integer.MAX_VALUE;
            }
            try {
                curBaseVersion = Integer.parseInt(baseTokenizer.nextToken());
                if (curBaseVersion > curCompareVersion) {
                    return false;
                }
                if (curCompareVersion <= curBaseVersion) continue;
                return true;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        while (baseTokenizer.hasMoreElements()) {
            try {
                curBaseVersion = Integer.parseInt(baseTokenizer.nextToken());
                if (curBaseVersion <= 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return true;
    }

    public static boolean isWebSphereRuntime(IRuntime runtime) {
        if (runtime == null) {
            return false;
        }
        IRuntimeType runtimeType = runtime.getRuntimeType();
        return runtimeType != null && runtimeType.getId().startsWith("com.ibm.ws.st.runtime");
    }

    protected static synchronized void configureValidatorsForRuntimeProject(IProject project) {
        long time = System.currentTimeMillis();
        if (project == null) {
            return;
        }
        IFolder serversFolder = project.getFolder("servers");
        IPath serversPath = serversFolder.getLocation();
        if (serversPath == null) {
            return;
        }
        File servers = serversPath.toFile();
        if (!servers.exists()) {
            return;
        }
        File[] dirs = servers.listFiles();
        String separater = ", ";
        StringBuilder sb = new StringBuilder();
        ArrayList<String> serverNames = new ArrayList<String>();
        for (File r : dirs) {
            if (!WebSphereUtil.isServerFolder(r)) continue;
            Iterator s = r.getName();
            serverNames.add((String)((Object)s));
            sb.append((String)((Object)s)).append(separater);
        }
        if (serverNames.isEmpty()) {
            return;
        }
        ProjectPrefs prefs = new ProjectPrefs(project);
        String oldServers = prefs.getRuntimeProjectValidationConfiguredServers();
        ArrayList<String> oldServerNames = new ArrayList<String>();
        if (oldServers != null) {
            StringTokenizer st = new StringTokenizer(oldServers, separater);
            while (st.hasMoreTokens()) {
                oldServerNames.add(st.nextToken());
            }
        }
        if (oldServerNames.size() == serverNames.size()) {
            boolean equals = true;
            for (String oldServerName : oldServerNames) {
                if (serverNames.contains(oldServerName)) continue;
                equals = false;
                break;
            }
            if (equals) {
                if (Trace.ENABLED) {
                    Trace.tracePerf("Update runtime project validation rules when there is no server change. " + project.getName(), time);
                }
                return;
            }
        }
        ArrayList<String> removedServerNames = new ArrayList<String>();
        for (String serverName : oldServerNames) {
            if (serverNames.contains(serverName)) {
                serverNames.remove(serverName);
                continue;
            }
            removedServerNames.add(serverName);
        }
        List<String> removedServerRulePaths = WebSphereUtil.getServerExcludeFolders(removedServerNames);
        List<String> addedServerRulePaths = WebSphereUtil.getServerExcludeFolders(serverNames);
        Validator[] existingValidators = ValManager.getDefault().getValidators(project);
        Validator[] validators = new Validator[existingValidators.length];
        for (int i = 0; i < existingValidators.length; ++i) {
            validators[i] = existingValidators[i].copy();
        }
        for (Validator val : validators) {
            FilterRule[] existing;
            boolean include = false;
            for (String string : VALIDATORS) {
                if (!val.getId().startsWith(string)) continue;
                include = true;
                break;
            }
            if (!include) {
                val.setBuildValidation(false);
                val.setManualValidation(false);
                continue;
            }
            Validator.V2 v2 = val.asV2Validator();
            FilterGroup[] groups = v2.getGroups();
            FilterGroup exclude = null;
            for (FilterGroup group : groups) {
                if (!group.isExclude()) continue;
                exclude = group;
                break;
            }
            FilterRule[] filterRuleArray = new FilterRule[addedServerRulePaths.size()];
            int i = 0;
            for (String path : addedServerRulePaths) {
                filterRuleArray[i] = FilterRule.createFile((String)path, (boolean)true, (int)2);
                ++i;
            }
            ArrayList<FilterRule> modifiedRules = new ArrayList<FilterRule>();
            if (exclude == null) {
                exclude = FilterGroup.create((boolean)true, (FilterRule[])filterRuleArray);
                v2.add(exclude);
                continue;
            }
            for (FilterRule rule : existing = exclude.getRules()) {
                String pattern = rule.getPattern();
                if (removedServerRulePaths.contains(pattern)) continue;
                modifiedRules.add(rule);
            }
            for (FilterRule rule : filterRuleArray) {
                modifiedRules.add(rule);
            }
            FilterRule[] newRules = modifiedRules.toArray(new FilterRule[modifiedRules.size()]);
            FilterGroup newExclude = FilterGroup.create((boolean)true, (FilterRule[])newRules);
            v2.replaceFilterGroup(exclude, newExclude);
        }
        GlobalPreferencesValues globalPrefs = ValManager.getDefault().getGlobalPreferences().asValues();
        if (!globalPrefs.override) {
            globalPrefs.override = true;
            ValManager.getDefault().replace(globalPrefs);
        }
        ProjectPreferences oldPrefs = ValManager.getDefault().getProjectPreferences(project);
        ProjectPreferences newPrefs = new ProjectPreferences(project, true, oldPrefs.getSuspend(), validators);
        ValPrefManagerProject vpm = new ValPrefManagerProject(project);
        vpm.savePreferences(newPrefs);
        prefs.setRuntimeProjectValidationConfiguredServers(sb.toString());
        prefs.save();
        if (Trace.ENABLED) {
            Trace.tracePerf("Update runtime project validation rules when there are server changes. " + project.getName(), time);
        }
    }

    protected static boolean isServerFolder(File folder) {
        File serverFile;
        return folder != null && folder.isDirectory() && (serverFile = new File(folder, "server.xml")).exists();
    }

    private static List<String> getServerExcludeFolders(List<String> serverNames) {
        ArrayList<String> list = new ArrayList<String>();
        for (String serverName : serverNames) {
            for (String s : SERVER_EXCLUDE_FOLDERS) {
                StringBuilder sbr = new StringBuilder("servers");
                sbr.append('/').append(serverName).append('/').append(s);
                list.add(sbr.toString());
            }
        }
        for (String s : SERVERS_EXCLUDE_FOLDERS) {
            StringBuilder sbr = new StringBuilder("servers");
            sbr.append('/').append(s);
            list.add(sbr.toString());
        }
        return list;
    }

    public static WebSphereRuntime getTargetedRuntime(URI fileURI) throws CoreException {
        IProject project;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileURI);
        if (files.length > 0 && ConfigUtils.isServerConfigFile(files[0]) && (project = files[0].getProject()) != null) {
            WebSphereRuntime wrt = WebSphereUtil.getTargetedRuntime(project);
            return wrt;
        }
        return null;
    }

    public static WebSphereRuntime getTargetedRuntime(IProject project) throws CoreException {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;
        IRuntime rt;
        Set targetRuntimes;
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
        if (fp != null && !(targetRuntimes = fp.getTargetedRuntimes()).isEmpty() && (rt = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)(facetRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)targetRuntimes.iterator().next()))) != null) {
            WebSphereRuntime wrt = (WebSphereRuntime)rt.loadAdapter(WebSphereRuntime.class, null);
            return wrt;
        }
        return null;
    }

    public static String getLastName(String path) {
        String filePath = path;
        String[] list = filePath.split("/");
        return list[list.length - 1];
    }

    public static boolean isDefaultRemoteUserDirectory(JMXConnection jmxConnection, String remoteUserPath) throws Exception {
        String wlpDirMetaData = (String)((CompositeData)jmxConnection.getMetadata("${wlp.install.dir}", "a")).get("fileName");
        return WebSphereUtil.getLastName(remoteUserPath).equals("usr") && remoteUserPath.contains(wlpDirMetaData);
    }

    public static String getUniqueRuntimeName(String proposedName, IRuntime[] runtimes) {
        String name = proposedName;
        boolean found = true;
        int index = 2;
        block0: while (found) {
            found = false;
            for (IRuntime runtime : runtimes) {
                if (!name.equals(runtime.getName())) continue;
                found = true;
                name = NLS.bind((String)Messages.runtimeName, (Object)name, (Object)index);
                ++index;
                continue block0;
            }
        }
        return name;
    }

    public static String getUniqueServerName(String proposedName, IServer[] servers) {
        String name = proposedName;
        boolean found = true;
        int index = 2;
        block0: while (found) {
            found = false;
            for (IServer server : servers) {
                if (!name.equals(server.getName())) continue;
                found = true;
                name = NLS.bind((String)Messages.runtimeName, (Object)name, (Object)index);
                ++index;
                continue block0;
            }
        }
        return name;
    }

    public static WebSphereServer getWebSphereServer(IServer server) {
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "The server should not be null.");
            }
            return null;
        }
        WebSphereServer wsServer = (WebSphereServer)((Object)server.getAdapter(WebSphereServer.class));
        if (wsServer == null && Trace.ENABLED) {
            Trace.trace((byte)1, "The server is not a WebSphereServer as expected: " + server.getName());
        }
        return wsServer;
    }
}

