/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.common.core.ext.internal.servertype.ServerTypeExtensionFactory;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.core.internal.AbstractMonitorThread;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.BaseLibertyBehaviourExtension;
import com.ibm.ws.st.core.internal.ConfigurationListener;
import com.ibm.ws.st.core.internal.ConsoleMonitorThread;
import com.ibm.ws.st.core.internal.ExcludeSyncModuleInfo;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.JMXMonitorThread;
import com.ibm.ws.st.core.internal.LibertyConfigSyncConflictHandler;
import com.ibm.ws.st.core.internal.MessageHandler;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.PublishHelper;
import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.core.internal.PublishWithErrorHandler;
import com.ibm.ws.st.core.internal.ServerExtensionWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationIncludeFilter;
import com.ibm.ws.st.core.internal.config.JVMOptions;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.LibertyRemoteUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.RemoteStartServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class WebSphereServerBehaviour
extends ServerBehaviourDelegate
implements IAdaptable {
    private static final String EXTERNAL_APP_PREFIX = "was.external";
    private static final String EXTERNAL_APP_VERSION = "1.0";
    private boolean cleanOnStartup;
    private List<IModule> externalModules = new ArrayList<IModule>(2);
    protected AbstractMonitorThread monitorThread;
    private Properties configSyncInfo = null;
    private Properties remoteConfigSyncInfo = null;
    public static final String CONFIG_SYNC_FILENAME = "configSyncInfo.properties";
    public static final String REMOTE_CONFIG_SYNC_FILENAME = "remoteConfigSyncInfo.properties";
    public static final int AUTO_PUBLISH_DISABLE = 1;
    public static final int AUTO_PUBLISH_RESOURCE = 2;
    public static final int AUTO_PUBLISH_BUILD = 3;
    private static final String PUBLISH_INFO_PROPERTIES = "publishInfo.properties";
    private static final String LAST_PUBLISH_LOOSE_CFG_SETTING = "last.publish.looseConfig";
    private boolean isPublishLooseCfgModeChanged;
    boolean shownFeaturePromptInLauncher = true;
    final ApplicationStateTracker appStateTracker = new ApplicationStateTracker();
    final Map<String, Integer> appTrackingMap = Collections.synchronizedMap(new HashMap());
    private PublishHelper publishHelper = null;
    protected Process serverCmdStopProcess = null;
    protected final Object syncObj1 = new Object();
    final Object serverStateSyncObj = new Object();
    private final ArrayList<String> appsRequireStartCallAfterPublish = new ArrayList();
    private boolean needSyncExteneralModulesAfterPublish = false;
    protected ArrayList<String> overriddenAppsInServerXML;
    protected ArrayList<String> overriddenDropinsApps;
    private IConfigurationElement[] configConflictHandlers = null;
    private static final String CONFLICT_HANDLER_XP_ID = "com.ibm.ws.st.core.libertyConfigConflictHandler";
    private static final String XP_ATTR_CLASS = "class";
    final HashMap<String, String> remoteConfigVarMap = new HashMap();
    private IDebugTarget debugTarget;
    private int debugPortNum = -1;
    protected AbstractServerBehaviourExtension behaviourExtension = null;
    private static final String WINDOWS_PATH_EXPR = "[a-zA-Z]:[\\\\/].*";
    private static final Pattern windowsPathPattern = Pattern.compile("[a-zA-Z]:[\\\\/].*");
    protected HashMap<IModule, ExcludeSyncModuleInfo> excludeSyncModules = new HashMap();

    public IDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public void setDebugTarget(IDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    public int getDebugPortNum() {
        return this.debugPortNum;
    }

    public void setDebugPortNum(int debugPortNum) {
        this.debugPortNum = debugPortNum;
    }

    public void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        if (ext != null) {
            this.behaviourExtension.initialize((ServerBehaviourDelegate)this, monitor);
        }
        this.startMonitorThread();
        this.syncExternalModules();
        Job initializeConfigFilesJob = new Job(NLS.bind((String)Messages.jobInitializeConfigSync, (Object)this.getServer().getName())){

            protected IStatus run(IProgressMonitor mon) {
                WebSphereServerBehaviour.this.initializeConfigSyncPropertyFiles();
                return Status.OK_STATUS;
            }
        };
        initializeConfigFilesJob.setPriority(30);
        initializeConfigFilesJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeConfigSyncPropertyFiles() {
        ConfigurationFile root = this.getWebSphereServer().getConfiguration();
        if (root != null) {
            JMXConnection jmx = null;
            try {
                if (!this.isLocalUserDir()) {
                    jmx = this.getWebSphereServer().createJMXConnection();
                }
                String[] fileLocations = this.getConfigFileLocations(jmx);
                if (!this.isLocalUserDir() && !this.getTempDirectory().append(REMOTE_CONFIG_SYNC_FILENAME).toFile().exists()) {
                    this.remoteConfigSyncInfo = new Properties();
                    this.fillRemoteConfigSyncInfo(fileLocations, jmx);
                    this.saveProperties(this.remoteConfigSyncInfo, REMOTE_CONFIG_SYNC_FILENAME);
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Failed to initialize server config sync property files", e);
                }
                this.remoteConfigSyncInfo = null;
            }
            finally {
                if (jmx != null) {
                    jmx.disconnect();
                }
            }
        }
    }

    protected void syncExternalModules() {
        File[] files;
        String appName;
        ConfigurationFile cf = this.getWebSphereServer().getConfiguration();
        if (cf == null) {
            return;
        }
        ConfigurationFile.Application[] apps = cf.getApplications();
        IModule[] modules = this.getServer().getModules();
        HashSet<String> ignoredConfigFileModuleNames = new HashSet<String>();
        HashSet<String> ignoredDropinFileNames = new HashSet<String>();
        Set<IModule> keys = this.excludeSyncModules.keySet();
        for (IModule iModule : keys) {
            String appFileName;
            String appsDir;
            ExcludeSyncModuleInfo info = this.excludeSyncModules.get(iModule);
            HashMap<String, String> properties = info.getProperties();
            if (properties == null) continue;
            String appName2 = iModule.getName();
            if (appName2 != null) {
                ignoredConfigFileModuleNames.add(appName2);
            }
            if (!"dropins".equals(appsDir = properties.get("appsDir")) || (appFileName = properties.get("appFileName")) == null) continue;
            ignoredDropinFileNames.add(appFileName);
        }
        ArrayList<IModule> newExternalModules = new ArrayList<IModule>(2);
        for (ConfigurationFile.Application app : apps) {
            boolean found = false;
            String currAppName = app.getName();
            if (ignoredConfigFileModuleNames.contains(currAppName)) continue;
            for (IModule m : modules) {
                if (m.isExternal() || !app.getName().equals(m.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            appName = app.getName();
            String appType = app.getType();
            String type = EXTERNAL_APP_PREFIX;
            if (appType != null && appType.length() > 0) {
                type = type + "." + appType;
            }
            newExternalModules.add(this.createExternalModule(appName, appName, type, EXTERNAL_APP_VERSION, null));
        }
        IPath iPath = this.getWebSphereServer().getServerPath().append("dropins");
        File f = iPath.toFile();
        if (f.exists() && (files = f.listFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (ignoredDropinFileNames.contains(name)) continue;
                int ind = name.lastIndexOf(".");
                if (ind == -1) {
                    String appType = name;
                    if (!ServerExtensionWrapper.isValidApplicationType(appType)) continue;
                    String type = "was.external." + appType;
                    File[] files2 = files[i].listFiles();
                    if (files2 == null || files2.length <= 0) continue;
                    for (int j = 0; j < files2.length; ++j) {
                        String appName3 = files2[j].getName();
                        newExternalModules.add(this.createExternalModule(appName3, appName3, type, EXTERNAL_APP_VERSION, null));
                    }
                    continue;
                }
                if (ind <= 0) continue;
                appName = name.substring(0, ind);
                String appType = name.substring(ind + 1);
                String type = EXTERNAL_APP_PREFIX;
                if (ServerExtensionWrapper.isValidApplicationType(appType)) {
                    type = type + "." + appType;
                }
                newExternalModules.add(this.createExternalModule(appName, appName, type, EXTERNAL_APP_VERSION, null));
            }
        }
        boolean changed = false;
        if (newExternalModules.size() != this.externalModules.size()) {
            changed = true;
        } else {
            int size = this.externalModules.size();
            for (int i = 0; i < size; ++i) {
                IModule m1 = this.externalModules.get(i);
                IModule m2 = (IModule)newExternalModules.get(i);
                if (!m1.getName().equals(m2.getName())) {
                    changed = true;
                    break;
                }
                if (m1.getModuleType().equals(m2.getModuleType())) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.externalModules = newExternalModules;
            IModule[] externalModuleArray = this.externalModules.toArray(new IModule[this.externalModules.size()]);
            this.setExternalModules(externalModuleArray);
            if (this.externalModules.size() > 0) {
                this.getPublishedResourceDelta(externalModuleArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExternalModule(IModule module, IProgressMonitor monitor, MultiStatus status) {
        File[] files;
        String dropinsName = null;
        IPath path = this.getWebSphereServer().getServerPath().append("dropins");
        File f = path.toFile();
        if (f.exists() && (files = f.listFiles()) != null && files.length > 0) {
            monitor.beginTask(NLS.bind((String)Messages.taskDeleteDropinsApplication, (Object)module.getName()), files.length / 10 + 5);
            try {
                String appName = module.getName();
                String fullName = null;
                String type = module.getModuleType().getId();
                if (type.startsWith(EXTERNAL_APP_PREFIX)) {
                    type = type.substring(EXTERNAL_APP_PREFIX.length(), type.length());
                    fullName = appName + type;
                }
                monitor.worked(1);
                for (int i = 0; i < files.length; ++i) {
                    String name = files[i].getName();
                    if (name.equals(appName)) {
                        dropinsName = appName;
                        break;
                    }
                    if (name.equals(fullName)) {
                        dropinsName = fullName;
                        break;
                    }
                    if (i <= 0 || i % 10 != 0) continue;
                    if (monitor.isCanceled()) {
                        status.add(Status.CANCEL_STATUS);
                        return;
                    }
                    monitor.worked(1);
                }
                if (monitor.isCanceled()) {
                    status.add(Status.CANCEL_STATUS);
                    return;
                }
                if (dropinsName != null) {
                    IResource resource;
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IContainer folder = workspaceRoot.getContainerForLocation(path);
                    IResource iResource = resource = folder != null ? folder.findMember(dropinsName) : null;
                    if (resource != null) {
                        try {
                            resource.delete(true, monitor);
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    } else {
                        File dropinsFile = path.append(dropinsName).toFile();
                        if (dropinsFile.isDirectory()) {
                            IStatus[] ss;
                            for (IStatus s : ss = org.eclipse.wst.server.core.util.PublishHelper.deleteDirectory((File)dropinsFile, (IProgressMonitor)new SubProgressMonitor(monitor, 4))) {
                                status.add(s);
                            }
                        } else if (!dropinsFile.delete()) {
                            status.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorDeleteDropinsApplication, (Object)module.getName())));
                        }
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerStateImpl(int state) {
        Object object = this.serverStateSyncObj;
        synchronized (object) {
            super.setServerState(state);
        }
    }

    protected void setModuleStateImpl(IModule[] module, int state) {
        if (module == null || module.length == 0) {
            return;
        }
        if (!ServerExtensionWrapper.isGenericApplicationType(module[0].getModuleType())) {
            super.setModuleState(module, state);
        }
    }

    public void setServerAndModuleState(int state) {
        IModule[] modules;
        this.setServerStateImpl(state);
        for (IModule module : modules = this.getServer().getModules()) {
            this.setModuleStateImpl(new IModule[]{module}, state);
        }
    }

    public void stopMonitorThread() {
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Stop monitor thread");
        }
        if (this.monitorThread != null) {
            this.monitorThread.stopMonitor();
            try {
                this.monitorThread.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.monitorThread = null;
    }

    public void startMonitorThread() {
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Start monitor thread");
        }
        IServer server = this.getServer();
        if (this.monitorThread != null || server.isWorkingCopy() || ResourceManager.getInstance().getServer(server.getId()) == null) {
            return;
        }
        this.monitorThread = this.getWebSphereServer().isLocalSetup() ? new ConsoleMonitorThread(this, this.serverStateSyncObj, "WebSphere status monitor(console)") : new JMXMonitorThread(this, this.serverStateSyncObj, "WebSphere status monitor(JMX)");
        this.monitorThread.setPriority(2);
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        this.preLaunch(monitor);
        Object object = this.serverStateSyncObj;
        synchronized (object) {
            if (!this.getWebSphereServer().isLocalSetup()) {
                if (com.ibm.ws.st.common.core.ext.internal.Activator.getPlatformProvider((String)PlatformHandlerFactory.PlatformType.SSH_KEYLESS.name()) == null) {
                    this.setServerStateImpl(4);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptRemoteServerActionsUnavailable));
                }
                if (!this.getWebSphereServer().getIsRemoteServerStartEnabled()) {
                    this.setServerStateImpl(4);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPromptRemoteServerSettingsDisabled));
                }
                try {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "REMOTE EXECUTION START SERVER");
                    }
                    RemoteStartServer remoteLauncher = new RemoteStartServer(this.getServer().getStartTimeout() * 1000, new LibertyRemoteUtilityExecutionDelegate());
                    remoteLauncher.execute(this.getWebSphereServer(), launchMode, launch, monitor);
                }
                catch (CoreException ce) {
                    this.setServerState(4);
                    throw ce;
                }
            }
        }
    }

    public void preLaunch(IProgressMonitor monitor) {
        int curServerState = this.getServer().getServerState();
        if (curServerState != 4) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.stopImpl();
        this.setServerStateImpl(1);
    }

    public void postLaunch(boolean launchSuccessful) {
        if (!launchSuccessful) {
            this.setServerState(4);
        }
    }

    public void stop(boolean force) {
        this.stop(force, (IProgressMonitor)new NullProgressMonitor());
    }

    public void stop(boolean force, IProgressMonitor monitor) {
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        if (ext != null) {
            this.behaviourExtension.stop((ServerBehaviourDelegate)this, force, monitor);
        } else if (Trace.ENABLED) {
            Trace.trace((byte)1, "Unable to load the server stop extension");
        }
    }

    public void stopImpl() {
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Resetting JMX Monitor Thread");
        }
        this.setShownFeaturePromptInLauncher(true);
        if (this.monitorThread instanceof ConsoleMonitorThread) {
            ((ConsoleMonitorThread)this.monitorThread).removeProcessListeners();
        }
        this.setServerAndModuleState(4);
        this.stopMonitorThread();
        this.appStateTracker.clear();
        this.startMonitorThread();
    }

    public void ensureMonitorRunning() {
        if (this.monitorThread == null || !this.monitorThread.isRunning()) {
            this.stopMonitorThread();
            this.startMonitorThread();
        }
    }

    protected void terminateProcess() {
        try {
            ILaunch launch = this.getServer().getLaunch();
            if (launch != null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Killing the server process");
                }
                launch.terminate();
            }
        }
        catch (Exception e) {
            Trace.logError("Error killing the server process", e);
        }
    }

    public boolean waitForServerStop(int timeout) {
        block14: {
            WebSphereServerInfo info;
            WebSphereServer ws = this.getWebSphereServer();
            WebSphereRuntime wr = this.getWebSphereRuntime();
            if (wr != null && ws != null && (info = ws.getServerInfo()) != null && timeout > 0) {
                long t = 0L;
                if (Trace.ENABLED) {
                    t = System.currentTimeMillis();
                }
                try {
                    int iter = timeout / 50;
                    long lastPingTime = System.currentTimeMillis();
                    long endTime = lastPingTime + (long)timeout;
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Ensure the server is stopped.");
                    }
                    while (iter > 0 && wr.getServerStatus(info, (float)iter / 20.0f, null) != 1) {
                        long time1 = System.currentTimeMillis();
                        if (time1 >= endTime) {
                            iter = -1;
                            break;
                        }
                        long sleepTime = 300L - (time1 - lastPingTime);
                        if (sleepTime > 0L) {
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        lastPingTime = System.currentTimeMillis();
                        iter = (int)((endTime - lastPingTime) / 50L);
                    }
                    if (Trace.ENABLED) {
                        if (iter <= 0) {
                            Trace.trace((byte)1, "The server may not be fullly stopped after the server process is stopped.");
                        } else {
                            Trace.tracePerf("Time spent on waiting for server stop.", t);
                            Trace.trace((byte)0, "The server is stopped.");
                        }
                    }
                    if (iter > 0) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block14;
                    Trace.trace((byte)1, "There is an error when determining the server status.", e);
                }
            }
        }
        return false;
    }

    protected WebSphereRuntime getWebSphereRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (WebSphereRuntime)this.getServer().getRuntime().loadAdapter(WebSphereRuntime.class, null);
    }

    public WebSphereServer getWebSphereServer() {
        if (this.getServer() == null) {
            return null;
        }
        return (WebSphereServer)((Object)this.getServer().loadAdapter(WebSphereServer.class, null));
    }

    public WebSphereServerInfo getWebSphereServerInfo() {
        if (this.getServer() == null) {
            return null;
        }
        return this.getWebSphereServer().getServerInfo();
    }

    public void preLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        IModule[] modules;
        IStatus status = this.getWebSphereRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        ServerPort[] ports = this.getWebSphereServer().getServerPorts();
        ArrayList<ServerPort> usedPorts = new ArrayList<ServerPort>();
        for (ServerPort sp : ports) {
            InetAddress host;
            block10: {
                if (sp.getPort() < 0) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", 0, Messages.errorPortInvalid, null));
                }
                host = null;
                try {
                    host = InetAddress.getByName(this.getServer().getHost());
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block10;
                    Trace.trace((byte)1, "Could not determine InetAddress for host: " + this.getServer().getHost(), e);
                }
            }
            if (host == null || !SocketUtil.isPortInUse((InetAddress)host, (int)sp.getPort(), (int)3)) continue;
            usedPorts.add(sp);
        }
        if (usedPorts.size() == 1) {
            ServerPort port = (ServerPort)usedPorts.get(0);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{port.getPort() + "", this.getServer().getName()}), null));
        }
        if (usedPorts.size() > 1) {
            Iterator iterator = usedPorts.iterator();
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                ServerPort sp;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sp = (ServerPort)iterator.next();
                sb.append(sp.getPort());
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorPortsInUse, (Object[])new String[]{sb.toString(), this.getServer().getName()}), null));
        }
        this.stopMonitorThread();
        this.setServerRestartState(false);
        this.setServerStateImpl(1);
        for (IModule module : modules = this.getServer().getModules()) {
            this.setModuleStateImpl(new IModule[]{module}, 4);
        }
        this.setMode(launchMode);
    }

    public IModuleResource[] getResources(IModule[] module) {
        return super.getResources(module);
    }

    public IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public final IPath getRootPublishFolder(boolean shared) {
        WebSphereServerInfo info = this.getWebSphereServerInfo();
        if (info == null) {
            return null;
        }
        if (shared) {
            return info.getUserDirectory().getSharedAppsPath();
        }
        return info.getServerAppsPath();
    }

    public boolean isChanged(PublishUnit pu) {
        if (pu.getDeltaKind() != 0) {
            return true;
        }
        List<PublishUnit> children = pu.getChildren();
        if (children == null) {
            return false;
        }
        for (PublishUnit u : children) {
            if (!this.isChanged(u)) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicationPublishRequired(int kind, PublishUnit app) {
        if (kind != 1 && kind != 3) {
            return true;
        }
        return this.isChanged(app);
    }

    public void checkPublishedModules(IProgressMonitor monitor) {
        if (this.publishHelper == null) {
            this.publishHelper = new PublishHelper(this);
        }
        this.publishHelper.checkPublishedModules(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        this.checkPublishedModules(monitor);
        this.shownFeaturePromptInLauncher = false;
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        ext.prePublishModules((ServerBehaviourDelegate)this, monitor);
        int size = modules.size();
        if (size == 0) {
            this.handleAutoConfigSyncJob(0);
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        PublishUnit[] puList = new PublishUnit[size];
        ArrayList<PublishUnit> addedApps = new ArrayList<PublishUnit>(size);
        ArrayList<PublishUnit> deletedApps = new ArrayList<PublishUnit>(size);
        ArrayList<PublishUnit> otherApps = new ArrayList<PublishUnit>(size);
        for (int i = 0; i < size; ++i) {
            puList[i] = new PublishUnit((IModule[])modules.get(i), (Integer)deltaKind2.get(i));
        }
        int numberOfApps = 0;
        for (int i = 0; i < size; ++i) {
            IModule[] module = (IModule[])modules.get(i);
            if (this.shouldIgnorePublishRequest(module[module.length - 1])) continue;
            if (module.length == 1) {
                ++numberOfApps;
                switch (puList[i].getDeltaKind()) {
                    case 1: {
                        addedApps.add(puList[i]);
                        break;
                    }
                    case 3: {
                        deletedApps.add(puList[i]);
                        break;
                    }
                    default: {
                        otherApps.add(puList[i]);
                    }
                }
            }
            for (int j = 0; j < size; ++j) {
                IModule[] module2;
                if (i == j || (module2 = (IModule[])modules.get(j)).length != module.length + 1 || this.shouldIgnorePublishRequest(module2[module2.length - 1])) continue;
                boolean found = true;
                for (int k = 0; k < module.length; ++k) {
                    try {
                        if (module[k] == module2[k] || module[k].getId().equals(module2[k].getId())) continue;
                        found = false;
                    }
                    catch (Throwable t) {
                        if (module[k] == null) {
                            Trace.logError("module[k] is null", null);
                        } else {
                            Trace.logError("module[k]'s id is " + module[k].getId(), null);
                        }
                        if (module2[k] == null) {
                            Trace.logError("module2[k] is null", null);
                        } else {
                            Trace.logError("module2[k]'s id is " + module2[k].getId(), null);
                        }
                        found = false;
                    }
                    break;
                }
                if (!found) continue;
                puList[i].addChild(puList[j]);
                puList[j].setParent(puList[i]);
            }
        }
        int totalWork = 3500 * size;
        int perAppWork = numberOfApps != 0 ? totalWork / numberOfApps : totalWork;
        Properties publishInfo = new Properties();
        FileUtil.loadProperties(publishInfo, this.getTempDirectory().append(PUBLISH_INFO_PROPERTIES));
        String sLooseCfg = publishInfo.getProperty(LAST_PUBLISH_LOOSE_CFG_SETTING);
        boolean isLooseConfig = this.getWebSphereServer().isLooseConfigEnabled();
        if (sLooseCfg == null) {
            this.isPublishLooseCfgModeChanged = !isLooseConfig;
        } else {
            boolean lastLoose = sLooseCfg.equalsIgnoreCase("true");
            boolean bl = this.isPublishLooseCfgModeChanged = isLooseConfig != lastLoose;
        }
        if (this.isPublishLooseCfgModeChanged) {
            publishInfo.put(LAST_PUBLISH_LOOSE_CFG_SETTING, String.valueOf(isLooseConfig));
            FileUtil.saveCachedProperties(publishInfo, this.getTempDirectory().append(PUBLISH_INFO_PROPERTIES));
        }
        this.appTrackingMap.clear();
        boolean isRunOnServerWait = false;
        this.appsRequireStartCallAfterPublish.clear();
        this.needSyncExteneralModulesAfterPublish = false;
        this.updateDebugSourcePath(deltaKind2);
        JMXConnection jmxConnection = null;
        try {
            int sev;
            block72: {
                block71: {
                    String appName;
                    if (this.getServer().getServerState() == 2) {
                        try {
                            jmxConnection = this.getWebSphereServer().createJMXConnection();
                        }
                        catch (Exception e) {
                            Trace.logError("Could not connect to the server via JMX.  Exiting from publish.", e);
                            multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPublishJMX));
                            if (jmxConnection != null) {
                                jmxConnection.disconnect();
                            }
                            return;
                        }
                    }
                    if (jmxConnection == null && !this.isLocalUserDir()) {
                        if (this.getServer().getServerState() == 2) {
                            multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorPublishJMX));
                        }
                        return;
                    }
                    PublishWithErrorHandler handler = Activator.getPublishWithErrorHandler();
                    if (!this.getWebSphereServer().isPublishWithError() && handler != null) {
                        Iterator<Object> errorModules = new ArrayList();
                        ArrayList<PublishUnit> errorApps = new ArrayList<PublishUnit>();
                        this.validatePublishUnits((List<PublishUnit>)addedApps, (List<String>)((Object)errorModules), (List<PublishUnit>)errorApps);
                        this.validatePublishUnits((List<PublishUnit>)otherApps, (List<String>)((Object)errorModules), (List<PublishUnit>)errorApps);
                        if (!((ArrayList)((Object)errorModules)).isEmpty()) {
                            handler.handlePublishWithError((ArrayList<String>)((Object)errorModules), this.getWebSphereServer());
                            if (handler.getReturnCode() != 0) {
                                addedApps.removeAll(errorApps);
                                otherApps.removeAll(errorApps);
                            }
                        }
                    }
                    for (PublishUnit pu : addedApps) {
                        isRunOnServerWait = true;
                        appName = pu.getModuleName();
                        this.addAppToTrackingMapIfNeeded(appName, 9);
                        MultiStatus mStatus = new MultiStatus("com.ibm.ws.st.core", 0, NLS.bind((String)Messages.publishModule, (Object)pu.getModule()[0].getName()), null);
                        boolean needMonitorConsole = this.publishApplication(kind, pu, mStatus, perAppWork, jmxConnection, monitor);
                        if (!needMonitorConsole) {
                            this.appTrackingMap.remove(appName);
                        }
                        multi.add((IStatus)mStatus);
                    }
                    for (PublishUnit pu : otherApps) {
                        appName = pu.getModuleName();
                        this.appStateTracker.andOpAppState(appName, 64);
                        int expectedAppState = 43;
                        this.addAppToTrackingMapIfNeeded(appName, expectedAppState);
                        MultiStatus mStatus = new MultiStatus("com.ibm.ws.st.core", 0, NLS.bind((String)Messages.publishModule, (Object)pu.getModule()[0].getName()), null);
                        boolean needMonitorConsole = this.publishApplication(kind, pu, mStatus, perAppWork, jmxConnection, monitor);
                        if (!needMonitorConsole || !this.isChanged(pu) || this.getServer().getModuleState(pu.getModule()) != 2) {
                            this.appTrackingMap.remove(appName);
                        } else {
                            isRunOnServerWait = true;
                        }
                        multi.add((IStatus)mStatus);
                    }
                    for (PublishUnit pu : deletedApps) {
                        appName = pu.getModuleName();
                        MultiStatus mStatus = new MultiStatus("com.ibm.ws.st.core", 0, NLS.bind((String)Messages.publishModule, (Object)pu.getModule()[0].getName()), null);
                        this.addAppToTrackingMapIfNeeded(appName, 20);
                        boolean needMonitorConsole = this.publishApplication(kind, pu, mStatus, perAppWork, jmxConnection, monitor);
                        if (!needMonitorConsole || !this.isChanged(pu) || this.getServer().getModuleState(pu.getModule()) != 2) {
                            this.appTrackingMap.remove(appName);
                        }
                        if (pu.getModule()[0].isExternal()) {
                            this.removeExternalModule(pu.getModule()[0], (IProgressMonitor)new SubProgressMonitor(monitor, perAppWork), mStatus);
                            this.needSyncExteneralModulesAfterPublish = true;
                        }
                        multi.add((IStatus)mStatus);
                    }
                    if (this.needSyncExteneralModulesAfterPublish) {
                        this.syncExternalModules();
                    }
                    this.appsRequireStartCallAfterPublish.addAll(this.getOverriddenDropinsApps());
                    if (!this.appsRequireStartCallAfterPublish.isEmpty()) {
                        if (jmxConnection != null) {
                            for (String name : this.appsRequireStartCallAfterPublish) {
                                try {
                                    jmxConnection.startApplication(name);
                                }
                                catch (Exception e) {
                                    if (Trace.ENABLED) {
                                        Trace.trace((byte)1, "Cannot use JMX start applications.", e);
                                    }
                                    this.appTrackingMap.remove(name);
                                    multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.warningApplicationNotStarted, (Object)name)));
                                }
                            }
                        } else {
                            for (String name : this.appsRequireStartCallAfterPublish) {
                                this.appTrackingMap.remove(name);
                                multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.warningApplicationNotStarted, (Object)name)));
                            }
                        }
                    }
                    this.appsRequireStartCallAfterPublish.clear();
                    this.getOverriddenAppsInServerXML().clear();
                    this.getOverriddenDropinsApps().clear();
                    SubProgressMonitor waitForStatusMonitor = new SubProgressMonitor(monitor, 2000);
                    waitForStatusMonitor.beginTask(Messages.publishWaitingForStatus, 1000);
                    waitForStatusMonitor.subTask(Messages.publishWaitingForStatus);
                    waitForStatusMonitor.worked(100);
                    int numberOfAppsToWait = this.appTrackingMap.size();
                    int waitTicksPerApp = numberOfAppsToWait == 0 ? 900 : 900 / numberOfAppsToWait;
                    long waitStartTime = System.currentTimeMillis();
                    long waitTime = Activator.getInstance().getPreferencePublishWaitTimeMS();
                    int counter = 0;
                    block31: while (true) {
                        while (!(this.getServer().getServerState() != 2 || multi.getSeverity() == 4 || this.appTrackingMap.isEmpty() || waitTime >= 0L && System.currentTimeMillis() >= waitStartTime + waitTime || monitor.isCanceled())) {
                            int appsProcessed = numberOfAppsToWait - this.appTrackingMap.size();
                            numberOfAppsToWait -= appsProcessed;
                            if (appsProcessed > 0) {
                                waitForStatusMonitor.worked(appsProcessed * waitTicksPerApp);
                            }
                            try {
                                if (Trace.ENABLED) {
                                    if (counter == 0) {
                                        Trace.trace((byte)0, "waiting for message from applications: " + this.appTrackingMap.toString());
                                        counter = 20;
                                    } else {
                                        --counter;
                                    }
                                }
                                Thread.sleep(100L);
                                continue block31;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        break block71;
                        {
                            continue block31;
                            break;
                        }
                        break;
                    }
                    finally {
                        waitForStatusMonitor.done();
                    }
                }
                for (String key : this.appStateTracker.getAppNames()) {
                    if (this.appStateTracker.hasApplicationState(key, 40)) {
                        multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.warningApplicationNotStarted, (Object)key)));
                    }
                    if (!this.appStateTracker.hasApplicationState(key, 16)) continue;
                    multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", key + ": " + Messages.errorApplicationStop));
                }
                long t = Activator.getInstance().getPreferenceRunOnServerDelayTimeMS();
                if (this.getServer().getServerState() == 2 && isRunOnServerWait && t > 0L && multi.getSeverity() != 4 && !monitor.isCanceled()) {
                    try {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Sleep " + t + " before do run on server.");
                        }
                        Thread.sleep(t);
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Finish sleep. May do run on server.");
                        }
                    }
                    catch (InterruptedException e) {
                        if (!Trace.ENABLED) break block72;
                        Trace.trace((byte)0, "Interrupted during sleep", e);
                    }
                }
            }
            if ((sev = multi.getSeverity()) != 4 && sev != 8) {
                this.setServerPublishState(1);
            }
        }
        finally {
            if (jmxConnection != null) {
                jmxConnection.disconnect();
            }
        }
    }

    private void validatePublishUnits(List<PublishUnit> moduleList, List<String> errorModules, List<PublishUnit> errorApps) {
        for (PublishUnit pu : moduleList) {
            if (!this.isChanged(pu)) continue;
            errorModules.addAll(this.validatePublishUnit(pu));
            if (errorModules.isEmpty()) continue;
            errorApps.add(pu);
        }
    }

    private HashSet<String> validatePublishUnit(PublishUnit pu) {
        HashSet<String> errorModules = new HashSet<String>();
        try {
            IModule module = pu.getModule()[0];
            if (module != null && !module.isExternal()) {
                this.validate(module.getProject(), errorModules);
            }
        }
        catch (CoreException e) {
            Trace.logError("Validation failed for Module" + pu.getModuleName(), e);
        }
        return errorModules;
    }

    private void validate(IProject project, HashSet<String> errorModules) throws CoreException {
        this.validate(project, errorModules, new HashSet<IProject>());
    }

    private void validate(IProject project, Set<String> errorModules, Set<IProject> visitedProjects) throws CoreException {
        IProject[] projects;
        int i;
        if (project == null) {
            return;
        }
        if (visitedProjects.contains(project)) {
            return;
        }
        visitedProjects.add(project);
        IMarker[] markers = project.getProject().findMarkers("org.eclipse.wst.validation.problemmarker", true, 2);
        for (i = 0; i < markers.length; ++i) {
            if ((Integer)markers[i].getAttribute("severity") != 2 || errorModules.contains(project.getName())) continue;
            errorModules.add(project.getName());
        }
        markers = project.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        for (i = 0; i < markers.length; ++i) {
            if ((Integer)markers[i].getAttribute("severity") != 2 || errorModules.contains(project.getName())) continue;
            errorModules.add(project.getName());
        }
        for (IProject projectz : projects = project.getReferencedProjects()) {
            this.validate(projectz, errorModules, visitedProjects);
        }
    }

    protected boolean publishApplication(int kind, PublishUnit pu, MultiStatus status, int perAppWork, JMXConnection jmxConnection, IProgressMonitor monitor) {
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        boolean requireConsoleOutputBeforeComplete = false;
        if (pu.getParent() == null && !this.shouldIgnorePublishRequest(pu.getModule()[0])) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, perAppWork);
            if (3 == pu.getDeltaKind() && this.monitorThread instanceof JMXMonitorThread) {
                ((JMXMonitorThread)this.monitorThread).removeAppListener(pu.getModuleName());
            }
            ServerExtensionWrapper[] publishers = this.getWebSphereServer().getServerExtensions();
            String taskName = NLS.bind((String)Messages.publishingModule, (Object)pu.getModule()[0].getName());
            subMonitor.beginTask(taskName, 100);
            subMonitor.setTaskName(taskName);
            for (ServerExtensionWrapper se : publishers) {
                if (ext != null && !ext.shouldRunPublisherForServerType((ServerBehaviourDelegate)this, (Object)pu, (Object)se) || !se.supportsApplicationType(pu.getModule()[0].getModuleType())) continue;
                se.initServerBehaviour(this);
                se.setJmxConnection(jmxConnection);
                se.setIsLooseConfig(this.getWebSphereServer().isLooseConfigEnabled());
                if (!this.isApplicationPublishRequired(kind, pu) && !this.isPublishLooseCfgModeChanged) {
                    this.setModulesPublishStates(pu, 1);
                    continue;
                }
                if (this.isPublishLooseCfgModeChanged && se.needToActOnLooseConfigModeChange(pu) && pu.getDeltaKind() != 1) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Publish for loose config mode change.");
                    }
                    se.handleLooseConfigModeChange(kind, pu, status, (IProgressMonitor)subMonitor);
                    continue;
                }
                SubProgressMonitor childMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 15);
                se.prePublishApplication(kind, pu, status, (IProgressMonitor)childMonitor);
                childMonitor.done();
                childMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 70);
                se.publishModuleAndChildren(kind, pu, status, (IProgressMonitor)childMonitor);
                childMonitor.done();
                childMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 15);
                se.postPublishApplication(kind, pu, status, (IProgressMonitor)childMonitor);
                requireConsoleOutputBeforeComplete = requireConsoleOutputBeforeComplete || se.requireConsoleOutputBeforePublishComplete(kind, pu, status, (IProgressMonitor)childMonitor);
            }
            if (status.getSeverity() != 4 && 1 == pu.getDeltaKind() && this.monitorThread instanceof JMXMonitorThread) {
                ((JMXMonitorThread)this.monitorThread).addAppListenerOnPublish(pu.getModuleName(), this, monitor);
            }
            this.appStateTracker.andOpAppState(pu.getModuleName(), -65);
            subMonitor.done();
        }
        return requireConsoleOutputBeforeComplete;
    }

    private void setModulesPublishStates(PublishUnit pu, int state) {
        if (pu == null) {
            return;
        }
        this.setModulePublishState(pu.getModule(), state);
        List<PublishUnit> children = pu.getChildren();
        if (children != null) {
            for (PublishUnit u : children) {
                this.setModulesPublishStates(u, state);
            }
        }
    }

    protected boolean isServerExtensionInterested(ServerExtensionWrapper sew, List<?> modules) {
        for (IModule[] module : modules) {
            if (!sew.supports(module[0].getModuleType())) continue;
            return true;
        }
        return false;
    }

    public boolean isCleanOnStartup() {
        return this.cleanOnStartup;
    }

    public void setCleanOnStartup(boolean clean) {
        this.cleanOnStartup = clean;
    }

    public void setRestartState(boolean value) {
        this.setServerRestartState(value);
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory();
    }

    public final List<IModule[]> getPublishedModules() {
        return super.getAllModules();
    }

    public void dispose() {
        if (this.monitorThread instanceof ConsoleMonitorThread) {
            ((ConsoleMonitorThread)this.monitorThread).removeProcessListeners();
        }
        this.terminateDebugTarget();
        this.stopMonitorThread();
    }

    public void setModulePublishState(int state, IModule[] module) {
        super.setModulePublishState(module, state);
    }

    public void setWebSphereServerPublishState(int state) {
        super.setServerPublishState(state);
    }

    protected synchronized IStatus syncConfig(JMXConnection jmxConnection) {
        List<String> allFeatures;
        long time = System.currentTimeMillis();
        if (this.configSyncInfo == null) {
            this.configSyncInfo = new Properties();
            FileUtil.loadProperties(this.configSyncInfo, this.getTempDirectory().append(CONFIG_SYNC_FILENAME));
        }
        if (!(allFeatures = this.getWebSphereServer().getConfiguration().getAllFeatures()).isEmpty()) {
            FeatureSet fs = new FeatureSet(this.getWebSphereRuntime(), allFeatures);
            if (fs.resolve("localConnector") == null && fs.resolve("restConnector") == null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "JMX feature is not enabled on the server for application update");
                }
                int level = this.isLocalUserDir() ? 2 : 4;
                return new Status(level, "com.ibm.ws.st.core", Messages.publishConfigSyncNoJMXConnector);
            }
            try {
                List<String> updatedFiles = new ArrayList<String>(5);
                List<String> deletedFiles = new ArrayList<String>(5);
                String[] configFileLocations = this.getConfigFileLocations(jmxConnection);
                Enumeration<Object> cachedSet = this.configSyncInfo.keys();
                while (cachedSet.hasMoreElements()) {
                    String k = (String)cachedSet.nextElement();
                    boolean found = false;
                    for (int i = 0; i < configFileLocations.length; ++i) {
                        if (!k.equals(configFileLocations[i])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.configSyncInfo.remove(k);
                    deletedFiles.add(k);
                }
                this.fillConfigSyncInfo(updatedFiles, configFileLocations);
                long currentTime = System.currentTimeMillis();
                if (Trace.ENABLED) {
                    Trace.tracePerf("Sync config calculate", time);
                }
                time = currentTime;
                if (!(jmxConnection == null || updatedFiles.isEmpty() && deletedFiles.isEmpty())) {
                    if (this.isLocalUserDir()) {
                        deletedFiles = this.getMappedConfigPaths(deletedFiles, jmxConnection);
                        updatedFiles = this.getMappedConfigPaths(updatedFiles, jmxConnection);
                        this.notifyChanges(jmxConnection, updatedFiles, deletedFiles);
                    } else {
                        try {
                            if (this.remoteConfigSyncInfo == null) {
                                this.remoteConfigSyncInfo = new Properties();
                                FileUtil.loadProperties(this.remoteConfigSyncInfo, this.getTempDirectory().append(REMOTE_CONFIG_SYNC_FILENAME));
                            }
                            ArrayList<String> remotelyUpdatedFiles = this.fillRemoteConfigSyncInfo(configFileLocations, jmxConnection);
                            String localConfigRoot = null;
                            String remoteConfigRoot = null;
                            URI configRoot = this.getWebSphereServer().getConfiguration().getURI();
                            if (configRoot != null) {
                                localConfigRoot = new File(configRoot).toString().replace("\\", "/");
                                remoteConfigRoot = this.resolveRemoteFilePath(localConfigRoot, jmxConnection);
                            }
                            LibertyConfigSyncConflictHandler.Resolution conflict = null;
                            if (!remotelyUpdatedFiles.isEmpty()) {
                                Object o;
                                if (Trace.ENABLED) {
                                    Trace.trace((byte)0, "Detected remote configuration files were updated by external factors");
                                    Trace.trace((byte)0, "Updated files on remote system: " + remotelyUpdatedFiles.toString());
                                }
                                if (this.configConflictHandlers == null) {
                                    for (IConfigurationElement configurationElement : this.configConflictHandlers = Platform.getExtensionRegistry().getConfigurationElementsFor(CONFLICT_HANDLER_XP_ID)) {
                                        if (!Trace.ENABLED) continue;
                                        Trace.trace((byte)0, "configurationElement class=[" + configurationElement.getAttribute(XP_ATTR_CLASS) + "]");
                                    }
                                }
                                if (this.configConflictHandlers != null && this.configConflictHandlers.length > 0 && !Boolean.getBoolean("wtp.autotest.noninteractive") && (o = this.configConflictHandlers[0].createExecutableExtension(XP_ATTR_CLASS)) instanceof LibertyConfigSyncConflictHandler) {
                                    ArrayList<LibertyConfigSyncConflictHandler.Pair> conflictFiles = new ArrayList<LibertyConfigSyncConflictHandler.Pair>();
                                    for (String remoteFile : remotelyUpdatedFiles) {
                                        for (String localFile : updatedFiles) {
                                            if (!this.resolveRemoteFilePath(localFile, jmxConnection).equals(remoteFile)) continue;
                                            conflictFiles.add(new LibertyConfigSyncConflictHandler.Pair(localFile, remoteFile));
                                        }
                                    }
                                    if (!conflictFiles.isEmpty()) {
                                        LibertyConfigSyncConflictHandler handler = (LibertyConfigSyncConflictHandler)o;
                                        conflict = handler.handleConflict(conflictFiles, this.getTempDirectory(), jmxConnection, remoteConfigRoot);
                                    }
                                }
                            }
                            String remoteUserPath = null;
                            if (this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath() != null) {
                                remoteUserPath = this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath().toOSString().replace("\\", "/");
                            }
                            String localUserDir = this.getWebSphereServer().getUserDirectory().getPath().toOSString().replace("\\", "/");
                            if (conflict == null || LibertyConfigSyncConflictHandler.Resolution.OVERWRITE_REMOTE.equals((Object)conflict) || LibertyConfigSyncConflictHandler.Resolution.MERGE.equals((Object)conflict)) {
                                ArrayList<String> updatedRemoteFiles = new ArrayList<String>(updatedFiles.size());
                                ArrayList<String> deletedRemoteFiles = new ArrayList<String>(deletedFiles.size());
                                for (String file : updatedFiles) {
                                    File f = new File(file);
                                    String remotePath = file.replace("\\", "/").replace(localUserDir, remoteUserPath);
                                    jmxConnection.uploadFile(f, remotePath, false);
                                    updatedRemoteFiles.add(remotePath);
                                }
                                for (String file : deletedFiles) {
                                    String remotePath = file.replace("\\", "/").replace(localUserDir, remoteUserPath);
                                    if (remotePath.startsWith(remoteUserPath)) {
                                        jmxConnection.deleteFile(remotePath);
                                    }
                                    deletedRemoteFiles.add(remotePath);
                                }
                                this.notifyChanges(jmxConnection, updatedRemoteFiles, deletedRemoteFiles);
                                for (String filePath : deletedRemoteFiles) {
                                    if (!this.remoteConfigSyncInfo.containsKey(filePath)) continue;
                                    this.remoteConfigSyncInfo.remove(filePath);
                                }
                            } else {
                                throw new Exception(Messages.publishConfigSyncCanceled);
                            }
                            this.fillConfigSyncInfo(updatedFiles, configFileLocations);
                            Job refreshJob = new Job(Messages.promptUpdateServerConfiguration){

                                protected IStatus run(IProgressMonitor arg0) {
                                    IProject userDirProj = WebSphereServerBehaviour.this.getWebSphereServer().getUserDirectory().getProject();
                                    try {
                                        if (userDirProj.exists()) {
                                            userDirProj.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                        }
                                    }
                                    catch (Exception e) {
                                        Trace.logError("Refreshing user directory project failed", e);
                                        return new Status(2, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorRefreshingFolder, (Object)userDirProj.getLocation().toOSString()), (Throwable)e);
                                    }
                                    return Status.OK_STATUS;
                                }

                                public boolean belongsTo(Object family) {
                                    return "com.ibm.ws.st.core.job.family".equals(family);
                                }
                            };
                            refreshJob.schedule(5000L);
                            this.fillRemoteConfigSyncInfo(configFileLocations, jmxConnection);
                        }
                        catch (Exception e) {
                            throw new Exception(Messages.remotePublishConfigSyncFailed, e);
                        }
                    }
                }
                if (Trace.ENABLED) {
                    Trace.tracePerf("Sync config JMX", time);
                }
            }
            catch (Exception e) {
                Trace.logError("Exception when syncing server config", e);
                this.configSyncInfo = null;
                this.remoteConfigSyncInfo = null;
                return new Status(4, "com.ibm.ws.st.core", Messages.publishConfigSyncError, (Throwable)e);
            }
        }
        this.saveProperties(this.configSyncInfo, CONFIG_SYNC_FILENAME);
        this.saveProperties(this.remoteConfigSyncInfo, REMOTE_CONFIG_SYNC_FILENAME);
        return new Status(0, "com.ibm.ws.st.core", Messages.publishConfigSyncSuccess);
    }

    private void fillConfigSyncInfo(List<String> updatedFileList, String[] fileLocations) {
        if (fileLocations == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)7, "No configuration files detected");
            }
            return;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Filling configuration file timestamps");
        }
        for (String key : fileLocations) {
            File file = new File(key);
            key = key.replace("\\", "/");
            String cachedTS = this.configSyncInfo.getProperty(key);
            String s = Long.toString(file.lastModified());
            if (Trace.ENABLED) {
                Trace.trace((byte)7, "File: " + key + " TS: " + s + " cached TS: " + cachedTS);
            }
            if (cachedTS != null && s.equals(cachedTS)) continue;
            this.configSyncInfo.put(key, s);
            if (updatedFileList == null) continue;
            updatedFileList.add(key);
        }
    }

    private ArrayList<String> fillRemoteConfigSyncInfo(String[] fileLocations, JMXConnection jmx) {
        ArrayList<String> remoteUpdatedFileList = new ArrayList<String>(3);
        String remoteUserPath = null;
        if (this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath() != null) {
            remoteUserPath = this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath().toOSString().replace("\\", "/");
        }
        String localUserDir = this.getWebSphereServer().getUserDirectory().getPath().toOSString().replace("\\", "/");
        if (fileLocations == null || jmx == null) {
            return remoteUpdatedFileList;
        }
        for (String key : fileLocations) {
            if ((key = key.replace("\\", "/")).startsWith(localUserDir)) {
                key = key.replace(localUserDir, remoteUserPath);
            }
            String lastModified = null;
            try {
                CompositeData metadata = (CompositeData)jmx.getMetadata(key, "t");
                Date lastModifiedDate = null;
                if (metadata != null) {
                    lastModifiedDate = (Date)metadata.get("lastModified");
                    lastModified = lastModifiedDate.toString();
                }
            }
            catch (Exception e) {
                Trace.logError("Couldn't retrieve server user directory using JMX for: " + key, e);
            }
            String cachedTS = this.remoteConfigSyncInfo.getProperty(key);
            if (lastModified == null || cachedTS != null && lastModified.equals(cachedTS)) continue;
            this.remoteConfigSyncInfo.put(key, lastModified);
            remoteUpdatedFileList.add(key);
        }
        return remoteUpdatedFileList;
    }

    private String[] getConfigFileLocations(JMXConnection jmx) throws Exception {
        String serverXMLLocation;
        URI rootURI;
        UserDirectory userDir;
        HashSet<Object> fileLocations = new HashSet<Object>();
        ArrayList<String> includeFiles = new ArrayList<String>();
        ConfigurationFile root = this.getWebSphereServer().getConfiguration();
        ArrayList<ConfigurationFile> files = new ArrayList<ConfigurationFile>();
        ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
        root.getAllConfigFiles(files, includeFilter);
        String[] unresolvedIncludes = root.getAllUnresolvedIncludes();
        for (ConfigurationFile f : files) {
            URI uri = f.getURI();
            if (uri == null) continue;
            includeFiles.add(new File(uri).toString().replace('\\', '/'));
        }
        for (int i = 0; i < unresolvedIncludes.length; ++i) {
            includeFiles.add(unresolvedIncludes[i].replace('\\', '/'));
        }
        WebSphereServerInfo serverInfo = this.getWebSphereServerInfo();
        UserDirectory userDirectory = userDir = serverInfo == null ? null : serverInfo.getUserDirectory();
        if (this.isLocalUserDir()) {
            fileLocations.addAll(includeFiles);
            if (unresolvedIncludes.length > 0) {
                fileLocations.removeAll(Arrays.asList(unresolvedIncludes));
            }
        } else if (userDir != null && userDir.getRemoteUserPath() != null) {
            for (String file : includeFiles) {
                Object fileName = this.resolveLocalFilePath(file, jmx);
                if (fileName == null || fileLocations.contains(fileName = ((String)fileName).replace('\\', '/')) || !new File((String)fileName).exists()) continue;
                fileLocations.add(fileName);
            }
        }
        if ((rootURI = root.getURI()) != null && (serverXMLLocation = new File(rootURI).toString()) != null) {
            serverXMLLocation = serverXMLLocation.replace('\\', '/');
            fileLocations.add(serverXMLLocation);
        }
        if (this.getWebSphereServer().getServerPath() != null && this.getWebSphereServer().getServerPath().toFile().exists() && serverInfo != null) {
            URI fileLocation;
            URI fileLocation2;
            if (serverInfo.getBootstrap() != null && (fileLocation2 = serverInfo.getBootstrap().getURI()) != null) {
                fileLocations.add(new File(fileLocation2).toString().replace("\\", "/"));
            }
            Collection<JVMOptions> jvmOptionsFiles = serverInfo.getJVMOptionsFiles();
            for (JVMOptions jvmOptionsFile : jvmOptionsFiles) {
                URI fileLocation3 = jvmOptionsFile.getURI();
                if (fileLocation3 == null) continue;
                fileLocations.add(new File(fileLocation3).toString().replace("\\", "/"));
            }
            if (serverInfo.getServerEnv() != null && (fileLocation = serverInfo.getServerEnv().getURI()) != null) {
                fileLocations.add(new File(fileLocation).toString().replace("\\", "/"));
            }
        }
        return fileLocations.toArray(new String[fileLocations.size()]);
    }

    public static boolean isAbsolutePath(String path) {
        if (windowsPathPattern.matcher(path).matches()) {
            return true;
        }
        return new Path(path).isAbsolute();
    }

    public String resolveLocalFilePath(String remoteFileName, JMXConnection jmxConnection) {
        if (remoteFileName == null) {
            return null;
        }
        String fileName = remoteFileName;
        Object metadata = null;
        String remoteUserPath = null;
        if (this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath() != null) {
            remoteUserPath = this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath().toOSString().replace("\\", "/");
        }
        String localUserDir = this.getWebSphereServer().getUserDirectory().getPath().toOSString().replace("\\", "/");
        if (WebSphereServerBehaviour.isAbsolutePath(remoteFileName)) {
            fileName = remoteFileName.replace("\\", "/");
            if (fileName.startsWith(remoteUserPath)) {
                fileName = fileName.replace(remoteUserPath, localUserDir);
            }
        } else if (jmxConnection != null && ConfigVarsUtils.containsReference(remoteFileName)) {
            try {
                fileName = this.resolveLocalFilePath(this.resolveConfigVar(remoteFileName, jmxConnection), jmxConnection);
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.logError("Unable to resolve variable: " + metadata, e);
                }
            }
        } else if (!new File(remoteFileName).isAbsolute() && (remoteFileName.contains("/") || remoteFileName.startsWith("../"))) {
            URI base = new File(localUserDir).toURI();
            URI resolvedPath = base.resolve(remoteFileName);
            fileName = resolvedPath.getPath();
        }
        return fileName;
    }

    private String resolveRemoteFilePath(String localFileName, JMXConnection jmxConnection) throws Exception {
        if (this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath() == null || localFileName == null) {
            return null;
        }
        String fileName = localFileName;
        Object metadata = null;
        String remoteUserDir = null;
        if (this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath() != null) {
            remoteUserDir = this.getWebSphereServerInfo().getUserDirectory().getRemoteUserPath().toOSString().replace("\\", "/");
        }
        String localUserDir = this.getWebSphereServer().getUserDirectory().getPath().toOSString().replace("\\", "/");
        if (new File(localFileName).isAbsolute()) {
            fileName = localFileName.replace("\\", "/");
            if (fileName.startsWith(localUserDir)) {
                fileName = fileName.replace(localUserDir, remoteUserDir);
            }
        } else if (jmxConnection != null && ConfigVarsUtils.containsReference(localFileName)) {
            try {
                fileName = this.resolveConfigVar(localFileName, jmxConnection);
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.logError("Unable to resolve variable: " + metadata, e);
                }
            }
        } else if (!new File(localFileName).isAbsolute() && (localFileName.contains("/") || localFileName.startsWith("../"))) {
            URI base = new File(remoteUserDir).toURI();
            URI resolvedPath = base.resolve(localFileName);
            fileName = resolvedPath.getPath();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(Properties prop, String fileName) {
        if (prop == null) {
            return;
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(this.getTempDirectory().append(fileName).toFile());
            prop.store(out, null);
        }
        catch (Exception e) {
            Trace.logError("Could not write to the properties file: " + fileName, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Trace.logError("Could not close the properties file: " + fileName, e);
                }
            }
        }
    }

    public void startAutoConfigSyncJob() {
        IServer server = this.getServer();
        int state = server.getServerPublishState();
        if (state != 3) {
            if (server.getServerState() != 2) {
                if (!this.getWebSphereServer().isLocalSetup() && !this.isLocalUserDir()) {
                    this.setWebSphereServerPublishState(2);
                }
                return;
            }
            this.setWebSphereServerPublishState(2);
            if (server.getAttribute("auto-publish-setting", 2) == 1) {
                return;
            }
            int time = server.getAttribute("auto-publish-time", 15);
            this.handleAutoConfigSyncJob(time);
        }
    }

    synchronized void handleAutoConfigSyncJob(int delayTime) {
        int state;
        Job[] jobs = Job.getJobManager().find((Object)"com.ibm.ws.st.core.job.family");
        AutoConfigSyncJob syncJob = null;
        if (jobs != null && jobs.length > 0) {
            for (Job j : jobs) {
                if (!(j instanceof AutoConfigSyncJob)) continue;
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Reuse Auto Config Sync Job");
                }
                syncJob = j;
                break;
            }
        }
        if (delayTime < 0) {
            if (syncJob != null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Cancel Auto Config Sync Job");
                }
                syncJob.cancel();
            }
            return;
        }
        if (syncJob == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Create a new Auto Config Sync Job");
            }
            syncJob = new AutoConfigSyncJob();
        }
        if ((state = syncJob.getState()) == 1) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Reschedule Auto Config Sync Job");
            }
            syncJob.wakeUp(delayTime * 1000);
        } else if (state != 2) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Schedule Auto Config Sync Job");
            }
            syncJob.schedule(delayTime * 1000);
        }
    }

    public boolean canRestartModule(IModule[] module) {
        ServerExtensionWrapper[] extensions;
        if (module == null || module.length != 1) {
            return false;
        }
        for (ServerExtensionWrapper se : extensions = this.getWebSphereServer().getServerExtensions()) {
            if (!se.supportsApplicationType(module[0].getModuleType())) continue;
            se.initServerBehaviour(this);
            return se.canRestartModule(module);
        }
        return false;
    }

    public void startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module == null || module.length == 0) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "startModule(): module is null or it is empty");
            }
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        JMXConnection jmxConnection = null;
        try {
            jmxConnection = this.getWebSphereServer().createJMXConnection();
            jmxConnection.startApplication(module[0].getName());
        }
        catch (Exception e) {
            Trace.logError("Failed to start application: " + module[0].getName(), e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorApplicationStart, (Throwable)e));
        }
        finally {
            if (jmxConnection != null) {
                jmxConnection.disconnect();
            }
        }
    }

    public void stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module == null || module.length == 0) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "stopModule(): module is null or it is empty");
            }
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        JMXConnection jmxConnection = null;
        try {
            jmxConnection = this.getWebSphereServer().createJMXConnection();
            jmxConnection.stopApplication(module[0].getName());
        }
        catch (Exception e) {
            Trace.logError("Failed to stop application: " + module[0].getName(), e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorApplicationStop, (Throwable)e));
        }
        finally {
            if (jmxConnection != null) {
                jmxConnection.disconnect();
            }
        }
    }

    public void restartModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module == null || module.length == 0) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "restartModule(): module is null or it is empty");
            }
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        JMXConnection jmxConnection = null;
        try {
            jmxConnection = this.getWebSphereServer().createJMXConnection();
            jmxConnection.restartApplication(module[0].getName());
        }
        catch (Exception e) {
            Trace.logError("Failed to restart application: " + module[0].getName(), e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.errorApplicationRestart, (Throwable)e));
        }
        finally {
            if (jmxConnection != null) {
                jmxConnection.disconnect();
            }
        }
    }

    public OutOfSyncModuleInfo checkModuleConfigOutOfSync(IModule module) {
        ServerExtensionWrapper[] extensions;
        if (module == null) {
            return null;
        }
        if (this.excludeSyncModules.containsKey(module)) {
            return null;
        }
        for (ServerExtensionWrapper se : extensions = this.getWebSphereServer().getServerExtensions()) {
            OutOfSyncModuleInfo info;
            if (!se.supportsApplicationType(module.getModuleType()) || (info = se.checkModuleConfigOutOfSync(module)) == null) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAppToTrackingMapIfNeeded(String appName, int state) {
        Map<String, Integer> map = this.appTrackingMap;
        synchronized (map) {
            if (!this.appStateTracker.hasApplicationState(appName, state)) {
                Integer i;
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Add application to trackingMap: " + appName);
                }
                if ((i = this.appTrackingMap.get(appName)) != null) {
                    this.appTrackingMap.put(appName, i | state);
                } else {
                    this.appTrackingMap.put(appName, state);
                }
            } else if (Trace.ENABLED) {
                Trace.trace((byte)0, "Application message already received: " + appName);
            }
        }
    }

    public boolean isAppStateTrackerHasState(String applicationName, int state) {
        if (this.appStateTracker == null) {
            return false;
        }
        return this.appStateTracker.hasApplicationState(applicationName, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isServerCmdStopProcessRunning() {
        Object object = this.syncObj1;
        synchronized (object) {
            if (this.serverCmdStopProcess == null) {
                return false;
            }
            try {
                this.serverCmdStopProcess.exitValue();
                this.serverCmdStopProcess = null;
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }
    }

    public void addAppRequireCallStartAfterPublish(String appName) {
        if (appName != null) {
            this.appsRequireStartCallAfterPublish.add(appName);
        }
    }

    public void setSyncExternalModulesAfterPublish() {
        this.needSyncExteneralModulesAfterPublish = true;
    }

    public void restart(String launchMode) throws CoreException {
        this.restart(launchMode, (IProgressMonitor)new NullProgressMonitor());
    }

    public void restart(String launchMode, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        IStatus status = this.getServerTypeExtension().canRestart((ServerBehaviourDelegate)this);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        monitor.subTask(Messages.taskGenericStopServer);
        this.stop(true, (IProgressMonitor)monitor.newChild(20));
        IServer cServer = this.getServer();
        int i = 8;
        for (int stopTimeOut = this.getServer().getStopTimeout() * 4; cServer.getServerState() != 4 && stopTimeOut > 0; --stopTimeOut) {
            if (Trace.ENABLED) {
                if (i == 0) {
                    i = 8;
                    Trace.trace((byte)0, "Waiting for server to stop during server restart.");
                } else {
                    --i;
                }
            }
            try {
                Thread.sleep(250L);
                if (!monitor.isCanceled()) continue;
                throw new CoreException(Status.CANCEL_STATUS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        monitor.worked(10);
        this.shownFeaturePromptInLauncher = true;
        monitor.subTask(Messages.taskGenericStartServer);
        ILaunchConfiguration launchConfig = cServer.getLaunchConfiguration(true, (IProgressMonitor)monitor.newChild(5));
        launchConfig.launch(launchMode, (IProgressMonitor)monitor.newChild(65));
    }

    protected void updateDebugSourcePath(List deltaKind) {
        ILaunch launch = this.getServer().getLaunch();
        if (launch == null || deltaKind == null || !launch.getLaunchMode().equals("debug")) {
            return;
        }
        Iterator deltaKindIter = deltaKind.iterator();
        while (deltaKindIter.hasNext()) {
            ILaunchConfiguration launchConfig;
            int curDeltaKind = (Integer)deltaKindIter.next();
            if (curDeltaKind != 1 && curDeltaKind != 3 || (launchConfig = launch.getLaunchConfiguration()) == null) continue;
            try {
                ILaunchConfigurationWorkingCopy launchConfigWc = launchConfig.getWorkingCopy();
                launchConfigWc.doSave();
                break;
            }
            catch (CoreException e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "Cannot force a touch on the launch configuration. Source path will not updated.");
            }
        }
    }

    public boolean shouldShownFeaturePromptInLauncher() {
        return this.shownFeaturePromptInLauncher;
    }

    public void setShownFeaturePromptInLauncher(boolean shownFeaturePromptInLauncher) {
        this.shownFeaturePromptInLauncher = shownFeaturePromptInLauncher;
    }

    public List<String> getOverriddenAppsInServerXML() {
        if (this.overriddenAppsInServerXML == null) {
            this.overriddenAppsInServerXML = new ArrayList();
        }
        return this.overriddenAppsInServerXML;
    }

    public List<String> getOverriddenDropinsApps() {
        if (this.overriddenDropinsApps == null) {
            this.overriddenDropinsApps = new ArrayList();
        }
        return this.overriddenDropinsApps;
    }

    public void addProcessListeners(IProcess newProcess) {
        if (this.monitorThread == null) {
            this.startMonitorThread();
        }
        if (this.monitorThread instanceof ConsoleMonitorThread) {
            ((ConsoleMonitorThread)this.monitorThread).addProcessListeners(newProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveConfigVar(String var, JMXConnection jmx) throws Exception {
        String host = jmx.getHost();
        String port = jmx.getPort();
        String key = host == null || port == null ? null : host + ":" + port + ":" + var;
        HashMap<String, String> hashMap = this.remoteConfigVarMap;
        synchronized (hashMap) {
            String val;
            if (key != null && this.remoteConfigVarMap.containsKey(key) && (val = this.remoteConfigVarMap.get(key)) != null) {
                return val;
            }
            String path = null;
            try {
                CompositeData metadata = (CompositeData)jmx.getMetadata(var, "a");
                path = (String)metadata.get("fileName");
            }
            catch (Exception e) {
                throw new Exception(NLS.bind((String)Messages.errorRemoteConfigResolution, (Object)var), e);
            }
            if (path == null) {
                throw new Exception(NLS.bind((String)Messages.errorRemoteConfigResolution, (Object)var));
            }
            path = path.replace("\\", "/");
            if (key != null) {
                this.remoteConfigVarMap.put(key, path);
            }
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRemoteConfigVarMap() {
        HashMap<String, String> hashMap = this.remoteConfigVarMap;
        synchronized (hashMap) {
            if (!this.remoteConfigVarMap.isEmpty()) {
                this.remoteConfigVarMap.clear();
            }
        }
    }

    public void setInternalMode(String curMode) {
        this.setMode(curMode);
    }

    public boolean isDebugAttached(int curDebugPort, IServer server) throws Exception {
        if (this.getDebugTarget() != null && !this.getDebugTarget().isDisconnected() && !this.getDebugTarget().isTerminated()) {
            return true;
        }
        boolean isDebugAttached = false;
        String curHost = server.getHost();
        if (curDebugPort > 0 && curHost != null) {
            isDebugAttached = this.isDebugConnected(curDebugPort);
        }
        return isDebugAttached;
    }

    public boolean isDebugConnected(int curDebugPort) {
        if (curDebugPort <= 0) {
            return false;
        }
        ILaunch[] curLaunches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (curLaunches != null) {
            for (int i = 0; i < curLaunches.length; ++i) {
                ILaunch curLaunch;
                block7: {
                    curLaunch = curLaunches[i];
                    ILaunchConfiguration curLaunchConfig = curLaunch.getLaunchConfiguration();
                    if (curLaunchConfig == null) continue;
                    try {
                        IServer curServer = ServerUtil.getServer((ILaunchConfiguration)curLaunchConfig);
                        if (curServer == null) continue;
                        if (!curServer.equals(this.getServer())) {
                        }
                        break block7;
                    }
                    catch (CoreException e) {
                        Trace.logError("Failed trying get the launch configuration server to detect if debug already connected: " + curLaunchConfig.getName(), e);
                    }
                    continue;
                }
                IDebugTarget[] debugTargets = curLaunch.getDebugTargets();
                for (int j = 0; j < debugTargets.length; ++j) {
                    IDebugTarget curDebugTarget = debugTargets[j];
                    if (curDebugTarget == null || curDebugTarget.isTerminated() || curDebugTarget.isDisconnected() || this.getDebugPortNum() < 0 || curDebugPort != this.getDebugPortNum()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void terminateDebugTarget() {
        block4: {
            try {
                if (this.debugTarget != null) {
                    Activator.getInstance().removeDebugTarget(this.debugTarget);
                    if (this.debugTarget.canDisconnect()) {
                        this.debugTarget.disconnect();
                        this.debugTarget.terminate();
                        this.debugTarget = null;
                    }
                }
            }
            catch (DebugException e) {
                if (!Trace.ENABLED) break block4;
                Trace.trace((byte)1, "Could not disconnect debug target", e);
            }
        }
    }

    public IStatus canStop() {
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        IStatus result = null;
        if (ext != null) {
            result = this.behaviourExtension.canStop((ServerBehaviourDelegate)this);
            if (result != null) {
                return result;
            }
        } else if (Trace.ENABLED) {
            Trace.trace((byte)1, "Could not load the can stop server extension");
        }
        return super.canStop();
    }

    public boolean canCleanOnStart() {
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        if (ext != null) {
            return ext.canCleanOnStart();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyChanges(JMXConnection jmxConnection, List<String> updatedFiles, List<String> deletedFiles) throws Exception {
        if (updatedFiles.isEmpty() && deletedFiles.isEmpty()) {
            return;
        }
        if (!jmxConnection.isLocalConnection() && jmxConnection.isMBeanExists("WebSphere:name=com.ibm.websphere.runtime.update.RuntimeUpdateNotificationMBean")) {
            ConfigurationFile root = this.getWebSphereServerInfo().getConfigRoot();
            boolean addConfigListener = false;
            ArrayList<String> combinedList = new ArrayList<String>();
            combinedList.addAll(updatedFiles);
            combinedList.addAll(deletedFiles);
            block2: for (String file : combinedList) {
                if (addConfigListener) continue;
                String fileName = new Path(file).lastSegment();
                if (fileName.equals(root.getName())) {
                    addConfigListener = true;
                    break;
                }
                for (ConfigurationFile includeFile : root.getAllIncludedFiles()) {
                    if (!includeFile.getName().equals(fileName)) continue;
                    addConfigListener = true;
                    continue block2;
                }
            }
            if (!addConfigListener) {
                jmxConnection.notifyFileChanges(null, updatedFiles, deletedFiles);
                return;
            } else {
                final ArrayList<Map<String, Object>> notificationsList = new ArrayList<Map<String, Object>>(3);
                final ConfigurationListener configListener = new ConfigurationListener();
                configListener.setNotificationList(notificationsList);
                JMXConnection jmx = null;
                try {
                    jmx = this.getWebSphereServer().createJMXConnection();
                    jmx.addConfigListener(configListener);
                    jmx.notifyFileChanges(null, updatedFiles, deletedFiles);
                    final JMXConnection connection = jmx;
                    Job configUpdateNotificationJob = new Job(Messages.jobRefreshRuntimeMetadata){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                MessageHandler handler;
                                boolean isDone = false;
                                long timeout = System.currentTimeMillis() + 40000L;
                                while (!isDone && System.currentTimeMillis() < timeout) {
                                    for (Map userData : notificationsList) {
                                        if (Trace.ENABLED) {
                                            Trace.trace((byte)7, "Config notification -> Name: " + userData.get("name") + " Status: " + userData.get("status"));
                                        }
                                        isDone = (Boolean)userData.get("status");
                                    }
                                    Thread.sleep(500L);
                                }
                                if (isDone) {
                                    if (!Trace.ENABLED) return Status.OK_STATUS;
                                    Trace.trace((byte)7, "Configuration sync has successfully completed.");
                                    return Status.OK_STATUS;
                                }
                                if (System.currentTimeMillis() > timeout) {
                                    if (!Trace.ENABLED) return Status.OK_STATUS;
                                    Trace.trace((byte)7, "Configuration sync has timed out. ");
                                    return Status.OK_STATUS;
                                }
                                if (Trace.ENABLED) {
                                    Trace.trace((byte)7, "Configuration sync has failed");
                                }
                                if ((handler = Activator.getMessageHandler()) == null) return Status.OK_STATUS;
                                handler.handleMessage(MessageHandler.MessageType.ERROR, Messages.publishErrorTitle, Messages.publishConfigSyncError);
                                return Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                if (!Trace.ENABLED) return Status.OK_STATUS;
                                Trace.trace((byte)1, "An exception was thrown while waiting for configuration update notification from the server.", e);
                                return Status.OK_STATUS;
                            }
                            finally {
                                try {
                                    connection.removeConfigListener(configListener);
                                }
                                catch (Exception e) {
                                    if (Trace.ENABLED) {
                                        Trace.trace((byte)7, "Configuration listener was not found during remove");
                                    }
                                }
                                finally {
                                    connection.disconnect();
                                }
                            }
                        }
                    };
                    configUpdateNotificationJob.setPriority(30);
                    configUpdateNotificationJob.schedule();
                    return;
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "An exception was thrown setting up the configuration listener.", e);
                    }
                    if (jmx == null) return;
                    jmx.disconnect();
                }
            }
            return;
        } else {
            jmxConnection.notifyFileChanges(null, updatedFiles, deletedFiles);
        }
    }

    private List<String> getMappedConfigPaths(List<String> paths, JMXConnection jmx) {
        if (this.getWebSphereServer().isLocalSetup()) {
            return paths;
        }
        ArrayList<String> mappedPaths = new ArrayList<String>(paths.size());
        for (String path : paths) {
            String mappedPath;
            block5: {
                mappedPath = null;
                try {
                    mappedPath = this.resolveRemoteFilePath(path, jmx);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)1, "Failed to map the following local path to a remote path: " + path, e);
                }
            }
            if (mappedPath == null) {
                mappedPath = path;
            }
            mappedPaths.add(mappedPath);
        }
        return mappedPaths;
    }

    private AbstractServerBehaviourExtension getServerTypeExtension() {
        if (this.behaviourExtension == null) {
            this.behaviourExtension = ServerTypeExtensionFactory.getServerBehaviourExtension((String)this.getWebSphereServer().getServerType());
            if (this.behaviourExtension == null) {
                this.behaviourExtension = new BaseLibertyBehaviourExtension();
            }
        }
        return this.behaviourExtension;
    }

    public Object getAdapter(Class adapter) {
        AbstractServerBehaviourExtension behaviourExt = this.getServerTypeExtension();
        if (adapter.isInstance(behaviourExt)) {
            return behaviourExt;
        }
        return null;
    }

    public boolean isLocalUserDir() {
        if (this.getWebSphereServer().isLocalSetup()) {
            return true;
        }
        AbstractServerBehaviourExtension ext = this.getServerTypeExtension();
        if (ext != null) {
            return ext.isLocalUserDir((ServerBehaviourDelegate)this);
        }
        return false;
    }

    public HashMap<IModule, ExcludeSyncModuleInfo> getExcludeSyncModules() {
        return this.excludeSyncModules;
    }

    public void waitForServerStart(IServer server, IProgressMonitor monitor) {
        int timeout = 0;
        int MAX = server.getStartTimeout() * 2;
        while (timeout++ < MAX && !monitor.isCanceled() && server.getServerState() != 2) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e2) {
                timeout = MAX;
            }
        }
    }

    public class ApplicationStateTracker {
        public static final int STARTED = 1;
        public static final int UPDATED = 2;
        public static final int STOPPED = 4;
        public static final int FAILED_START = 8;
        public static final int FAILED_STOP = 16;
        public static final int FAILED_UPDATE = 32;
        public static final int NEED_RESTART_APP = 64;
        private final Hashtable<String, Integer> appStates = new Hashtable();

        Set<String> getAppNames() {
            return this.appStates.keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addApplicationState(String applicationName, int state) {
            if (applicationName == null) {
                return;
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Application message received: " + applicationName + ":" + state);
            }
            Map<String, Integer> map = WebSphereServerBehaviour.this.appTrackingMap;
            synchronized (map) {
                Integer i;
                int trackedValue;
                Integer trackState;
                if (!WebSphereServerBehaviour.this.appTrackingMap.isEmpty() && (trackState = WebSphereServerBehaviour.this.appTrackingMap.get(applicationName)) != null && (state & (trackedValue = trackState.intValue())) != 0) {
                    WebSphereServerBehaviour.this.appTrackingMap.remove(applicationName);
                }
                if ((i = this.appStates.get(applicationName)) != null) {
                    this.appStates.put(applicationName, i | state);
                } else {
                    this.appStates.put(applicationName, state);
                }
            }
        }

        protected boolean hasApplicationState(String applicationName, int state) {
            if (applicationName == null) {
                return false;
            }
            Integer temp = this.appStates.get(applicationName);
            if (temp == null) {
                return false;
            }
            return (temp & state) != 0;
        }

        protected void andOpAppState(String applicationName, int state) {
            if (applicationName == null) {
                return;
            }
            Integer i = this.appStates.get(applicationName);
            if (i != null) {
                this.appStates.put(applicationName, i & state);
            }
        }

        protected void clear() {
            this.appStates.clear();
        }
    }

    public class AutoConfigSyncJob
    extends Job {
        public AutoConfigSyncJob() {
            super("WebSphere Configuration Sync Job");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus status;
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Auto Config Sync job starting");
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (WebSphereServerBehaviour.this.getServer().getServerState() != 2) {
                return Status.OK_STATUS;
            }
            JMXConnection jmxConnection = null;
            try {
                jmxConnection = WebSphereServerBehaviour.this.getWebSphereServer().createJMXConnection();
                status = WebSphereServerBehaviour.this.syncConfig(jmxConnection);
            }
            catch (Exception e) {
                Trace.logError("Exception while syncing server config", e);
                status = new Status(4, "com.ibm.ws.st.core", Messages.publishConfigSyncError, (Throwable)e);
            }
            finally {
                if (jmxConnection != null) {
                    jmxConnection.disconnect();
                }
            }
            if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                WebSphereServerBehaviour.this.setWebSphereServerPublishState(1);
            }
            return status;
        }

        public boolean belongsTo(Object family) {
            return "com.ibm.ws.st.core.job.family".equals(family);
        }
    }
}

