/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerExtension;
import com.ibm.ws.st.common.core.ext.internal.servertype.ServerTypeExtensionFactory;
import com.ibm.ws.st.common.core.internal.CommonServerUtil;
import com.ibm.ws.st.common.core.internal.RemoteServerInfo;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.BaseLibertyServerExtension;
import com.ibm.ws.st.core.internal.FeatureConflictHandler;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureResolverWrapper;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.FeatureUtil;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.IgnoredFeatureConflictMetadataHandler;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ProjectPrefs;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.ServerExtensionWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.jmx.JMXConnectionInfo;
import com.ibm.ws.st.core.internal.remote.RemoteUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class WebSphereServer
extends ServerDelegate
implements IURLProvider,
IAdaptable {
    public static final String PROP_SERVER_NAME = "serverName";
    public static final String PROP_LOOSE_CONFIG = "looseConfig";
    public static final String PROP_STOP_ON_SHUTDOWN = "stopOnShutdown";
    public static final String PUBLISH_WITH_ERROR = "publishWithError";
    public static final String PROP_USER_NAME = "userName";
    public static final String PROP_SECURE_PORT = "securePort";
    public static final String PROP_SERVER_TYPE = "serverType";
    public static final String LIBERTY_SERVER_TYPE = "libertyServer";
    public static final String PROP_USERDIR_ID = "userDirId";
    public static final String SECURE_SERVER_CONNECTION_PASSWORD_KEY = ".serverConnectionPassword";
    private String tempServerConnectionPassword = "";
    private String cachedHost = "localhost";
    private boolean cachedIsLocalHost = true;
    private JMXConnectionInfo jmxConnectionInfo = null;
    protected ServerExtensionWrapper[] serverExtensions;
    protected static transient Vector<PropertyChangeListener> propertyListeners;
    protected AbstractServerExtension serverExtension = null;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (propertyListeners == null) {
            propertyListeners = new Vector();
        }
        propertyListeners.add(listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(RemoteServerInfo.class, propertyName, oldValue, newValue);
        try {
            Vector clone = (Vector)propertyListeners.clone();
            int size = clone.size();
            for (int i = 0; i < size; ++i) {
                try {
                    PropertyChangeListener listener = (PropertyChangeListener)clone.elementAt(i);
                    listener.propertyChange(event);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initialize() {
        this.getServerExtensions();
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setAttribute("auto-publish-setting", 2);
        this.setAttribute("auto-publish-time", 1);
        this.setAttribute(PROP_LOOSE_CONFIG, true);
        this.setAttribute(PROP_SERVER_TYPE, LIBERTY_SERVER_TYPE);
    }

    protected synchronized ServerExtensionWrapper[] getServerExtensions() {
        WebSphereServer ws;
        IServer server;
        if (this.serverExtensions != null) {
            return this.serverExtensions;
        }
        if (this.getServer().isWorkingCopy() && (server = ((IServerWorkingCopy)this.getServer()).getOriginal()) != null && (ws = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null))) != this) {
            return ws.getServerExtensions();
        }
        for (ServerExtensionWrapper se : this.serverExtensions = ServerExtensionWrapper.createServerExtensions()) {
            se.initServer(this);
        }
        return this.serverExtensions;
    }

    public String getServerName() {
        return this.getAttribute(PROP_SERVER_NAME, null);
    }

    public String getServerDisplayName() {
        return this.getServerTypeExtension().getServerDisplayName(this.getServer());
    }

    public void setServerName(String name) {
        this.setAttribute(PROP_SERVER_NAME, name);
        this.refreshConfiguration();
    }

    public boolean isLooseConfigEnabled() {
        return this.getAttribute(PROP_LOOSE_CONFIG, false);
    }

    public void setLooseConfigEnabled(boolean looseConfigEnabled) {
        this.setAttribute(PROP_LOOSE_CONFIG, looseConfigEnabled);
    }

    public boolean isStopOnShutdown() {
        return this.getAttribute(PROP_STOP_ON_SHUTDOWN, true);
    }

    public void setStopOnShutdown(boolean stopOnShutdown) {
        this.setAttribute(PROP_STOP_ON_SHUTDOWN, stopOnShutdown);
    }

    public void SetPublishWithError(boolean publishWithError) {
        this.setAttribute(PUBLISH_WITH_ERROR, publishWithError);
    }

    public void setStopTimeout(int timeout) {
        this.setAttribute("stop-timeout", timeout);
    }

    public boolean isPublishWithError() {
        return this.getAttribute(PUBLISH_WITH_ERROR, false);
    }

    public void setServerUserName(String userName) {
        String oldValue = this.getServerUserName();
        if (oldValue.equals(userName)) {
            return;
        }
        this.setServerProperty(PROP_USER_NAME, userName);
    }

    public String getServerUserName() {
        return this.getServerPropertyString(PROP_USER_NAME);
    }

    public void setServerPassword(String curPassword) {
        String oldPasswd = this.getServerPassword();
        if (oldPasswd.equals(curPassword)) {
            return;
        }
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = preferences.node(CommonServerUtil.getSecurePreferenceNodeName((IServer)this.getServer()));
        try {
            node.put(SECURE_SERVER_CONNECTION_PASSWORD_KEY, curPassword, true);
            preferences.flush();
        }
        catch (Exception e) {
            Trace.logError("Failed to store server password", e);
        }
    }

    public String getServerPassword() {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        String nodeName = CommonServerUtil.getSecurePreferenceNodeName((IServer)this.getServer());
        ISecurePreferences node = preferences.node(nodeName);
        String password = "";
        try {
            password = node.get(SECURE_SERVER_CONNECTION_PASSWORD_KEY, "");
            if (password.equals("")) {
                password = node.get(".password", "");
            }
        }
        catch (StorageException e) {
            Trace.logError("Failed to retrieve server password", e);
        }
        return password;
    }

    public String getTempServerConnectionPassword() {
        return this.tempServerConnectionPassword;
    }

    public void setTempServerConnectionPassword(String tempPassword) {
        String oldPass = this.getTempServerConnectionPassword();
        if (oldPass != null && oldPass.equals(tempPassword)) {
            return;
        }
        this.tempServerConnectionPassword = tempPassword;
        this.firePropertyChangeEvent(SECURE_SERVER_CONNECTION_PASSWORD_KEY, oldPass, tempPassword);
    }

    public void setServerSecurePort(String securePort) {
        String oldValue = this.getServerSecurePort();
        if (oldValue.equals(securePort)) {
            return;
        }
        this.setServerProperty(PROP_SECURE_PORT, securePort);
    }

    public String getServerSecurePort() {
        return this.getServerPropertyString(PROP_SECURE_PORT);
    }

    public void setServerType(String type) {
        String oldValue = this.getServerType();
        if (type.equals(oldValue)) {
            return;
        }
        this.setServerProperty(PROP_SERVER_TYPE, type);
        this.serverExtension = null;
    }

    public String getServerType() {
        return this.getAttribute(PROP_SERVER_TYPE, LIBERTY_SERVER_TYPE);
    }

    public boolean isPublishToRuntime() {
        return true;
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (this.getServer().getRuntime() == null) {
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorNoRuntime, null);
        }
        if (this.getServerName() != null && this.getServerInfo() == null) {
            return new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorNoServer, (Object)this.getServerName()), null);
        }
        if (add != null) {
            for (IModule module : add) {
                IStatus status;
                if (module.getProject() == null || (status = FacetUtil.verifyFacets((IProject)module.getProject(), (IServer)this.getServer())) == null || status.isOK()) continue;
                return status;
            }
        }
        if (add != null && add.length > 0) {
            int unsupported = add.length;
            for (IModule module : add) {
                boolean recognized = false;
                for (ServerExtensionWrapper se : this.getServerExtensions()) {
                    if (!se.supports(module.getModuleType())) continue;
                    IStatus status = se.canAddModule(module);
                    if (status != null && !status.isOK()) {
                        return status;
                    }
                    if (status == null) continue;
                    recognized = true;
                }
                if (!recognized) break;
                --unsupported;
            }
            if (unsupported == 0) {
                return Status.OK_STATUS;
            }
            return new Status(4, "com.ibm.ws.st.core", 0, Messages.errorModuleNotRecognized, null);
        }
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        if (module == null) {
            return null;
        }
        ArrayList<IModule> children = new ArrayList<IModule>();
        for (ServerExtensionWrapper se : this.getServerExtensions()) {
            IModule[] c;
            if (!se.supports(module[module.length - 1].getModuleType()) || (c = se.getChildModules(module)) == null || c.length <= 0) continue;
            for (IModule m : c) {
                children.add(m);
            }
        }
        return children.toArray(new IModule[children.size()]);
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        if (module == null) {
            return null;
        }
        ArrayList<Object> root = new ArrayList<Object>();
        for (ServerExtensionWrapper serverExtensionWrapper : this.getServerExtensions()) {
            IModule[] c;
            if (!serverExtensionWrapper.supports(module.getModuleType()) || (c = serverExtensionWrapper.getRootModules(module)) == null || c.length <= 0) continue;
            IModule[] iModuleArray = c;
            int n = iModuleArray.length;
            for (int i = 0; i < n; ++i) {
                IModule m = iModuleArray[i];
                root.add(m);
            }
        }
        if (root.size() > 1) {
            IModule[] existingModules = this.getServer().getModules();
            Object m = null;
            for (IModule iModule : root) {
                for (IModule me : existingModules) {
                    if (!iModule.equals(me)) continue;
                    m = iModule;
                    break;
                }
                if (m == null) continue;
                break;
            }
            if (m != null && !m.equals(root.get(0))) {
                root.remove(m);
                root.add(0, m);
            }
        }
        return root.toArray(new IModule[root.size()]);
    }

    private void gatherChildModules(List<IModule[]> moduleList, IModule[] parent) {
        IModule[] children;
        int size = parent.length;
        for (IModule m : children = this.getChildModules(parent)) {
            IModule[] mod = new IModule[size + 1];
            System.arraycopy(parent, 0, mod, 0, size);
            mod[size] = m;
            moduleList.add(mod);
            this.gatherChildModules(moduleList, mod);
        }
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        Object configFile;
        IStatus status = this.canModifyModules(add, remove);
        if (status == null || status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        AbstractServerExtension serverExt = this.getServerTypeExtension();
        if (serverExt != null && !(status = serverExt.preModifyModules(this.getServer(), add, remove, monitor)).isOK()) {
            throw new CoreException(status);
        }
        if (this.getConfiguration().getIFile() == null) {
            this.refreshConfiguration();
        }
        boolean configModified = false;
        if (add != null && add.length > 0) {
            configFile = this.getConfiguration();
            List<String> allFeatures = ((ConfigurationFile)configFile).getAllFeatures();
            if (!this.isFeatureConfigured("localConnector-1.0")) {
                ((ConfigurationFile)configFile).addFeature("localConnector-1.0");
                allFeatures.add("localConnector-1.0");
                configModified = true;
            }
            ArrayList<IModule[]> moduleList = new ArrayList<IModule[]>();
            for (IModule module : add) {
                IModule[] mod = new IModule[]{module};
                moduleList.add(mod);
                this.gatherChildModules(moduleList, mod);
            }
            HashMap<String, List<String>> alwaysAdd = new HashMap<String, List<String>>();
            ArrayList<String> featuresToAdd = new ArrayList<String>();
            RequiredFeatureMap rfm = this.getRequiredFeatures((ConfigurationFile)configFile, moduleList, null, monitor);
            if (rfm != null) {
                FeatureResolverFeature[] rfs;
                HashMap<IProject, ProjectPrefs> prefsMap = new HashMap<IProject, ProjectPrefs>();
                block3: for (FeatureResolverFeature rf : rfs = rfm.getFeatures()) {
                    List<IModule[]> modules = rfm.getModules(rf);
                    for (IModule[] module : modules) {
                        String featureName;
                        IProject project = module[module.length - 1].getProject();
                        if (project == null) continue;
                        ProjectPrefs prefs = (ProjectPrefs)prefsMap.get(project);
                        if (prefs == null) {
                            prefs = new ProjectPrefs(project);
                            prefsMap.put(project, prefs);
                        }
                        if (featuresToAdd.contains(featureName = rf.getName()) || prefs.getFeaturePrompt(featureName) != 1) continue;
                        featuresToAdd.add(featureName);
                        ArrayList<String> appList = (ArrayList<String>)alwaysAdd.get(featureName);
                        if (appList == null) {
                            appList = new ArrayList<String>();
                            alwaysAdd.put(featureName, appList);
                        }
                        appList.add(module[0].getName());
                        continue block3;
                    }
                }
            }
            ArrayList<String> combinedFeatures = new ArrayList<String>(allFeatures);
            combinedFeatures.addAll(featuresToAdd);
            RuntimeFeatureResolver.ResolverResult result = RuntimeFeatureResolver.resolve(this.getWebSphereRuntime(), combinedFeatures);
            Set<RuntimeFeatureResolver.FeatureConflict> conflicts = result.getFeatureConflicts();
            boolean ignoreConflicts = this.shouldIgnoreConflicts(conflicts);
            FeatureConflictHandler featureConflictHandler = Activator.getFeatureConflictHandler();
            if (conflicts != null && !conflicts.isEmpty() && featureConflictHandler != null && !ignoreConflicts) {
                if (featureConflictHandler.handleFeatureConflicts(this.getServerInfo(), alwaysAdd, conflicts, false)) {
                    configModified = true;
                }
            } else if (!featuresToAdd.isEmpty()) {
                for (String s : featuresToAdd) {
                    ((ConfigurationFile)configFile).addFeature(s);
                }
                configModified = true;
            }
            if (!((ConfigurationFile)configFile).hasElement("applicationMonitor")) {
                ((ConfigurationFile)configFile).addElement("applicationMonitor");
                configModified = true;
            }
            ((ConfigurationFile)configFile).setAttribute("applicationMonitor", "updateTrigger", "mbean");
        }
        if (remove != null && remove.length > 0) {
            configFile = this.getConfiguration();
            if (!this.isFeatureConfigured("localConnector-1.0")) {
                ((ConfigurationFile)configFile).addFeature("localConnector-1.0");
                configModified = true;
            }
            for (IModule module : remove) {
                if (!module.isExternal()) continue;
                this.getConfiguration().removeApplication(module.getName());
                configModified = true;
            }
        }
        for (ServerExtensionWrapper se : this.getServerExtensions()) {
            ArrayList<IModule> addList = new ArrayList<IModule>();
            if (add != null) {
                for (IModule module : add) {
                    if (!se.supports(module.getModuleType())) continue;
                    addList.add(module);
                    this.getWebSphereServerBehaviour().appStateTracker.andOpAppState(module.getName(), 64);
                }
            }
            ArrayList<IModule> removeList = new ArrayList<IModule>();
            if (remove != null) {
                for (IModule module : remove) {
                    if (!se.supports(module.getModuleType())) continue;
                    removeList.add(module);
                    this.getWebSphereServerBehaviour().appStateTracker.andOpAppState(module.getName(), 0);
                }
            }
            if (addList.size() <= 0 && removeList.size() <= 0 || !se.modifyModules(addList.toArray(new IModule[addList.size()]), removeList.toArray(new IModule[removeList.size()]), monitor)) continue;
            configModified = true;
        }
        if (configModified) {
            try {
                this.getConfiguration().save(monitor);
            }
            catch (IOException e) {
                Trace.logError("Error saving configuration for server: " + this.getServerName(), e);
                status = new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorServerConfigurationModifyFailed, (Object)this.getConfiguration().getPath().toOSString(), (Object)e));
                throw new CoreException(status);
            }
            if (this.getConfiguration().getIFile() == null) {
                this.refreshConfiguration();
            }
        }
    }

    public void addLocalConnectorFeature(IProgressMonitor monitor) {
        boolean configModified = false;
        ConfigurationFile configFile = this.getConfiguration();
        if (!this.isFeatureConfigured("localConnector-1.0")) {
            configFile.addFeature("localConnector-1.0");
            configModified = true;
        }
        if (configModified) {
            try {
                configFile.save(monitor);
            }
            catch (IOException e) {
                Trace.logError("Error saving configuration for server: " + this.getServerName(), e);
            }
        }
    }

    public RequiredFeatureMap getRequiredFeatures(ConfigurationFile configFile, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, IProgressMonitor monitor) throws CoreException {
        FeatureResolverFeature[] requiredFeatures;
        if (!Activator.isAutomaticFeatureDetectionEnabled()) {
            return null;
        }
        if (moduleList == null || moduleList.isEmpty()) {
            return null;
        }
        if (deltaList != null && moduleList.size() != deltaList.size()) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "The delta list should be either null or have the same size as the module list", null);
            }
            return null;
        }
        WebSphereRuntime wr = this.getWebSphereRuntime();
        FeatureSet existingFeatures = new FeatureSet(wr, configFile.getAllFeatures());
        ArrayList<IModule[]> allModules = new ArrayList<IModule[]>(moduleList.size());
        ArrayList<IModuleResourceDelta[]> allDeltas = deltaList == null ? null : new ArrayList<IModuleResourceDelta[]>(deltaList.size());
        for (int i = 0; i < moduleList.size(); ++i) {
            IModule[] module = moduleList.get(i);
            if (module[0].isExternal()) continue;
            allModules.add(module);
            if (deltaList == null || allDeltas == null) continue;
            allDeltas.add(deltaList.get(i));
        }
        RequiredFeatureMap requiredFeatureMap = FeatureResolverWrapper.getAllRequiredFeatures(wr, allModules, allDeltas, existingFeatures, false, monitor);
        if (requiredFeatureMap.isEmpty()) {
            return null;
        }
        for (FeatureResolverFeature rf : requiredFeatures = requiredFeatureMap.getFeatures()) {
            String f;
            if (rf.getName().contains("-")) continue;
            String feature = rf.getName().toLowerCase() + "-";
            boolean removed = false;
            FeatureResolverFeature[] featureResolverFeatureArray = requiredFeatures;
            int n = featureResolverFeatureArray.length;
            for (int i = 0; i < n; ++i) {
                FeatureResolverFeature rf2 = featureResolverFeatureArray[i];
                if (!rf2.getName().toLowerCase().startsWith(feature)) continue;
                List<IModule[]> modules = requiredFeatureMap.getModules(rf);
                if (modules != null) {
                    for (IModule[] module : modules) {
                        requiredFeatureMap.addModule(rf2, module);
                    }
                }
                requiredFeatureMap.removeFeature(rf);
                removed = true;
                break;
            }
            if (removed || (f = existingFeatures.resolve(rf.getName())) == null) continue;
            requiredFeatureMap.removeFeature(rf);
        }
        FeatureResolverFeature[] allContainedFeatures = FeatureResolverWrapper.getAllContainedFeatures(wr, allModules, monitor);
        requiredFeatures = requiredFeatureMap.getFeatures();
        block4: for (FeatureResolverFeature required : requiredFeatures) {
            String feature;
            if (allContainedFeatures.length > 0) {
                for (FeatureResolverFeature contained : allContainedFeatures) {
                    if (required.equals(contained)) {
                        requiredFeatureMap.removeFeature(required);
                        continue block4;
                    }
                    if (contained.getName().contains("-") || !required.getName().contains("-") || !required.getName().startsWith(contained + "-")) continue;
                    requiredFeatureMap.removeFeature(required);
                    continue block4;
                }
            }
            if ((feature = wr.getInstalledFeatures().resolveToHigherVersion(required.getName())) == null) {
                List<IModule[]> modules = requiredFeatureMap.getModules(required);
                IModule[] module = modules.get(0);
                String app = module[0].getName();
                if (module.length > 1) {
                    app = app + " (" + module[module.length - 1].getName() + ")";
                }
                Object[] params = new String[]{app, required.getName(), this.getServer().getRuntime().getName()};
                throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorRequiredFeature, (Object[])params)));
            }
            if (existingFeatures.supports(feature)) {
                requiredFeatureMap.removeFeature(required);
                continue;
            }
            if (feature.toLowerCase().equals(required.getName().toLowerCase())) continue;
            FeatureResolverFeature newFeature = required.getAcceptedAlternatives().size() > 0 ? new FeatureResolverFeature(feature, required.getAcceptedAlternatives().toArray(new String[required.getAcceptedAlternatives().size()])) : new FeatureResolverFeature(feature);
            requiredFeatureMap.replaceFeature(required, newFeature);
        }
        if (requiredFeatureMap.isEmpty()) {
            return null;
        }
        requiredFeatures = requiredFeatureMap.getFeatures();
        block6: for (String f : existingFeatures) {
            for (FeatureResolverFeature fAdd : requiredFeatures) {
                if (!wr.isContainedBy(fAdd.getName(), f)) continue;
                requiredFeatureMap.removeFeature(fAdd);
                continue block6;
            }
        }
        if (requiredFeatureMap.isEmpty()) {
            return null;
        }
        requiredFeatures = requiredFeatureMap.getFeatures();
        for (String f : existingFeatures) {
            for (FeatureResolverFeature fAdd : requiredFeatures) {
                if (fAdd.getAcceptedAlternatives().size() <= 0) continue;
                boolean acceptedAlternativeFound = false;
                for (String acceptedAlternative : fAdd.getAcceptedAlternatives()) {
                    String resolvedAlternative = wr.getInstalledFeatures().resolve(acceptedAlternative);
                    if (!f.equalsIgnoreCase(resolvedAlternative)) continue;
                    acceptedAlternativeFound = true;
                    break;
                }
                if (!acceptedAlternativeFound) continue;
                requiredFeatureMap.removeFeature(fAdd);
            }
        }
        if (requiredFeatureMap.isEmpty()) {
            return null;
        }
        requiredFeatures = requiredFeatureMap.getFeatures();
        block11: for (int i = 0; i < requiredFeatures.length - 1; ++i) {
            for (int j = i + 1; j < requiredFeatures.length; ++j) {
                FeatureResolverFeature fi = requiredFeatures[i];
                FeatureResolverFeature fj = requiredFeatures[j];
                if (FeatureUtil.isLowerVersion(fi.getName(), fj.getName()) || wr.isContainedBy(fi.getName(), fj.getName())) {
                    requiredFeatureMap.removeFeature(fi);
                    continue block11;
                }
                if (!FeatureUtil.isLowerVersion(fj.getName(), fi.getName()) && !wr.isContainedBy(fj.getName(), fi.getName())) continue;
                requiredFeatureMap.removeFeature(fj);
                continue block11;
            }
        }
        return requiredFeatureMap.isEmpty() ? null : requiredFeatureMap;
    }

    public URL getModuleRootURL(IModule module) {
        if (module == null) {
            String s = null;
            try {
                s = this.getServerWebURL();
                URL url = new URL(s);
                return url;
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Failed to get server root url. " + s, e);
                }
                return null;
            }
        }
        for (ServerExtensionWrapper se : this.getServerExtensions()) {
            URL url;
            if (!se.supports(module.getModuleType()) || (url = se.getModuleRootURL(module)) == null) continue;
            return url;
        }
        return null;
    }

    public IStatus validate() {
        String name = this.getServer().getName();
        if (name == null || name.isEmpty()) {
            return new Status(4, "com.ibm.ws.st.core", 0, "", null);
        }
        if (this.getServerInfo() == null) {
            return new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorNoServer, (Object)this.getServerName()));
        }
        return WebSphereServer.validateServerName(this.getServerName());
    }

    public static IStatus validateServerName(String serverName) {
        if (serverName == null) {
            return Status.OK_STATUS;
        }
        int size = serverName.length();
        for (int i = 0; i < size; ++i) {
            char c = serverName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') continue;
            return new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorServerName, (Object)(c + "")), null);
        }
        return Status.OK_STATUS;
    }

    public WebSphereRuntime getWebSphereRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (WebSphereRuntime)this.getServer().getRuntime().loadAdapter(WebSphereRuntime.class, null);
    }

    public WebSphereServerBehaviour getWebSphereServerBehaviour() {
        if (this.getServer() == null) {
            return null;
        }
        return (WebSphereServerBehaviour)((Object)this.getServer().loadAdapter(WebSphereServerBehaviour.class, null));
    }

    public WebSphereServerInfo getServerInfo() {
        WebSphereRuntime wr = this.getWebSphereRuntime();
        if (wr == null) {
            return null;
        }
        return wr.getServerInfo(this.getServerName(), this.getUserDirectory());
    }

    public void refreshConfiguration() {
        WebSphereServer ws;
        IServerWorkingCopy wc;
        IServer server;
        if (this.getServer().isWorkingCopy() && (server = (wc = (IServerWorkingCopy)this.getServer()).getOriginal()) != null && (ws = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null))) != this) {
            ws.refreshConfiguration();
            return;
        }
        WebSphereServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null || serverInfo.getConfigRoot() == null) {
            return;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Configuration refreshed " + (Object)((Object)this) + " " + this.getServer().isWorkingCopy());
        }
        if (!serverInfo.updateCache()) {
            return;
        }
        WebSphereServerBehaviour wsb = this.getWebSphereServerBehaviour();
        if (wsb != null) {
            wsb.syncExternalModules();
        }
    }

    public IPath getServerPath() {
        WebSphereServerInfo rc = this.getServerInfo();
        if (rc == null) {
            return null;
        }
        return rc.getServerPath();
    }

    public IPath getOutputPath() {
        WebSphereServerInfo rc = this.getServerInfo();
        if (rc == null) {
            return null;
        }
        return rc.getServerOutputPath();
    }

    public IFolder getFolder() {
        WebSphereServerInfo rc = this.getServerInfo();
        if (rc == null) {
            return null;
        }
        return rc.getServerFolder();
    }

    public IPath getConfigurationRoot() {
        WebSphereServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null) {
            return null;
        }
        ConfigurationFile configFile = serverInfo.getConfigRoot();
        if (configFile == null) {
            return null;
        }
        return configFile.getPath();
    }

    public Bootstrap getBootstrap() {
        WebSphereServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null) {
            return null;
        }
        return serverInfo.getBootstrap();
    }

    private void setupUserDir() {
        if (this.getServer().isWorkingCopy()) {
            WebSphereServer ws;
            IServer server = ((IServerWorkingCopy)this.getServer()).getOriginal();
            if (server != null && (ws = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null))) != this) {
                return;
            }
            this.setupUserDir((IServerWorkingCopy)this.getServer(), false);
        } else {
            IServerWorkingCopy serverWC = this.getServer().createWorkingCopy();
            this.setupUserDir(serverWC, true);
        }
    }

    private void setupUserDir(IServerWorkingCopy server, boolean save) {
        List<WebSphereServerInfo> serverInfos = this.getWebSphereRuntime().getWebSphereServerInfos();
        for (WebSphereServerInfo serverInfo : serverInfos) {
            if (!serverInfo.getServerName().equals(this.getServerName())) continue;
            server.setAttribute(PROP_USERDIR_ID, serverInfo.getUserDirectory().getUniqueId());
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Setting the user directory for server: " + this.getServerName() + " to: " + serverInfo.getUserDirectory().getUniqueId());
            }
            if (!save) break;
            try {
                server.save(true, null);
            }
            catch (CoreException e) {
                Trace.logError("Failed to set up the user directory for server: " + this.getServerName(), e);
            }
            break;
        }
    }

    public void setUserDir(String userDirId) {
        this.setAttribute(PROP_USERDIR_ID, userDirId);
    }

    public void setUserDir(UserDirectory userDir) {
        this.setAttribute(PROP_USERDIR_ID, userDir == null ? null : userDir.getUniqueId());
    }

    public UserDirectory getUserDirectory() {
        String id = this.getUserDirId();
        WebSphereRuntime wr = this.getWebSphereRuntime();
        if (id != null && wr != null) {
            return wr.getUserDir(id);
        }
        return null;
    }

    public String getUserDirId() {
        String id = this.getAttribute(PROP_USERDIR_ID, null);
        if (id == null) {
            this.setupUserDir();
            id = this.getAttribute(PROP_USERDIR_ID, null);
        }
        return id;
    }

    public ConfigurationFile getConfigurationFileFromURI(URI uri) {
        WebSphereServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null) {
            return null;
        }
        return serverInfo.getConfigurationFileFromURI(uri);
    }

    public URI[] getConfigurationURIs() {
        WebSphereServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null) {
            return new URI[0];
        }
        return serverInfo.getConfigurationURIs();
    }

    public ConfigurationFile getConfiguration() {
        WebSphereServerInfo serverInfo = this.getServerInfo();
        if (serverInfo == null) {
            return null;
        }
        return serverInfo.getConfigRoot();
    }

    public ServerPort[] getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        try {
            ConfigurationFile configFile = this.getConfiguration();
            if (configFile != null) {
                configFile.getPorts(ports);
            }
        }
        catch (Exception e) {
            Trace.logError("Error getting server ports for server: " + this.getServerName(), e);
        }
        return ports.toArray(new ServerPort[ports.size()]);
    }

    public IPath getWorkAreaTempPath() {
        return this.getOutputPath().append("workarea").append("com.ibm.ws.server.adapter");
    }

    public IPath getWorkAreaPath() {
        return this.getOutputPath().append("workarea");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultRemoteLogDirectory() {
        JMXConnection jmx = null;
        try {
            String logFileDirectory;
            jmx = this.createJMXConnection();
            CompositeData metadata = (CompositeData)jmx.getMetadata("${com.ibm.ws.logging.log.directory}", "a");
            if (metadata == null) {
                String string = null;
                return string;
            }
            String string = logFileDirectory = (String)metadata.get("fileName");
            return string;
        }
        catch (Exception e) {
            Trace.logError("getRemoteLogDirectory :Connection to Remote Server failed", e);
        }
        finally {
            if (jmx != null) {
                jmx.disconnect();
            }
        }
        return null;
    }

    public IPath getMessagesFile() throws ConnectException, UnsupportedServiceException, IOException {
        IPath relativePath = RemoteUtils.getRemoteLogDirectory(this);
        if (relativePath != null) {
            return relativePath.append(this.getServerInfo().getMessageFileName());
        }
        return this.getServerInfo().getMessagesFile();
    }

    public IPath getTraceLogFile() throws ConnectException, UnsupportedServiceException, IOException {
        IPath relativePath = RemoteUtils.getRemoteLogDirectory(this);
        if (relativePath != null) {
            return relativePath.append(this.getServerInfo().getTraceFileName());
        }
        return this.getServerInfo().getTraceLogFile();
    }

    public String toString() {
        return "WebSphereServer [" + this.getServerName() + "]";
    }

    public boolean isExternalAppOnServer(String moduleName) {
        return this.getExternalApp(moduleName) != null;
    }

    public IModule getExternalApp(String moduleName) {
        IModule[] modules;
        if (moduleName == null) {
            return null;
        }
        for (IModule m : modules = this.getServer().getModules()) {
            if (!m.isExternal() || !moduleName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerWebURL() {
        ConfigurationFile configFile = this.getConfiguration();
        int httpPort = 9080;
        if (!this.isLocalSetup()) {
            JMXConnection connection = null;
            try {
                connection = this.createJMXConnection();
                httpPort = connection.getRemoteUnsecureHTTPPort();
            }
            catch (Exception e) {
                Trace.logError("Failed to connect to remote server via JMX.", e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        } else if (configFile != null) {
            httpPort = configFile.getHTTPPort();
        }
        return this.getServerTypeExtension().getBaseURL(this.getServer(), httpPort);
    }

    public boolean isLocalHost() {
        String host = this.getServer().getHost();
        if (this.cachedHost.equals(host)) {
            return this.cachedIsLocalHost;
        }
        this.cachedHost = host;
        this.cachedIsLocalHost = SocketUtil.isLocalhost((String)host);
        return this.cachedIsLocalHost;
    }

    public boolean isLocalSetup() {
        Boolean isLocalhost;
        AbstractServerExtension serverExt = this.getServerTypeExtension();
        if (serverExt != null && (isLocalhost = serverExt.isLocalSetup(this.getServer())) != null) {
            return isLocalhost;
        }
        if (LIBERTY_SERVER_TYPE.equals(this.getServerType())) {
            return this.isLocalHost();
        }
        return false;
    }

    public JMXConnection createJMXConnection() throws Exception {
        JMXConnection connection = null;
        if (!this.isLocalSetup()) {
            String userName = this.getServerUserName();
            String password = this.getServerPassword();
            String host = this.getConnectionHost();
            String portNum = this.getConnectionPort();
            connection = new JMXConnection(host, portNum, userName, password);
            connection.connect();
            if (this.getServerInfo() != null) {
                this.getServerInfo().getUserDirectory().setRemoteUserPath((IPath)new Path(this.getWebSphereServerBehaviour().resolveConfigVar("${wlp.user.dir}", connection)));
            }
        } else {
            connection = this.getServerInfo().createLocalJMXConnection();
        }
        return connection;
    }

    public String getConnectionPort() {
        String port = null;
        String serverPort = this.getServerSecurePort();
        AbstractServerExtension serverExt = this.getServerTypeExtension();
        if (serverExt != null) {
            port = serverExt.getConnectionPort(this.getServer(), serverPort);
        }
        if (port == null) {
            port = serverPort;
        }
        return port;
    }

    public String getConnectionHost() {
        String host = null;
        String serverHost = this.getServer().getHost();
        String serverPort = this.getServerSecurePort();
        AbstractServerExtension serverExt = this.getServerTypeExtension();
        if (serverExt != null) {
            host = serverExt.getConnectionHost(this.getServer(), serverHost, serverPort);
        }
        if (host == null) {
            host = serverHost;
        }
        return host;
    }

    public boolean getIsRemoteServerStartEnabled() {
        return this.getServerPropertyBoolean("remoteStart_Enabled");
    }

    public void setIsRemoteServerStartEnabled(boolean enabled) {
        boolean oldEnabled = this.getIsRemoteServerStartEnabled();
        if (oldEnabled == enabled) {
            return;
        }
        this.setServerProperty("remoteStart_Enabled", enabled);
    }

    public String getRemoteServerStartRuntimePath() {
        return this.getServerPropertyString("remoteStart_LibertyRuntimePath");
    }

    public void setRemoteServerStartRuntimePath(String newValue) {
        String oldValue = this.getRemoteServerStartRuntimePath();
        if (oldValue.equals(newValue)) {
            return;
        }
        this.setAttribute("remoteStart_LibertyRuntimePath", newValue);
    }

    public String getRemoteServerStartConfigPath() {
        return this.getServerPropertyString("remoteStart_LibertyConfigPath");
    }

    public void setRemoteServerStartConfigPath(String newValue) {
        String oldValue = this.getRemoteServerStartConfigPath();
        if (oldValue.equals(newValue)) {
            return;
        }
        this.setAttribute("remoteStart_LibertyConfigPath", newValue);
    }

    public int getRemoteServerStartPlatform() {
        return this.getAttribute("remoteStart_Platform", 0);
    }

    public void setRemoteServerStartPlatform(int newValue) {
        int oldValue = this.getRemoteServerStartPlatform();
        if (oldValue == newValue) {
            return;
        }
        this.setServerProperty("remoteStart_Platform", newValue);
    }

    public int getRemoteServerStartLogonMethod() {
        return this.getAttribute("remoteStart_LogonMethod", 0);
    }

    public void setRemoteServerStartLogonMethod(int newValue) {
        int oldValue = this.getRemoteServerStartLogonMethod();
        if (oldValue == newValue) {
            return;
        }
        this.setServerProperty("remoteStart_LogonMethod", newValue);
    }

    public String getRemoteServerStartOSId() {
        return this.getServerPropertyString("remoteStart_OSId");
    }

    public void setRemoteServerStartOSId(String newValue) {
        String oldValue = this.getRemoteServerStartOSId();
        if (oldValue.equals(newValue)) {
            return;
        }
        this.setAttribute("remoteStart_OSId", newValue);
    }

    public String getRemoteServerStartOSPassword() {
        RemoteServerInfo remoteInfo = new RemoteServerInfo(RemoteServerInfo.RemoteServerType.Liberty);
        return remoteInfo.getRemoteServerOSPwd(CommonServerUtil.getSecurePreferenceNodeName((IServer)this.getServer()));
    }

    public void setRemoteServerStartOSPassword(String newValue) {
        RemoteServerInfo remoteInfo = new RemoteServerInfo(RemoteServerInfo.RemoteServerType.Liberty);
        remoteInfo.setRemoteServerOSPwd(newValue, CommonServerUtil.getSecurePreferenceNodeName((IServer)this.getServer()));
    }

    public String getRemoteServerStartSSHId() {
        return this.getServerPropertyString("remoteStart_SSHId");
    }

    public void setRemoteServerStartSSHId(String newValue) {
        String oldValue = this.getRemoteServerStartSSHId();
        if (oldValue.equals(newValue)) {
            return;
        }
        this.setAttribute("remoteStart_SSHId", newValue);
    }

    public String getRemoteServerStartSSHPassphrase() {
        try {
            String value = this.getServerPropertyString("remoteStart_SSHPassphrase");
            if (value.isEmpty()) {
                return "";
            }
            return PasswordUtil.decode((String)value);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.logError("Failed to get remote SSH passphrase", e);
            }
            return "";
        }
    }

    public void setRemoteServerStartSSHPassphrase(String newValue) {
        block3: {
            String oldValue = this.getRemoteServerStartSSHPassphrase();
            if (oldValue.equals(newValue)) {
                return;
            }
            try {
                String valueToSet = newValue.isEmpty() ? "" : PasswordUtil.encode((String)newValue);
                this.setAttribute("remoteStart_SSHPassphrase", valueToSet);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.logError("Failed to set remote SSH passphrase", e);
            }
        }
    }

    public String getRemoteServerStartSSHKeyFile() {
        return this.getServerPropertyString("remoteStart_SSHKeyFile");
    }

    public void setRemoteServerStartSSHKeyFile(String newValue) {
        String oldValue = this.getRemoteServerStartSSHKeyFile();
        if (oldValue.equals(newValue)) {
            return;
        }
        this.setAttribute("remoteStart_SSHKeyFile", newValue);
    }

    public boolean getIsCloudEnabled() {
        return this.getServerPropertyBoolean("cloudIsEnabled");
    }

    public String getRemoteServerStartDebugPort() {
        try {
            String port = this.getServerPropertyString("remoteStart_debugPort");
            if (port == null || port.isEmpty()) {
                port = "7777";
            }
            return port;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.logError("Failed to get remote SSH passphrase", e);
            }
            return "7777";
        }
    }

    public void setRemoteServerStartDebugPort(String newValue) {
        String oldValue = this.getRemoteServerStartDebugPort();
        if (oldValue == newValue) {
            return;
        }
        this.setAttribute("remoteStart_debugPort", newValue);
    }

    protected void setServerProperty(String propName, boolean propValue) {
        if (propName == null) {
            return;
        }
        this.setAttribute(propName, propValue);
    }

    protected void setServerProperty(String propName, int propValue) {
        if (propName == null) {
            return;
        }
        this.setAttribute(propName, propValue);
    }

    protected void setServerProperty(String propName, String propValue) {
        if (propName == null) {
            return;
        }
        this.setAttribute(propName, propValue == null ? "" : propValue);
    }

    protected void setServerProperty(String propName, List<String> propValue) {
        if (propName == null) {
            return;
        }
        this.setAttribute(propName, propValue == null ? new ArrayList(0) : propValue);
    }

    protected boolean getServerPropertyBoolean(String propName) {
        return this.getAttribute(propName, false);
    }

    protected boolean getServerPropertyBoolean(String propName, boolean defaultValue) {
        return this.getAttribute(propName, defaultValue);
    }

    protected int getServerPropertyInt(String propName) {
        return this.getAttribute(propName, -1);
    }

    protected String getServerPropertyString(String propName) {
        return this.getAttribute(propName, "");
    }

    protected List<Object> getServerPropertyList(String propName) {
        return this.getAttribute(propName, new ArrayList());
    }

    protected void setJMXConnectionInfo(JMXConnectionInfo jmxInfo) {
        if (jmxInfo == null) {
            return;
        }
        this.jmxConnectionInfo = jmxInfo;
    }

    protected JMXConnectionInfo getJMXConnectionInfo() {
        return this.jmxConnectionInfo;
    }

    public void setRemoteServerProperties(RemoteServerInfo remoteInfo) {
        this.setIsRemoteServerStartEnabled(remoteInfo.getBooleanValue("remoteStart_Enabled", this.getIsRemoteServerStartEnabled()));
        this.setRemoteServerStartPlatform(remoteInfo.getIntegerValue("remoteStart_Platform", 0));
        this.setRemoteServerStartRuntimePath(remoteInfo.getStringValue("remoteStart_LibertyRuntimePath"));
        this.setRemoteServerStartConfigPath(remoteInfo.getStringValue("remoteStart_LibertyConfigPath"));
        this.setRemoteServerStartLogonMethod(remoteInfo.getIntegerValue("remoteStart_LogonMethod", 0));
        this.setRemoteServerStartOSId(remoteInfo.getStringValue("remoteStart_OSId"));
        this.setRemoteServerStartOSPassword(remoteInfo.getStringValue("remoteStart_OSPassword"));
        this.setRemoteServerStartSSHKeyFile(remoteInfo.getStringValue("remoteStart_SSHKeyFile"));
        this.setRemoteServerStartSSHId(remoteInfo.getStringValue("remoteStart_SSHId"));
        this.setRemoteServerStartSSHPassphrase(remoteInfo.getStringValue("remoteStart_SSHPassphrase"));
        this.setRemoteServerStartDebugPort(remoteInfo.getStringValue("remoteStart_debugPort"));
    }

    public RemoteServerInfo getRemoteServerInfo() {
        RemoteServerInfo remoteInfo = new RemoteServerInfo(RemoteServerInfo.RemoteServerType.Liberty);
        remoteInfo.putBooleanValue("remoteStart_Enabled", this.getIsRemoteServerStartEnabled());
        remoteInfo.putIntegerValue("remoteStart_Platform", this.getRemoteServerStartPlatform());
        remoteInfo.put((Object)"remoteStart_LibertyRuntimePath", (Object)this.getRemoteServerStartRuntimePath());
        remoteInfo.put((Object)"remoteStart_LibertyConfigPath", (Object)this.getRemoteServerStartConfigPath());
        remoteInfo.putIntegerValue("remoteStart_LogonMethod", this.getRemoteServerStartLogonMethod());
        remoteInfo.put((Object)"remoteStart_OSId", (Object)this.getRemoteServerStartOSId());
        remoteInfo.put((Object)"remoteStart_OSPassword", (Object)this.getRemoteServerStartOSPassword());
        remoteInfo.put((Object)"remoteStart_SSHKeyFile", (Object)this.getRemoteServerStartSSHKeyFile());
        remoteInfo.put((Object)"remoteStart_SSHId", (Object)this.getRemoteServerStartSSHId());
        remoteInfo.put((Object)"remoteStart_SSHPassphrase", (Object)this.getRemoteServerStartSSHPassphrase());
        remoteInfo.put((Object)"remoteStart_debugPort", (Object)this.getRemoteServerStartDebugPort());
        return remoteInfo;
    }

    public void setDisableUtilityPromptPref(String key, boolean value) {
        if (key != null) {
            String newKey = this.getServer().getId() + "_" + key;
            Activator.setPreference(newKey, value);
        }
    }

    public boolean getDisableUtilityPromptPref(String key) {
        if (key != null) {
            String newKey = this.getServer().getId() + "_" + key;
            return Activator.getPreference(newKey, false);
        }
        return false;
    }

    public Set<RuntimeFeatureResolver.FeatureConflict> readIgnoredFeatureConflicts() {
        Set<RuntimeFeatureResolver.FeatureConflict> ignoredFeatureConflicts;
        block3: {
            ignoredFeatureConflicts = Collections.emptySet();
            IPath path = null;
            try {
                path = this.getWebSphereServerBehaviour().getTempDirectory().append("ignoredFeatures.xml");
                File ignoredFeaturesFile = path.toFile();
                if (ignoredFeaturesFile.exists()) {
                    ignoredFeatureConflicts = IgnoredFeatureConflictMetadataHandler.read(ignoredFeaturesFile);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Cannot retrieve ignored features from " + path, e);
            }
        }
        return ignoredFeatureConflicts;
    }

    public void saveIgnoredFeatureConflicts(Set<RuntimeFeatureResolver.FeatureConflict> knownConflicts) {
        block5: {
            IPath path = null;
            try {
                path = this.getWebSphereServerBehaviour().getTempDirectory().append("ignoredFeatures.xml");
                File ignoredFeaturesFile = path.toFile();
                if (knownConflicts != null && !knownConflicts.isEmpty()) {
                    if (ignoredFeaturesFile.exists()) {
                        FileUtil.deleteFile(ignoredFeaturesFile);
                    }
                    IgnoredFeatureConflictMetadataHandler.generateMetadataFile(path, knownConflicts);
                } else {
                    FileUtil.deleteFile(ignoredFeaturesFile);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block5;
                Trace.trace((byte)1, "Cannot write ignored features to " + path, e);
            }
        }
    }

    public boolean shouldIgnoreConflicts(Set<RuntimeFeatureResolver.FeatureConflict> conflicts) {
        if (conflicts.isEmpty()) {
            return true;
        }
        Set<RuntimeFeatureResolver.FeatureConflict> ignoredConflicts = this.readIgnoredFeatureConflicts();
        if (ignoredConflicts.size() != conflicts.size()) {
            return false;
        }
        for (RuntimeFeatureResolver.FeatureConflict ignoreConflict : ignoredConflicts) {
            boolean found = false;
            for (RuntimeFeatureResolver.FeatureConflict conflict : conflicts) {
                if (!ignoreConflict.equals(conflict)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setServiceInfo(Map<String, String> serviceInfo) {
        if (serviceInfo != null) {
            Iterator<Map.Entry<String, String>> entries = serviceInfo.entrySet().iterator();
            ISecurePreferences node = this.getSecurePreferencesNode();
            while (entries.hasNext()) {
                Map.Entry<String, String> entry = entries.next();
                String key = entry.getKey();
                String value = entry.getValue();
                try {
                    if (value == null) {
                        node.remove(key);
                        continue;
                    }
                    node.put(key, value, true);
                }
                catch (Exception e) {
                    Trace.logError("Failed to save the value for the " + key + " key in the secure storage.", e);
                }
            }
            try {
                node.flush();
            }
            catch (IOException e) {
                Trace.logError("Failed to save secure preferences for the " + this.getServerName() + " server.  If eclipse is restarted the server may not restore properly.", e);
            }
        }
    }

    public Map<String, String> getServiceInfo() {
        HashMap<String, String> serviceInfo = new HashMap<String, String>();
        AbstractServerExtension ext = this.getServerTypeExtension();
        if (ext != null) {
            String[] keys = ext.getServiceInfoKeys();
            ISecurePreferences node = this.getSecurePreferencesNode();
            for (String key : keys) {
                try {
                    String value = node.get(key, (String)null);
                    serviceInfo.put(key, value);
                }
                catch (Exception e) {
                    Trace.logError("Failed to retrieve the value for the " + key + " key from the secure storage.", e);
                }
            }
        }
        RemoteUtils.copyRemoteInfoToServiceInfo(this.getRemoteServerInfo(), serviceInfo);
        return serviceInfo;
    }

    private ISecurePreferences getSecurePreferencesNode() {
        String nodeName = CommonServerUtil.getSecurePreferenceNodeName((IServer)this.getServer());
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        return preferences.node(nodeName);
    }

    public void cleanup() {
        this.getServerTypeExtension().cleanup(this.getServer());
    }

    public boolean requiresRemoteStartSettings() {
        return this.getServerTypeExtension().requiresRemoteStartSettings(this.getServer());
    }

    private AbstractServerExtension getServerTypeExtension() {
        if (this.serverExtension == null) {
            this.serverExtension = ServerTypeExtensionFactory.getServerExtension((String)this.getServerType());
            if (this.serverExtension == null) {
                this.serverExtension = new BaseLibertyServerExtension();
            }
        }
        return this.serverExtension;
    }

    public Object getAdapter(Class adapter) {
        AbstractServerExtension serverExt = this.getServerTypeExtension();
        if (adapter.isInstance(serverExt)) {
            return serverExt;
        }
        return null;
    }

    public boolean isFeatureConfigured(String featureName) {
        ConfigurationFile cf = this.getConfiguration();
        if (cf == null) {
            return false;
        }
        List<String> allFeatures = cf.getAllFeatures();
        return FeatureSet.resolve(featureName, allFeatures.toArray(new String[allFeatures.size()])) != null;
    }

    public void ensureLocalConnectorAndAppMBeanConfig(IProgressMonitor monitor) {
        boolean configModified = false;
        ConfigurationFile configFile = this.getConfiguration();
        if (!this.isFeatureConfigured("localConnector-1.0")) {
            configFile.addFeature("localConnector-1.0");
            configModified = true;
        }
        if (!configFile.hasElement("applicationMonitor")) {
            configFile.addElement("applicationMonitor");
            configFile.setAttribute("applicationMonitor", "updateTrigger", "mbean");
            configModified = true;
        } else {
            String updateType = configFile.getResolvedAttributeValue("applicationMonitor", "updateTrigger");
            if (updateType == null || !updateType.equals("mbean")) {
                configFile.setAttribute("applicationMonitor", "updateTrigger", "mbean");
                configModified = true;
            }
        }
        if (configModified) {
            try {
                configFile.save(monitor);
            }
            catch (IOException e) {
                Trace.logError("Error saving configuration for server: " + this.getServerName(), e);
            }
        }
    }

    public void serverConfigChanged(IProgressMonitor monitor) {
        AbstractServerExtension serverExt = this.getServerTypeExtension();
        serverExt.serverConfigChanged(this.getServer(), monitor);
    }
}

