/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntimeTargetedProject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;

public class WebSphereRuntimeTargetedProjectRegistry
implements IResourceChangeListener {
    public static final WebSphereRuntimeTargetedProjectRegistry INSTANCE = new WebSphereRuntimeTargetedProjectRegistry();
    private final Map<IProject, WebSphereRuntimeTargetedProject> registry = Collections.synchronizedMap(new HashMap());

    private WebSphereRuntimeTargetedProjectRegistry() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
    }

    public synchronized WebSphereRuntimeTargetedProject getProject(IProject project) {
        return this.registry.get(project);
    }

    public synchronized WebSphereRuntimeTargetedProject addProject(IProject project) {
        WebSphereRuntimeTargetedProject wrtp = new WebSphereRuntimeTargetedProject(project);
        this.registry.put(project, wrtp);
        return wrtp;
    }

    public synchronized void removeProject(IProject project) {
        this.registry.remove(project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject closing = null;
        switch (event.getType()) {
            case 2: 
            case 4: {
                try {
                    closing = (IProject)event.getResource();
                    this.removeProject(closing);
                    break;
                }
                catch (ClassCastException e) {
                    if (!Trace.ENABLED) break;
                    Trace.trace((byte)1, "The resource is not a project " + e.getMessage());
                }
            }
        }
    }
}

