/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;

public class WebSphereRuntimeProductInfoCacheUtil {
    public static final String PRODUCT_EXTENSION_TITLE = "Product Extension:";
    public static final String FEATURE_INFO = "featureInfo";
    public static final String PRODUCT_INFO_LINE_SEPARATOR = " >$< ";
    private static final String VERSION = "version";
    private static final String CACHE_FILE_NAME = "productInfoKey.properties";

    protected static String getProductVersionInfo(WebSphereRuntime runtime) {
        return WebSphereRuntimeProductInfoCacheUtil.executeProductInfo(runtime, VERSION);
    }

    protected static String getProductFeatureInfo(WebSphereRuntime runtime) {
        return WebSphereRuntimeProductInfoCacheUtil.executeProductInfo(runtime, FEATURE_INFO);
    }

    protected static Properties getCombinedProductKey(final WebSphereRuntime runtime) {
        Properties prop;
        block5: {
            Thread featureInfoThread;
            block4: {
                prop = new Properties();
                Thread versionThread = new Thread("Product version"){

                    @Override
                    public void run() {
                        String s = WebSphereRuntimeProductInfoCacheUtil.getProductVersionInfo(runtime);
                        if (s != null) {
                            prop.put(WebSphereRuntimeProductInfoCacheUtil.VERSION, s);
                        }
                    }
                };
                featureInfoThread = new Thread("Product feature info"){

                    @Override
                    public void run() {
                        String s = WebSphereRuntimeProductInfoCacheUtil.getProductFeatureInfo(runtime);
                        if (s != null) {
                            prop.put(WebSphereRuntimeProductInfoCacheUtil.FEATURE_INFO, s);
                        }
                    }
                };
                versionThread.start();
                featureInfoThread.start();
                try {
                    versionThread.join();
                }
                catch (InterruptedException e) {
                    if (!Trace.ENABLED) break block4;
                    Trace.trace((byte)1, "Product version thread was interrupted", e);
                }
            }
            try {
                featureInfoThread.join();
            }
            catch (InterruptedException e) {
                if (!Trace.ENABLED) break block5;
                Trace.trace((byte)1, "Product feature info thread was interrupted", e);
            }
        }
        return prop;
    }

    public static void saveProductInfoCache(WebSphereRuntime runtime, Properties productInfo) {
        if (runtime == null) {
            return;
        }
        Properties curProp = productInfo == null ? WebSphereRuntimeProductInfoCacheUtil.getCombinedProductKey(runtime) : productInfo;
        IPath path = WebSphereRuntimeProductInfoCacheUtil.buildMetadataDirectoryPath(runtime).append(CACHE_FILE_NAME);
        FileUtil.saveCachedProperties(curProp, path);
    }

    public static boolean deleteProductInfoCache(WebSphereRuntime runtime) {
        if (runtime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "The runtime is null.");
            }
            return true;
        }
        IPath path = WebSphereRuntimeProductInfoCacheUtil.buildMetadataDirectoryPath(runtime).append(CACHE_FILE_NAME);
        File file = path.toFile();
        if (file.exists() && !file.delete()) {
            if (Trace.ENABLED) {
                Trace.logError("Failed to delete cache file: " + path.toOSString(), null);
            }
            return false;
        }
        return true;
    }

    protected static Properties loadCachedProductKey(WebSphereRuntime runtime) {
        Properties prop = new Properties();
        if (runtime != null) {
            IPath path = WebSphereRuntimeProductInfoCacheUtil.buildMetadataDirectoryPath(runtime);
            FileUtil.loadProperties(prop, path.append(CACHE_FILE_NAME));
        } else if (Trace.ENABLED) {
            Trace.logError("The runtime is null.", null);
        }
        return prop;
    }

    public static Properties getChangedProductInfo(WebSphereRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        long startTime = 0L;
        if (Trace.ENABLED) {
            startTime = System.currentTimeMillis();
        }
        Properties cached = WebSphereRuntimeProductInfoCacheUtil.loadCachedProductKey(runtime);
        Properties current = WebSphereRuntimeProductInfoCacheUtil.getCombinedProductKey(runtime);
        if (Trace.ENABLED) {
            Trace.tracePerf("Time to determine if productKey cache need to be updated", startTime);
        }
        if (current.equals(cached)) {
            return null;
        }
        return current;
    }

    private static String executeProductInfo(WebSphereRuntime runtime, String cmd) {
        if (runtime.getRuntime() == null || runtime.getRuntime().getLocation() == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Runtime location is null. " + runtime.getRuntime().getName());
            }
            return null;
        }
        try {
            String productInfo = runtime.getProductInfo(cmd, null);
            if (productInfo == null) {
                return null;
            }
            return productInfo.replace("\n", PRODUCT_INFO_LINE_SEPARATOR);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Exception occured when executing command " + cmd, e);
            }
            return null;
        }
    }

    private static IPath buildMetadataDirectoryPath(WebSphereRuntime runtime) {
        return Activator.getInstance().getStateLocation().append(runtime.getRuntime().getId());
    }

    public static List<String> getProductExtensionNames(WebSphereRuntime runtime) {
        ArrayList<String> productExtensionNames = new ArrayList<String>(3);
        Properties productInfo = WebSphereRuntimeProductInfoCacheUtil.getCombinedProductKey(runtime);
        String featureInfo = (String)productInfo.get(FEATURE_INFO);
        if (featureInfo == null) {
            String runtimeVersion = runtime.getRuntimeVersion();
            if (runtimeVersion == null || !runtimeVersion.startsWith("8.5.0")) {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                Trace.logError("featureInfo is null, this could be because the product info generation failed.", t);
            }
            return productExtensionNames;
        }
        int index = featureInfo.indexOf(PRODUCT_EXTENSION_TITLE);
        if (index < 0) {
            return productExtensionNames;
        }
        String[] featureInfos = (featureInfo = featureInfo.substring(index)).split(PRODUCT_INFO_LINE_SEPARATOR.replace("$", "\\$"));
        if (featureInfos[0].lastIndexOf(PRODUCT_EXTENSION_TITLE) != 0) {
            return productExtensionNames;
        }
        for (String f : featureInfos) {
            int subIndex;
            if (!f.contains(PRODUCT_EXTENSION_TITLE) || (subIndex = f.indexOf(58) + 1) >= f.length()) continue;
            productExtensionNames.add(f.substring(subIndex).trim());
        }
        return productExtensionNames;
    }
}

