/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class WebSphereRuntimeLocator
extends RuntimeLocatorDelegate {
    private static final String[] runtimeTypes = new String[]{"com.ibm.ws.st.runtime.wlp", "com.ibm.ws.st.runtime.v85.was"};

    public void searchForRuntimes(IPath origPath, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        File f;
        IPath path = origPath;
        if (path == null) {
            path = Path.ROOT;
        }
        if (!(f = path.toFile()).exists()) {
            return;
        }
        File[] files = f.listFiles();
        if (files != null) {
            int size = files.length;
            int work = 100 / size;
            int workLeft = 100 - work * size;
            for (int i = 0; i < size; ++i) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (files[i] != null && files[i].isDirectory()) {
                    WebSphereRuntimeLocator.searchPath(listener, path.append(files[i].getName()), 4, monitor);
                }
                monitor.worked(work);
            }
            monitor.worked(workLeft);
        } else {
            monitor.worked(100);
        }
    }

    protected static void searchPath(RuntimeLocatorDelegate.IRuntimeSearchListener listener, IPath path, int depth, IProgressMonitor monitor) {
        if (WebSphereRuntime.validateLocation(path).isOK()) {
            IRuntimeWorkingCopy runtime = WebSphereRuntimeLocator.getRuntimeFromDir(path, monitor);
            if (runtime != null) {
                listener.runtimeFound(runtime);
                return;
            }
        } else {
            if (depth == 0) {
                return;
            }
            File[] files = path.toFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            if (files != null) {
                int size = files.length;
                for (int i = 0; i < size; ++i) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    WebSphereRuntimeLocator.searchPath(listener, path.append(files[i].getName()), depth - 1, monitor);
                }
            }
        }
    }

    public static IRuntimeWorkingCopy getRuntimeFromDir(IPath path, IProgressMonitor monitor) {
        for (int i = 0; i < runtimeTypes.length; ++i) {
            try {
                IRuntime[] runtimes;
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypes[i]);
                for (IRuntime runtime : runtimes = ServerCore.getRuntimes()) {
                    if (runtime.getLocation() == null || !runtime.getLocation().equals((Object)path)) continue;
                    return null;
                }
                String name = WebSphereUtil.getUniqueRuntimeName(path.lastSegment(), runtimes);
                String id = path.toOSString().replace(File.separatorChar, '_').replace(':', '-');
                IRuntimeWorkingCopy runtime = runtimeType.createRuntime(id, monitor);
                runtime.setName(name);
                runtime.setLocation(path);
                WebSphereRuntime wc = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
                wc.setVMInstall(JavaRuntime.getDefaultVMInstall());
                IStatus status = runtime.validate(monitor);
                if (status == null || status.getSeverity() != 4) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Runtime found at " + path.toOSString());
                    }
                    return runtime;
                }
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)0, "Invalid runtime found at " + path.toOSString() + ": " + status.getMessage());
                continue;
            }
            catch (Exception e) {
                Trace.logError("Could not find runtime", e);
            }
        }
        return null;
    }
}

