/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.ClasspathExtension;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.ProjectPrefs;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntimeTargetedProject;
import com.ibm.ws.st.core.internal.WebSphereRuntimeTargetedProjectRegistry;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.wst.server.core.IRuntime;

public class WebSphereRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate {
    public static final String FOLDER_DEV = "dev";
    public static final String FOLDER_API = "api";
    public static final String FOLDER_SPI = "spi";
    public static final String FOLDER_TOOLS = "tools";
    public static final String FOLDER_SPEC = "spec";
    public static final String FOLDER_IBM = "ibm";
    public static final String FOLDER_THIRD_PARTY = "third-party";
    public static final String FOLDER_STABLE = "stable";
    public static final String FOLDER_JAVADOC = "javadoc";
    public static final String FOLDER_IBM_API = "ibm-api";
    private static final String PATTERN_JAR_FULL_VERSION = ".*\\_\\d+(\\.\\d+(\\.\\d+))\\.jar";
    private static final Pattern patternJarFullVersion = Pattern.compile(".*\\_\\d+(\\.\\d+(\\.\\d+))\\.jar");
    private static final String JAVADOC_ZIP_EXT = "-javadoc.zip";
    private static final String JAVADOC_URL_EXT = "-javadoc.url";
    private static Map<String, RuntimeClasspathEntry> parsedEntriesCache = new HashMap<String, RuntimeClasspathEntry>();

    protected static void findJars(IPath path, ProjectPrefs prefs, List<IClasspathEntry> list, boolean searchAllSubdirectories, Set<String> jarsToSkip) {
        File dir = path.toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        IPath javadocPath = path.append(FOLDER_JAVADOC);
        File javadocDir = javadocPath.toFile();
        if (!javadocDir.exists() || !javadocDir.isDirectory()) {
            javadocDir = null;
        }
        for (File f : files) {
            String javaDocZipName;
            File javaDoc;
            int ind;
            if (f.isDirectory()) {
                if (!searchAllSubdirectories && !WebSphereRuntimeClasspathProvider.isIncludedFolder(f.getName(), prefs)) continue;
                WebSphereRuntimeClasspathProvider.findJars(path.append(f.getName()), prefs, list, searchAllSubdirectories, jarsToSkip);
                continue;
            }
            String name = f.getName();
            boolean skip = false;
            if (jarsToSkip != null && !jarsToSkip.isEmpty()) {
                for (String jarToSkip : jarsToSkip) {
                    if (!jarToSkip.endsWith(name)) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || name == null || !name.endsWith(".jar")) continue;
            File matchedJavaDoc = null;
            String javaDocUrlStr = null;
            if (javadocDir != null && (matchedJavaDoc = WebSphereRuntimeClasspathProvider.getJavadocFile(javadocDir, name, JAVADOC_ZIP_EXT)) == null && (javaDocUrlStr = WebSphereRuntimeClasspathProvider.getJavadocUrl(javadocDir, name)) == null && (ind = name.lastIndexOf("_")) >= 0 && (javaDoc = new File(javadocDir, javaDocZipName = name.substring(0, ind) + JAVADOC_ZIP_EXT)).exists() && javaDoc.isFile()) {
                matchedJavaDoc = javaDoc;
            }
            IClasspathEntry entry = null;
            if (matchedJavaDoc != null) {
                URI uri = matchedJavaDoc.toURI();
                IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)("jar:" + uri.toASCIIString() + "!/"));
                entry = JavaCore.newLibraryEntry((IPath)path.append(name), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{attr}, (boolean)false);
            } else if (javaDocUrlStr != null) {
                try {
                    URL javaDocUrl = new URL(javaDocUrlStr);
                    URI uri = javaDocUrl.toURI();
                    IClasspathAttribute attr = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)uri.toASCIIString());
                    entry = JavaCore.newLibraryEntry((IPath)path.append(name), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{attr}, (boolean)false);
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Invalid javadoc URL " + javaDocUrlStr + " for " + javadocDir + "/" + name);
                    }
                }
            } else {
                entry = JavaCore.newLibraryEntry((IPath)path.append(name), null, null);
            }
            list.add(entry);
        }
    }

    private static String getJavadocUrl(File javadocDir, String jarName) {
        File javaDocUrlFile = WebSphereRuntimeClasspathProvider.getJavadocFile(javadocDir, jarName, JAVADOC_URL_EXT);
        if (javaDocUrlFile != null) {
            Properties urlProps = new Properties();
            FileUtil.loadProperties(urlProps, (IPath)new Path(javaDocUrlFile.getAbsolutePath()));
            return urlProps.getProperty("URL");
        }
        return null;
    }

    private static File getJavadocFile(File javadocDir, String jarName, String extension) {
        int index;
        if (jarName == null || !jarName.endsWith(".jar")) {
            return null;
        }
        String rootName = jarName.substring(0, jarName.length() - 4);
        File javadocFile = new File(javadocDir, rootName + extension);
        if (javadocFile.exists() && javadocFile.isFile()) {
            return javadocFile;
        }
        Matcher matcher = patternJarFullVersion.matcher(jarName);
        if (matcher.matches() && (index = rootName.lastIndexOf(46)) > 0 && (javadocFile = new File(javadocDir, (rootName = rootName.substring(0, index)) + extension)).exists() && javadocFile.isFile()) {
            return javadocFile;
        }
        return null;
    }

    private static boolean isIncludedFolder(String s, ProjectPrefs prefs) {
        if (FOLDER_API.equals(s) || FOLDER_SPEC.equals(s)) {
            return true;
        }
        if (FOLDER_TOOLS.equals(s) || FOLDER_SPI.equals(s)) {
            return false;
        }
        if (FOLDER_THIRD_PARTY.equals(s)) {
            return !prefs.isExcludeThirdPartyAPI();
        }
        if (FOLDER_STABLE.equals(s)) {
            return !prefs.isExcludeStableAPI();
        }
        if (FOLDER_IBM.equals(s) || FOLDER_IBM_API.equals(s)) {
            return !prefs.isExcludeIBMAPI();
        }
        return !prefs.isExcludeUnrecognized();
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        IPath runtimeLocation;
        WebSphereRuntimeTargetedProject wrtp = null;
        if (Activator.getInstance().getPreferenceUseDynamicClasspathContainer() && (wrtp = WebSphereRuntimeTargetedProjectRegistry.INSTANCE.getProject(project)) == null) {
            wrtp = WebSphereRuntimeTargetedProjectRegistry.INSTANCE.addProject(project);
            wrtp.refresh(false);
        }
        if ((runtimeLocation = runtime.getLocation()) == null) {
            return new IClasspathEntry[0];
        }
        for (ClasspathExtension ce : Activator.getInstance().getEmptyContainerExtensions()) {
            if (!ce.supportsNature(project) && !ce.containsSupportedFacet(project)) continue;
            return new IClasspathEntry[0];
        }
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>(30);
        ProjectPrefs prefs = new ProjectPrefs(project);
        Set<String> jarsToSkip = null;
        if (wrtp != null) {
            try {
                IClasspathEntry[] tmp = wrtp.getClasspathEntriesCache().getEntries();
                if (tmp.length > 0) {
                    return tmp;
                }
                jarsToSkip = wrtp.getConflictedJars();
            }
            catch (Exception e) {
                Trace.logError("Could not get list of jars to ignore for project " + project.getName(), e);
            }
        }
        WebSphereRuntimeClasspathProvider.findJars(runtimeLocation.append(FOLDER_DEV), prefs, list, false, jarsToSkip);
        WebSphereRuntimeClasspathProvider.findJars(runtimeLocation.append("usr/extension"), prefs, list, true, null);
        IClasspathEntry[] entries = list.toArray(new IClasspathEntry[list.size()]);
        Arrays.sort(entries, new RuntimeClasspathEntriesComparator());
        entries = WebSphereRuntimeClasspathProvider.filterDuplicateFeatures(entries);
        if (wrtp != null) {
            wrtp.getClasspathEntriesCache().setEntries(entries);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IClasspathEntry[] filterDuplicateFeatures(IClasspathEntry[] entries) {
        ArrayList<IClasspathEntry> filteredEntries = new ArrayList<IClasspathEntry>();
        int j = 0;
        while (j < entries.length) {
            RuntimeClasspathEntry cpe;
            boolean foundLatest = false;
            IClasspathEntry cp = entries[j];
            String cpePath = cp.getPath().lastSegment();
            Map<String, RuntimeClasspathEntry> map = parsedEntriesCache;
            synchronized (map) {
                if (!parsedEntriesCache.containsKey(cpePath)) {
                    cpe = new RuntimeClasspathEntry(cpePath);
                    parsedEntriesCache.put(cpePath, cpe);
                } else {
                    cpe = parsedEntriesCache.get(cpePath);
                }
            }
            int k = 1;
            IClasspathEntry latestVersion = cp;
            while (!foundLatest) {
                if (j + k == entries.length) {
                    latestVersion = cp;
                    foundLatest = true;
                    filteredEntries.add(latestVersion);
                } else {
                    RuntimeClasspathEntry nextCpe;
                    IClasspathEntry nextCp = entries[j + k];
                    String nextCpePath = nextCp.getPath().lastSegment();
                    Map<String, RuntimeClasspathEntry> map2 = parsedEntriesCache;
                    synchronized (map2) {
                        if (!parsedEntriesCache.containsKey(nextCpePath)) {
                            nextCpe = new RuntimeClasspathEntry(nextCpePath);
                            parsedEntriesCache.put(nextCpePath, nextCpe);
                        } else {
                            nextCpe = parsedEntriesCache.get(nextCpePath);
                        }
                    }
                    if (cpe.getJarName().equals(nextCpe.getJarName())) {
                        latestVersion = cpe.isVersionGreater(nextCpe) ? cp : nextCp;
                    } else {
                        foundLatest = true;
                        filteredEntries.add(latestVersion);
                    }
                }
                ++k;
            }
            j = j + k - 1;
        }
        return filteredEntries.toArray(new IClasspathEntry[filteredEntries.size()]);
    }

    public static class RuntimeClasspathEntriesComparator
    implements Comparator<IClasspathEntry> {
        @Override
        public int compare(IClasspathEntry cp1, IClasspathEntry cp2) {
            String cp1Path = cp1.getPath().lastSegment();
            String cp2Path = cp2.getPath().lastSegment();
            return cp1Path.compareTo(cp2Path);
        }
    }

    private static class RuntimeClasspathEntry {
        private String jarName;
        private Version specVersion;
        private Version jarVersion;
        private static final String PATTERN_LIBERTY_JARS = "((\\.\\d+(\\.\\d+(\\.\\d+)?)?)?\\_\\d+(\\.\\d+(\\.\\d+)?)?\\.jar)$";
        private static final Pattern patternLibertyJars = Pattern.compile("((\\.\\d+(\\.\\d+(\\.\\d+)?)?)?\\_\\d+(\\.\\d+(\\.\\d+)?)?\\.jar)$");

        public RuntimeClasspathEntry(String classpathEntryName) {
            if (classpathEntryName == null) {
                throw new IllegalArgumentException();
            }
            Matcher matcher = patternLibertyJars.matcher(classpathEntryName);
            if (matcher.find()) {
                this.jarName = classpathEntryName.substring(0, matcher.start());
                String versionStr = classpathEntryName.substring(matcher.start() + 1, classpathEntryName.length() - 4);
                int underscoreLocation = versionStr.indexOf(95);
                if (underscoreLocation != -1) {
                    this.specVersion = Version.create((String)versionStr.substring(0, underscoreLocation));
                    this.jarVersion = Version.create((String)versionStr.substring(underscoreLocation + 1));
                } else {
                    this.jarVersion = Version.create((String)versionStr);
                }
            } else {
                this.jarName = classpathEntryName;
            }
        }

        public String getJarName() {
            return this.jarName;
        }

        public Version getSpecVersion() {
            return this.specVersion;
        }

        public Version getJarVersion() {
            return this.jarVersion;
        }

        public boolean isVersionGreater(RuntimeClasspathEntry other) {
            if (this.getSpecVersion() != null && other.getSpecVersion() != null) {
                int compareResult = this.getSpecVersion().compareTo((Object)other.getSpecVersion());
                if (compareResult == 0) {
                    if (this.getJarVersion() != null && other.getJarVersion() != null) {
                        return this.getJarVersion().compareTo((Object)other.getJarVersion()) > 0;
                    }
                    return false;
                }
                return compareResult > 0;
            }
            if (this.getJarVersion() != null && other.getJarVersion() != null) {
                return this.getJarVersion().compareTo((Object)other.getJarVersion()) > 0;
            }
            return false;
        }
    }
}

