/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class RuntimeMessageHelper {
    private static char[] convtBuf = new char[30];
    private static String[] messages;
    private static int KEY_LENGTH;

    protected static void loadMessages() {
        BufferedReader in = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            in = new BufferedReader(new InputStreamReader(((Object)((Object)Activator.getInstance())).getClass().getResourceAsStream("runtimeMessages.txt")));
            String s = in.readLine();
            while (s != null) {
                list.add(RuntimeMessageHelper.convertUnicode(s));
                s = in.readLine();
            }
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not read runtime messages file", e);
            }
        }
        finally {
            block15: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block15;
                    Trace.trace((byte)1, "Could not close stream", e);
                }
            }
        }
        messages = list.toArray(new String[list.size()]);
    }

    protected static String getAppName(String message) {
        block4: {
            try {
                for (int i = 0; i < messages.length; i += 3) {
                    int endIndex;
                    int startIndex;
                    int index;
                    String start = messages[i];
                    String end = messages[i + 2];
                    int indexStart = message.indexOf(start);
                    if (!message.regionMatches(indexStart, start, 0, KEY_LENGTH) || !message.endsWith(end) || (index = message.indexOf(start = start.substring(KEY_LENGTH), indexStart + KEY_LENGTH)) == -1 || (startIndex = start.length() + index) >= (endIndex = message.length() - end.length())) continue;
                    String s = message.substring(startIndex, endIndex);
                    String middle = messages[i + 1];
                    if (middle != null && middle.length() > 0) {
                        int ind = s.indexOf(middle);
                        return s.substring(0, ind);
                    }
                    return s;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block4;
                Trace.trace((byte)1, "Could not determine app name", e);
            }
        }
        return null;
    }

    protected static Set<String> getAllSubstitutionText(String message, IServer server) {
        HashSet<String> set;
        block5: {
            set = new HashSet<String>();
            try {
                for (int i = 0; i < messages.length; i += 3) {
                    int endIndex;
                    int startIndex;
                    int index;
                    String start = messages[i];
                    String end = messages[i + 2];
                    int indexStart = message.indexOf(start);
                    if (!message.regionMatches(indexStart, start, 0, KEY_LENGTH) || !message.endsWith(end) || (index = message.indexOf(start = start.substring(KEY_LENGTH), indexStart + KEY_LENGTH)) == -1 || (startIndex = start.length() + index) >= (endIndex = message.length() - end.length())) continue;
                    String s = message.substring(startIndex, endIndex);
                    String middle = messages[i + 1];
                    if (middle != null && middle.length() > 0) {
                        int ind = s.indexOf(middle);
                        String name = s.substring(0, ind);
                        set.add(name);
                        name = s.substring(ind + middle.length(), s.length());
                        set.add(name);
                    } else {
                        set.add(s);
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block5;
                Trace.trace((byte)1, "Could not get message substitution text from: " + message, e);
            }
        }
        return set;
    }

    protected static String matchAppNameFromWorkspaceProjects(String message, IServer server) {
        block6: {
            try {
                for (int i = 0; i < messages.length; i += 3) {
                    int endIndex;
                    int startIndex;
                    int index;
                    String start = messages[i];
                    String end = messages[i + 2];
                    int indexStart = message.indexOf(start);
                    if (!message.regionMatches(indexStart, start, 0, KEY_LENGTH) || !message.endsWith(end) || (index = message.indexOf(start = start.substring(KEY_LENGTH), indexStart + KEY_LENGTH)) == -1 || (startIndex = start.length() + index) >= (endIndex = message.length() - end.length())) continue;
                    String s = message.substring(startIndex, endIndex);
                    String middle = messages[i + 1];
                    if (middle != null && middle.length() > 0) {
                        int ind = s.indexOf(middle);
                        String name = s.substring(0, ind);
                        if (RuntimeMessageHelper.matchesProjectName(name, server)) {
                            return name;
                        }
                        name = s.substring(ind + middle.length(), s.length());
                        if (RuntimeMessageHelper.matchesProjectName(name, server)) {
                            return name;
                        }
                    }
                    if (!RuntimeMessageHelper.matchesProjectName(s, server)) continue;
                    return s;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block6;
                Trace.trace((byte)1, "Could not determine app name", e);
            }
        }
        return null;
    }

    private static boolean matchesProjectName(String text, IServer server) {
        block3: {
            try {
                IModule[] modules;
                for (IModule module : modules = server.getModules()) {
                    if (!module.getName().equals(text)) continue;
                    return true;
                }
            }
            catch (Throwable t) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Could not match app name \"" + text + "\" in message to workspace project names", t);
            }
        }
        return false;
    }

    private static String convertUnicode(String s) {
        int len = s.length();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int off = 0;
        while (off < len) {
            char aChar;
            if ((aChar = s.charAt(off++)) == '\\') {
                if ((aChar = s.charAt(off++)) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = s.charAt(off++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    static {
        KEY_LENGTH = 12;
        RuntimeMessageHelper.loadMessages();
    }
}

