/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ProjectPrefs {
    protected static final String QUALIFIER = "com.ibm.ws.st";
    private static final String PROP_CLASSPATH_EXCLUDE_THIRD_PARTY = "com.ibm.ws.st.classpath.exclude.third-party";
    private static final String PROP_CLASSPATH_EXCLUDE_STABLE = "com.ibm.ws.st.classpath.exclude.stable";
    private static final String PROP_CLASSPATH_EXCLUDE_IBM_API = "com.ibm.ws.st.classpath.exclude.ibm-api";
    private static final String PROP_CLASSPATH_EXCLUDE_UNRECOGNIZED = "com.ibm.ws.st.classpath.exclude.unrecognized";
    private static final String PROP_FEATURE = "com.ibm.ws.st.feature.";
    private static final String PROP_OLD_EXCLUDE_THIRD_PARTY = "exclude-third-party";
    private static final String PROP_OLD_EXCLUDE_STABLE = "exclude-stable";
    private static final String PROP_OLD_EXCLUDE_IBM_API = "exclude-ibm-api";
    private static final String PROP_OLD_EXCLUDE_UNRECOGNIZED = "exclude-unrecognized";
    private static final String PROP_RUNTIME_PROJECT_VALIDATION_SERVERS = "com.ibm.ws.st.runtime.validation.configured.servers";
    private static final String[] ADD_FEATURE_STRINGS = new String[]{"prompt", "always", "never"};
    public static final byte ADD_FEATURE_PROMPT = 0;
    public static final byte ADD_FEATURE_ALWAYS = 1;
    public static final byte ADD_FEATURE_NEVER = 2;
    protected IEclipsePreferences prefs;

    public ProjectPrefs(IProject project) {
        this.prefs = new ProjectScope(project).getNode(QUALIFIER);
    }

    public int getFeaturePrompt(String feature) {
        String value = this.prefs.get(PROP_FEATURE + feature, null);
        if (value == null) {
            return Activator.getDefaultClassScanning();
        }
        for (int i = 0; i < ADD_FEATURE_STRINGS.length; ++i) {
            if (!ADD_FEATURE_STRINGS[i].equals(value)) continue;
            return i;
        }
        return Activator.getDefaultClassScanning();
    }

    public void setFeaturePrompt(String feature, byte prompt) {
        if (prompt < 0 || prompt >= ADD_FEATURE_STRINGS.length) {
            return;
        }
        this.prefs.put(PROP_FEATURE + feature, ADD_FEATURE_STRINGS[prompt]);
    }

    public boolean reset() {
        try {
            this.prefs.clear();
            return true;
        }
        catch (Exception e) {
            Trace.logError("Could not reset preferences: " + this.prefs, e);
            return false;
        }
    }

    public boolean save() {
        try {
            this.prefs.flush();
            return true;
        }
        catch (Exception e) {
            Trace.logError("Could not save preferences: " + this.prefs, e);
            return false;
        }
    }

    public boolean isExcludeThirdPartyAPI() {
        return this.prefs.getBoolean(PROP_CLASSPATH_EXCLUDE_THIRD_PARTY, this.prefs.getBoolean(PROP_OLD_EXCLUDE_THIRD_PARTY, false));
    }

    public void setExcludeThirdPartyAPI(boolean b) {
        if (this.isExcludeThirdPartyAPI() == b) {
            return;
        }
        this.prefs.putBoolean(PROP_CLASSPATH_EXCLUDE_THIRD_PARTY, b);
        if (this.prefs.get(PROP_OLD_EXCLUDE_IBM_API, null) != null) {
            this.prefs.putBoolean(PROP_OLD_EXCLUDE_IBM_API, b);
        }
    }

    public boolean isExcludeStableAPI() {
        return this.prefs.getBoolean(PROP_CLASSPATH_EXCLUDE_STABLE, this.prefs.getBoolean(PROP_OLD_EXCLUDE_STABLE, false));
    }

    public void setExcludeStableAPI(boolean b) {
        if (this.isExcludeStableAPI() == b) {
            return;
        }
        this.prefs.putBoolean(PROP_CLASSPATH_EXCLUDE_STABLE, b);
        if (this.prefs.get(PROP_OLD_EXCLUDE_STABLE, null) != null) {
            this.prefs.putBoolean(PROP_OLD_EXCLUDE_STABLE, b);
        }
    }

    public boolean isExcludeIBMAPI() {
        return this.prefs.getBoolean(PROP_CLASSPATH_EXCLUDE_IBM_API, this.prefs.getBoolean(PROP_OLD_EXCLUDE_IBM_API, false));
    }

    public void setExcludeIBMAPI(boolean b) {
        if (this.isExcludeIBMAPI() == b) {
            return;
        }
        this.prefs.putBoolean(PROP_CLASSPATH_EXCLUDE_IBM_API, b);
        if (this.prefs.get(PROP_OLD_EXCLUDE_IBM_API, null) != null) {
            this.prefs.putBoolean(PROP_OLD_EXCLUDE_IBM_API, b);
        }
    }

    public boolean isExcludeUnrecognized() {
        return this.prefs.getBoolean(PROP_CLASSPATH_EXCLUDE_UNRECOGNIZED, this.prefs.getBoolean(PROP_OLD_EXCLUDE_UNRECOGNIZED, false));
    }

    public void setExcludeUnrecognized(boolean b) {
        if (this.isExcludeUnrecognized() == b) {
            return;
        }
        this.prefs.putBoolean(PROP_CLASSPATH_EXCLUDE_UNRECOGNIZED, b);
        if (this.prefs.get(PROP_OLD_EXCLUDE_UNRECOGNIZED, null) != null) {
            this.prefs.putBoolean(PROP_OLD_EXCLUDE_UNRECOGNIZED, b);
        }
    }

    public String toString() {
        return this.prefs.toString();
    }

    public String getRuntimeProjectValidationConfiguredServers() {
        return this.prefs.get(PROP_RUNTIME_PROJECT_VALIDATION_SERVERS, null);
    }

    public void setRuntimeProjectValidationConfiguredServers(String servers) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        this.prefs.put(PROP_RUNTIME_PROJECT_VALIDATION_SERVERS, servers);
    }
}

