/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.IPromptActionHandler;
import com.ibm.ws.st.core.internal.IPromptIssue;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PublishHelper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class OutOfSyncApplicationPrompt
extends PromptHandler.AbstractPrompt
implements IPromptActionHandler {
    private final Map<IPromptIssue, IModule> moduleMap = new HashMap<IPromptIssue, IModule>(2);
    private final HashSet<String> appNames = new HashSet(2);
    private final List<IPromptIssue> issueList = new ArrayList<IPromptIssue>(2);

    private void addAppIssue(OutOfSyncModuleInfo info, IModule module) {
        if (!this.appNames.add(module.getName())) {
            return;
        }
        OutOfSyncIssue issue = new OutOfSyncIssue(info, module.getName());
        this.issueList.add(issue);
        this.moduleMap.put(issue, module);
    }

    @Override
    public boolean getApplyAlways() {
        return false;
    }

    @Override
    public boolean isActive() {
        return !this.issueList.isEmpty();
    }

    @Override
    public IPromptActionHandler getActionHandler() {
        return this;
    }

    @Override
    public void prePromptAction(List<IModule[]> publishedModules, PublishHelper helper, IProgressMonitor monitor) {
        WebSphereServerBehaviour wsBehaviour = helper.getWebSphereServerBehaviour();
        this.issueList.clear();
        this.moduleMap.clear();
        this.appNames.clear();
        for (IModule[] module : publishedModules) {
            OutOfSyncModuleInfo info;
            if (module[0].isExternal() || (info = wsBehaviour.checkModuleConfigOutOfSync(module[0])) == null) continue;
            this.addAppIssue(info, module[0]);
        }
    }

    @Override
    public void postPromptAction(IPromptResponse response, PublishHelper helper) {
        WebSphereServer ws = helper.getWebSphereServer();
        ArrayList<IModule> addList = new ArrayList<IModule>(this.issueList.size());
        ArrayList<IModule> removeList = new ArrayList<IModule>(this.issueList.size());
        for (IPromptIssue issue : this.issueList) {
            PromptAction action = response.getSelectedAction(issue);
            if (action == PromptAction.UPDATE_SERVER_CONFIG) {
                addList.add(this.moduleMap.get(issue));
                continue;
            }
            if (action != PromptAction.REMOVE_FROM_SERVER) continue;
            removeList.add(this.moduleMap.get(issue));
        }
        IModule[] add = null;
        IModule[] remove = null;
        if (!addList.isEmpty()) {
            add = addList.toArray(new IModule[addList.size()]);
            addList.clear();
        }
        if (!removeList.isEmpty()) {
            remove = removeList.toArray(new IModule[removeList.size()]);
            removeList.clear();
        }
        if (add == null && remove == null) {
            return;
        }
        IServerWorkingCopy wc = ws.getServer().isWorkingCopy() ? (IServerWorkingCopy)ws.getServer() : ws.getServer().createWorkingCopy();
        try {
            wc.modifyModules(add, remove, null);
            wc.save(true, null);
        }
        catch (CoreException e) {
            Trace.logError("Failed to modify application(s) from server: " + ws.getServerName(), e);
        }
    }

    @Override
    public IPromptIssue[] getIssues() {
        return this.issueList.toArray(new IPromptIssue[this.issueList.size()]);
    }

    private static class OutOfSyncIssue
    implements IPromptIssue {
        private final OutOfSyncModuleInfo info;
        private final String details;
        private final String summary;

        OutOfSyncIssue(OutOfSyncModuleInfo info, String moduleName) {
            this.info = info;
            this.details = this.buildDetails(info, moduleName);
            this.summary = this.buildSummary(info, moduleName);
        }

        @Override
        public String getType() {
            return Messages.outOfSyncIssue;
        }

        @Override
        public String getSummary() {
            return this.summary;
        }

        @Override
        public String getDetails() {
            return this.details;
        }

        @Override
        public PromptAction[] getPossibleActions() {
            if (this.info.getType() == OutOfSyncModuleInfo.Type.SHARED_LIB_REF_MISMATCH) {
                return new PromptAction[]{PromptAction.UPDATE_SERVER_CONFIG, PromptAction.IGNORE};
            }
            return new PromptAction[]{PromptAction.UPDATE_SERVER_CONFIG, PromptAction.REMOVE_FROM_SERVER, PromptAction.IGNORE};
        }

        @Override
        public PromptAction getDefaultAction() {
            return PromptAction.UPDATE_SERVER_CONFIG;
        }

        private String buildDetails(OutOfSyncModuleInfo info, String moduleName) {
            OutOfSyncModuleInfo.Type type = info.getType();
            if (type == OutOfSyncModuleInfo.Type.SHARED_LIB_REF_MISMATCH) {
                String addIds = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_IDS_ADD);
                String removeIds = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_IDS_REMOVE);
                String changeIds = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_IDS_CHANGE);
                String apiVisibility = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_API_VISIBILITY);
                if (!(removeIds != null && !removeIds.isEmpty() || addIds != null && !addIds.isEmpty() || changeIds != null && !changeIds.isEmpty())) {
                    return NLS.bind((String)Messages.outOfSyncSharedLibRefAPIVisibilityChangedDetails, (Object)apiVisibility);
                }
                String message = null;
                if (addIds != null && !addIds.isEmpty()) {
                    message = this.buildRefIdsDetails(Messages.outOfSyncSharedLibRefMissingDetails, moduleName, addIds);
                }
                if (removeIds != null && !removeIds.isEmpty()) {
                    if (message != null) {
                        message = message + "\n\n";
                    }
                    message = message + this.buildRefIdsDetails(Messages.outOfSyncSharedLibRefNotUsedDetails, moduleName, removeIds);
                }
                if (changeIds != null && !changeIds.isEmpty()) {
                    if (message != null) {
                        message = message + "\n\n";
                    }
                    message = message + this.buildRefIdsDetails(Messages.outOfSyncSharedLibRefChangedDetails, moduleName, changeIds);
                }
                return message;
            }
            String label = type == OutOfSyncModuleInfo.Type.APP_ENTRY_MISSING ? Messages.applicationLabel : Messages.sharedLibraryLabel;
            return NLS.bind((String)Messages.outOfSyncAppMissingDetails, (Object[])new String[]{moduleName, label});
        }

        private String buildRefIdsDetails(String message, String moduleName, String idList) {
            String[] ids = this.convertToArray(idList);
            StringBuilder sb = new StringBuilder();
            if (ids == null) {
                if (Trace.ENABLED) {
                    Trace.logError("lib id references are null", null);
                }
            } else {
                for (String id : ids) {
                    sb.append("\n - ");
                    sb.append(id);
                }
            }
            return NLS.bind((String)message, (Object[])new String[]{moduleName, sb.toString()});
        }

        private String buildSummary(OutOfSyncModuleInfo info, String moduleName) {
            OutOfSyncModuleInfo.Type type = info.getType();
            if (type == OutOfSyncModuleInfo.Type.SHARED_LIB_REF_MISMATCH) {
                String addIds = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_IDS_ADD);
                String removeIds = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_IDS_REMOVE);
                String changeIds = info.getPropertyValue(OutOfSyncModuleInfo.Property.LIB_REF_IDS_CHANGE);
                if (!(removeIds != null && !removeIds.isEmpty() || addIds != null && !addIds.isEmpty() || changeIds != null && !changeIds.isEmpty())) {
                    return NLS.bind((String)Messages.outOfSyncSharedLibRefAPIVisibilityChangedSummary, (Object)moduleName);
                }
                if ((removeIds == null || removeIds.isEmpty()) && (changeIds == null || changeIds.isEmpty())) {
                    return NLS.bind((String)Messages.outOfSyncSharedLibRefMissingSummary, (Object)moduleName);
                }
                if ((addIds == null || addIds.isEmpty()) && (changeIds == null || changeIds.isEmpty())) {
                    return NLS.bind((String)Messages.outOfSyncSharedLibRefNotUsedSummary, (Object)moduleName);
                }
                if ((addIds == null || addIds.isEmpty()) && (removeIds == null || removeIds.isEmpty())) {
                    return NLS.bind((String)Messages.outOfSyncSharedLibRefChangedSummary, (Object)moduleName);
                }
                return NLS.bind((String)Messages.outOfSyncSharedLibRefMismatchSummary, (Object)moduleName);
            }
            String label = type == OutOfSyncModuleInfo.Type.APP_ENTRY_MISSING ? Messages.applicationLabel : Messages.sharedLibraryLabel;
            return NLS.bind((String)Messages.outOfSyncAppMissingSummary, (Object[])new String[]{moduleName, label});
        }

        private String[] convertToArray(String str) {
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s == null || s.length() <= 0) continue;
                list.add(s.trim());
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

