/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.LibertyRuntimeProvider;
import com.ibm.ws.st.core.internal.Trace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class LibertyRuntimeProviderExtension {
    private static final String EXTENSION_POINT = "libertyRuntimeProvider";
    private static List<LibertyRuntimeProvider> libertyRuntimeProviders = null;

    public static List<LibertyRuntimeProvider> getLibertyRuntimeProviders() {
        if (libertyRuntimeProviders != null) {
            return libertyRuntimeProviders;
        }
        libertyRuntimeProviders = LibertyRuntimeProviderExtension.loadLibertyRuntimeProviderExtensions();
        return libertyRuntimeProviders;
    }

    private static List<LibertyRuntimeProvider> loadLibertyRuntimeProviderExtensions() {
        IConfigurationElement[] libertyRuntimeProviderExtensions = null;
        ArrayList<LibertyRuntimeProvider> handlers = new ArrayList<LibertyRuntimeProvider>();
        for (IConfigurationElement configurationElement : libertyRuntimeProviderExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ws.st.core", EXTENSION_POINT)) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "configurationElement class=[" + configurationElement.getAttribute("class") + "]");
            }
            try {
                Object o = configurationElement.createExecutableExtension("class");
                if (!(o instanceof LibertyRuntimeProvider)) continue;
                handlers.add((LibertyRuntimeProvider)o);
            }
            catch (CoreException e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)0, "Cannot get the Liberty Runtime Provider class ", e);
            }
        }
        return handlers;
    }
}

