/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.osgi.util.NLS;

public class LaunchUtil {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MMM d, yyyy K:mm:ss a");
    private static final String[] JAVA_EXECUTABLES = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    public static final String VM_QUICKSTART = "-Xquickstart";
    private static String errorPage = null;

    private LaunchUtil() {
    }

    public static void setErrorPage(String newErrorPage) {
        errorPage = newErrorPage;
    }

    public static String getErrorPage() {
        return errorPage;
    }

    public static String getProcessLabel(String command) {
        return NLS.bind((String)Messages.processLabel, (Object[])new Object[]{command, sdf.format(new Date())});
    }

    public static String getProcessLabelAttr(String s1, String s2) {
        return NLS.bind((String)Messages.processLabelAttr, (Object[])new Object[]{s1, s2, sdf.format(new Date())});
    }

    public static File getJavaHome(File vmInstallLocation) {
        String BIN = "bin" + File.separatorChar;
        for (int i = 0; i < JAVA_EXECUTABLES.length; ++i) {
            File javaFile = new File(vmInstallLocation, BIN + JAVA_EXECUTABLES[i]);
            if (!javaFile.isFile()) continue;
            return vmInstallLocation;
        }
        File jreLocation = new File(vmInstallLocation, "jre");
        if (!jreLocation.exists()) {
            return vmInstallLocation;
        }
        for (int i = 0; i < JAVA_EXECUTABLES.length; ++i) {
            File javaFile = new File(jreLocation, BIN + JAVA_EXECUTABLES[i]);
            if (!javaFile.isFile()) continue;
            return jreLocation;
        }
        return vmInstallLocation;
    }

    public static boolean isIBMJRE(IVMInstall vm) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return false;
        }
        boolean isIBMJRE = false;
        if (vm instanceof AbstractVMInstall) {
            LibraryLocation[] libs;
            long time = 0L;
            if (Trace.ENABLED_DETAILS) {
                time = System.currentTimeMillis();
            }
            if ((libs = ((AbstractVMInstall)vm).getLibraryLocations()) == null) {
                libs = vm.getVMInstallType().getDefaultLibraryLocations(vm.getInstallLocation());
            }
            if (libs != null) {
                for (LibraryLocation lib : libs) {
                    String s = lib.getSystemLibraryPath().lastSegment();
                    if (s == null || !s.startsWith("ibm")) continue;
                    isIBMJRE = true;
                    break;
                }
            }
            if (Trace.ENABLED_DETAILS) {
                Trace.tracePerf("IBM JRE check", time);
            }
        }
        return isIBMJRE;
    }
}

