/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FeatureSet
implements Iterable<String> {
    private final String[] features;
    private final WebSphereRuntime wsRuntime;

    public FeatureSet(WebSphereRuntime wr, String[] s) {
        this.wsRuntime = wr;
        this.features = s;
    }

    public FeatureSet(WebSphereRuntime wr, List<String> s) {
        this.wsRuntime = wr;
        this.features = s.toArray(new String[s.size()]);
    }

    public boolean supports(String featureToFind) {
        if (featureToFind == null) {
            return false;
        }
        if (!featureToFind.contains("-")) {
            String t = featureToFind.toLowerCase() + "-";
            for (String f : this.wsRuntime.getInstalledFeatures()) {
                if (!f.toLowerCase().startsWith(t) || !this.isFeatureSupported(f)) continue;
                return true;
            }
        } else {
            return this.isFeatureSupported(featureToFind);
        }
        return false;
    }

    public boolean isFeatureSupported(String featureToFind) {
        if (!featureToFind.contains("-")) {
            return false;
        }
        for (String feature : this.features) {
            if (!feature.equalsIgnoreCase(featureToFind) && !FeatureUtil.isLowerVersion(featureToFind, feature) && !this.wsRuntime.isContainedBy(featureToFind, feature)) continue;
            return true;
        }
        return false;
    }

    public String resolve(String feature) {
        return FeatureSet.resolve(feature, this.features);
    }

    public static String resolve(String feature, String[] features) {
        if (feature == null) {
            return null;
        }
        if (!feature.contains("-")) {
            String t = feature.toLowerCase() + "-";
            String matchedFeature = null;
            for (String f : features) {
                if (!f.toLowerCase().startsWith(t)) continue;
                try {
                    if (matchedFeature != null && FeatureUtil.compareFeatureVersions(matchedFeature, f) >= 0) continue;
                    matchedFeature = f;
                }
                catch (Throwable e) {
                    if (!Trace.ENABLED) continue;
                    Trace.logError("Failed to compare feature version between " + matchedFeature + " and " + f, e);
                }
            }
            return matchedFeature;
        }
        for (String f : features) {
            if (!f.equalsIgnoreCase(feature)) continue;
            return f;
        }
        return null;
    }

    public String resolveToHigherVersion(String feature) {
        String resolvedFeature = FeatureSet.resolve(feature, this.features);
        if (resolvedFeature == null) {
            resolvedFeature = FeatureUtil.findHigherVersion(Arrays.asList(this.features), feature);
        }
        return resolvedFeature;
    }

    public String[] resolveAll(String feature) {
        return FeatureSet.resolveAll(feature, this.features);
    }

    public static String[] resolveAll(String feature, String[] features) {
        if (feature == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        if (!feature.contains("-")) {
            String t = feature.toLowerCase() + "-";
            for (String f : features) {
                if (!f.toLowerCase().startsWith(t)) continue;
                matchList.add(f);
            }
            if (matchList.isEmpty()) {
                return null;
            }
            String[] match = new String[matchList.size()];
            return matchList.toArray(match);
        }
        for (String f : features) {
            if (!f.equalsIgnoreCase(feature)) continue;
            return new String[]{f};
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.features).iterator();
    }

    public void sort() {
        Arrays.sort(this.features);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureSet[");
        int size = this.features.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            String s = this.features[i];
            sb.append(s);
        }
        sb.append("]");
        return sb.toString();
    }
}

