/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FacetFeatureMap;
import com.ibm.ws.st.core.internal.FeatureResolver;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class FacetFeatureResolver
extends FeatureResolver {
    @Override
    public void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, boolean includeAll, IProgressMonitor monitor) {
        if (moduleList == null || moduleList.isEmpty()) {
            return;
        }
        Map<IProjectFacetVersion, List<IModule[]>> facetMap = this.collectFacets(moduleList);
        if (facetMap.isEmpty()) {
            return;
        }
        IProjectFacetVersion[] projectFacets = facetMap.keySet().toArray(new IProjectFacetVersion[facetMap.size()]);
        Arrays.sort(projectFacets, new Comparator<IProjectFacetVersion>(){

            @Override
            public int compare(IProjectFacetVersion facet1, IProjectFacetVersion facet2) {
                int result = facet1.getProjectFacet().getId().compareTo(facet2.getProjectFacet().getId());
                if (result == 0) {
                    float version1 = Float.parseFloat(facet1.getVersionString());
                    float version2 = Float.parseFloat(facet2.getVersionString());
                    result = Float.compare(version1, version2);
                }
                return result;
            }
        });
        int i = 0;
        while (i < projectFacets.length) {
            ArrayList<IProjectFacetVersion> facetList = new ArrayList<IProjectFacetVersion>();
            String id = projectFacets[i].getProjectFacet().getId();
            facetList.add(projectFacets[i]);
            while (++i < projectFacets.length && id.equals(projectFacets[i].getProjectFacet().getId())) {
                facetList.add(projectFacets[i]);
            }
            while (!facetList.isEmpty()) {
                HashSet modulesToAdd;
                FacetFeatureMap.Entry facetFeatureEntry;
                block11: {
                    IProjectFacetVersion facet = (IProjectFacetVersion)facetList.remove(facetList.size() - 1);
                    facetFeatureEntry = FacetFeatureMap.getInstance().getFeatures(facet);
                    if (facetFeatureEntry == null) continue;
                    modulesToAdd = new HashSet();
                    modulesToAdd.addAll(facetMap.get(facet));
                    if (facetList.size() > 0) {
                        try {
                            Set versions = facet.getProjectFacet().getVersions(facetFeatureEntry.getVersion());
                            ArrayList<IProjectFacetVersion> removeList = new ArrayList<IProjectFacetVersion>();
                            for (IProjectFacetVersion version : versions) {
                                for (IProjectFacetVersion listVersion : facetList) {
                                    if (!listVersion.equals(version)) continue;
                                    removeList.add(listVersion);
                                    modulesToAdd.addAll(facetMap.get(listVersion));
                                }
                            }
                            facetList.removeAll(removeList);
                        }
                        catch (CoreException e) {
                            if (!Trace.ENABLED) break block11;
                            Trace.trace((byte)1, "Failed to get facets versions for: " + facet, e);
                        }
                    }
                }
                for (String feature : facetFeatureEntry.getFeatures()) {
                    FeatureResolver.checkAndAddFeature(requiredFeatures, existingFeatures, wr, feature, new ArrayList<IModule[]>(modulesToAdd), includeAll);
                }
            }
        }
    }

    private Map<IProjectFacetVersion, List<IModule[]>> collectFacets(List<IModule[]> moduleList) {
        HashMap<IProjectFacetVersion, List<IModule[]>> facetMap = new HashMap<IProjectFacetVersion, List<IModule[]>>();
        for (IModule[] module : moduleList) {
            IModule m = module[module.length - 1];
            IProject project = m.getProject();
            if (project == null) continue;
            try {
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                if (fp == null) continue;
                Set facetSet = fp.getProjectFacets();
                for (IProjectFacetVersion facet : facetSet) {
                    ArrayList<IModule[]> modules = (ArrayList<IModule[]>)facetMap.get(facet);
                    if (modules == null) {
                        modules = new ArrayList<IModule[]>();
                        facetMap.put(facet, modules);
                    }
                    modules.add(module);
                }
            }
            catch (CoreException e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "Failed to get facets for: " + project.getName(), e);
            }
        }
        return facetMap;
    }
}

