/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureResolverWrapper;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.FeatureUtil;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

public class FacetFeatureMap {
    private static final String EXTENSION_POINT = "facetFeatureMapping";
    private final Set<Entry> facetFeatureSet = new HashSet<Entry>();
    private static final FacetFeatureMap instance = new FacetFeatureMap();

    private FacetFeatureMap() {
        this.loadFeatureMap();
    }

    public static FacetFeatureMap getInstance() {
        return instance;
    }

    private void loadFeatureMap() {
        IConfigurationElement[] cf;
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "->- Loading .facetFeatureMapping extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        for (IConfigurationElement ce : cf = registry.getConfigurationElementsFor("com.ibm.ws.st.core", EXTENSION_POINT)) {
            IConfigurationElement[] facetElems;
            String featuresAttr = ce.getAttribute("features");
            String[] features = this.listToArray(featuresAttr, ",");
            for (IConfigurationElement facetElem : facetElems = ce.getChildren("facet")) {
                Entry entry = new Entry(features, facetElem.getAttribute("id"), facetElem.getAttribute("version"));
                this.facetFeatureSet.add(entry);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "-<- Done loading .facetFeatureMapping extension point -<-");
        }
    }

    private String[] listToArray(String list, String separator) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(list, separator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.isEmpty()) continue;
            strings.add(s);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public Entry getFeatures(IProjectFacetVersion facetVersion) {
        Entry result = null;
        for (Entry entry : this.facetFeatureSet) {
            if (!entry.matches(facetVersion) || result != null && !this.isLower(entry.getFeatures(), result.getFeatures())) continue;
            result = entry;
        }
        return result;
    }

    public Map<IProjectFacet, Set<IProjectFacetVersion>> getFacets(IProject project, IProgressMonitor monitor) {
        FeatureResolverFeature[] allContainedFeatures;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;
        IRuntime runtime;
        IFacetedProject facetedProject;
        block18: {
            facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                if (!Trace.ENABLED) break block18;
                Trace.trace((byte)1, "Failed to create faceted project for: " + project, e);
            }
        }
        if (facetedProject == null) {
            return Collections.emptyMap();
        }
        WebSphereRuntime wsRuntime = null;
        Set facetRuntimes = facetedProject.getTargetedRuntimes();
        Iterator iterator = facetRuntimes.iterator();
        while (iterator.hasNext() && ((runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)(facetRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)iterator.next()))) == null || (wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null)) == null)) {
        }
        if (wsRuntime == null) {
            return Collections.emptyMap();
        }
        IModule[] module = ServerUtil.getModules((IProject)project);
        RequiredFeatureMap requiredFeatureMap = FeatureResolverWrapper.getAllRequiredFeatures(wsRuntime, Collections.singletonList(module), null, null, true, monitor);
        ArrayList<FeatureResolverFeature> noVersionFeatures = new ArrayList<FeatureResolverFeature>();
        for (FeatureResolverFeature required : requiredFeatureMap.getFeatures()) {
            if (required.getName().contains("-")) continue;
            noVersionFeatures.add(required);
        }
        if (!noVersionFeatures.isEmpty()) {
            FeatureSet installedFeatures = wsRuntime.getInstalledFeatures();
            for (FeatureResolverFeature noVersionFeature : noVersionFeatures) {
                boolean remove = false;
                for (FeatureResolverFeature required : requiredFeatureMap.getFeatures()) {
                    String requiredName = required.getName();
                    if (!requiredName.contains("-") || !requiredName.toLowerCase().startsWith(noVersionFeature.getName().toLowerCase())) continue;
                    remove = true;
                    break;
                }
                if (remove) {
                    requiredFeatureMap.removeFeature(noVersionFeature);
                    continue;
                }
                String feature = installedFeatures.resolveToHigherVersion(noVersionFeature.getName());
                if (feature == null) continue;
                requiredFeatureMap.replaceFeature(noVersionFeature, new FeatureResolverFeature(feature));
            }
        }
        if ((allContainedFeatures = FeatureResolverWrapper.getAllContainedFeatures(wsRuntime, Collections.singletonList(module), monitor)).length > 0) {
            for (FeatureResolverFeature required : requiredFeatureMap.getFeatures()) {
                for (FeatureResolverFeature contained : allContainedFeatures) {
                    if (required.equals(contained)) {
                        requiredFeatureMap.removeFeature(required);
                        continue;
                    }
                    if (contained.getName().contains("-") || !required.getName().contains("-") || !required.getName().toLowerCase().startsWith(contained.getName().toLowerCase() + "-")) continue;
                    requiredFeatureMap.removeFeature(required);
                }
            }
        }
        HashMap<IProjectFacet, Set<IProjectFacetVersion>> facetMap = new HashMap<IProjectFacet, Set<IProjectFacetVersion>>();
        for (FeatureResolverFeature feature : requiredFeatureMap.getFeatures()) {
            List<Entry> entries = this.getEntriesForFeature(feature.getName());
            for (Entry entry : entries) {
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)entry.getId());
                try {
                    Set facetVersions = facet.getVersions(entry.getVersion());
                    facetMap.put(facet, facetVersions);
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Failed to get versions for facet: " + facet.getId() + " and version string: " + entry.getVersion() + "(" + (Object)((Object)e) + ").");
                }
            }
        }
        return facetMap;
    }

    private List<Entry> getEntriesForFeature(String feature) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Entry entry : this.facetFeatureSet) {
            if (!entry.containsFeature(feature)) continue;
            entries.add(entry);
        }
        return entries;
    }

    private boolean isLower(String[] newSet, String[] compareSet) {
        for (String startStr : compareSet) {
            for (String newStr : newSet) {
                if (!FeatureUtil.isLowerVersion(startStr, newStr)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Entry {
        private final String[] features;
        private final String id;
        private final String version;

        protected Entry(String[] features, String id, String version) {
            this.features = features;
            this.id = id;
            this.version = version;
        }

        public String[] getFeatures() {
            return this.features;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean matches(IProjectFacetVersion facetVersion) {
            block4: {
                IProjectFacet facet = facetVersion.getProjectFacet();
                if (!this.id.equals(facet.getId())) {
                    return false;
                }
                try {
                    Set versions = facetVersion.getProjectFacet().getVersions(this.version);
                    for (IProjectFacetVersion version : versions) {
                        if (!facetVersion.getVersionString().equals(version.getVersionString())) continue;
                        return true;
                    }
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block4;
                    Trace.trace((byte)1, "Failed to get facet versions for facet:" + facet.getId() + ", and version expression: " + this.version, e);
                }
            }
            return false;
        }

        public boolean containsFeature(String feature) {
            for (String f : this.features) {
                if (!f.equalsIgnoreCase(feature)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (String feature : this.features) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(feature);
            }
            return "Features: [" + builder.toString() + "], Facet: " + this.id + " [" + this.version + "]";
        }
    }
}

