/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.AbstractMonitorThread;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.LaunchUtil;
import com.ibm.ws.st.core.internal.RuntimeMessageHelper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.ConsoleStreamsProxy;
import com.ibm.ws.st.core.internal.launch.ExternalProcess;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class ConsoleMonitorThread
extends AbstractMonitorThread {
    private IStreamListener streamListener;
    private IDebugEventSetListener processListener;
    protected final JsonReaderFactory jsonFactory = Json.createReaderFactory(null);
    protected static final String MESSAGE_KEY = "message";

    ConsoleMonitorThread(WebSphereServerBehaviour wsBehaviour, Object serverStateSyncObj, String name) {
        super(wsBehaviour, serverStateSyncObj, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopMonitor) {
            block32: {
                try {
                    int state = this.server.getServerState();
                    WebSphereRuntime wsRuntime = this.getWebSphereRuntime();
                    int serverStatus = -2;
                    if (wsRuntime != null && this.wsServer.getUserDirectory() != null) {
                        serverStatus = wsRuntime.getServerStatus(this.wsServer.getServerInfo(), 20.0f, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (serverStatus == 0) {
                        if (state == 2 || state == 1 || state == 3 || this.wsBehaviour.isServerCmdStopProcessRunning()) break block32;
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Detected externally started server. Changing server state to STARTING");
                        }
                        Object object = this.serverStateSyncObj;
                        synchronized (object) {
                            this.wsBehaviour.setServerStateImpl(1);
                            IModule[] modules = this.server.getModules();
                            for (IProcess iProcess : modules) {
                                this.wsBehaviour.setModuleStateImpl(new IModule[]{iProcess}, 4);
                            }
                        }
                        ILaunchConfiguration lc = this.server.getLaunchConfiguration(true, null);
                        Launch launch = new Launch(lc, "run", null);
                        IPath consoleLog = this.wsServer.getOutputPath().append("logs").append("console.log");
                        boolean isUseConsoleLog = this.isUseConsoleLogToMonitor(consoleLog, this.wsServer.getWorkAreaPath().append(".sLock"));
                        IPath consolePath = isUseConsoleLog ? consoleLog : this.wsServer.getMessagesFile();
                        ConsoleStreamsProxy consoleStreamsProxy = new ConsoleStreamsProxy(consolePath.toFile(), isUseConsoleLog, null);
                        ExternalProcess process = new ExternalProcess((ILaunch)launch, this.server, consoleStreamsProxy);
                        process.setAttribute(IProcess.ATTR_PROCESS_LABEL, LaunchUtil.getProcessLabelAttr(this.server.getName(), this.wsServer.getServerName()));
                        process.setAttribute(IProcess.ATTR_PROCESS_TYPE, "java");
                        this.addProcessListeners(process);
                        launch.addProcess((IProcess)process);
                        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
                        this.wsBehaviour.setLaunch((ILaunch)launch);
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Changing server state to STARTED");
                        }
                        Object object2 = this.serverStateSyncObj;
                        synchronized (object2) {
                            block33: {
                                this.wsBehaviour.setServerStateImpl(2);
                                this.wsBehaviour.setInternalMode("run");
                                try {
                                    IServerWorkingCopy serverWorkingCopy = this.server.createWorkingCopy();
                                    boolean stopOnShutDown = serverWorkingCopy.getAttribute("stopOnShutdown", true);
                                    if (stopOnShutDown) {
                                        serverWorkingCopy.setAttribute("stopOnShutdown", false);
                                        serverWorkingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                                catch (Exception e) {
                                    if (!Trace.ENABLED) break block33;
                                    Trace.trace((byte)8, "Attempting to change the state of the option to stop server on shutdown.", e);
                                }
                            }
                        }
                        try {
                            JMXConnection jmxConnection = this.wsServer.createJMXConnection();
                            this.detectAndSetServerMode(jmxConnection);
                        }
                        catch (Exception e) {
                            Trace.logError("Cannot detect mode of externally started server, ensure the server's localConnector feature is configured", e);
                        }
                        break block32;
                    }
                    if (state == 0 || state == 3) {
                        Object stateName;
                        if (Trace.ENABLED) {
                            stateName = state == 3 ? "STOPPING" : "UNKNOWN";
                            Trace.trace((byte)8, "Server process is stopped but server state is " + (String)stateName + ". Changing to STOPPED...");
                        }
                        stateName = this.serverStateSyncObj;
                        synchronized (stateName) {
                            this.wsBehaviour.stopImpl();
                            break block32;
                        }
                    }
                    if (state != 2) break block32;
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "Server state is started but the status is: " + serverStatus);
                    }
                    ILaunch launch = this.server.getLaunch();
                    if (serverStatus == -1) {
                        IProcess[] processes;
                        if (launch == null || launch.isTerminated()) break block32;
                        for (IProcess iProcess : processes = launch.getProcesses()) {
                            if (!iProcess.isTerminated()) continue;
                            if (Trace.ENABLED) {
                                Trace.trace((byte)8, "Terminating launch since the process is stopped: " + serverStatus);
                            }
                            launch.terminate();
                            break block32;
                        }
                        break block32;
                    }
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "Server process is stopped, terminate the launch");
                    }
                    if (launch != null) {
                        launch.terminate();
                    }
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) break block32;
                    Trace.trace((byte)1, "Unable to verify server status", t);
                }
            }
            try {
                Thread.sleep(POLLING_DELAY);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addProcessListeners(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.streamListener = new IStreamListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void streamAppended(String text, IStreamMonitor monitor) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "Stream appended: " + text);
                }
                StringTokenizer st = new StringTokenizer(text, "\r\n");
                Activator actr = Activator.getInstance();
                Properties serverMessageReplacementKey = null;
                if (actr != null) {
                    serverMessageReplacementKey = actr.getServerMessageReplacementKey();
                }
                while (st.hasMoreTokens()) {
                    int n;
                    int n2;
                    Object object;
                    boolean externalModuleAdded;
                    IModule[] modules;
                    String appName;
                    Object tempS;
                    String message;
                    String s = st.nextToken();
                    if (s.startsWith("{") && (message = this.parseJsonMessage(s)) != null) {
                        s = message;
                    }
                    if (serverMessageReplacementKey != null && s.length() > 22) {
                        tempS = s.substring(11, 21);
                        if ((tempS = serverMessageReplacementKey.getProperty((String)tempS)) != null) {
                            StringBuilder sb = new StringBuilder(s);
                            sb.delete(11, 21);
                            sb.insert(11, (String)tempS);
                            s = sb.toString();
                        }
                    }
                    if (s.contains("CWWKF0011I")) {
                        tempS = ConsoleMonitorThread.this.serverStateSyncObj;
                        // MONITORENTER : tempS
                        ConsoleMonitorThread.this.wsBehaviour.setServerStateImpl(2);
                        // MONITOREXIT : tempS
                        continue;
                    }
                    if (s.contains("CWWKZ0001I") || s.contains("CWWKZ0013E") || s.contains("J2CA7001I") || s.contains("J2CA7013E")) {
                        appName = s.contains("J2CA7001I") ? RuntimeMessageHelper.matchAppNameFromWorkspaceProjects(s, ConsoleMonitorThread.this.server) : RuntimeMessageHelper.getAppName(s);
                        ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(appName, 1);
                        modules = ConsoleMonitorThread.this.server.getModules();
                        externalModuleAdded = true;
                        IModule[] iModuleArray = ConsoleMonitorThread.this.serverStateSyncObj;
                        // MONITORENTER : ConsoleMonitorThread.this.serverStateSyncObj
                        object = modules;
                        n2 = ((IModule[])object).length;
                    } else {
                        if (s.contains("CWWKZ0009I") || s.contains("J2CA7009I")) {
                            appName = RuntimeMessageHelper.getAppName(s);
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(appName, 4);
                            modules = ConsoleMonitorThread.this.server.getModules();
                            Object object2 = ConsoleMonitorThread.this.serverStateSyncObj;
                            // MONITORENTER : object2
                            for (IModule module : modules) {
                                if (!module.getName().equals(appName)) continue;
                                if (module.isExternal()) {
                                    ConsoleMonitorThread.this.wsBehaviour.syncExternalModules();
                                }
                                ConsoleMonitorThread.this.wsBehaviour.setModuleStateImpl(new IModule[]{module}, 4);
                            }
                            // MONITOREXIT : object2
                            continue;
                        }
                        if (s.contains("CWWKZ0003I") || s.contains("CWWKZ0062I")) {
                            appName = RuntimeMessageHelper.getAppName(s);
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(appName, 2);
                            modules = ConsoleMonitorThread.this.server.getModules();
                            Object object3 = ConsoleMonitorThread.this.serverStateSyncObj;
                            // MONITORENTER : object3
                            for (IModule module : modules) {
                                if (!module.getName().equals(appName)) continue;
                                ConsoleMonitorThread.this.wsBehaviour.setModuleStateImpl(new IModule[]{module}, 2);
                            }
                            // MONITOREXIT : object3
                            continue;
                        }
                        if (s.contains("CWWKZ0002E") || s.contains("J2CA7002E")) {
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.getAppName(s), 8);
                            continue;
                        }
                        if (s.contains("CWWKZ0012I") || s.contains("J2CA7012I")) {
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.getAppName(s), 8);
                            continue;
                        }
                        if (s.contains("CWWKZ0005E")) {
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.matchAppNameFromWorkspaceProjects(s, ConsoleMonitorThread.this.server), 8);
                            continue;
                        }
                        if (s.contains("CWWKZ0004E")) {
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.getAppName(s), 32);
                            continue;
                        }
                        if (s.contains("CWWKZ0020I") || s.contains("J2CA7020I")) {
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.getAppName(s), 32);
                            continue;
                        }
                        if (s.contains("CWWKZ0010E") || s.contains("J2CA7010E")) {
                            ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.getAppName(s), 16);
                            continue;
                        }
                        if (!s.contains("CWWKZ0014W") && !s.contains("J2CA7014W")) continue;
                        ConsoleMonitorThread.this.wsBehaviour.appStateTracker.addApplicationState(RuntimeMessageHelper.getAppName(s), 64);
                        continue;
                    }
                    for (n = 0; n < n2; ++n) {
                        IModule module = object[n];
                        if (!module.getName().equals(appName)) continue;
                        ConsoleMonitorThread.this.wsBehaviour.setModuleStateImpl(new IModule[]{module}, 2);
                        externalModuleAdded = false;
                        break;
                    }
                    // MONITOREXIT : iModuleArray
                    if (!externalModuleAdded) continue;
                    Set<String> potentialNames = null;
                    if (appName == null) {
                        potentialNames = RuntimeMessageHelper.getAllSubstitutionText(s, ConsoleMonitorThread.this.server);
                    }
                    ConsoleMonitorThread.this.wsBehaviour.syncExternalModules();
                    modules = ConsoleMonitorThread.this.server.getModules();
                    object = ConsoleMonitorThread.this.serverStateSyncObj;
                    // MONITORENTER : object
                    IModule[] iModuleArray = modules;
                    n = iModuleArray.length;
                    for (int i = 0; i < n; ++i) {
                        IModule module = iModuleArray[i];
                        String moduleName = module.getName();
                        if ((potentialNames == null || !potentialNames.contains(moduleName)) && !moduleName.equals(appName)) continue;
                        ConsoleMonitorThread.this.wsBehaviour.setModuleStateImpl(new IModule[]{module}, 2);
                        break;
                    }
                    // MONITOREXIT : object
                }
            }

            private String parseJsonMessage(String s) {
                block3: {
                    try {
                        JsonReader reader = ConsoleMonitorThread.this.jsonFactory.createReader((InputStream)new ByteArrayInputStream(s.getBytes()));
                        JsonObject obj = reader.readObject();
                        String message = obj.getString(ConsoleMonitorThread.MESSAGE_KEY);
                        if (message != null && !message.isEmpty()) {
                            return message;
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block3;
                        Trace.trace((byte)1, "Message started with '{' but could not parse as JSON: " + s, e);
                    }
                }
                return null;
            }
        };
        newProcess.getStreamsProxy().getOutputStreamMonitor().addListener(this.streamListener);
        newProcess.getStreamsProxy().getErrorStreamMonitor().addListener(this.streamListener);
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Added stream listener to process: " + newProcess.getLabel());
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    for (int i = 0; i < size; ++i) {
                        if (!newProcess.equals(events[i].getSource()) || events[i].getKind() != 8) continue;
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Server processes stopped");
                        }
                        ConsoleMonitorThread.this.wsBehaviour.waitForServerStop(ConsoleMonitorThread.this.server.getStopTimeout() * 300);
                        ConsoleMonitorThread.this.wsBehaviour.stopImpl();
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Added debug event listener for process: " + newProcess.getLabel());
        }
    }

    public void removeProcessListeners() {
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "Removing process listeners");
        }
        if (this.processListener != null) {
            block8: {
                try {
                    DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block8;
                    Trace.trace((byte)1, "Could not remove debug event listener", e);
                }
            }
            this.processListener = null;
        }
        if (this.streamListener != null) {
            block9: {
                try {
                    ILaunch launch = this.server.getLaunch();
                    if (launch != null) {
                        launch.getProcesses()[0].getStreamsProxy().getOutputStreamMonitor().removeListener(this.streamListener);
                        launch.getProcesses()[0].getStreamsProxy().getErrorStreamMonitor().removeListener(this.streamListener);
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block9;
                    Trace.trace((byte)1, "Could not remove stream listener", e);
                }
            }
            this.streamListener = null;
        }
    }

    boolean isUseConsoleLogToMonitor(IPath consoleLog, IPath sLock) {
        if (consoleLog == null || sLock == null) {
            return false;
        }
        File consoleFie = consoleLog.toFile();
        if (!consoleFie.exists()) {
            return false;
        }
        long consoleLogModifyTS = consoleFie.lastModified();
        long sLockTS = sLock.toFile().lastModified();
        return sLockTS - consoleLogModifyTS < 3200L;
    }
}

