/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConsoleLineTrackerHelper {
    public static final IStatus EXIST_STATUS = new Status(1, "com.ibm.ws.st.core", "");
    public static final IStatus UNRESOLVED_STATUS = new Status(1, "com.ibm.ws.st.core", "");

    private ConsoleLineTrackerHelper() {
    }

    public static IStatus addFeatureSupport(WebSphereServer server, String feature) throws Exception {
        FeatureSet existingFeatures;
        String resolvedFeature;
        WebSphereRuntime runtime = server.getWebSphereRuntime();
        ConfigurationFile configFile = server.getConfiguration();
        if (configFile.getIFile() == null) {
            server.refreshConfiguration();
        }
        if ((resolvedFeature = (existingFeatures = new FeatureSet(runtime, configFile.getAllFeatures())).resolve(feature)) != null) {
            return EXIST_STATUS;
        }
        FeatureSet installedFeatures = runtime.getInstalledFeatures();
        String[] resolvedAll = installedFeatures.resolveAll(feature);
        if (resolvedAll != null) {
            for (String r : resolvedAll) {
                for (String f : existingFeatures) {
                    if (!runtime.isContainedBy(r, f)) continue;
                    return EXIST_STATUS;
                }
            }
        }
        if ((resolvedFeature = installedFeatures.resolve(feature)) == null) {
            return UNRESOLVED_STATUS;
        }
        configFile.addFeature(resolvedFeature);
        configFile.save((IProgressMonitor)null);
        if (configFile.getIFile() == null) {
            server.refreshConfiguration();
        }
        return Status.OK_STATUS;
    }

    public static boolean isFeatureExist(WebSphereServer server, String feature) {
        ConfigurationFile configFile;
        WebSphereRuntime runtime = server.getWebSphereRuntime();
        FeatureSet existingFeatures = new FeatureSet(runtime, (configFile = server.getConfiguration()).getAllFeatures());
        return existingFeatures.resolve(feature) != null;
    }
}

