/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.SchemaLocationProvider;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ConfigurationResourceChangeListener
implements IResourceChangeListener {
    private static final String XML = "xml";
    private static ConfigurationResourceChangeListener resourceChangeListener;

    public static synchronized void start() {
        if (resourceChangeListener != null) {
            return;
        }
        resourceChangeListener = new ConfigurationResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)resourceChangeListener, 1);
    }

    public static synchronized void stop() {
        if (resourceChangeListener == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)resourceChangeListener);
        }
        resourceChangeListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        if (event.getBuildKind() == 15) {
            return;
        }
        long time = System.currentTimeMillis();
        try {
            final ArrayList<IFolder> folders = new ArrayList<IFolder>(2);
            final ArrayList<IFile> files = new ArrayList<IFile>(10);
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta visitorDelta) {
                    IFile file;
                    IResource resource = visitorDelta.getResource();
                    if (resource instanceof IProject) {
                        IProject proj = (IProject)resource;
                        return proj.getFolder("servers").exists() || this.isConfiguredUserDirectory(proj);
                    }
                    int kind = visitorDelta.getKind();
                    if (resource != null && resource instanceof IFile && (ConfigurationResourceChangeListener.XML.equals((file = (IFile)resource).getFileExtension()) || ExtendedConfigFile.isExtendedConfigFile(file.getName()))) {
                        switch (kind) {
                            case 1: {
                                files.add(file);
                                break;
                            }
                            case 2: {
                                files.add(file);
                                break;
                            }
                            default: {
                                if ((visitorDelta.getFlags() & 0x100) == 0 && (visitorDelta.getFlags() & 0x4000) == 0 && (visitorDelta.getFlags() & 0x40000) == 0) {
                                    return false;
                                }
                                files.add(file);
                            }
                        }
                    }
                    if (resource != null && resource instanceof IFolder && (kind == 1 || kind == 2)) {
                        IPath path = resource.getProjectRelativePath();
                        if (path.segmentCount() == 2 && "servers".equals(path.segment(0))) {
                            IContainer serverFolder = resource.getParent();
                            if (serverFolder instanceof IFolder && !folders.contains(serverFolder)) {
                                folders.add((IFolder)serverFolder);
                            }
                        } else if (path.segmentCount() > 2 && "servers".equals(path.segment(0)) && "configDropins".equals(path.segment(2))) {
                            folders.add((IFolder)resource);
                        }
                    }
                    return true;
                }

                private boolean isConfiguredUserDirectory(IProject proj) {
                    WebSphereRuntime[] runtimes;
                    for (WebSphereRuntime r : runtimes = WebSphereUtil.getWebSphereRuntimes()) {
                        for (UserDirectory ud : r.getUserDirectories()) {
                            if (!proj.equals(ud.getProject())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
            if (!folders.isEmpty() || !files.isEmpty()) {
                this.refreshChanges(folders, files);
            }
        }
        catch (CoreException ce) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Error in resource listener", ce);
            }
        }
        finally {
            if (Trace.ENABLED) {
                Trace.tracePerf("Resource change listener", time);
            }
        }
    }

    protected void refreshChanges(final List<IFolder> folders, final List<IFile> files) {
        SchemaLocationProvider.clearCache();
        Job job = new Job("WebSphere Configuration Updater"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    long time = System.currentTimeMillis();
                    ConfigurationResourceChangeListener.refreshChangesImpl(folders, files);
                    if (Trace.ENABLED) {
                        Trace.tracePerf("Configuration update job", time);
                    }
                }
                catch (Exception e) {
                    Trace.logError("Error in WebSphere Configuration Updater", e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.job.family".equals(family);
            }
        };
        job.setSystem(true);
        job.setPriority(30);
        job.schedule();
    }

    protected static void refreshChangesImpl(List<IFolder> folders, List<IFile> files) {
        WebSphereRuntime[] runtimes = WebSphereUtil.getWebSphereRuntimes();
        if (!folders.isEmpty()) {
            for (WebSphereRuntime runtime : runtimes) {
                List<UserDirectory> userDirs = runtime.getUserDirectories();
                for (UserDirectory ud : userDirs) {
                    IFolder folder = ud.getServersFolder();
                    if (!folders.contains(folder)) continue;
                    WebSphereUtil.configureValidatorsForRuntimeProject(ud.getProject());
                    runtime.updateServerCache(true);
                }
            }
        }
        HashSet<WebSphereServerInfo> serverSet = new HashSet<WebSphereServerInfo>();
        HashSet<UserDirectory> userDirSet = new HashSet<UserDirectory>();
        for (WebSphereRuntime runtime : runtimes) {
            List<UserDirectory> userDirs = runtime.getUserDirectories();
            for (UserDirectory ud : userDirs) {
                List<WebSphereServerInfo> servers = runtime.getWebSphereServerInfos(ud);
                IFolder folder = ud.getSharedConfigFolder();
                if (folder != null && folder.exists()) {
                    for (IFile iFile : files) {
                        if (!folder.getFullPath().isPrefixOf(iFile.getFullPath())) continue;
                        userDirSet.add(ud);
                        for (WebSphereServerInfo server : servers) {
                            WebSphereServer ws = WebSphereUtil.getWebSphereServer(server);
                            if (ws == null || ws.isLocalSetup()) continue;
                            serverSet.add(server);
                        }
                    }
                    IPath sharedJVMPath = ud.getSharedFolder().getFullPath().append("jvm.options");
                    for (IFile file3 : files) {
                        if (!sharedJVMPath.equals((Object)file3.getFullPath())) continue;
                        serverSet.addAll(servers);
                        break;
                    }
                }
                for (WebSphereServerInfo webSphereServerInfo : servers) {
                    IFile file3;
                    folder = webSphereServerInfo.getServerFolder();
                    if (folder == null) continue;
                    file3 = files.iterator();
                    while (file3.hasNext()) {
                        IFile file = file3.next();
                        if (!folder.getFullPath().isPrefixOf(file.getFullPath())) continue;
                        serverSet.add(webSphereServerInfo);
                        break;
                    }
                    IPath configDropinsPath = folder.getFullPath().append("configDropins");
                    for (IFolder changedFolder : folders) {
                        if (!configDropinsPath.isPrefixOf(changedFolder.getFullPath())) continue;
                        serverSet.add(webSphereServerInfo);
                    }
                }
            }
        }
        for (UserDirectory ud : userDirSet) {
            ud.refreshSharedConfig();
        }
        for (WebSphereServerInfo server : serverSet) {
            server.updateCache();
            WebSphereServer ws = WebSphereUtil.getWebSphereServer(server);
            if (ws != null) {
                if (ws.isLocalSetup()) {
                    ws.serverConfigChanged(null);
                }
                ws.getWebSphereServerBehaviour().startAutoConfigSyncJob();
            }
            ServerListenerUtil.getInstance().fireServerChangedEvent(server);
        }
    }
}

