/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.core.internal.ServerExtensionWrapper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.looseconfig.LooseconfigXMLGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.w3c.dom.Document;

public abstract class ApplicationPublisher {
    private ServerExtensionWrapper wrapper;
    private static final String CLASS_EXTENSION = ".class";
    private static final int RETRY_LIMIT_IN_SECS = Integer.getInteger("com.ibm.ws.st.applicationPublishTimeoutInSeconds", 60);
    private boolean isLooseConfig = false;
    protected List<String> addedResourceList;
    protected List<String> removedResourceList;
    protected List<String> changedResourceList;
    protected List<String> jmxDeleteList = new ArrayList<String>();

    protected final void init(ServerExtensionWrapper wrapper) {
        this.wrapper = wrapper;
    }

    protected final IServer getServer() {
        return this.wrapper.getWebSphereServer().getServer();
    }

    protected final WebSphereServerInfo getWebSphereServerInfo() {
        return this.wrapper.getWebSphereServerInfo();
    }

    protected final WebSphereServer getWebSphereServer() {
        return this.wrapper.getWebSphereServer();
    }

    protected final WebSphereServerBehaviour getWebSphereServerBehaviour() {
        return this.wrapper.getWebSphereServerBehaviour();
    }

    protected final ConfigurationFile getConfiguration() {
        return this.wrapper.getWebSphereServer().getConfiguration();
    }

    protected final JMXConnection getJMXConnection() {
        return this.wrapper.getJmxConnection();
    }

    protected final boolean isLooseConfig() {
        return this.isLooseConfig;
    }

    protected final void setIsLooseConfig(boolean value) {
        this.isLooseConfig = value && this.isLooseConfigSupported();
    }

    public String toString() {
        return "ApplicationPublisher [" + this.getClass().toString() + "]";
    }

    public void prePublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishModuleAndChildren(int kind, PublishUnit unit, MultiStatus mStatus, IProgressMonitor monitor) {
        IModule[] module = unit.getModule();
        String projectName = module[module.length - 1].getName();
        int kind2 = kind;
        try {
            List<PublishUnit> children = unit.getChildren();
            int ticks = 2;
            if (children != null) {
                ticks += children.size();
            }
            monitor.beginTask("", ticks);
            IStatus status = null;
            int deltaKind = unit.getDeltaKind();
            if (deltaKind != 3) {
                status = this.publishModule(kind2, unit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
            }
            if (children != null) {
                for (PublishUnit child : children) {
                    this.publishModuleAndChildren(kind, child, mStatus, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    monitor.worked(1);
                }
            }
            if (deltaKind == 3) {
                status = this.publishModule(kind2, unit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.worked(1);
            if (status != null && !status.isOK()) {
                mStatus.add(status);
            }
            monitor.worked(ticks);
        }
        finally {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "--<-- Done publishing module " + projectName);
            }
            monitor.done();
        }
    }

    protected abstract IStatus publishModule(int var1, PublishUnit var2, IProgressMonitor var3);

    protected void setModulePublishState(IModule[] module, int state) {
        this.getWebSphereServerBehaviour().setModulePublishState(state, module);
    }

    protected abstract String getModuleDeployName(IModule var1);

    protected void handleAppLooseConfigXML(PublishUnit app) throws Exception {
        String xmlFileName = this.getModuleDeployName(app.getModule()[0]) + ".xml";
        IPath serverPath = this.getWebSphereServerBehaviour().getRootPublishFolder(false);
        serverPath = serverPath.append(xmlFileName);
        File serverFile = serverPath.toFile();
        IPath appsPathOverride = this.getAppsPathOverride();
        if (appsPathOverride != null) {
            appsPathOverride = appsPathOverride.append(xmlFileName);
        }
        if (app.getDeltaKind() == 3) {
            if (appsPathOverride != null) {
                serverFile = appsPathOverride.toFile();
            }
            if (serverFile.exists() && !serverFile.delete()) {
                Trace.logError("Can't delete loose config xml " + serverPath.toString(), null);
            }
        } else {
            IPath tempPath = this.getWebSphereServerBehaviour().getTempDirectory().append(xmlFileName);
            long time = System.currentTimeMillis();
            LooseconfigXMLGenerator gen = new LooseconfigXMLGenerator(this.getWebSphereServerBehaviour());
            if (appsPathOverride == null) {
                this.doHandleGen(app, serverPath, serverFile, tempPath, gen);
            }
            if (appsPathOverride != null) {
                File looseConfigXmlFile = appsPathOverride.toFile();
                this.doHandleGen(app, appsPathOverride, looseConfigXmlFile, tempPath, gen);
                this.getChangedResourceList().add(serverPath.toOSString());
            }
            if (Trace.ENABLED) {
                Trace.tracePerf("Loose config xml gen", time);
            }
        }
    }

    private void doHandleGen(PublishUnit app, IPath serverPath, File serverFile, IPath tempPath, LooseconfigXMLGenerator gen) throws ParserConfigurationException, IOException {
        if (serverFile.exists()) {
            try {
                gen.generateRepository(tempPath, app);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document tempDoc = builder.parse(tempPath.toFile());
                Document serverDoc = builder.parse(serverFile);
                tempDoc.normalizeDocument();
                serverDoc.normalizeDocument();
                if (!tempDoc.isEqualNode(serverDoc)) {
                    FileUtil.move(tempPath, serverPath);
                    this.getChangedResourceList().add(serverPath.toOSString());
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Exception when update loose config file", e);
                }
                gen.generateRepository(serverPath, app);
                this.getChangedResourceList().add(serverPath.toOSString());
            }
        } else {
            gen.generateRepository(serverPath, app);
            if (app.getDeltaKind() != 1) {
                this.getChangedResourceList().add(serverPath.toOSString());
            }
        }
    }

    protected void notifyUpdatedApplicationResourcesViaJMX() throws Exception {
        JMXConnection jmx = this.getJMXConnection();
        if (jmx == null || this.getServer().getServerState() != 2) {
            return;
        }
        if (!(this.addedResourceList != null && !this.addedResourceList.isEmpty() || this.removedResourceList != null && !this.removedResourceList.isEmpty() || this.changedResourceList != null && !this.changedResourceList.isEmpty())) {
            return;
        }
        if (!this.getWebSphereServer().isLocalSetup()) {
            String dest;
            WebSphereServerBehaviour wsb = this.getWebSphereServerBehaviour();
            String remoteServerConfigPath = wsb.resolveConfigVar("${server.config.dir}", jmx);
            ArrayList<String> remoteAddedResourceList = null;
            ArrayList<String> remoteChangedResourceList = null;
            ArrayList<String> remoteRemovedResourceList = null;
            if (this.addedResourceList != null) {
                remoteAddedResourceList = new ArrayList<String>(this.addedResourceList.size());
                for (String f : this.addedResourceList) {
                    try {
                        dest = f.replace(this.wrapper.getWebSphereServerInfo().getServerPath().toOSString(), remoteServerConfigPath).replace("\\", "/");
                        remoteAddedResourceList.add(dest);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Failed to upload file: " + f, e);
                    }
                }
            }
            if (this.changedResourceList != null) {
                remoteChangedResourceList = new ArrayList<String>(this.changedResourceList.size());
                for (String f : this.changedResourceList) {
                    try {
                        dest = f.replace(this.wrapper.getWebSphereServerInfo().getServerPath().toOSString(), remoteServerConfigPath).replace("\\", "/");
                        remoteChangedResourceList.add(dest);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Failed to upload file: " + f, e);
                    }
                }
            }
            if (this.removedResourceList != null) {
                long deleteStartTime = System.currentTimeMillis();
                remoteRemovedResourceList = new ArrayList<String>(this.removedResourceList.size());
                for (String f : this.removedResourceList) {
                    try {
                        String dest2 = f.replace(this.wrapper.getWebSphereServerInfo().getServerPath().toOSString(), remoteServerConfigPath).replace("\\", "/");
                        remoteRemovedResourceList.add(dest2);
                        jmx.deleteFile(dest2);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Failed to delete remote file: " + f, e);
                    }
                }
                if (Trace.ENABLED && this.removedResourceList.size() > 0) {
                    Trace.tracePerf("Finished JMX delete operations", deleteStartTime);
                }
            }
            jmx.notifyFileChanges(remoteAddedResourceList, remoteChangedResourceList, remoteRemovedResourceList);
        } else {
            jmx.notifyFileChanges(this.addedResourceList, this.changedResourceList, this.removedResourceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
        try {
            if (this.isLooseConfig) {
                this.handleAppLooseConfigXML(app);
            }
            this.updateRemoteApplicationFilesViaJMX(app, status);
            if (app.getDeltaKind() == 3 && this.getServer().getModulePublishState(app.getModule()) != 0) {
                try {
                    int trycount;
                    for (trycount = 0; !this.getWebSphereServerBehaviour().appStateTracker.hasApplicationState(app.getModuleName(), 4) && trycount < 50 && !monitor.isCanceled(); ++trycount) {
                        Thread.sleep(200L);
                    }
                    if (trycount >= 50) {
                        Trace.logError("Timed out waiting for Application Stopped message(CWWKZ0009I) for app " + app.getModuleName(), null);
                    }
                }
                catch (Exception e) {
                    Trace.logError("Exception occured for app " + app.getModuleName(), e);
                }
            }
            this.notifyUpdatedApplicationResourcesViaJMX();
            JMXConnection jmx = this.getJMXConnection();
            WebSphereServerBehaviour wsb = this.getWebSphereServerBehaviour();
            wsb.handleAutoConfigSyncJob(-1);
            status.add(wsb.syncConfig(jmx));
            if (status.getSeverity() != 4) {
                this.setApplicationModuleStates(app, 1);
            }
            boolean appPreExistInServerXML = wsb.getOverriddenAppsInServerXML().contains(app.getModuleName());
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "status=" + status.getSeverity());
                Trace.trace((byte)0, "isJMXNull=" + (jmx == null));
                Trace.trace((byte)0, "appDeltaKind=" + app.getDeltaKind());
                Trace.trace((byte)0, "serverState=" + this.getServer().getServerState());
                Trace.trace((byte)0, "moduleState=" + this.getServer().getModuleState(app.getModule()));
                Trace.trace((byte)0, "appStateTrackerHasRestartState=" + wsb.isAppStateTrackerHasState(app.getModuleName(), 64));
                Trace.trace((byte)0, "appPreExistInServerXML=" + appPreExistInServerXML);
                Trace.trace((byte)0, "isLocalHost=" + wsb.getWebSphereServer().isLocalSetup());
            }
            if (status.getSeverity() != 4 && jmx != null && app.getDeltaKind() == 1 && this.getServer().getServerState() == 2 && this.getServer().getModuleState(app.getModule()) != 2 && (wsb.isAppStateTrackerHasState(app.getModuleName(), 64) || appPreExistInServerXML || !wsb.getWebSphereServer().isLocalSetup())) {
                IPath deployPath;
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Getting deployment path and pushing notification to the server.");
                }
                String appDeployName = this.getModuleDeployName(app.getModule()[0]);
                if (this.isLooseConfig) {
                    appDeployName = appDeployName + ".xml";
                }
                if ((deployPath = wsb.getRootPublishFolder(false)) != null) {
                    deployPath = deployPath.append(appDeployName);
                    IPath usrMount = this.getAppsPathOverride();
                    if (usrMount != null) {
                        deployPath = usrMount.append(appDeployName);
                    }
                    ArrayList<String> a = new ArrayList<String>(1);
                    a.add(this.getDestinationPath(deployPath, jmx));
                    long startTime = System.currentTimeMillis();
                    jmx.notifyFileChanges(a, null, null);
                    if (Trace.ENABLED) {
                        Trace.tracePerf("Notify file changes completed", startTime);
                    }
                    int retries = 0;
                    while (!jmx.appMBeanExists(app.getModuleName()) && !monitor.isCanceled()) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Waiting for application MBean to be created before attempting to start");
                        }
                        try {
                            Thread.sleep(250L);
                            if (retries++ <= RETRY_LIMIT_IN_SECS * 4) continue;
                            retries = 0;
                            boolean continueWaiting = this.waitForApplicationPrompt(app.getModuleName());
                            if (continueWaiting) continue;
                            monitor.setCanceled(true);
                        }
                        catch (Exception exception) {}
                    }
                    jmx.startApplication(app.getModuleName());
                }
                if (appPreExistInServerXML) {
                    wsb.getOverriddenAppsInServerXML().remove(app.getModuleName());
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Exception occured in postPublishApplication()", e);
            status.add((IStatus)new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorPublishModule, (Object)app.getModule()[0].getName()), (Throwable)e));
        }
        finally {
            this.cleanupRemoteTempPublishFiles();
        }
        if (status.getSeverity() == 0) {
            status.add((IStatus)new Status(0, "com.ibm.ws.st.core", NLS.bind((String)Messages.deployAppSuccessfully, (Object)app.getModule()[0].getName())));
        } else {
            status.add((IStatus)new Status(status.getSeverity(), "com.ibm.ws.st.core", NLS.bind((String)Messages.deployAppFailed, (Object)app.getModule()[0].getName())));
        }
    }

    private boolean waitForApplicationPrompt(String appName) {
        PromptHandler handler = Activator.getPromptHandler();
        if (handler == null || PromptUtil.isSuppressDialog()) {
            return false;
        }
        return handler.handleConfirmPrompt(NLS.bind((String)Messages.publishModule, (Object)appName), Messages.waitForApplicationDialogMsg, true);
    }

    protected static IStatus combineModulePublishStatus(List<IStatus> status, String moduleName) {
        if (status == null || status.size() == 0) {
            return Status.OK_STATUS;
        }
        if (status.size() == 1) {
            return status.get(0);
        }
        IStatus[] children = new IStatus[status.size()];
        status.toArray(children);
        return new MultiStatus("com.ibm.ws.st.core", 0, children, NLS.bind((String)Messages.publishingModule, (Object)moduleName), null);
    }

    protected void setApplicationModuleStates(PublishUnit app, int state) {
        this.setModulePublishState(app.getModule(), state);
        List<PublishUnit> children = app.getChildren();
        if (children != null) {
            for (PublishUnit child : children) {
                this.setApplicationModuleStates(child, state);
            }
        }
    }

    protected int getApplicationChangeKind(PublishUnit pu) {
        if (pu.getParent() == null) {
            return pu.getDeltaKind();
        }
        return this.getApplicationChangeKind(pu.getParent());
    }

    protected String getPublishLocation(IPath deployPath, IModuleResource resource) {
        IPath mappedPath;
        String path = null;
        try {
            if (deployPath == null) {
                File file = (File)resource.getAdapter(File.class);
                if (file != null) {
                    path = file.getAbsolutePath();
                } else {
                    IFile ifile = (IFile)resource.getAdapter(IFile.class);
                    if (ifile != null) {
                        path = ifile.getLocation().toOSString();
                    }
                }
                if (path == null) {
                    Trace.logError("The File and IFile for the " + resource.getName() + " resource were both null.", null);
                    return null;
                }
            } else {
                path = deployPath.append(resource.getModuleRelativePath()).append(resource.getName()).toFile().getAbsolutePath();
            }
        }
        catch (Exception e) {
            Trace.logError("getPublishLocation(..) " + resource.getName(), e);
        }
        if (this.isLooseConfig && (mappedPath = this.getLooseConfigVolumeMapping((IPath)new Path(path))) != null) {
            path = mappedPath.toOSString();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)2, "PublishLocation: isLooseConfig = " + this.isLooseConfig + " : path is " + path);
        }
        return path;
    }

    protected void computeDeltaResources(IPath deployPath, IModuleResourceDelta[] deltaArray) {
        for (IModuleResourceDelta delta : deltaArray) {
            IModuleResourceDelta[] childDelta;
            String s = this.getPublishLocation(deployPath, delta.getModuleResource());
            if (s != null) {
                switch (delta.getKind()) {
                    case 1: {
                        this.getAddedResourceList().add(s);
                        if (!Trace.ENABLED) break;
                        Trace.trace((byte)2, "Resource added: " + s);
                        break;
                    }
                    case 2: {
                        this.getChangedResourceList().add(s);
                        if (!Trace.ENABLED) break;
                        Trace.trace((byte)2, "Resource changed: " + s);
                        break;
                    }
                    case 3: {
                        this.getRemovedResourceList().add(s);
                        if (!Trace.ENABLED) break;
                        Trace.trace((byte)2, "Resource removed: " + s);
                        break;
                    }
                }
            }
            if ((childDelta = delta.getAffectedChildren()) == null || childDelta.length == 0) continue;
            this.computeDeltaResources(deployPath, childDelta);
        }
    }

    public void handleLooseConfigModeChange(int kind, PublishUnit pu, MultiStatus multi, IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("com.ibm.ws.st.core", 0, NLS.bind((String)Messages.publishModule, (Object)pu.getModule()[0].getName()), null);
        if (pu.getDeltaKind() != 3 && pu.getDeltaKind() != 1) {
            JMXConnection jmx;
            int appState;
            String appName;
            block16: {
                appName = pu.getModule()[0].getName();
                appState = this.getServer().getModuleState(pu.getModule());
                jmx = this.getJMXConnection();
                if (jmx != null && appState == 2) {
                    try {
                        jmx.stopApplication(appName);
                        int timeout = this.getServer().getStopTimeout() * 20;
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Waiting for the " + appName + " application to stop. Wait " + timeout + " times 0.05 seconds.");
                        }
                        for (int i = 0; i < timeout && !monitor.isCanceled() && this.getServer().getModuleState(pu.getModule()) != 4; ++i) {
                            try {
                                Thread.sleep(50L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (Trace.ENABLED && this.getServer().getModuleState(pu.getModule()) != 4) {
                            Trace.trace((byte)1, "The " + appName + " module did not stop before the timeout.");
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block16;
                        Trace.trace((byte)1, "Exception occured in handleLooseConfigModeChange() when stopping the application", e);
                    }
                }
            }
            this.removePublishedAppFiles(pu, !this.isLooseConfig, status, monitor);
            SubProgressMonitor childMonitor = new SubProgressMonitor(monitor, 15);
            PublishUnit currentPU = this.copyPublishUnitWithADD(pu);
            this.prePublishApplication(2, currentPU, status, (IProgressMonitor)childMonitor);
            childMonitor.done();
            childMonitor = new SubProgressMonitor((IProgressMonitor)childMonitor, 70);
            this.publishModuleAndChildren(2, currentPU, status, (IProgressMonitor)childMonitor);
            if (this.isLooseConfig) {
                try {
                    this.handleAppLooseConfigXML(pu);
                }
                catch (Exception e) {
                    Trace.logError("Exception occured in handlePublishModeChange() when generate loose config file", e);
                    status.add((IStatus)new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorPublishModule, (Object)appName), (Throwable)e));
                }
            }
            childMonitor.done();
            if (jmx != null && appState == 2) {
                try {
                    childMonitor = new SubProgressMonitor((IProgressMonitor)childMonitor, 15);
                    this.updateServerOnPublishModeChangeViaJMX(kind, pu, jmx, status, (IProgressMonitor)childMonitor);
                    if (this.postLooseConfigChange()) {
                        this.updateRemoteApplicationFilesViaJMX(pu, status);
                    }
                    jmx.startApplication(appName);
                }
                catch (Exception e) {
                    Trace.logError("Exception occured in handlePublishModeChange() when start the application", e);
                    status.add((IStatus)new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorPublishModule, (Object)appName), (Throwable)e));
                }
            }
            multi.addAll((IStatus)status);
            monitor.done();
        }
    }

    private PublishUnit copyPublishUnitWithADD(PublishUnit origPU) {
        PublishUnit pu = new PublishUnit(origPU.getModule(), 1);
        List<PublishUnit> children = origPU.getChildren();
        if (children != null) {
            for (PublishUnit child : children) {
                pu.addChild(this.copyPublishUnitWithADD(child));
            }
        }
        return pu;
    }

    private void updateServerOnPublishModeChangeViaJMX(int kind, PublishUnit app, JMXConnection jmx, MultiStatus multi, IProgressMonitor monitor) {
        IPath symLinkPath;
        IPath path = this.getWebSphereServerBehaviour().getRootPublishFolder(false);
        IPath loosePath = path.append(this.getModuleDeployName(app.getModule()[0]) + ".xml");
        IPath non_loosePath = path.append(this.getModuleDeployName(app.getModule()[0]));
        if (this.isLooseConfig && (symLinkPath = this.getAppsPathOverride()) != null) {
            loosePath = symLinkPath.append(this.getModuleDeployName(app.getModule()[0]) + ".xml");
            non_loosePath = symLinkPath.append(this.getModuleDeployName(app.getModule()[0]));
        }
        String looseStr = this.getDestinationPath(loosePath, jmx);
        String non_looseStr = this.getDestinationPath(non_loosePath, jmx);
        ArrayList<String> add = null;
        ArrayList<String> remove = new ArrayList<String>();
        if (this.isLooseConfig) {
            remove.add(non_looseStr);
        } else {
            remove.add(looseStr);
        }
        if (app.getDeltaKind() != 3) {
            add = new ArrayList<String>();
            if (this.isLooseConfig) {
                add.add(looseStr);
            } else {
                add.add(non_looseStr);
            }
        }
        try {
            if (Trace.ENABLED) {
                String s = add != null ? (String)add.get(0) : "none";
                Trace.trace((byte)0, "JMX for switch publish mode. Add: " + s + " Remove: " + remove.get(0));
            }
            jmx.notifyFileChanges(add, null, remove);
        }
        catch (Exception e) {
            Trace.logError("Exception occured in updateServerOnPublishModeChange ", e);
            multi.add((IStatus)new Status(4, "com.ibm.ws.st.core", 0, NLS.bind((String)Messages.errorPublishModule, (Object)app.getModule()[0].getName()), (Throwable)e));
        }
    }

    public String getDestinationPath(IPath sourcePath, JMXConnection jmx) {
        IPath mappedPath;
        AbstractServerBehaviourExtension ext;
        IPath destPath = sourcePath;
        if (this.isLooseConfig && (ext = (AbstractServerBehaviourExtension)this.getWebSphereServerBehaviour().getAdapter(AbstractServerBehaviourExtension.class)) != null && (mappedPath = ext.getMappedPath(destPath, (ServerBehaviourDelegate)this.getWebSphereServerBehaviour())) != null) {
            destPath = mappedPath;
        }
        String destStr = destPath.toOSString();
        if (!this.isLooseConfig && !this.getWebSphereServer().isLocalSetup()) {
            try {
                String remotePath = this.getWebSphereServerBehaviour().resolveConfigVar("${server.config.dir}", jmx);
                destStr = destStr.replace(this.wrapper.getWebSphereServerInfo().getServerPath().toOSString(), remotePath);
            }
            catch (Exception e) {
                Trace.logError("An exception occured trying to get the value for ${server.config.dir} for the " + this.getServer().getName() + " server.", e);
            }
        }
        destStr = destStr.replace("\\", "/");
        return destStr;
    }

    protected static void addArrayStatusToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            list.add(a[i]);
        }
    }

    public boolean needToActOnLooseConfigModeChange(PublishUnit pu) {
        return true;
    }

    protected void removePublishedAppFiles(PublishUnit app, boolean looseCfg, MultiStatus multi, IProgressMonitor monitor) {
        IPath path = this.getWebSphereServerBehaviour().getRootPublishFolder(false);
        IPath symLinkPath = this.getAppsPathOverride();
        if (looseCfg) {
            path = path.append(this.getModuleDeployName(app.getModule()[0]) + ".xml");
            if (symLinkPath != null) {
                path = symLinkPath.append(this.getModuleDeployName(app.getModule()[0]) + ".xml");
            }
            this.removeRemoteFiles(path, looseCfg, monitor);
        } else {
            path = path.append(this.getModuleDeployName(app.getModule()[0]));
            if (symLinkPath != null) {
                path = symLinkPath.append(this.getModuleDeployName(app.getModule()[0]));
            }
        }
        File f = path.toFile();
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (f.exists()) {
            if (f.isDirectory()) {
                IStatus[] stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                ApplicationPublisher.addArrayStatusToList(status, stat);
            } else if (!f.delete()) {
                status.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorPublishModule, (Object)app.getModule()[0].getName())));
            }
        }
        multi.add(ApplicationPublisher.combineModulePublishStatus(status, app.getModule()[0].getName()));
    }

    public boolean requireConsoleOutputBeforePublishComplete(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        return false;
    }

    protected void removeExternalAppFiles(IModule module, String taskName, IProgressMonitor monitor) {
        block35: {
            String appName;
            block34: {
                IModule externalModule;
                if (module == null) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "application module is null");
                    }
                    return;
                }
                monitor.beginTask(taskName, 30);
                this.getWebSphereServerBehaviour().setSyncExternalModulesAfterPublish();
                appName = module.getName();
                if (this.getServer().getServerState() == 2 && (externalModule = this.getWebSphereServer().getExternalApp(appName)) != null) {
                    IModule[] externalApp = new IModule[]{externalModule};
                    JMXConnection jmx = this.getJMXConnection();
                    if (jmx != null && this.getServer().getModuleState(externalApp) != 4) {
                        try {
                            jmx.stopApplication(appName);
                            int itr = this.getServer().getStopTimeout() * 20;
                            if (Trace.ENABLED) {
                                Trace.trace((byte)0, "Start to wait for application " + appName + ", to stop before remove it. wait " + itr + " times of 0.05 seconds.");
                            }
                            while (--itr > 0 && !monitor.isCanceled() && this.getServer().getModuleState(externalApp) != 4) {
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if (Trace.ENABLED) {
                                if (itr <= 0) {
                                    Trace.trace((byte)1, "Application " + appName + " is not stopped before timeout.");
                                } else {
                                    Trace.trace((byte)0, "Application " + appName + " is stopped successfully. Loop remain: " + itr);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.ENABLED) break block34;
                            Trace.trace((byte)1, "Cannot stop the application, " + appName + ", before override it.");
                        }
                    }
                }
            }
            monitor.worked(5);
            String deployName = this.getModuleDeployName(module);
            IPath rootPublishPath = this.getWebSphereServerBehaviour().getRootPublishFolder(false);
            File dropinsFile = this.getWebSphereServer().getServerPath().append("dropins").append(deployName).toFile();
            File nonLooseFile = null;
            File looseFile = null;
            if (rootPublishPath == null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "The root publish path is null when remove module files for external application: " + appName);
                }
            } else {
                nonLooseFile = rootPublishPath.append(deployName).toFile();
                looseFile = rootPublishPath.append(deployName + ".xml").toFile();
            }
            try {
                if (dropinsFile.exists()) {
                    this.getWebSphereServerBehaviour().addAppRequireCallStartAfterPublish(appName);
                    if (dropinsFile.isDirectory()) {
                        IStatus[] ss = PublishHelper.deleteDirectory((File)dropinsFile, (IProgressMonitor)monitor);
                        if (Trace.ENABLED) {
                            for (IStatus s : ss) {
                                if (s.getSeverity() == 0) continue;
                                Trace.trace((byte)1, "There is a problme to delete application file. " + s.getMessage());
                            }
                        }
                    } else if (!dropinsFile.delete() && Trace.ENABLED) {
                        Trace.trace((byte)1, "Cannot delete application file. " + dropinsFile.getAbsolutePath());
                    }
                } else if (nonLooseFile != null && nonLooseFile.exists()) {
                    this.getWebSphereServerBehaviour().addAppRequireCallStartAfterPublish(appName);
                    if (nonLooseFile.isDirectory()) {
                        IStatus[] ss = PublishHelper.deleteDirectory((File)nonLooseFile, (IProgressMonitor)monitor);
                        if (Trace.ENABLED) {
                            for (IStatus s : ss) {
                                if (s.getSeverity() == 0) continue;
                                Trace.trace((byte)1, "There is a problme to delete application file. " + s.getMessage());
                            }
                        }
                    } else if (!nonLooseFile.delete() && Trace.ENABLED) {
                        Trace.trace((byte)1, "Cannot delete application file. " + nonLooseFile.getAbsolutePath());
                    }
                } else if (looseFile != null && looseFile.exists()) {
                    this.getWebSphereServerBehaviour().addAppRequireCallStartAfterPublish(appName);
                    if (!looseFile.delete() && Trace.ENABLED) {
                        Trace.trace((byte)1, "Cannot delete application file. " + looseFile.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block35;
                Trace.trace((byte)1, "Cannot delete application file for " + appName, e);
            }
        }
    }

    protected void publishDir(int kind, int deltaKind, IModule[] module, IPath destPath, PublishHelper helper, List<IStatus> status, IProgressMonitor monitor) {
        block7: {
            try {
                File f;
                WebSphereServer serv = this.getWebSphereServer();
                if (kind == 4 || deltaKind == 3 || !serv.isPublishToRuntime()) {
                    f = destPath.toFile();
                    this.jmxDeleteList.add(destPath.toOSString());
                    if (f.exists() && f.isDirectory()) {
                        IStatus[] stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                        ApplicationPublisher.addArrayStatusToList(status, stat);
                    }
                    if (deltaKind == 3 || !serv.isPublishToRuntime()) {
                        return;
                    }
                }
                if ((f = destPath.toFile()).exists() && !f.isDirectory() && !f.delete()) {
                    status.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorDeleteFile, (Object)f.getName())));
                    return;
                }
                WebSphereServerBehaviour servBehaviour = this.getWebSphereServerBehaviour();
                if (kind == 4 || kind == 2) {
                    IModuleResource[] mr = servBehaviour.getResources(module);
                    IStatus[] stat = helper.publishSmart(mr, destPath, monitor);
                    ApplicationPublisher.addArrayStatusToList(status, stat);
                    return;
                }
                IModuleResourceDelta[] delta = servBehaviour.getPublishedResourceDelta(module);
                IStatus[] stat = helper.publishDelta(delta, destPath, monitor);
                ApplicationPublisher.addArrayStatusToList(status, stat);
            }
            catch (Throwable t) {
                Trace.logError("Failed to copy module resource.", t);
                if (status == null) break block7;
                status.add((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.internalErrorPublishing, t));
            }
        }
    }

    protected List<String> getAddedResourceList() {
        if (this.addedResourceList == null) {
            this.addedResourceList = new ArrayList<String>();
        }
        return this.addedResourceList;
    }

    protected void clearAddedResourceList() {
        this.addedResourceList = null;
    }

    protected List<String> getRemovedResourceList() {
        if (this.removedResourceList == null) {
            this.removedResourceList = new ArrayList<String>();
        }
        return this.removedResourceList;
    }

    protected void clearRemovedResourceList() {
        this.removedResourceList = null;
    }

    protected List<String> getChangedResourceList() {
        if (this.changedResourceList == null) {
            this.changedResourceList = new ArrayList<String>();
        }
        return this.changedResourceList;
    }

    protected void clearChangedResourceList() {
        this.changedResourceList = null;
    }

    protected boolean checkFileExtension(List<String> list) {
        for (String s : list) {
            String ext = this.getFileExtension(s);
            if (ext == null || !ext.equalsIgnoreCase(CLASS_EXTENSION)) continue;
            return true;
        }
        return false;
    }

    private String getFileExtension(String fullName) {
        if (fullName == null) {
            return null;
        }
        int i = fullName.lastIndexOf(46);
        if (i != -1) {
            return fullName.substring(i);
        }
        return null;
    }

    public boolean isLooseConfigSupported() {
        return this.getWebSphereServer().isLocalSetup() || this.getWebSphereServer().isLooseConfigEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteApplicationFilesViaJMX(PublishUnit app, MultiStatus status) throws Exception {
        block24: {
            JMXConnection jmx = this.getJMXConnection();
            if (jmx == null || jmx.isLocalConnection() || this.getServer().getServerState() != 2) {
                this.jmxDeleteList.clear();
                return;
            }
            WebSphereServerBehaviour wsb = this.getWebSphereServerBehaviour();
            if (!this.jmxDeleteList.isEmpty()) {
                long deleteStartTime = System.currentTimeMillis();
                for (String file : this.jmxDeleteList) {
                    try {
                        String remotePath = wsb.resolveConfigVar("${server.config.dir}", jmx);
                        File[] dest = file.replace(this.wrapper.getWebSphereServerInfo().getServerPath().toOSString(), remotePath).replace("\\", "/");
                        CompositeData[] compositeDataArray = jmx.getDirectoryEntries((String)dest, true, "");
                        if (compositeDataArray == null) continue;
                        ArrayDeque<Object> dirs = new ArrayDeque<Object>(compositeDataArray.length);
                        dirs.push(dest);
                        for (CompositeData c : compositeDataArray) {
                            dirs.push((String)c.get("fileName"));
                        }
                        while (!dirs.isEmpty()) {
                            String string = (String)dirs.pop();
                            try {
                                jmx.deleteFile(string);
                            }
                            catch (Exception e) {
                                if (!Trace.ENABLED) continue;
                                Trace.trace((byte)1, "Could not delete remote file: " + string, e);
                            }
                        }
                    }
                    catch (Exception e) {
                        Trace.logError("Failed to delete file: " + file, e);
                    }
                }
                if (Trace.ENABLED) {
                    Trace.tracePerf("Finished JMX delete operations", deleteStartTime);
                }
                this.jmxDeleteList.clear();
            }
            IPath path = wsb.getRootPublishFolder(false);
            IPath tempPath = wsb.getTempDirectory();
            HashMap<File, Object> filesToUpload = new HashMap<File, Object>();
            try {
                if (path == null) break block24;
                try {
                    File[] files;
                    File appsDir = path.toFile();
                    if (appsDir.exists() && appsDir.isDirectory() && (files = appsDir.listFiles()) != null) {
                        for (File file : files) {
                            if (!file.isDirectory()) continue;
                            IPath zipPath = tempPath.append(file.getName() + ".zip");
                            FileUtil.zipDirectory(file, zipPath.toOSString());
                            File zipFile = zipPath.toFile();
                            if (!zipFile.exists()) continue;
                            filesToUpload.put(zipFile, file);
                        }
                    }
                }
                catch (Exception e) {
                    status.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorRemotePublishPackage, (Object)app.getModuleName()), (Throwable)e));
                }
                if (status.getSeverity() != 0) {
                    return;
                }
                long uploadStartTime = System.currentTimeMillis();
                try {
                    for (Map.Entry entry : filesToUpload.entrySet()) {
                        File zipFile = (File)entry.getKey();
                        File file = (File)entry.getValue();
                        String remoteServerConfigPath = wsb.resolveConfigVar("${server.config.dir}", jmx);
                        String remoteDestination = file.getAbsolutePath().replace(this.wrapper.getWebSphereServerInfo().getServerPath().toOSString(), remoteServerConfigPath).replace("\\", "/");
                        jmx.uploadFile(zipFile, remoteDestination, true);
                    }
                }
                catch (Exception e) {
                    status.add((IStatus)new Status(4, "com.ibm.ws.st.core", NLS.bind((String)Messages.errorRemotePublishTransfer, (Object)app.getModuleName()), (Throwable)e));
                }
                if (Trace.ENABLED && !filesToUpload.isEmpty()) {
                    Trace.tracePerf("Finished JMX upload operations", uploadStartTime);
                }
            }
            finally {
                for (File file : filesToUpload.keySet()) {
                    if (file.delete() || !Trace.ENABLED) continue;
                    Trace.trace((byte)0, "Failed to delete temporary file: " + file);
                }
            }
        }
    }

    private void cleanupRemoteTempPublishFiles() {
        if (this.getWebSphereServerBehaviour().isLocalUserDir()) {
            return;
        }
        WebSphereServerBehaviour wsb = this.getWebSphereServerBehaviour();
        IPath path = wsb.getRootPublishFolder(false);
        if (path == null) {
            return;
        }
        File appDir = path.toFile();
        if (appDir.exists() && appDir.isDirectory()) {
            File[] files = appDir.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                try {
                    if (f.isDirectory()) {
                        FileUtil.deleteDirectory(f.getAbsolutePath(), true);
                        continue;
                    }
                    if (f.delete() || !Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Unable to delete temporary remote publish file: " + f.getAbsolutePath());
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Failed to delete temporary remote publish file: " + f.getAbsolutePath());
                }
            }
        }
    }

    protected IPath getAppsPathOverride() {
        IPath appsOverridePath = null;
        WebSphereServerBehaviour webSphereServerBehaviour = this.getWebSphereServerBehaviour();
        AbstractServerBehaviourExtension ext = (AbstractServerBehaviourExtension)webSphereServerBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        if (ext != null) {
            appsOverridePath = ext.getAppsOverride((ServerBehaviourDelegate)webSphereServerBehaviour);
        }
        return appsOverridePath;
    }

    protected IPath getLooseConfigVolumeMapping(IPath localPath) {
        WebSphereServerBehaviour webSphereServerBehaviour = this.getWebSphereServerBehaviour();
        AbstractServerBehaviourExtension ext = (AbstractServerBehaviourExtension)webSphereServerBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        if (ext != null) {
            return ext.getMappedPath(localPath, (ServerBehaviourDelegate)webSphereServerBehaviour);
        }
        return null;
    }

    protected boolean postLooseConfigChange() throws Exception {
        WebSphereServerBehaviour webSphereServerBehaviour = this.getWebSphereServerBehaviour();
        AbstractServerBehaviourExtension ext = (AbstractServerBehaviourExtension)webSphereServerBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        if (ext != null) {
            return ext.doUpdateRemoteAppFiles((ServerBehaviourDelegate)webSphereServerBehaviour, this.isLooseConfig);
        }
        return false;
    }

    protected void removeRemoteFiles(IPath path, boolean looseCfg, IProgressMonitor monitor) {
        WebSphereServerBehaviour webSphereServerBehaviour = this.getWebSphereServerBehaviour();
        AbstractServerBehaviourExtension ext = (AbstractServerBehaviourExtension)webSphereServerBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        if (ext != null) {
            ext.removeRemoteAppFiles((ServerBehaviourDelegate)webSphereServerBehaviour, path, looseCfg, monitor);
        }
    }
}

