/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.eclipse.wst.server.core.IModule;

public class ApplicationNotificationListener
implements NotificationListener {
    public static final String STATE_STOPPED = "STOPPED";
    public static final String STATE_STARTING = "STARTING";
    public static final String STATE_STARTED = "STARTED";
    public static final String STATE_PARTIALY_STARTED = "PARTIALY_STARTED";
    public static final String STATE_STOPPING = "STOPPING";
    public static final String STATE_INSTALLED = "INSTALLED";
    public static final String APP_UPDATE = "application.update";
    public static final String STATE_UNKNOWN = "UNKNOWN";
    private final String appName;
    private final WebSphereServerBehaviour wsBehaviour;

    public ApplicationNotificationListener(String appName, WebSphereServerBehaviour wsBehaviour) {
        this.appName = appName;
        this.wsBehaviour = wsBehaviour;
    }

    @Override
    public void handleNotification(Notification notification, Object arg1) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification acn = (AttributeChangeNotification)notification;
            this.handleState((String)acn.getOldValue(), (String)acn.getNewValue());
        }
        if (notification != null && notification.getType().startsWith("application.")) {
            String type = notification.getType();
            Map userData = (Map)notification.getUserData();
            Boolean status = (Boolean)userData.get("status");
            if (status.booleanValue()) {
                if (APP_UPDATE.equals(type)) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)8, "\tApplication <" + this.appName + ">: Update Successful");
                    }
                    this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 2);
                }
            } else if (APP_UPDATE.equals(type)) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "\tApplication <" + this.appName + ">: Update Failed");
                }
                this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 32);
            }
        }
    }

    public synchronized void handleState(String oldState, String newState) {
        IModule[] modules;
        if (Trace.ENABLED) {
            Trace.trace((byte)8, "\tApplication <" + this.appName + ">: " + oldState + " -> " + newState);
        }
        if (STATE_STARTED.equals(newState)) {
            if (!STATE_UNKNOWN.equals(oldState)) {
                this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 1);
                this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 2);
            }
            this.setInternalExternalState(2);
        }
        if (STATE_STOPPED.equals(newState)) {
            if (!STATE_UNKNOWN.equals(oldState)) {
                this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 4);
            }
            for (IModule iModule : modules = this.wsBehaviour.getServer().getModules()) {
                if (!iModule.getName().equals(this.appName)) continue;
                if (iModule.isExternal()) {
                    this.wsBehaviour.syncExternalModules();
                }
                this.wsBehaviour.setModuleStateImpl(new IModule[]{iModule}, 4);
            }
        }
        if (STATE_STARTED.equals(oldState) && STATE_STOPPING.equals(newState)) {
            for (IModule iModule : modules = this.wsBehaviour.getServer().getModules()) {
                if (!iModule.getName().equals(this.appName)) continue;
                if (iModule.isExternal()) {
                    this.wsBehaviour.syncExternalModules();
                }
                this.wsBehaviour.setModuleStateImpl(new IModule[]{iModule}, 3);
            }
        }
        if (STATE_STOPPED.equals(oldState) && STATE_STARTING.equals(newState)) {
            for (IModule iModule : modules = this.wsBehaviour.getServer().getModules()) {
                if (!iModule.getName().equals(this.appName)) continue;
                if (iModule.isExternal()) {
                    this.wsBehaviour.syncExternalModules();
                }
                this.wsBehaviour.setModuleStateImpl(new IModule[]{iModule}, 1);
            }
        }
        if (STATE_STARTING.equals(oldState) && STATE_INSTALLED.equals(newState)) {
            this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 8);
            this.setInternalExternalState(0);
        }
        if (STATE_STARTING.equals(oldState) && STATE_STOPPED.equals(newState)) {
            boolean isAutoStart = true;
            try {
                for (ConfigurationFile.Application application : this.wsBehaviour.getWebSphereServerInfo().getConfigRoot().getApplications()) {
                    if (!application.getName().equals(this.appName) || application.getAutoStart() == null || !application.getAutoStart().equalsIgnoreCase("false")) continue;
                    isAutoStart = false;
                    this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 1);
                }
            }
            catch (Exception exception) {
                Trace.trace((byte)8, "Couldn't check the autoStart value for the app " + this.appName, exception);
            }
            if (isAutoStart) {
                this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 8);
            }
            this.setInternalExternalState(4);
        }
        if (STATE_STARTING.equals(oldState) && STATE_UNKNOWN.equals(newState)) {
            this.wsBehaviour.appStateTracker.addApplicationState(this.appName, 8);
            this.setInternalExternalState(0);
        }
    }

    private void setInternalExternalState(int state) {
        IModule[] modules = this.wsBehaviour.getServer().getModules();
        boolean externalModuleAdded = true;
        for (IModule module : modules) {
            if (!module.getName().equals(this.appName)) continue;
            this.wsBehaviour.setModuleStateImpl(new IModule[]{module}, state);
            externalModuleAdded = false;
            break;
        }
        if (externalModuleAdded) {
            this.wsBehaviour.syncExternalModules();
            for (IModule module : modules = this.wsBehaviour.getServer().getModules()) {
                if (!module.getName().equals(this.appName)) continue;
                this.wsBehaviour.setModuleStateImpl(new IModule[]{module}, state);
                break;
            }
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public WebSphereServerBehaviour getServerDelegate() {
        return this.wsBehaviour;
    }
}

