/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.AbstractServerStartupExtension;
import com.ibm.ws.st.core.internal.launch.ServerStartInfo;
import com.ibm.ws.st.core.internal.launch.WebSphereLaunchConfigurationDelegate;
import java.util.Arrays;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractMonitorThread
extends Thread {
    public static final String SERVER_STATUS_POLLING_DELAY_PROPERTY = "com.ibm.ws.st.serverStatusPollingDelaySeconds";
    protected static int POLLING_DELAY = 3500;
    protected boolean stopMonitor = false;
    protected WebSphereServerBehaviour wsBehaviour;
    protected IServer server;
    protected WebSphereServer wsServer;
    protected Object serverStateSyncObj;

    public AbstractMonitorThread(WebSphereServerBehaviour wsBehaviour, Object serverStateSyncObj, String name) {
        super(name);
        this.wsBehaviour = wsBehaviour;
        this.server = wsBehaviour.getServer();
        this.wsServer = wsBehaviour.getWebSphereServer();
        this.serverStateSyncObj = serverStateSyncObj;
    }

    public void stopMonitor() {
        this.stopMonitor = true;
    }

    protected WebSphereRuntime getWebSphereRuntime() {
        return this.wsBehaviour.getWebSphereRuntime();
    }

    public boolean isRunning() {
        return !this.stopMonitor;
    }

    protected boolean isProfileMode(String[] vmArgs) throws Exception {
        AbstractServerStartupExtension[] preStartExtensions;
        if (vmArgs == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Profile mode cannot be detected because no vmArgs were found");
            }
            return false;
        }
        for (AbstractServerStartupExtension startup : preStartExtensions = Activator.getInstance().getPreStartExtensions()) {
            Boolean isProfiling = startup.isProfiling(new ServerStartInfo(this.server, this.server.getMode()), Arrays.asList(vmArgs));
            if (isProfiling == null || !isProfiling.booleanValue()) continue;
            if (Trace.ENABLED) {
                Trace.trace((byte)8, "Profile mode detected by pre-startup class: " + startup.getClass().toString());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectAndSetServerMode(JMXConnection jmxConnection) {
        block20: {
            try {
                String[] jvmArgs = jmxConnection.getVMArgs();
                int debugPortNum = jmxConnection.getDebugPortNum();
                String serverMode = this.server.getMode();
                boolean isDebugMode = debugPortNum > -1;
                boolean isProfileMode = this.isProfileMode(jvmArgs);
                if (isDebugMode) {
                    try {
                        if ("debug".equals(serverMode)) break block20;
                        if (!this.wsBehaviour.isDebugAttached(debugPortNum, this.server)) {
                            WebSphereLaunchConfigurationDelegate.launchIt("debug", this.wsBehaviour);
                        }
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Changing server state to DEBUGGING, attaching debugger. Server listening at port: " + debugPortNum);
                        }
                        Object object = this.serverStateSyncObj;
                        synchronized (object) {
                            this.wsBehaviour.setInternalMode("debug");
                            this.wsBehaviour.setServerStateImpl(2);
                            break block20;
                        }
                    }
                    catch (Exception e) {
                        if (Trace.ENABLED) {
                            Trace.logError("Error launching in DEBUGGING mode ", e);
                        }
                        break block20;
                    }
                }
                if (isProfileMode) {
                    try {
                        if ("profile".equals(serverMode)) break block20;
                        WebSphereLaunchConfigurationDelegate.launchIt("profile", this.wsBehaviour);
                        if (Trace.ENABLED) {
                            Trace.trace((byte)8, "Changing server state to PROFILING");
                        }
                        Object e = this.serverStateSyncObj;
                        synchronized (e) {
                            this.wsBehaviour.setInternalMode("profile");
                            this.wsBehaviour.setServerStateImpl(2);
                            break block20;
                        }
                    }
                    catch (Exception e) {
                        if (Trace.ENABLED) {
                            Trace.logError("Error launching in PROFILING mode ", e);
                        }
                        break block20;
                    }
                }
                if (!"run".equals(serverMode)) {
                    this.wsBehaviour.setInternalMode("run");
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block20;
                Trace.logError("Error parsing vm args ", e);
            }
        }
    }

    static {
        String pollingDelay = System.getProperty(SERVER_STATUS_POLLING_DELAY_PROPERTY);
        if (pollingDelay != null && !pollingDelay.isEmpty()) {
            try {
                POLLING_DELAY = Integer.parseInt(pollingDelay) * 1000;
            }
            catch (NumberFormatException e) {
                Trace.logError("The server status polling delay specified is not valid: " + pollingDelay + ". The default will be used: " + POLLING_DELAY, e);
            }
        }
    }
}

