/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal.wizard;

import com.ibm.ws.st.common.core.ext.internal.Activator;
import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.internal.RemoteServerInfo;
import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.common.ui.ext.internal.servertype.WizardFragmentProvider;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.docker.ui.internal.wizard.LibertyDockerComposite;
import com.ibm.ws.st.docker.ui.internal.wizard.LibertyRemoteDockerLogonComposite;
import com.ibm.ws.st.docker.ui.internal.wizard.LibertyRemoteDockerWizardFragment;
import com.ibm.ws.st.ui.internal.wizard.WebSphereServerWizardCommonFragment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class LibertyDockerWizardFragmentProvider
extends WizardFragmentProvider {
    public boolean isActive(TaskModel taskModel) {
        if (WebSphereServerWizardCommonFragment.isLocalhost((TaskModel)taskModel)) {
            try {
                return AbstractDockerMachine.isDockerInstalled((IPlatformHandler)PlatformHandlerFactory.getPlatformHandler(null, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.COMMAND));
            }
            catch (UnsupportedServiceException e) {
                Trace.logError((String)"Failed to retrieve the platform handler.", (Throwable)e);
                return false;
            }
        }
        return Activator.getPlatformProvider((String)PlatformHandlerFactory.PlatformType.SSH_KEYLESS.name()) != null;
    }

    public Composite getInitialComposite(Composite parent, IWizardHandle handle, TaskModel taskModel) {
        Object comp = null;
        if (WebSphereServerWizardCommonFragment.isLocalhost((TaskModel)taskModel)) {
            comp = new LibertyDockerComposite(parent, handle, taskModel);
        } else {
            IServerWorkingCopy serverWC = (IServerWorkingCopy)taskModel.getObject("server");
            WebSphereServer wsServer = (WebSphereServer)serverWC.getAdapter(WebSphereServer.class);
            RemoteServerInfo remoteInfo = this.getInitializedRemoteServerInfo(wsServer);
            comp = new LibertyRemoteDockerLogonComposite(parent, serverWC, handle, remoteInfo);
        }
        return comp;
    }

    public List<WizardFragment> getFollowingFragments() {
        ArrayList<WizardFragment> fragments = new ArrayList<WizardFragment>();
        fragments.add(new LibertyRemoteDockerWizardFragment());
        return fragments;
    }

    private RemoteServerInfo getInitializedRemoteServerInfo(WebSphereServer wsServer) {
        RemoteServerInfo info = null;
        info = wsServer != null ? wsServer.getRemoteServerInfo() : new RemoteServerInfo(RemoteServerInfo.RemoteServerType.Liberty);
        info.putBooleanValue("remoteStart_Enabled", true);
        info.putIntegerValue("remoteStart_Platform", 1);
        return info;
    }
}

