/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal.wizard;

import com.ibm.ws.st.common.core.ext.internal.AbstractServerSetup;
import com.ibm.ws.st.common.core.ext.internal.ServerSetupFactory;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.remote.RemoteUtils;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerRunUtility;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import com.ibm.ws.st.docker.ui.internal.Activator;
import com.ibm.ws.st.docker.ui.internal.Messages;
import com.ibm.ws.st.docker.ui.internal.Trace;
import com.ibm.ws.st.docker.ui.internal.wizard.ContainersInUseDialog;
import com.ibm.ws.st.docker.ui.internal.wizard.LibertyDockerUtil;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.wizard.AbstractRemoteServerComposite;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.w3c.dom.Document;

public class LibertyDockerComposite
extends AbstractRemoteServerComposite {
    private static final char PASSWORD_CHAR = '\u25cf';
    private static final String SERVER_TYPE = "LibertyDocker";
    private static final String DEFAULT_PORT = "9443";
    protected TaskModel taskModel;
    protected Group connectionInfo;
    protected Map<String, BaseDockerContainer> containerNameMap;
    protected Combo containerCombo;
    protected Text userText;
    protected Text passwordText;
    protected Text portText;
    protected Button connectButton;
    protected Button refreshButton;
    protected StyledText remoteServerOutputPath;
    protected String selectedContainerName;
    protected BaseDockerContainer selectedContainer;
    protected String userName;
    protected String userPassword;
    protected String portNum = "9443";
    protected boolean isComplete = false;
    protected AbstractServerSetup serverSetup = null;
    protected boolean serverSetupUpdateNeeded = false;
    protected Map<String, String> serviceInfo;
    protected Button enableLooseConfigButton;
    protected boolean looseConfigEnabled = false;
    private String hostname = null;
    protected boolean isLocalHost = false;
    protected Composite fileSyncComposite = null;
    protected Map<String, String> containersInUse;
    protected Link containersInUseLink;

    protected LibertyDockerComposite(Composite parent, IWizardHandle wizard, TaskModel taskModel) {
        super(parent, wizard);
        IServerWorkingCopy serverWorkingCopy;
        this.taskModel = taskModel;
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizServer"));
        if (taskModel != null && (serverWorkingCopy = (IServerWorkingCopy)taskModel.getObject("server")) != null) {
            this.hostname = serverWorkingCopy.getHost();
            this.isLocalHost = SocketUtil.isLocalhost((String)this.hostname);
        }
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels((Composite)this, (int)4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels((Composite)this, (int)4);
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.setLayoutData(data);
        this.connectionInfo = new Group((Composite)this, 0);
        this.connectionInfo.setText(Messages.wizDockerServerConnectionInfo);
        int numCols = 5;
        layout = new GridLayout(numCols, false);
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        this.connectionInfo.setLayout((Layout)layout);
        data = new GridData(768);
        this.connectionInfo.setLayoutData((Object)data);
        StyledText text = new StyledText((Composite)this.connectionInfo, 0);
        text.setText(Messages.wizDockerServerContainerInfo);
        text.setBackground(this.connectionInfo.getBackground());
        text.setEditable(false);
        text.setCaret(null);
        data = new GridData(1, 2, false, false);
        data.horizontalSpan = 5;
        text.setLayoutData((Object)data);
        int indentSize = 3;
        this.createDummyLabel((Composite)this.connectionInfo, indentSize);
        Label label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizDockerContainerName);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        this.containerCombo = new Combo((Composite)this.connectionInfo, 8);
        data = new GridData(4, 2, true, false);
        data.horizontalSpan = 2;
        this.containerCombo.setLayoutData((Object)data);
        this.containerNameMap = this.createContainerNameMap();
        Set<String> nameSet = this.containerNameMap.keySet();
        Object[] containerNames = nameSet.toArray(new String[nameSet.size()]);
        Arrays.sort(containerNames);
        this.containerCombo.setItems((String[])containerNames);
        this.containerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = LibertyDockerComposite.this.containerCombo.getSelectionIndex();
                String newContainerName = LibertyDockerComposite.this.containerCombo.getItem(index);
                if (LibertyDockerComposite.this.selectedContainerName != null && !newContainerName.equals(LibertyDockerComposite.this.selectedContainerName)) {
                    LibertyDockerComposite.this.selectedContainerName = newContainerName;
                    LibertyDockerComposite.this.selectedContainer = LibertyDockerComposite.this.getDockerContainer(newContainerName);
                    LibertyDockerComposite.this.serverSetupUpdateNeeded = true;
                    LibertyDockerComposite.this.isComplete = false;
                    LibertyDockerComposite.this.validate();
                }
            }
        });
        this.refreshButton = new Button((Composite)this.connectionInfo, 0);
        this.refreshButton.setText(Messages.wizDockerRefresh);
        this.refreshButton.setToolTipText(Messages.wizDockerRefreshTooltip);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibertyDockerComposite.this.refreshContainers();
                LibertyDockerComposite.this.validate();
            }
        });
        this.createDummyLabel((Composite)this.connectionInfo, indentSize);
        this.containersInUseLink = new Link((Composite)this.connectionInfo, 0);
        this.containersInUseLink.setText(Messages.wizDockerViewInUseContainersLink);
        this.containersInUseLink.setToolTipText(Messages.wizDockerInUseContainersCannotCreateNewServer);
        this.containersInUseLink.setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        this.containersInUseLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ContainersInUseDialog(LibertyDockerComposite.this.getShell(), LibertyDockerComposite.this.containersInUse).open();
            }
        });
        this.containersInUseLink.setVisible(!this.containersInUse.isEmpty());
        text = new StyledText((Composite)this.connectionInfo, 0);
        text.setText(Messages.wizDockerServerLibertySecurityInfo);
        text.setBackground(this.connectionInfo.getBackground());
        text.setEditable(false);
        text.setCaret(null);
        data = new GridData(1, 2, false, false);
        data.horizontalSpan = 5;
        text.setLayoutData((Object)data);
        this.createDummyLabel((Composite)this.connectionInfo, indentSize);
        label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizDockerUserLabel);
        this.userText = new Text((Composite)this.connectionInfo, 2048);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.userText.setLayoutData((Object)data);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                LibertyDockerComposite.this.userName = LibertyDockerComposite.this.userText.getText();
                LibertyDockerComposite.this.isComplete = false;
                LibertyDockerComposite.this.validate();
            }
        });
        this.createDummyLabel((Composite)this.connectionInfo, 0);
        this.createDummyLabel((Composite)this.connectionInfo, indentSize);
        label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizDockerPasswordLabel);
        this.passwordText = new Text((Composite)this.connectionInfo, 2048);
        this.passwordText.setText("");
        data = new GridData(4, 0x1000000, true, false);
        this.passwordText.setLayoutData((Object)data);
        this.passwordText.setEchoChar('\u25cf');
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                LibertyDockerComposite.this.userPassword = LibertyDockerComposite.this.passwordText.getText();
                LibertyDockerComposite.this.isComplete = false;
                LibertyDockerComposite.this.validate();
            }
        });
        final Button showPassword = new Button((Composite)this.connectionInfo, 32);
        showPassword.setText(Messages.wizDockerPasswordShowButton);
        data = new GridData(3, 2, false, false);
        showPassword.setLayoutData((Object)data);
        showPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (showPassword.getSelection()) {
                    LibertyDockerComposite.this.passwordText.setEchoChar('\u0000');
                } else {
                    LibertyDockerComposite.this.passwordText.setEchoChar('\u25cf');
                }
            }
        });
        this.createDummyLabel((Composite)this.connectionInfo, 0);
        this.createDummyLabel((Composite)this.connectionInfo, indentSize);
        label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizDockerSecurePort);
        this.portText = new Text((Composite)this.connectionInfo, 2048);
        this.portText.setMessage(DEFAULT_PORT);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.portText.setLayoutData((Object)data);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                LibertyDockerComposite.this.portNum = LibertyDockerComposite.this.portText.getText();
                if (LibertyDockerComposite.this.portNum == null || LibertyDockerComposite.this.portNum.isEmpty()) {
                    LibertyDockerComposite.this.portNum = LibertyDockerComposite.DEFAULT_PORT;
                }
                LibertyDockerComposite.this.isComplete = false;
                LibertyDockerComposite.this.validate();
            }
        });
        if (this.isLocalHost) {
            this.createDummyLabel((Composite)this.connectionInfo, indentSize);
            this.enableLooseConfigButton = new Button((Composite)this.connectionInfo, 32);
            this.enableLooseConfigButton.setText(Messages.wizDockerLooseConfigButton);
            this.enableLooseConfigButton.setToolTipText(com.ibm.ws.st.ui.internal.Messages.editorGeneralLooseConfigMessage);
            data = new GridData(1, 2, false, false);
            data.horizontalSpan = 4;
            this.enableLooseConfigButton.setLayoutData((Object)data);
            this.enableLooseConfigButton.setSelection(true);
            this.looseConfigEnabled = true;
            this.enableLooseConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibertyDockerComposite.this.looseConfigEnabled = LibertyDockerComposite.this.enableLooseConfigButton.getSelection();
                    LibertyDockerComposite.this.fileSyncComposite.setVisible(!LibertyDockerComposite.this.looseConfigEnabled);
                }
            });
        }
        this.connectButton = new Button((Composite)this.connectionInfo, 0);
        this.connectButton.setText(Messages.wizDockerConnect);
        this.connectButton.setToolTipText(Messages.wizDockerConnectTooltip);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    LibertyDockerComposite.this.handleConnect(LibertyDockerComposite.this.selectedContainer);
                }
                catch (Exception e) {
                    Trace.logError("Failed to connect with Docker container: " + LibertyDockerComposite.this.selectedContainer.getContainerName(), e);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getParent(), "com.ibm.ws.st.docker.ui.wizdc0010");
        this.createConfigControl((Composite)this);
        text = new StyledText((Composite)this, 0);
        text.setText(Messages.wizDockerDirectoryLabel);
        text.setBackground(this.getBackground());
        text.setEditable(false);
        text.setCaret(null);
        this.remoteServerOutputPath = new StyledText((Composite)this, 0);
        this.remoteServerOutputPath.setText("");
        this.remoteServerOutputPath.setBackground(this.getBackground());
        this.remoteServerOutputPath.setEditable(false);
        this.remoteServerOutputPath.setCaret(null);
        label = new Label((Composite)this, 0);
        this.fileSyncComposite = new Composite((Composite)this, 0);
        layout = new GridLayout(numCols, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        this.fileSyncComposite.setLayout((Layout)layout);
        data = new GridData(768);
        this.fileSyncComposite.setLayoutData((Object)data);
        label = new Label(this.fileSyncComposite, 64);
        label.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        data = new GridData(1, 1, false, false);
        label.setLayoutData((Object)data);
        Text infoText = new Text(this.fileSyncComposite, 72);
        infoText.setBackground(this.fileSyncComposite.getBackground());
        infoText.setForeground(this.fileSyncComposite.getForeground());
        infoText.setText(Messages.infoOnlyServerConfigSynchronized);
        data = new GridData(4, 1, true, false);
        data.widthHint = 500;
        infoText.setLayoutData((Object)data);
        this.fileSyncComposite.setVisible(!this.looseConfigEnabled);
        if (containerNames.length > 0) {
            this.selectedContainerName = containerNames[0];
            this.selectedContainer = this.getDockerContainer(this.selectedContainerName);
            this.containerCombo.setText(this.selectedContainerName);
            this.userText.setFocus();
        } else {
            this.containerCombo.setFocus();
        }
        Dialog.applyDialogFont((Control)this);
    }

    protected void createDummyLabel(Composite composite, int length) {
        Label label = new Label((Composite)this.connectionInfo, 0);
        if (length > 0) {
            char[] charArray = new char[length];
            Arrays.fill(charArray, ' ');
            label.setText(new String(charArray));
        }
    }

    protected void init() {
        this.wizard.setTitle(Messages.wizDockerServerTitle);
        this.wizard.setDescription(Messages.wizDockerServerDescription);
        if (this.server == null) {
            return;
        }
        this.server.setDefaults((IProgressMonitor)new NullProgressMonitor());
        this.server.setLooseConfigEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialValidate() {
        Map<String, String> info = this.getCommandServiceInfo();
        IPlatformHandler handler = null;
        try {
            handler = PlatformHandlerFactory.getPlatformHandler(info, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.COMMAND);
            handler.startSession();
        }
        catch (Exception e) {
            this.wizard.setMessage(Messages.wizDockerMachineConnectionError, 3);
            this.wizard.update();
            this.setEnabled(false);
            Trace.logError("Failed to start session with  machine: " + info.get("hostname"), e);
            return;
        }
        finally {
            try {
                if (handler != null) {
                    handler.endSession();
                }
            }
            catch (ConnectException e) {
                Trace.logError("Failed to end session with machine: " + info.get("hostname"), e);
            }
        }
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        if (this.containerNameMap == null) {
            this.refreshContainers();
        }
        if (this.containerNameMap.isEmpty()) {
            this.wizard.setMessage(Messages.wizDockerNoContainersFound, 3);
            this.wizard.update();
            return;
        }
    }

    protected void clearContainers() {
        this.containerNameMap = null;
        this.containersInUse = null;
        this.containerCombo.removeAll();
    }

    public void validate() {
        if (this.containerNameMap == null) {
            this.isComplete = false;
            return;
        }
        boolean bl = this.isComplete ? true : (this.isComplete = false);
        if (this.containerNameMap.isEmpty()) {
            this.wizard.setMessage(Messages.wizDockerNoContainersFound, 3);
            this.wizard.update();
            return;
        }
        if (this.selectedContainer == null) {
            this.wizard.setMessage(Messages.wizDockerContainerNameNotSet, 3);
            this.wizard.update();
            return;
        }
        if (this.userName == null || this.userName.isEmpty()) {
            this.wizard.setMessage(Messages.wizDockerUserNotSet, 3);
            this.wizard.update();
            return;
        }
        if (this.userPassword == null || this.userPassword.isEmpty()) {
            this.wizard.setMessage(Messages.wizDockerPasswordNotSet, 3);
            this.wizard.update();
            return;
        }
        if (this.portNum == null || this.portNum.isEmpty()) {
            this.portNum = DEFAULT_PORT;
        } else {
            try {
                int port = Integer.parseInt(this.portNum);
                if (port < 1 || port > 65535) {
                    this.wizard.setMessage(Messages.wizDockerPortNotSet, 3);
                    this.wizard.update();
                    return;
                }
            }
            catch (Throwable t) {
                this.wizard.setMessage(Messages.wizDockerPortNotSet, 3);
                this.wizard.update();
                return;
            }
        }
        this.wizard.setMessage(null, 0);
        this.connectButton.setEnabled(true);
        this.wizard.update();
    }

    protected void refreshContainers() {
        this.refreshContainers(null);
    }

    private void refreshContainers(String selectContainerName) {
        this.containerNameMap = this.createContainerNameMap();
        Set<String> nameSet = this.containerNameMap.keySet();
        Object[] containerNames = nameSet.toArray(new String[nameSet.size()]);
        Arrays.sort(containerNames);
        this.containerCombo.setItems((String[])containerNames);
        if (containerNames.length > 0) {
            if (selectContainerName != null) {
                this.containerCombo.setText(selectContainerName);
            } else {
                this.selectedContainerName = containerNames[0];
                this.selectedContainer = this.getDockerContainer(this.selectedContainerName);
                this.containerCombo.setText(this.selectedContainerName);
            }
            this.userText.setFocus();
        } else {
            this.containerCombo.setFocus();
        }
        this.containersInUseLink.setVisible(!this.containersInUse.isEmpty());
    }

    protected void handleConnect(BaseDockerContainer container) {
        this.validate();
        if (this.wizard.getMessageType() != 0) {
            return;
        }
        if (this.serverSetup == null || this.serverSetupUpdateNeeded) {
            this.serverSetup = this.getServerSetup(container);
            try {
                if (this.serverSetup.getServerXML() != null) {
                    this.serverSetupUpdateNeeded = false;
                }
            }
            catch (Exception e) {
                Trace.logError("Failed to get the server.xml from Docker container", e);
                return;
            }
        }
        if (this.serverSetup.getServerXML() != null) {
            ArrayList validation = this.remoteSecurityValidation(this.serverSetup);
            block1 : switch ((Integer)validation.get(0)) {
                case -1: {
                    this.wizard.setMessage(Messages.wizDockerMissingServerXML, 3);
                    return;
                }
                case 0: {
                    break;
                }
                case 1: {
                    MessageDialog dg = new MessageDialog(this.getShell(), Messages.wizDockerSecuDiaTitle, null, NLS.bind((String)Messages.wizDockerNoRegOrUser, (Object)this.getUserId()), 6, new String[]{Messages.wizDockerNoUserCreateButton, Messages.wizDockerNoUserProceedButton, IDialogConstants.CANCEL_LABEL}, 0);
                    switch (dg.open()) {
                        case 0: {
                            this.remoteSecurityUpdate(this.serverSetup, 1);
                            break block1;
                        }
                        case 1: {
                            break block1;
                        }
                        case 2: {
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    this.wizard.setMessage(Messages.wizDockerUserMismatch, 3);
                    return;
                }
                case 4: {
                    this.wizard.setMessage(Messages.wizDockerPWMismatch, 3);
                    return;
                }
                case 8: {
                    boolean addAdmin = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.wizDockerSecuDiaTitle, (String)Messages.wizDockerNotAdmin);
                    if (addAdmin) {
                        this.remoteSecurityUpdate(this.serverSetup, 8);
                        break;
                    }
                    return;
                }
            }
        } else {
            this.wizard.setMessage(Messages.wizDockerMissingServerXML, 3);
            return;
        }
        MultiStatus multiStatus = this.remoteConfigSetup(this.serverSetup);
        if (this.serverConfigDir != null) {
            this.remoteServerOutputPath.setText(this.serverConfigDir);
        } else {
            this.remoteServerOutputPath.setText("");
        }
        this.remoteServerOutputPath.getParent().layout();
        if (multiStatus.isOK()) {
            this.isComplete = true;
            this.connectButton.setEnabled(false);
            this.setTreeInput();
        } else {
            this.isComplete = false;
            this.connectButton.setEnabled(true);
            for (IStatus status : multiStatus.getChildren()) {
                if (status == null || status.isOK()) continue;
                this.wizard.setMessage(status.getMessage(), 3);
                break;
            }
            this.setTreeInput(null);
        }
        this.wizard.update();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IPath workspacePath = this.getWorkspacePath(this.selectedContainer);
        boolean createNewContainer = false;
        LibertyDockerRunUtility.MountProperty existingVolumeStatus = LibertyDockerRunUtility.checkContainerForLooseConfigMountVolume((BaseDockerContainer)this.selectedContainer, this.serviceInfo, (IPath)workspacePath);
        if (this.looseConfigEnabled && this.needsNewContainerForLooseConfig(this.selectedContainer, workspacePath, existingVolumeStatus)) {
            final int[] answer = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dg = new MessageDialog(LibertyDockerComposite.this.getShell(), Messages.wizDockerSupportLooseConfigTitle, null, Messages.wizDockerContainerNotEnabledForLooseConfig, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    answer[0] = dg.open();
                }
            });
            if (answer[0] == 0) {
                createNewContainer = true;
            } else if (answer[0] == 1) {
                this.looseConfigEnabled = false;
            } else if (answer[0] == 2) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.saveCredentials();
        UserDirectory userDir = null;
        if (!existingVolumeStatus.equals((Object)LibertyDockerRunUtility.MountProperty.OTHER_USR_MOUNT)) {
            userDir = this.createUserDir(this.generateUserDirName(), (IProgressMonitor)subMonitor.newChild(createNewContainer ? 30 : 100));
        } else {
            this.addMandatoryVolumes();
            userDir = this.createExternalUserDir(null, (IProgressMonitor)subMonitor.newChild(createNewContainer ? 30 : 100));
        }
        LibertyDockerServer serverExt = (LibertyDockerServer)this.server.getAdapter(LibertyDockerServer.class);
        if (createNewContainer) {
            try {
                String newContainerName = LibertyDockerRunUtility.setupNewContainer((UserDirectory)userDir, (IPath)workspacePath, (BaseDockerContainer)this.selectedContainer, this.getServiceInfo(this.selectedContainer), (WebSphereServer)this.server, (LibertyDockerRunUtility.MountProperty)existingVolumeStatus, (IProgressMonitor)subMonitor.newChild(70));
                if (newContainerName != null && !newContainerName.isEmpty()) {
                    serverExt.setCurrentRunStatus(newContainerName, "run", false, true, this.server);
                }
                this.server.setLooseConfigEnabled(false);
                serverExt.setLooseConfigEnabled(false, this.server);
            }
            catch (ConnectException e) {
                Status status = new Status(4, "com.ibm.ws.st.docker.ui", Messages.wizDockerConnectExceptionDialogDetails, (Throwable)e);
                if (Trace.ENABLED) {
                    Trace.logError("Failed to create new container for supporting loose config.", e);
                }
                throw new CoreException((IStatus)status);
            }
            catch (IOException e) {
                Status status = new Status(4, "com.ibm.ws.st.docker.ui", Messages.wizDockerIOExceptionDialogDetails, (Throwable)e);
                if (Trace.ENABLED) {
                    Trace.logError("Failed to create new container for supporting loose config.", e);
                }
                throw new CoreException((IStatus)status);
            }
            catch (Exception e) {
                Status status = new Status(4, "com.ibm.ws.st.docker.ui", Messages.wizDockerExceptionDialogDetails, (Throwable)e);
                if (Trace.ENABLED) {
                    Trace.logError("Failed to create new container for supporting loose config.", e);
                }
                throw new CoreException((IStatus)status);
            }
        } else {
            this.server.setLooseConfigEnabled(this.looseConfigEnabled);
            serverExt.setLooseConfigEnabled(this.looseConfigEnabled, this.server);
        }
    }

    protected IPath getWorkspacePath(BaseDockerContainer container) {
        IPath workspacePath = null;
        if (this.server != null && this.server.getWebSphereRuntime() != null) {
            workspacePath = this.server.getWebSphereRuntime().getProject().getWorkspace().getRoot().getLocation();
        }
        if (workspacePath == null) {
            workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        workspacePath = BaseDockerContainer.getLocalToContainerPath(workspacePath);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Workspace path is " + workspacePath);
        }
        return workspacePath;
    }

    protected boolean needsNewContainerForLooseConfig(BaseDockerContainer container, IPath workspacePath, LibertyDockerRunUtility.MountProperty existingVolumeStatus) {
        block3: {
            try {
                String usrMount = container.getMountSourceForDestination(LibertyDockerRunUtility.getLibertyUsrPath(this.serviceInfo));
                IPath looseConfigPathMount = container.getMountDestinationForSource(workspacePath);
                if (usrMount != null && looseConfigPathMount != null && !looseConfigPathMount.equals((Object)"") && existingVolumeStatus.equals((Object)LibertyDockerRunUtility.MountProperty.SAME_USR_MOUNT)) {
                    return false;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.logError("Failed to determine if the " + container.getContainerName() + " container is already set up for running applications directly from the workspace", e);
            }
        }
        return true;
    }

    private String generateUserDirName() {
        String userDirId = this.selectedContainer.getContainerName();
        AbstractDockerMachine machine = this.selectedContainer.getDockerMachine();
        if (machine.isRealMachine()) {
            userDirId = NLS.bind((String)Messages.wizDockerContainerNameFormat, (Object[])new String[]{userDirId, machine.getMachineName()});
        }
        if (!this.isLocalHost && this.hostname != null && !this.hostname.isEmpty()) {
            userDirId = NLS.bind((String)Messages.dockerUserDirName, (Object[])new String[]{userDirId, this.hostname});
        }
        return RemoteUtils.generateRemoteUsrDirName((WebSphereRuntime)this.server.getWebSphereRuntime(), (String)userDirId);
    }

    protected void performCancel() {
        this.discardTemporaryFiles();
    }

    protected String getHost() {
        return this.getHost(this.selectedContainer);
    }

    protected String getHost(BaseDockerContainer container) {
        String host = null;
        if (this.server != null && SocketUtil.isLocalhost((String)this.server.getServer().getHost())) {
            try {
                host = container.getHostMappedIP(this.portNum);
            }
            catch (Exception e) {
                String name = container != null ? container.getContainerName() : "unknown";
                Trace.logError("Could not get host mapped IP for the " + name + " container and port " + this.portNum, e);
            }
        }
        if (host == null && this.server != null) {
            host = this.server.getServer().getHost();
        }
        return host;
    }

    protected BaseDockerContainer getDockerContainer(String name) {
        if (name == null || this.containerNameMap == null) {
            return null;
        }
        return this.containerNameMap.get(name);
    }

    protected String getUserId() {
        return this.userName;
    }

    protected String getUserPassword() {
        return this.userPassword;
    }

    protected String getPort() {
        String port = null;
        try {
            port = this.selectedContainer.getHostMappedPort(this.portNum);
        }
        catch (Exception e) {
            String name = this.selectedContainer != null ? this.selectedContainer.getContainerName() : "unknown";
            String traceError = "Could not get port mapping for the " + name + " container and port " + this.portNum;
            Trace.logError(traceError, e);
            String errMsg = NLS.bind((String)Messages.wizDockerMappedPortErrorMsg, (Object)this.portNum, (Object)name);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.wizDockerConnectExceptionDialogTitle, (String)errMsg);
            throw new OperationCanceledException(traceError);
        }
        if (port == null) {
            port = this.portNum;
        }
        return port;
    }

    protected void setTreeInput() {
        if (this.serverWC == null) {
            return;
        }
        Document document = this.getServerConfigDocument();
        this.setTreeInput(document);
    }

    protected void setTreeInput(Document document) {
        try {
            if (document == null) {
                this.treeViewer.setInput((Object)this.getEmptyConfigMsg());
                return;
            }
            WebSphereRuntime wrt = this.server == null ? null : this.server.getWebSphereRuntime();
            boolean metadataDirExistsBefore = wrt == null ? false : wrt.metadataDirectoryExists();
            this.treeViewer.setInput((Object)document.getDocumentElement());
            if (!metadataDirExistsBefore && wrt != null && wrt.metadataDirectoryExists()) {
                this.addMetaDataRuntimeId(wrt.getRuntime());
            }
        }
        catch (Throwable t) {
            Trace.logError("Error loading config tree", t);
        }
    }

    private void saveCredentials() {
        this.server.setLooseConfigEnabled(this.looseConfigEnabled);
        this.server.setServerUserName(this.userName);
        this.server.setServerPassword(this.userPassword);
        this.server.setServerSecurePort(this.portNum);
        this.server.setServerType(SERVER_TYPE);
        this.server.setServiceInfo(this.serviceInfo);
        this.server.setStopTimeout(60);
        this.setAdditionalVolumes();
    }

    private void setAdditionalVolumes() {
        LibertyDockerServer dockerServer = (LibertyDockerServer)this.server.getAdapter(LibertyDockerServer.class);
        if (dockerServer != null) {
            try {
                List moduleList = (List)this.taskModel.getObject("modules");
                if (moduleList != null && !moduleList.isEmpty()) {
                    HashSet newVolumes = new HashSet();
                    Map containerVolumes = this.selectedContainer.getMountedVolumeHash();
                    for (IModule[] module : moduleList) {
                        LibertyDockerRunUtility.addModuleLocations((WebSphereServer)this.server, (Map)containerVolumes, newVolumes, (IModule)module[module.length - 1]);
                    }
                    dockerServer.setAdditionalVolumes(this.server, newVolumes);
                }
            }
            catch (Exception e) {
                Trace.logError("Failed to calculate any additional volumes needed for added modules to the " + this.server.getServer().getName() + " server.", e);
            }
        }
    }

    private void addMandatoryVolumes() {
        LibertyDockerServer dockerServer = (LibertyDockerServer)this.server.getAdapter(LibertyDockerServer.class);
        if (dockerServer != null) {
            try {
                Map containerVolumes = this.selectedContainer.getMountedVolumeHash();
                Set volumes = containerVolumes.keySet();
                ArrayList<IPath> workspaceMountVolumes = new ArrayList<IPath>();
                for (IPath volume : volumes) {
                    String aVolume = ((IPath)containerVolumes.get(volume)).toString();
                    if (aVolume.equals(LibertyDockerRunUtility.getLibertyUsrPath(this.serviceInfo)) || !aVolume.startsWith(LibertyDockerRunUtility.getLibertyStdevPath(this.serviceInfo))) continue;
                    workspaceMountVolumes.add(volume);
                }
                dockerServer.addMandatoryVolumes(this.server, workspaceMountVolumes);
            }
            catch (Exception e) {
                Trace.logError("Failed to calculate any additional volumes needed for added modules to the " + this.server.getServer().getName() + " server.", e);
            }
        }
    }

    protected List<BaseDockerContainer> getDockerContainers(List<AbstractDockerMachine> machines, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.beginTask(null, 100);
        ArrayList<BaseDockerContainer> libertyContainers = new ArrayList<BaseDockerContainer>();
        if (machines.isEmpty()) {
            subMonitor.worked(100);
            return libertyContainers;
        }
        int machineWork = 100 / machines.size();
        for (AbstractDockerMachine machine : machines) {
            try {
                List containers = machine.getContainers(false);
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "All containers for machine " + machine + ": " + containers);
                }
                if (containers.isEmpty()) {
                    subMonitor.worked(machineWork);
                    continue;
                }
                int containerWork = machineWork / containers.size();
                for (BaseDockerContainer container : containers) {
                    if (LibertyDockerUtil.isLibertyContainer(container)) {
                        libertyContainers.add(container);
                    }
                    if (monitor.isCanceled()) {
                        return libertyContainers;
                    }
                    subMonitor.worked(containerWork);
                }
            }
            catch (Exception e) {
                if (machine.isRealMachine()) {
                    Trace.logError("Could not get the list of liberty containers for machine: " + machine.getMachineName() + ".", e);
                    continue;
                }
                Trace.logError("Could not get the list of liberty containers.", e);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "All liberty containers: " + libertyContainers);
        }
        return libertyContainers;
    }

    protected Map<String, BaseDockerContainer> createContainerNameMap() {
        this.containerNameMap = new HashMap<String, BaseDockerContainer>();
        this.containersInUse = new HashMap<String, String>();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor mon) throws InvocationTargetException {
                IPlatformHandler handler = null;
                try {
                    IProgressMonitor monitor = mon;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    subMonitor.beginTask(Messages.wizDockerServerGatheringContainers, 100);
                    Map<String, String> info = LibertyDockerComposite.this.getCommandServiceInfo();
                    handler = PlatformHandlerFactory.getPlatformHandler(info, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.COMMAND);
                    List machines = AbstractDockerMachine.getDockerMachines((IPlatformHandler)handler);
                    if (mon.isCanceled()) {
                        return;
                    }
                    monitor.worked(30);
                    List<BaseDockerContainer> containers = LibertyDockerComposite.this.getDockerContainers(machines, (IProgressMonitor)subMonitor.newChild(60));
                    if (mon.isCanceled()) {
                        return;
                    }
                    for (BaseDockerContainer container : containers) {
                        WebSphereServer serverUsing;
                        String machineName;
                        String containerName = container.getContainerName();
                        if (machines.size() > 1 && (machineName = container.getDockerMachine().getMachineName()) != null) {
                            containerName = NLS.bind((String)Messages.wizDockerContainerNameFormat, (Object[])new String[]{containerName, machineName});
                        }
                        if ((serverUsing = LibertyDockerComposite.this.getServerUsingContainer(container)) != null) {
                            LibertyDockerComposite.this.containersInUse.put(containerName, serverUsing.getServer().getName());
                            continue;
                        }
                        LibertyDockerComposite.this.containerNameMap.put(containerName, container);
                    }
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Container name map: " + LibertyDockerComposite.this.containerNameMap);
                    }
                    if (mon.isCanceled()) {
                        return;
                    }
                    monitor.worked(10);
                    monitor.done();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.wizard.run(true, true, runnable);
        }
        catch (Exception e) {
            Trace.logError("Exception thrown while trying to obtain Docker containers running WebSphere Liberty.", e);
        }
        return this.containerNameMap;
    }

    protected WebSphereServer getServerUsingContainer(BaseDockerContainer container) {
        for (WebSphereServer server : WebSphereUtil.getWebSphereServers()) {
            String machineType;
            String machineName;
            if (!SERVER_TYPE.equals(server.getServerType())) continue;
            String serverHost = server.getServer().getHost();
            if ((this.hostname == null || !this.hostname.equals(serverHost)) && (this.hostname != null || serverHost != null)) continue;
            Map serviceInfo = server.getServiceInfo();
            String containerName = (String)serviceInfo.get("dockerContainer");
            if (this.containerMatch(container, containerName, machineName = (String)serviceInfo.get("dockerMachine"), machineType = (String)serviceInfo.get("dockerMachineType"))) {
                return server;
            }
            LibertyDockerServer dockerServer = (LibertyDockerServer)server.getAdapter(LibertyDockerServer.class);
            if (dockerServer.isUserContainer(server) || !this.containerMatch(container, containerName = dockerServer.getContainerName(server), machineName, machineType)) continue;
            return server;
        }
        return null;
    }

    protected boolean containerMatch(BaseDockerContainer container, String containerName, String machineName, String machineType) {
        if (container.getContainerName().equals(containerName)) {
            AbstractDockerMachine.MachineType type2;
            AbstractDockerMachine.MachineType type1;
            String machineName2 = container.getDockerMachine().getMachineName();
            if ((machineName == null && machineName2 == null || machineName != null && machineName.equals(machineName2)) && (type1 = AbstractDockerMachine.getMachineType((String)machineType, (String)machineName)) == (type2 = container.getDockerMachine().getMachineType())) {
                return true;
            }
        }
        return false;
    }

    protected AbstractServerSetup getServerSetup(BaseDockerContainer container) {
        this.serviceInfo = this.getServiceInfo(container);
        try {
            AbstractServerSetup serverSetup = ServerSetupFactory.getServerSetup((String)"LibertyDockerLocal", this.serviceInfo, (IRuntime)this.server.getWebSphereRuntime().getRuntime());
            return serverSetup;
        }
        catch (Exception e) {
            Trace.logError("Failed to create LibertyDockerLocal server setup.", e);
            return null;
        }
    }

    public void clearMessage() {
        this.wizard.setMessage(null, 0);
    }

    protected Map<String, String> getServiceInfo(BaseDockerContainer container) {
        Map<String, String> serviceInfo = LibertyDockerUtil.getServiceInfo(container, this.server, this.serverWC.getHost(), this.getPort());
        serviceInfo.putAll(this.getCommandServiceInfo());
        return serviceInfo;
    }

    protected Map<String, String> getCommandServiceInfo() {
        HashMap<String, String> serviceInfo = new HashMap<String, String>();
        if (this.taskModel != null) {
            IServerWorkingCopy server = (IServerWorkingCopy)this.taskModel.getObject("server");
            serviceInfo.put("hostname", server.getHost());
            Map<String, String> info = this.getTaskModelServiceInfo();
            serviceInfo.putAll(info);
        }
        return serviceInfo;
    }

    protected Map<String, String> getTaskModelServiceInfo() {
        Map serviceInfo = null;
        if (this.taskModel != null) {
            serviceInfo = (Map)this.taskModel.getObject("com.ibm.ws.st.ui.serviceInfo");
        }
        if (serviceInfo == null) {
            serviceInfo = Collections.emptyMap();
        }
        return serviceInfo;
    }

    private UserDirectory createExternalUserDir(String userDirName, IProgressMonitor monitor) throws CoreException {
        UserDirectory userDir = null;
        this.server.setServerName(this.serverName);
        WebSphereRuntime wsRuntime = this.server.getWebSphereRuntime();
        String usrMount = null;
        try {
            usrMount = this.selectedContainer.getMountSourceForDestination(LibertyDockerRunUtility.getLibertyUsrPath(this.serviceInfo));
        }
        catch (Exception e) {
            Trace.logError("Failed to get the user path of the container ", e);
            Status status = new Status(4, "com.ibm.ws.st.docker.ui", Messages.wizDockerExceptionDialogDetails, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        if (usrMount == null) {
            Trace.logError("Expecting a non-null usr mount volume, otherwise, the container will be created the usual way.", null);
            Status status = new Status(4, "com.ibm.ws.st.docker.ui", Messages.wizDockerExceptionDialogDetails, null);
            throw new CoreException((IStatus)status);
        }
        String projectName = usrMount.substring(usrMount.lastIndexOf("/") + 1);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            Trace.logError("An existing project link to the target external project already exists.", null);
            Status status = new Status(4, "com.ibm.ws.st.docker.ui", NLS.bind((String)Messages.wizDockerExistingProjectOverlaps, (Object)projectName), null);
            throw new CoreException((IStatus)status);
        }
        usrMount = BaseDockerContainer.getContainerToLocalPath((IPath)new Path(usrMount)).toString();
        IProject externalUsrProject = WebSphereUtil.createUserProject((String)projectName, (IPath)new Path(usrMount), (IProgressMonitor)monitor);
        IPath outputPath = externalUsrProject.getLocation().append("servers");
        userDir = new UserDirectory(wsRuntime, (IPath)new Path(usrMount), externalUsrProject, outputPath, (IPath)new Path(this.remoteUserPath));
        IRuntimeWorkingCopy runtimeWorkingCopy = wsRuntime.getRuntime().createWorkingCopy();
        WebSphereRuntime wRuntimeWorkingCopy = (WebSphereRuntime)runtimeWorkingCopy.loadAdapter(WebSphereRuntime.class, null);
        boolean found = false;
        for (UserDirectory usr : wRuntimeWorkingCopy.getUserDirectories()) {
            if (!usr.getPath().equals((Object)userDir.getPath())) continue;
            found = true;
            break;
        }
        if (!found) {
            wRuntimeWorkingCopy.addUserDirectory(userDir);
        }
        try {
            runtimeWorkingCopy.save(true, null);
        }
        catch (CoreException ce) {
            Trace.logError(ce.getMessage(), ce);
        }
        wsRuntime.updateServerCache(true);
        wsRuntime = this.server.getWebSphereRuntime();
        this.server.setUserDir(userDir);
        this.server.setLooseConfigEnabled(true);
        return userDir;
    }
}

