/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal.wizard;

import com.ibm.ws.st.docker.ui.internal.Activator;
import com.ibm.ws.st.docker.ui.internal.Messages;
import com.ibm.ws.st.docker.ui.internal.Trace;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ContainersInUseDialog
extends TitleAreaDialog {
    private final Map<String, String> containerAndServerNames;

    public ContainersInUseDialog(Shell parentShell, Map<String, String> containerAndServerNames) {
        super(parentShell);
        this.containerAndServerNames = containerAndServerNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.containersInUseDialogBoldMessage);
        this.setMessage(Messages.wizDockerInUseContainersCannotCreateNewServer);
        this.setTitleImage(Activator.getImage("wizServer"));
        GridLayout dialogLayout = (GridLayout)dialogArea.getLayout();
        dialogLayout.marginWidth = 10;
        dialogLayout.marginHeight = 10;
        Table containersTable = new Table(dialogArea, 526336);
        containersTable.setHeaderVisible(true);
        containersTable.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn containerNamesCol = new TableColumn(containersTable, 0);
        containerNamesCol.setText(Messages.containersInUseDialogTableColumnContainersHeader);
        TableColumn serverNamesCol = new TableColumn(containersTable, 0);
        serverNamesCol.setText(Messages.containersInUseDialogTableColumnServersHeader);
        for (Map.Entry<String, String> entry : this.containerAndServerNames.entrySet()) {
            TableItem item = new TableItem(containersTable, 0);
            item.setText(new String[]{entry.getKey(), entry.getValue()});
            if (!Trace.ENABLED) continue;
            Trace.trace((byte)0, "Container " + entry.getKey() + " in use by server " + entry.getValue());
        }
        for (TableColumn column : containersTable.getColumns()) {
            column.pack();
        }
        return dialogArea;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.containersInUseDialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

