/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal;

import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.docker.core.internal.AbstractFlattenImageHandler;
import com.ibm.ws.st.docker.ui.internal.Messages;
import com.ibm.ws.st.docker.ui.internal.Trace;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FlattenImageHandler
extends AbstractFlattenImageHandler {
    public boolean handleFlattenImage(final BaseDockerContainer container, final String newImageName) {
        final Boolean[] isFlattened = new Boolean[]{Boolean.FALSE};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean flatten;
                    final String currentImage = container.getImageName();
                    final Shell shell = Display.getDefault().getActiveShell();
                    if (!PromptUtil.isSuppressDialog()) {
                        flatten = MessageDialog.openQuestion((Shell)shell, (String)Messages.dockerFlattenImageTitle, (String)NLS.bind((String)Messages.dockerFlattenImageMessage, (Object)currentImage));
                    } else {
                        System.out.println("Suppressing flattening dialog; image " + currentImage + " will be flattened.");
                        flatten = true;
                    }
                    if (flatten) {
                        new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    isFlattened[0] = container.flatten(newImageName, monitor);
                                }
                                catch (Throwable t) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)shell, (String)NLS.bind((String)Messages.dockerFlattenImageError, (Object)currentImage), (String)t.getLocalizedMessage());
                                        }
                                    });
                                    throw new InvocationTargetException(t);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Trace.logError("Failed to flatten the image for the " + container.getContainerName() + " container.", e);
                }
            }
        });
        return isFlattened[0];
    }
}

