/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.xml.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMBasedLibertyBuildPluginConfigurationBuilder {
    private final LibertyBuildPluginConfiguration config;

    DOMBasedLibertyBuildPluginConfigurationBuilder(long lastModified) {
        this.config = new LibertyBuildPluginConfiguration(lastModified);
    }

    public void buildModel(Element rootElement) {
        this.checkChildElements(rootElement);
    }

    public LibertyBuildPluginConfiguration getModel() {
        return this.config;
    }

    private void checkChildElements(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            this.addToModel((Element)child);
        }
    }

    private void addToModel(Element elem) {
        if (elem == null) {
            return;
        }
        ConfigurationType type = null;
        try {
            type = ConfigurationType.valueOf(elem.getNodeName());
        }
        catch (Exception e) {
            Trace.logError(elem.getNodeName() + " is not a supported liberty configuration element and will be ignored.", null);
        }
        if (type == null) {
            return;
        }
        try {
            switch (type) {
                case activeBuildProfiles: {
                    this.handleActiveBuildProfiles(elem);
                    break;
                }
                case applications: {
                    this.handleApplications(elem);
                    break;
                }
                case bootstrapProperties: {
                    this.handleBootstrapProperties(elem);
                    break;
                }
                case jvmOptions: {
                    this.handleJVMOptions(elem);
                    break;
                }
                case projectCompileDependency: {
                    this.handleProjectCompileDependencies(elem);
                    break;
                }
                case servers: {
                    this.handleServers(elem);
                    break;
                }
                default: {
                    this.setValue(type, elem);
                    break;
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Failed to parse data for liberty configuration element: " + elem.getNodeName(), e);
        }
    }

    private void handleApplications(Element elem) {
        NodeList children = elem.getChildNodes();
        int numOfChildren = children.getLength();
        for (int i = 0; i < numOfChildren; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("application")) continue;
            this.checkChildElements((Element)child);
            break;
        }
    }

    private void handleServers(Element elem) {
        NodeList children = elem.getChildNodes();
        int numOfChildren = children.getLength();
        for (int i = 0; i < numOfChildren; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("server")) continue;
            this.checkChildElements((Element)child);
            break;
        }
    }

    private void handleActiveBuildProfiles(Element elem) {
        NodeList children = elem.getChildNodes();
        ArrayList<String> profiles = new ArrayList<String>(5);
        for (int i = 0; i < children.getLength(); ++i) {
            String profile;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("profileId") || (profile = child.getTextContent().trim()) == null || profile.isEmpty()) continue;
            profiles.add(profile);
        }
        this.config.setActiveBuildProfiles(profiles);
    }

    private void handleBootstrapProperties(Element elem) {
        NodeList children = elem.getChildNodes();
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String key = child.getNodeName();
            String prop = child.getTextContent().trim();
            if (key == null || key.isEmpty() || prop == null || prop.isEmpty()) continue;
            props.put(key, prop);
        }
        this.config.setBootstrapProperties(props);
    }

    private void handleJVMOptions(Element elem) {
        NodeList children = elem.getChildNodes();
        ArrayList<String> params = new ArrayList<String>(5);
        for (int i = 0; i < children.getLength(); ++i) {
            String param;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("param") || (param = child.getTextContent().trim()) == null || param.isEmpty()) continue;
            params.add(param);
        }
        this.config.setJvmOptions(params);
    }

    private void handleProjectCompileDependencies(Element elem) {
        String param = elem.getTextContent().trim();
        if (param != null && !param.isEmpty()) {
            this.config.addProjectCompileDependency(param);
        }
    }

    private void setValue(ConfigurationType type, Element elem) {
        this.config.setConfigValue(type, elem.getTextContent().trim());
    }
}

