/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.servertype.internal;

import com.ibm.ws.st.core.internal.ExcludeSyncModuleInfo;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.jee.core.internal.JEEPublisher;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImpl;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImplProvider;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.manager.internal.AbstractLibertyProjectMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public abstract class AbstractLibertyBuildPluginJEEPublisher
extends JEEPublisher
implements ILibertyBuildPluginImplProvider {
    ILibertyBuildPluginImpl buildPluginHelper = this.getBuildPluginImpl();
    AbstractLibertyProjectMapping mappingHandler = this.getBuildPluginImpl().getMappingHandler();

    public void postPublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
        super.postPublishApplication(kind, app, status, monitor);
    }

    public void handleLooseConfigModeChange(int kind, PublishUnit pu, MultiStatus multi, IProgressMonitor monitor) {
    }

    protected String getPathToPublishedModule(LibertyBuildPluginConfiguration config) {
        String serverDir = config.getConfigValue(ConfigurationType.serverDirectory);
        String appsDir = config.getConfigValue(ConfigurationType.appsDirectory);
        String appName = config.getConfigValue(ConfigurationType.applicationFilename);
        Trace.trace((byte)0, "serverDir: " + serverDir + " appsDir:" + appsDir + " appName:" + appName);
        String pathToPublishedModule = "";
        if (serverDir != null && appsDir != null && appName != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(serverDir);
            buffer.append("/");
            buffer.append(appsDir);
            buffer.append("/");
            buffer.append(appName);
            pathToPublishedModule = buffer.toString();
        }
        return pathToPublishedModule;
    }

    public void prePublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
        super.prePublishApplication(kind, app, status, monitor);
    }

    protected String getModuleDeployName(IModule module) {
        String deployName;
        LibertyBuildPluginConfiguration config;
        IProject moduleProject = module.getProject();
        if (moduleProject != null && (config = this.buildPluginHelper.getLibertyBuildPluginConfiguration(moduleProject, (IProgressMonitor)new NullProgressMonitor())) != null && (deployName = config.getConfigValue(ConfigurationType.applicationFilename)) != null && !deployName.isEmpty()) {
            if (deployName.endsWith(".xml")) {
                deployName = deployName.substring(0, deployName.length() - 4);
            }
            return deployName;
        }
        return super.getModuleDeployName(module);
    }

    public boolean requireConsoleOutputBeforePublishComplete(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        int kind2 = unit.getDeltaKind();
        if (kind2 == 1 && !this.getAddedResourceList().isEmpty() || kind2 == 3) {
            return true;
        }
        if (this.getAddedResourceList().isEmpty() && this.getRemovedResourceList().isEmpty() && this.getChangedResourceList().isEmpty()) {
            return false;
        }
        return this.checkFileExtension(this.getAddedResourceList()) || this.checkFileExtension(this.getChangedResourceList()) || this.checkFileExtension(this.getRemovedResourceList());
    }

    protected IPath getAppsPathOverride() {
        AbstractLibertyProjectMapping.ProjectMapping mapping;
        IProject moduleProject;
        WebSphereServer wsServer = this.getWebSphereServer();
        if (wsServer != null && (moduleProject = this.mappingHandler.getMappedProject(wsServer.getServer())) != null && (mapping = this.mappingHandler.getMapping(moduleProject.getName())) != null && mapping.getServerID().equals(wsServer.getServer().getId())) {
            LibertyBuildPluginConfiguration config = this.buildPluginHelper.getLibertyBuildPluginConfiguration(moduleProject, (IProgressMonitor)new NullProgressMonitor());
            String serverDir = config.getConfigValue(ConfigurationType.serverDirectory);
            String appsDir = config.getConfigValue(ConfigurationType.appsDirectory);
            Trace.trace((byte)0, "serverDir: " + serverDir + " appsDir:" + appsDir);
            if (serverDir != null && appsDir != null) {
                Path returnPath = new Path(serverDir);
                returnPath = returnPath.append(appsDir);
                return returnPath;
            }
        }
        return null;
    }

    protected void removePublishedAppFiles(PublishUnit app, boolean looseCfg, MultiStatus multi, IProgressMonitor monitor) {
        ExcludeSyncModuleInfo info;
        HashMap map;
        WebSphereServer wsServer = this.getWebSphereServer();
        WebSphereServerBehaviour wsBehaviour = this.getWebSphereServerBehaviour();
        if (wsServer == null || wsBehaviour == null) {
            return;
        }
        IModule[] appModule = app.getModule();
        if (appModule != null && appModule.length > 0 && (map = wsBehaviour.getExcludeSyncModules()) != null && (info = (ExcludeSyncModuleInfo)map.get(appModule[0])) != null) {
            HashMap props = info.getProperties();
            if (props != null) {
                File toDelete;
                String fullAppPath;
                File toDelete2;
                String configDropins = (String)props.get("installAppsConfigDropins");
                boolean failedToRemove = false;
                if (configDropins != null && (toDelete2 = new File(configDropins)).exists()) {
                    if (!toDelete2.delete()) {
                        Trace.trace((byte)1, "Could not delete config dropins file: " + toDelete2.toString());
                    } else {
                        this.getRemovedResourceList().add(configDropins);
                        try {
                            this.notifyUpdatedApplicationResourcesViaJMX();
                        }
                        catch (Exception e) {
                            Trace.logError("Failed to notify app update via jmx", e);
                            failedToRemove = true;
                        }
                    }
                }
                if (!wsServer.isLooseConfigEnabled() && (fullAppPath = (String)props.get("fullAppPath")) != null && (toDelete = new File(fullAppPath)).exists() && !toDelete.delete()) {
                    Trace.trace((byte)1, "Could not delete application file: " + toDelete.toString());
                    failedToRemove = true;
                }
                if (failedToRemove) {
                    ArrayList<Status> status = new ArrayList<Status>();
                    status.add(new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", NLS.bind((String)Messages.errorPublishModule, (Object)app.getModule()[0].getName())));
                    multi.add(AbstractLibertyBuildPluginJEEPublisher.combineModulePublishStatus(status, (String)app.getModule()[0].getName()));
                }
            }
            map.remove(appModule[0]);
        }
    }
}

