/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.manager.internal;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.xml.internal.AbstractProjectMapXML;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractLibertyProjectMapping {
    private final ConcurrentHashMap<String, ProjectMapping> trackedLibertyProjects = new ConcurrentHashMap();
    private final Set<String> ignoredProjects = new HashSet<String>();

    protected AbstractLibertyProjectMapping() {
        this.initialize();
    }

    protected abstract IPath getPluginConfigPath();

    public abstract IPath getLibertyBuildProjectCachePath(String var1);

    synchronized void initialize() {
        try {
            this.getProjectMapXML().unmarshall(this.trackedLibertyProjects, this.ignoredProjects);
        }
        catch (FileNotFoundException e) {
            Trace.trace((byte)1, "The project mapping file does not exist.", e);
        }
        catch (Exception e) {
            Trace.logError("Failed to read Liberty project-server mapping metadata from file", e);
        }
    }

    protected abstract AbstractProjectMapXML getProjectMapXML();

    public ProjectMapping clearProjectMapping(IProject proj) {
        if (proj == null) {
            return null;
        }
        String projectName = proj.getName();
        Trace.trace((byte)0, "Clearing project mapping for project: " + projectName);
        ProjectMapping currentMapping = this.trackedLibertyProjects.get(projectName);
        if (currentMapping != null) {
            this.trackedLibertyProjects.put(projectName, new ProjectMapping());
            this.storeMap(proj);
        }
        return currentMapping;
    }

    private void cachePluginConfig(IProject proj) {
        IResource resource = proj.findMember(this.getPluginConfigPath());
        if (resource == null) {
            try {
                Trace.trace((byte)0, "Deleting outdated cached liberty build plugin config file");
                this.getLibertyBuildProjectCachePath(proj.getName()).toFile().delete();
            }
            catch (Exception e) {
                Trace.logError("Failed to delete outdated cached liberty build plugin config file.", e);
            }
            return;
        }
        URI configURI = resource.getLocationURI();
        try {
            FileUtil.copy((URL)configURI.toURL(), (IPath)this.getLibertyBuildProjectCachePath(proj.getName()));
        }
        catch (Exception e) {
            Trace.logError("Error caching liberty build plugin configuration", e);
        }
    }

    protected synchronized void mapProject(IProject proj, IRuntime runtime, IServer server) {
        ProjectMapping currentMapping;
        if (proj == null) {
            return;
        }
        String projectName = proj.getName();
        if (this.isIgnored(projectName)) {
            Trace.trace((byte)0, "Removing project from ignore list: " + projectName);
            this.ignoredProjects.remove(projectName);
        }
        if ((currentMapping = this.trackedLibertyProjects.get(projectName)) == null) {
            String runtimeID = runtime == null ? null : runtime.getId();
            String serverID = server == null ? null : server.getId();
            currentMapping = new ProjectMapping(runtimeID, serverID);
            this.trackedLibertyProjects.put(projectName, currentMapping);
            Trace.trace((byte)0, "Mapped project: " + projectName);
            this.storeMap(proj);
        } else {
            currentMapping.runtimeID = runtime == null ? null : runtime.getId();
            currentMapping.serverID = server == null ? null : server.getId();
            Trace.trace((byte)0, "Updated mapped project: " + projectName);
            this.storeMap(proj);
        }
        this.logMapping(projectName, currentMapping);
    }

    protected synchronized void ignoreProject(IProject proj) {
        if (proj == null) {
            return;
        }
        Trace.trace((byte)0, "Adding project to ignore list: " + proj.getName());
        this.ignoredProjects.add(proj.getName());
        this.storeMap(proj);
    }

    protected synchronized void removeIgnoredProject(IProject proj) {
        if (proj == null || !this.ignoredProjects.contains(proj)) {
            return;
        }
        Trace.trace((byte)0, "Removing project from ignore list: " + proj.getName());
        this.ignoredProjects.remove(proj.getName());
        this.storeMap(proj);
    }

    protected ProjectMapping unmapProject(IProject project) {
        if (project == null) {
            return null;
        }
        String projectName = project.getName();
        ProjectMapping mapping = this.trackedLibertyProjects.remove(projectName);
        this.ignoredProjects.remove(projectName);
        Trace.trace((byte)0, "Removed project from tracking list: " + projectName);
        Trace.trace((byte)0, "Removed project from ignore list: " + projectName);
        this.storeMap(project);
        return mapping;
    }

    protected ProjectMapping unmapAndIgnoreProject(IProject project) {
        if (project == null) {
            return null;
        }
        String projectName = project.getName();
        ProjectMapping mapping = this.trackedLibertyProjects.remove(projectName);
        this.ignoredProjects.add(projectName);
        Trace.trace((byte)0, "Removed project from tracking list: " + projectName);
        Trace.trace((byte)0, "Added project to ignore list: " + projectName);
        this.storeMap(project);
        return mapping;
    }

    private synchronized void storeMap(IProject proj) {
        try {
            this.cachePluginConfig(proj);
            this.getProjectMapXML().marshall(this.trackedLibertyProjects, this.ignoredProjects);
        }
        catch (Exception e) {
            Trace.logError("Failed to write Liberty build project-server mapping data to file", e);
        }
    }

    private void logMapping(String projectName, ProjectMapping currentMapping) {
        if (currentMapping == null) {
            Trace.logError("Liberty build project metadata error", null);
            return;
        }
        Trace.trace((byte)0, "Project [ " + projectName + " ] is mapped to runtime with ID { " + currentMapping.runtimeID + " } and server with ID { " + currentMapping.serverID + " }");
    }

    public boolean isEmpty() {
        return this.trackedLibertyProjects.isEmpty();
    }

    public Set<String> getMappedProjectSet() {
        return this.trackedLibertyProjects.keySet();
    }

    public boolean isTracked(String projectName) {
        return ((ConcurrentHashMap.KeySetView)this.trackedLibertyProjects.keySet()).contains(projectName);
    }

    public ProjectMapping getMapping(String projectName) {
        return this.trackedLibertyProjects.get(projectName);
    }

    public Set<String> getIgnoredProjectSet() {
        return this.ignoredProjects;
    }

    public synchronized boolean isIgnored(String projectName) {
        return this.ignoredProjects.contains(projectName);
    }

    public IProject getMappedProject(IServer server) {
        Set<String> mappedProjects = this.getMappedProjectSet();
        for (String project : mappedProjects) {
            ProjectMapping mapping = this.getMapping(project);
            if (mapping == null || !server.getId().equals(mapping.getServerID())) continue;
            return ResourcesPlugin.getWorkspace().getRoot().getProject(project);
        }
        return null;
    }

    public IProject[] getMappedProjects(IRuntime runtime) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (runtime != null) {
            Set<String> mappedProjects = this.getMappedProjectSet();
            for (String mappedProject : mappedProjects) {
                ProjectMapping mapping = this.getMapping(mappedProject);
                if (mapping == null || !runtime.getId().equals(mapping.getRuntimeID())) continue;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(mappedProject);
                projects.add(project);
            }
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static class ProjectMapping {
        String runtimeID;
        String serverID;

        public ProjectMapping() {
        }

        public ProjectMapping(String runtimeID, String serverID) {
            this.runtimeID = runtimeID;
            this.serverID = serverID;
        }

        public String getRuntimeID() {
            return this.runtimeID;
        }

        public String getServerID() {
            return this.serverID;
        }

        public boolean equals(Object other) {
            if (other instanceof ProjectMapping) {
                ProjectMapping o = (ProjectMapping)other;
                return this.isEqual(this.runtimeID, o.runtimeID) && this.isEqual(this.serverID, o.serverID);
            }
            return false;
        }

        private boolean isEqual(String one, String two) {
            if (one == two) {
                return true;
            }
            if (one == null || two == null) {
                return false;
            }
            return one.equals(two);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

