/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.manager.internal;

import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereRuntimeLocator;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ExcludeSyncModuleUtil;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImpl;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImplProvider;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.IProjectInspector;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Messages;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.manager.internal.AbstractLibertyProjectMapping;
import com.ibm.ws.st.liberty.buildplugin.integration.ui.internal.UIHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResults;

public abstract class AbstractLibertyManager
implements IResourceChangeListener,
ILibertyBuildPluginImplProvider {
    static final MutexRule generationRule = new MutexRule();
    AbstractLibertyProjectMapping mappingHandler = this.getBuildPluginImpl().getMappingHandler();
    ILibertyBuildPluginImpl buildPluginHelper = this.getBuildPluginImpl();

    protected AbstractLibertyManager() {
        this.init();
    }

    private void init() {
    }

    private void handleGeneration(IProject proj, IProgressMonitor monitor) {
        LibertyBuildPluginConfiguration config = this.buildPluginHelper.getLibertyBuildPluginConfiguration(proj, monitor);
        this.handleGeneration(proj, config);
    }

    void handleGeneration(IProject proj, LibertyBuildPluginConfiguration config) {
        this.mappingHandler.ignoreProject(proj);
        if (config != null && this.isValidConfig(config)) {
            ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{generationRule, ResourcesPlugin.getWorkspace().getRoot(), proj});
            CreationJob genJob = new CreationJob(NLS.bind((String)Messages.createJob, (Object)proj.getName()), proj, config);
            genJob.setRule(rule);
            genJob.schedule();
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Runtime and server generation job scheduled");
            }
        }
    }

    boolean isValidConfig(LibertyBuildPluginConfiguration config) {
        if (config.getConfigValue(ConfigurationType.installDirectory) == null) {
            Trace.logError("A runtime installation directory is not configured. Ensure the liberty build plugin configuration is coorrect.", null);
            return false;
        }
        if (config.getConfigValue(ConfigurationType.configFile) == null) {
            Trace.logError("A server configuration file is not configured. Ensure the liberty build plugin configuration is correct.", null);
            return false;
        }
        return true;
    }

    protected abstract boolean handleGenerationPrompt(String var1);

    protected abstract boolean isSupportedProjectType(IProject var1);

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta == null) {
            return;
        }
        IResourceDelta[] projectDeltas = rootDelta.getAffectedChildren();
        if (projectDeltas == null) {
            return;
        }
        ArrayList<IResourceDelta> applicableResourceDeltas = new ArrayList<IResourceDelta>();
        if (projectDeltas.length > 0) {
            for (int i = 0; i < projectDeltas.length; ++i) {
                IResource resource = projectDeltas[i].getResource();
                if (!(resource instanceof IProject)) continue;
                IProject project = (IProject)resource;
                if (projectDeltas[i].getKind() != 2 && project.isAccessible() && !this.isSupportedProjectType(project)) continue;
                try {
                    IResourceDelta srcConfigDelta;
                    Path srcConfigPath;
                    String configVal;
                    IProjectInspector pi;
                    LibertyBuildPluginConfiguration config;
                    WebSphereServer wsServer;
                    IServer server;
                    if (projectDeltas[i].getKind() == 2) {
                        applicableResourceDeltas.add(projectDeltas[i]);
                        continue;
                    }
                    if (this.mappingHandler.isIgnored(projectDeltas[i].getResource().getProject().getName())) continue;
                    IResourceDelta pluginConfigDelta = projectDeltas[i].findMember((IPath)new Path(this.buildPluginHelper.getRelativeBuildPluginConfigurationFileLocation()));
                    if (pluginConfigDelta != null && pluginConfigDelta.getResource() != null) {
                        applicableResourceDeltas.add(projectDeltas[i]);
                        continue;
                    }
                    AbstractLibertyProjectMapping.ProjectMapping mapping = this.mappingHandler.getMapping(project.getName());
                    if (mapping == null || mapping.getServerID() == null || (server = ServerCore.findServer((String)mapping.getServerID())) == null || (wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null)) == null || (config = (pi = this.getBuildPluginImpl().getProjectInspector(project)).getBuildPluginConfiguration(null)) == null || (configVal = config.getConfigValue(ConfigurationType.configFile)) == null || !(srcConfigPath = new Path(configVal)).toFile().exists() || !project.getLocation().isPrefixOf((IPath)srcConfigPath) || (srcConfigDelta = projectDeltas[i].findMember((IPath)(srcConfigPath = srcConfigPath.makeRelativeTo(project.getLocation())))) == null || srcConfigDelta.getResource() == null) continue;
                    applicableResourceDeltas.add(projectDeltas[i]);
                    continue;
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Checking resource deltas for relevant changes has encountered an error for project: " + project.getName(), e);
                }
            }
        }
        if (!applicableResourceDeltas.isEmpty()) {
            ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{generationRule, ResourcesPlugin.getWorkspace().getRoot()});
            ScanJob scanJob = new ScanJob(Messages.scanJob, applicableResourceDeltas.toArray(new IResourceDelta[0]));
            scanJob.setRule(rule);
            scanJob.schedule(5000L);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Liberty build plugin manager scanning job scheduled");
            }
        }
    }

    static synchronized List<IServer> getServerList(IRuntime runtime) {
        IServer[] servers = ServerCore.getServers();
        if (servers == null || runtime == null) {
            return Collections.emptyList();
        }
        ArrayList<IServer> list = new ArrayList<IServer>();
        for (IServer server : servers) {
            if (!runtime.equals(server.getRuntime())) continue;
            list.add(server);
        }
        return list;
    }

    public synchronized void triggerAddProject(IProject project, IProgressMonitor monitor) {
        Trace.trace((byte)0, "Generate Liberty runtime and server action invoked.");
        this.handleGeneration(project, monitor);
    }

    void printTrackedLibertyProjects() {
        if (this.mappingHandler.isEmpty()) {
            Trace.trace((byte)0, "There are no tracked Liberty projects.");
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (String p : this.mappingHandler.getMappedProjectSet()) {
            sb.append(p + "\n");
        }
        Trace.trace((byte)0, "Tracked Liberty Projects:\n" + sb.toString());
    }

    static class MutexRule
    implements ISchedulingRule {
        MutexRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }

    private class CreationJob
    extends WorkspaceJob {
        IProject project;
        LibertyBuildPluginConfiguration config;
        IRuntime mappedRuntime;
        IRuntime runtime;
        IServer server;
        IServerWorkingCopy serverWc;

        public CreationJob(String name, IProject project, LibertyBuildPluginConfiguration config) {
            super(name);
            this.mappedRuntime = null;
            this.runtime = null;
            this.server = null;
            this.serverWc = null;
            this.project = project;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IStatus status = Status.OK_STATUS;
            try {
                status = this.createRuntime(this.config.getConfigValue(ConfigurationType.installDirectory), monitor);
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                status = this.createServer(monitor);
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                status = this.serverSetup(monitor);
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            finally {
                if (status.isOK()) {
                    AbstractLibertyManager.this.mappingHandler.mapProject(this.project, this.mappedRuntime, this.server);
                } else {
                    this.cleanup();
                }
                RefreshJob refreshJob = new RefreshJob();
                refreshJob.setPriority(20);
                refreshJob.schedule();
            }
            return status;
        }

        private void cleanup() {
            if (this.serverWc != null) {
                try {
                    this.serverWc.delete();
                    this.serverWc = null;
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Problem during cleanup", e);
                }
            }
            if (this.server != null) {
                try {
                    this.server.delete();
                    this.server = null;
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Problem during cleanup", e);
                }
            }
            if (this.mappedRuntime != null) {
                try {
                    this.mappedRuntime.delete();
                    this.mappedRuntime = null;
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Problem during cleanup", e);
                }
            }
            AbstractLibertyManager.this.mappingHandler.unmapAndIgnoreProject(this.project);
        }

        private IStatus createRuntime(String installDir, IProgressMonitor monitor) throws CoreException {
            IRuntime[] runtimes;
            if (installDir == null) {
                return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", NLS.bind((String)Messages.invalidRuntime, (Object)installDir));
            }
            Path installDirectory = new Path(installDir);
            if (!WebSphereRuntime.isValidLocation((IPath)installDirectory)) {
                return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", NLS.bind((String)Messages.invalidRuntime, (Object)installDir));
            }
            for (IRuntime rt : runtimes = ServerCore.getRuntimes()) {
                if (!WebSphereUtil.isWebSphereRuntime((IRuntime)rt) || !installDirectory.equals((Object)rt.getLocation())) continue;
                this.runtime = rt;
                Trace.trace((byte)0, "Reusing runtime " + rt.getName() + " from " + installDirectory.toOSString());
                AbstractLibertyProjectMapping.ProjectMapping mapping = AbstractLibertyManager.this.mappingHandler.getMapping(this.project.getName());
                if (mapping != null && this.runtime.getId().equals(mapping.getRuntimeID())) {
                    this.mappedRuntime = this.runtime;
                } else if (AbstractLibertyManager.this.mappingHandler.getMappedProjects(rt).length > 0) {
                    this.mappedRuntime = this.runtime;
                }
                return Status.OK_STATUS;
            }
            String name = WebSphereUtil.getUniqueRuntimeName((String)NLS.bind((String)Messages.runtimeLabel, (Object)this.project.getName()), (IRuntime[])runtimes);
            Trace.trace((byte)0, "Creating runtime: " + name + " from " + installDirectory.toOSString());
            IRuntimeWorkingCopy runtimeWc = WebSphereRuntimeLocator.getRuntimeFromDir((IPath)installDirectory, (IProgressMonitor)monitor);
            if (runtimeWc == null) {
                return null;
            }
            runtimeWc.setName(name);
            this.mappedRuntime = this.runtime = runtimeWc.save(true, null);
            WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
            IStatus status = wsRuntime.validate();
            if (!status.isOK()) {
                Trace.trace((byte)1, "The runtime validation failed: " + status.getMessage());
            }
            return status;
        }

        private IStatus serverSetup(IProgressMonitor monitor) {
            try {
                String configVal;
                IModule[] projectModules;
                IProjectInspector pi = AbstractLibertyManager.this.getBuildPluginImpl().getProjectInspector(this.project);
                for (IModule module : projectModules = pi.getProjectModules()) {
                    if (!pi.isSupportedModule(module)) continue;
                    IModule[] serverModules = this.server.getModules();
                    int len = serverModules.length;
                    boolean found = false;
                    for (int i = 0; i < len; ++i) {
                        if (!module.equals(serverModules[i])) continue;
                        found = true;
                    }
                    if (found) continue;
                    boolean isWc = this.server.isWorkingCopy();
                    WebSphereServer wsServer = null;
                    if (!isWc) {
                        this.serverWc = this.server.createWorkingCopy();
                        wsServer = (WebSphereServer)this.serverWc.loadAdapter(WebSphereServer.class, null);
                    } else {
                        this.serverWc = (IServerWorkingCopy)this.server;
                        wsServer = (WebSphereServer)this.serverWc.loadAdapter(WebSphereServer.class, null);
                    }
                    if (wsServer == null || !wsServer.canModifyModules(new IModule[]{module}, null).isOK()) continue;
                    LibertyBuildPluginConfiguration config = AbstractLibertyManager.this.buildPluginHelper.getLibertyBuildPluginConfiguration(this.project, monitor);
                    wsServer.addLocalConnectorFeature(monitor);
                    if (config == null) continue;
                    ExcludeSyncModuleUtil.updateExcludeSyncModuleMapping(projectModules, config, wsServer.getWebSphereServerBehaviour());
                    ConfigurationFile serverConfig = wsServer.getConfiguration();
                    if (serverConfig == null) {
                        return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", NLS.bind((String)Messages.configFileNotFound, (Object)wsServer.getServerName()));
                    }
                    this.serverWc.modifyModules(new IModule[]{module}, new IModule[0], monitor);
                    this.server = this.serverWc.save(true, null);
                }
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = FacetUtil.getRuntime((IRuntime)this.runtime);
                if (facetRuntime != null) {
                    HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> runtimeSet = new HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime>();
                    runtimeSet.add(facetRuntime);
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project, (boolean)true, (IProgressMonitor)monitor);
                    facetedProject.setTargetedRuntimes(runtimeSet, monitor);
                    facetedProject.setPrimaryRuntime(facetRuntime, monitor);
                    Trace.trace((byte)0, "Setting targeted runtime to: " + facetRuntime.getName());
                }
                if ((configVal = this.config.getConfigValue(ConfigurationType.configFile)) != null) {
                    Path path = new Path(configVal);
                    IFile configFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    if (configFile != null) {
                        Trace.trace((byte)0, "Validate file: " + path.toString());
                        ValidationResults results = ValidationFramework.getDefault().validate(configFile, monitor);
                        if (results.getSeverityError() > 0) {
                            Trace.trace((byte)0, "Validation failed");
                        } else {
                            Trace.trace((byte)0, "Validation passed");
                        }
                    }
                }
            }
            catch (CoreException e) {
                Trace.logError("Failed to link configured application to project: " + this.project.getName(), e);
            }
            return Status.OK_STATUS;
        }

        private IStatus createServer(IProgressMonitor monitor) {
            if (this.runtime == null) {
                return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", Messages.noRuntimeDetected);
            }
            try {
                Path userPath;
                String hostname = "localhost";
                String serverName = this.config.getConfigValue(ConfigurationType.serverName);
                if (serverName == null) {
                    serverName = this.runtime.getName();
                }
                String looseConfigValue = this.config.getConfigValue(ConfigurationType.looseApplication);
                boolean isLC = Boolean.parseBoolean(looseConfigValue);
                WebSphereRuntime wrt = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
                UserDirectory userDir = null;
                String userDirVal = this.config.getConfigValue(ConfigurationType.userDirectory);
                if (userDirVal != null && (userPath = new Path(userDirVal)).toFile().exists()) {
                    IProject userDirProject = null;
                    for (IProject proj : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                        if (!proj.getLocation().equals((Object)userPath)) continue;
                        userDirProject = proj;
                    }
                    if (userDirProject == null) {
                        userDirProject = WebSphereUtil.createUserProject((String)this.runtime.getName(), (IPath)userPath, null);
                    }
                    userDir = new UserDirectory(wrt, (IPath)userPath, userDirProject);
                }
                IRuntimeWorkingCopy runtimeWorkingCopy = this.runtime.createWorkingCopy();
                WebSphereRuntime wRuntimeWorkingCopy = (WebSphereRuntime)runtimeWorkingCopy.loadAdapter(WebSphereRuntime.class, null);
                if (userDir == null) {
                    userDir = wRuntimeWorkingCopy.createDefaultUserDirectory(null);
                }
                IPath serverPath = userDir.getPath().append("servers").append(serverName);
                AbstractLibertyManager.this.buildPluginHelper.preServerSetup(this.project, this.config, serverPath, monitor);
                if (!serverPath.toFile().exists()) {
                    return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", "The server files were not found in location " + serverPath.toOSString());
                }
                Trace.trace((byte)0, "Creating server: " + serverName + " using User Dir: " + userDir.getPath() + " loose config: " + isLC);
                String serverTypeId = this.runtime.getId().endsWith(".v85.was") ? "com.ibm.ws.st.server.v85.was" : "com.ibm.ws.st.server.wlp";
                IServerType st = ServerCore.findServerType((String)serverTypeId);
                IServerWorkingCopy wc = st.createServer(null, null, this.runtime, null);
                wc.setHost(hostname);
                String instanceName = WebSphereUtil.getUniqueServerName((String)this.project.getName(), (IServer[])ServerCore.getServers());
                wc.setName(instanceName);
                WebSphereServer wsServer = (WebSphereServer)wc.loadAdapter(WebSphereServer.class, null);
                wsServer.setDefaults((IProgressMonitor)new NullProgressMonitor());
                wsServer.setServerName(serverName);
                wsServer.setUserDir(userDir);
                wsServer.setLooseConfigEnabled(isLC);
                wsServer.setServerType(AbstractLibertyManager.this.buildPluginHelper.getServerType());
                this.server = wc.save(true, null);
                wsServer = (WebSphereServer)this.server.loadAdapter(WebSphereServer.class, null);
                WebSphereServerInfo wsInfo = wsServer.getServerInfo();
                if (wsInfo == null) {
                    boolean found = false;
                    for (UserDirectory usr : wRuntimeWorkingCopy.getUserDirectories()) {
                        if (!usr.getPath().equals((Object)userDir.getPath())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        wRuntimeWorkingCopy.addUserDirectory(userDir);
                    }
                    this.runtime = runtimeWorkingCopy.save(true, null);
                }
                WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
                wsRuntime.updateServerCache(true);
                if (wsInfo != null) {
                    wsInfo.updateCache();
                }
            }
            catch (Exception e) {
                return new Status(4, "com.ibm.ws.st.liberty.buildplugin.integration", Messages.createServerActionFailed, (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    private class ScanJob
    extends WorkspaceJob {
        IResourceDelta[] projectDeltas;

        public ScanJob(String name, IResourceDelta[] projectDeltas) {
            super(name);
            this.projectDeltas = projectDeltas;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                for (IResourceDelta projectDelta : this.projectDeltas) {
                    if (AbstractLibertyManager.this.mappingHandler.isIgnored(projectDelta.getResource().getProject().getName())) {
                        if (projectDelta.getKind() == 2) {
                            this.handleProjectRemoved(projectDelta.getResource().getProject(), monitor);
                        }
                        return Status.OK_STATUS;
                    }
                    boolean isHandled = this.processPluginConfigDeltas(projectDelta, monitor);
                    if (!AbstractLibertyManager.this.buildPluginHelper.isSupportedProject(projectDelta.getResource().getProject(), monitor) || isHandled) continue;
                    this.lookForSrcConfigChanges(projectDelta, monitor);
                }
            }
            catch (Exception e) {
                Trace.trace((byte)0, "Scanning for Liberty build plugin configuration changes has encountered an error", e);
            }
            return Status.OK_STATUS;
        }

        private boolean processPluginConfigDeltas(IResourceDelta projectDelta, IProgressMonitor monitor) {
            IResourceDelta pluginConfigDelta = projectDelta.findMember((IPath)new Path(AbstractLibertyManager.this.buildPluginHelper.getRelativeBuildPluginConfigurationFileLocation()));
            if (pluginConfigDelta == null) {
                return false;
            }
            IResource resource = pluginConfigDelta.getResource();
            if (resource == null) {
                return false;
            }
            if (pluginConfigDelta.getKind() == 1) {
                Trace.trace((byte)0, "LibertyManager detected added resource: " + resource.getFullPath());
                this.handleProjectAdded(resource.getProject(), (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            if (pluginConfigDelta.getKind() == 4) {
                Trace.trace((byte)0, "LibertyManager detected changed resource: " + resource.getFullPath());
                IProject project = resource.getProject();
                if (this.requiresUpdate(project)) {
                    this.handleProjectRemoved(project, monitor);
                    this.handleProjectAdded(project, monitor);
                    return true;
                }
            } else if (pluginConfigDelta.getKind() == 2) {
                Trace.trace((byte)0, "LibertyManager detected removed resource: " + resource.getFullPath());
                this.handleProjectRemoved(resource.getProject(), (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            return false;
        }

        private boolean lookForSrcConfigChanges(IResourceDelta projectDelta, IProgressMonitor monitor) {
            IResourceDelta srcConfigDelta;
            IProject project;
            Set<String> mappedProjects = AbstractLibertyManager.this.mappingHandler.getMappedProjectSet();
            if (!mappedProjects.contains((project = projectDelta.getResource().getProject()).getName())) {
                return false;
            }
            IProjectInspector pi = AbstractLibertyManager.this.getBuildPluginImpl().getProjectInspector(project);
            LibertyBuildPluginConfiguration config = pi.getBuildPluginConfiguration(null);
            if (config == null) {
                return false;
            }
            String configVal = config.getConfigValue(ConfigurationType.configFile);
            if (configVal == null) {
                return false;
            }
            AbstractLibertyProjectMapping.ProjectMapping m = AbstractLibertyManager.this.mappingHandler.getMapping(project.getName());
            if (m == null) {
                return false;
            }
            String serverID = m.getServerID();
            if (serverID == null) {
                return false;
            }
            IServer server = ServerCore.findServer((String)m.getServerID());
            if (server == null) {
                return false;
            }
            WebSphereServer wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
            if (wsServer == null) {
                return false;
            }
            Path srcConfigPath = new Path(configVal);
            if (!srcConfigPath.toFile().exists()) {
                return false;
            }
            if (project.getLocation().isPrefixOf((IPath)srcConfigPath)) {
                srcConfigPath = srcConfigPath.makeRelativeTo(project.getLocation());
            }
            if ((srcConfigDelta = projectDelta.findMember((IPath)srcConfigPath)) == null) {
                return false;
            }
            IResource resource = srcConfigDelta.getResource();
            if (resource == null) {
                return false;
            }
            AbstractLibertyManager.this.buildPluginHelper.updateSrcConfig(project, config, monitor);
            WebSphereServerBehaviour wsb = wsServer.getWebSphereServerBehaviour();
            wsb.setWebSphereServerPublishState(2);
            return true;
        }

        private synchronized void handleProjectAdded(final IProject proj, IProgressMonitor monitor) {
            boolean isEnhanced = AbstractLibertyManager.this.buildPluginHelper.isSupportedProject(proj, monitor);
            if (isEnhanced) {
                LibertyBuildPluginConfiguration config = AbstractLibertyManager.this.buildPluginHelper.getLibertyBuildPluginConfiguration(proj, monitor);
                if (config != null && AbstractLibertyManager.this.isValidConfig(config)) {
                    final boolean[] doGeneration = new boolean[]{false};
                    if (AbstractLibertyManager.this.mappingHandler.isTracked(proj.getName())) {
                        doGeneration[0] = true;
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                UIHelper.openRuntimeExplorerView();
                            }
                        });
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Prompting for project mapping of project: " + proj.getName());
                        }
                        if (AbstractLibertyManager.this.mappingHandler.isIgnored(proj.getName())) {
                            Trace.trace((byte)0, "The project " + proj.getName() + " is on the ignore list");
                            doGeneration[0] = false;
                        } else if (!PromptUtil.isSuppressDialog()) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    doGeneration[0] = AbstractLibertyManager.this.handleGenerationPrompt(proj.getName());
                                    if (!doGeneration[0]) {
                                        AbstractLibertyManager.this.mappingHandler.ignoreProject(proj);
                                    }
                                }
                            });
                        } else {
                            doGeneration[0] = true;
                        }
                    }
                    if (!doGeneration[0]) {
                        AbstractLibertyManager.this.mappingHandler.ignoreProject(proj);
                        RefreshJob refreshJob = new RefreshJob();
                        refreshJob.setPriority(20);
                        refreshJob.schedule();
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Skipping runtime and server creation");
                        }
                        return;
                    }
                    AbstractLibertyManager.this.handleGeneration(proj, config);
                }
            } else {
                Trace.logError("The project " + proj.getName() + " uses a liberty build plugin but does not meet the requirements for automatic runtime and server management", null);
            }
            AbstractLibertyManager.this.printTrackedLibertyProjects();
        }

        private synchronized void handleProjectRemoved(IProject proj, IProgressMonitor progressMonitor) {
            Trace.trace((byte)0, "Handling removal of project: " + proj.getName());
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)30);
            String projName = proj.getName();
            if (projName == null) {
                return;
            }
            AbstractLibertyProjectMapping.ProjectMapping mapping = AbstractLibertyManager.this.mappingHandler.getMapping(projName);
            String runtimeId = null;
            String serverId = null;
            IRuntime mappedRuntime = null;
            IServer mappedServer = null;
            if (mapping != null) {
                Trace.trace((byte)0, proj.getName() + " is being tracked");
                runtimeId = mapping.getRuntimeID();
                serverId = mapping.getServerID();
                Trace.trace((byte)0, "runtimeId: " + runtimeId);
                Trace.trace((byte)0, "serverId: " + serverId);
            }
            if (runtimeId == null && serverId == null) {
                Trace.trace((byte)0, proj.getName() + " is not mapped to a runtime or server");
                AbstractLibertyManager.this.mappingHandler.unmapProject(proj);
                RefreshJob refreshJob = new RefreshJob();
                refreshJob.setPriority(20);
                refreshJob.schedule();
                return;
            }
            if (runtimeId != null && (mappedRuntime = ServerCore.findRuntime(runtimeId)) == null) {
                Trace.trace((byte)0, "A runtime with location " + runtimeId + " was not found");
            }
            if (serverId != null) {
                mappedServer = ServerCore.findServer(serverId);
            }
            List<IServer> serverList = AbstractLibertyManager.getServerList(mappedRuntime);
            ArrayList<MutexRule> allRules = new ArrayList<MutexRule>();
            allRules.add(generationRule);
            allRules.add((MutexRule)ResourcesPlugin.getWorkspace().getRoot());
            for (IServer server : serverList) {
                allRules.add((MutexRule)server);
            }
            ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])allRules.toArray(new ISchedulingRule[allRules.size()]));
            if (monitor.isCanceled()) {
                return;
            }
            Trace.trace((byte)0, "Schedule deletion job");
            DeletionJob genJob = new DeletionJob(NLS.bind((String)Messages.deleteJob, (Object)projName), proj, mappedRuntime, mappedServer);
            genJob.setRule(rule);
            genJob.schedule();
        }

        private boolean requiresUpdate(IProject project) {
            IProjectInspector pi = AbstractLibertyManager.this.getBuildPluginImpl().getProjectInspector(project);
            File cachedFile = pi.getCachedLibertyBuildPluginConfigurationFile(null);
            if (cachedFile == null || !cachedFile.exists()) {
                return true;
            }
            AbstractLibertyProjectMapping.ProjectMapping mapping = AbstractLibertyManager.this.mappingHandler.getMapping(project.getName());
            if (mapping == null && project.isOpen()) {
                return true;
            }
            if (!project.isOpen() && mapping != null) {
                return true;
            }
            if (mapping != null) {
                String runtimeID = mapping.getRuntimeID();
                String serverID = mapping.getServerID();
                IRuntime rt = ServerCore.findRuntime((String)runtimeID);
                if (rt == null) {
                    return true;
                }
                IServer sv = ServerCore.findServer((String)serverID);
                if (sv == null) {
                    return true;
                }
            }
            try {
                LibertyBuildPluginConfiguration currentConfig = pi.getBuildPluginConfiguration(null);
                LibertyBuildPluginConfiguration cachedConfig = pi.getCachedBuildPluginConfiguration(null);
                Set<ConfigurationType> deltas = currentConfig.getDelta(cachedConfig);
                if (!deltas.isEmpty()) {
                    Set<ConfigurationType> updateTriggers = ConfigurationType.getAllUpdateTriggers();
                    Iterator<ConfigurationType> iterator = deltas.iterator();
                    if (iterator.hasNext()) {
                        ConfigurationType t = iterator.next();
                        updateTriggers.contains((Object)t);
                        return true;
                    }
                }
            }
            catch (Exception e) {
                Trace.logError("Error encountered while computing differences in project configuration", e);
            }
            return false;
        }
    }

    private class RefreshJob
    extends WorkspaceJob {
        public RefreshJob() {
            super(Messages.refreshJob);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UIHelper.refreshRuntimeExplorerView();
                }
            });
            return Status.OK_STATUS;
        }
    }

    private class DeletionJob
    extends WorkspaceJob {
        IRuntime runtime;
        IServer server;
        IProject proj;

        public DeletionJob(String name, IProject proj, IRuntime runtime, IServer server) {
            super(name);
            this.runtime = runtime;
            this.server = server;
            this.proj = proj;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this.performDelete(monitor);
            return Status.OK_STATUS;
        }

        private void performDelete(IProgressMonitor monitor) {
            if (this.runtime == null) {
                AbstractLibertyManager.this.mappingHandler.unmapProject(this.proj);
                return;
            }
            if (AbstractLibertyManager.this.mappingHandler.getMappedProjects(this.runtime).length > 1) {
                Trace.trace((byte)0, "The " + this.runtime.getName() + " is being used by other projects.");
                if (this.server != null) {
                    try {
                        this.ensureServersStopped(monitor, this.server);
                        Trace.trace((byte)0, "Deleting server: " + this.server.getName());
                        this.server.delete();
                    }
                    catch (Exception e) {
                        Trace.logError("A problem was encountered trying to remove the server: " + this.server.getName(), e);
                    }
                }
            } else {
                block20: {
                    boolean inUse = false;
                    try {
                        inUse = FacetUtil.isRuntimeTargeted((IRuntime)this.runtime);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    List<IServer> serverList = AbstractLibertyManager.getServerList(this.runtime);
                    if (!serverList.isEmpty()) {
                        try {
                            this.ensureServersStopped(monitor, serverList.toArray(new IServer[serverList.size()]));
                            Trace.trace((byte)0, "Deleting servers associated with runtime: " + this.runtime.getName());
                            for (IServer s : serverList) {
                                Trace.trace((byte)0, "Deleting server: " + s.getName());
                                s.delete();
                            }
                        }
                        catch (Exception e) {
                            Trace.logError("Problem encountered while deleting servers", e);
                            return;
                        }
                        if (!inUse) {
                            try {
                                Trace.trace((byte)0, "Removing target facets for runtime: " + this.runtime.getName());
                                FacetUtil.removeTargets((IRuntime)this.runtime, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (Throwable t) {
                                if (!Trace.ENABLED) break block20;
                                Trace.trace((byte)1, "Error deleting facet targets", t);
                            }
                        }
                    }
                }
                try {
                    Trace.trace((byte)0, "Deleting runtime: " + this.runtime.getName());
                    this.runtime.delete();
                }
                catch (CoreException ce) {
                    Trace.logError(ce.getLocalizedMessage(), ce);
                }
                catch (Exception e) {
                    Trace.logError("Error deleting runtime: " + this.runtime.getId(), e);
                }
            }
            if (this.proj.exists() && this.proj.isOpen()) {
                AbstractLibertyManager.this.mappingHandler.clearProjectMapping(this.proj);
            } else {
                AbstractLibertyManager.this.mappingHandler.unmapProject(this.proj);
            }
            AbstractLibertyManager.this.printTrackedLibertyProjects();
        }

        private void ensureServersStopped(IProgressMonitor monitor, IServer ... serverList) throws Exception {
            for (IServer server : serverList) {
                IRuntime runtime = server.getRuntime();
                if (runtime == null || runtime.getLocation() == null || !runtime.getLocation().toFile().exists()) {
                    if (runtime != null) {
                        Trace.trace((byte)0, "Runtime doesn't exist, skipping stop servers for runtime: " + runtime.getName());
                        break;
                    }
                    Trace.trace((byte)0, "The server does not have an associated runtime");
                    break;
                }
                WebSphereServer wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
                WebSphereServerInfo wsInfo = wsServer.getWebSphereServerBehaviour().getWebSphereServerInfo();
                if (wsInfo == null) {
                    Trace.trace((byte)0, "Server doesn't exist, skipping stop server for server: " + server.getName());
                    continue;
                }
                IPath serverPath = wsInfo.getServerPath();
                if (!serverPath.toFile().exists()) {
                    Trace.trace((byte)0, "Server folder is missing, skipping stop server for server: " + server.getName());
                    continue;
                }
                Trace.trace((byte)0, "Stopping server: " + server.getName());
                wsServer.getWebSphereServerBehaviour().stop(true, monitor);
                boolean waitForServerStop = wsServer.getWebSphereServerBehaviour().waitForServerStop(server.getStopTimeout() * 1000);
                if (waitForServerStop) {
                    long endTime = System.currentTimeMillis() + 5000L;
                    while (4 != server.getServerState()) {
                        long currentTime = System.currentTimeMillis();
                        Thread.sleep(250L);
                        if (currentTime < endTime) continue;
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Server state failed to change to stop: " + server.getName());
                        }
                        throw new Exception("Server state failed to change to stop: " + server.getName());
                    }
                    continue;
                }
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Failed to stop server: " + server.getName());
                }
                throw new Exception("Failed to stop server: " + server.getName());
            }
        }
    }
}

