/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LibertyBuildPluginConfiguration {
    private final HashMap<ConfigurationType, String> configMap = new HashMap();
    private List<String> jvmOptions = null;
    private Map<String, String> bootstrapProperties = null;
    private List<String> activeBuildProfiles = null;
    private final Set<String> projectCompileDependencies = new HashSet<String>();
    private final long lastModified;
    private String version = null;

    public LibertyBuildPluginConfiguration(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getConfigValue(ConfigurationType type) {
        return this.configMap.get((Object)type);
    }

    public String setConfigValue(ConfigurationType type, String value) {
        Trace.trace((byte)0, "Setting: " + type.name() + " = " + value);
        return this.configMap.put(type, value);
    }

    public Map<String, String> getBootstrapProperties() {
        if (this.bootstrapProperties == null) {
            return Collections.emptyMap();
        }
        return this.bootstrapProperties;
    }

    public void setBootstrapProperties(Map<String, String> bootstrapProperties) {
        this.bootstrapProperties = bootstrapProperties;
    }

    public List<String> getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public List<String> getActiveBuildProfiles() {
        if (this.activeBuildProfiles == null) {
            return Collections.emptyList();
        }
        return this.activeBuildProfiles;
    }

    public void setActiveBuildProfiles(List<String> profiles) {
        this.activeBuildProfiles = profiles;
    }

    public void addProjectCompileDependency(String dependency) {
        this.projectCompileDependencies.add(dependency);
    }

    public Set<String> getProjectCompileDependencies() {
        return this.projectCompileDependencies;
    }

    public Set<ConfigurationType> getDelta(LibertyBuildPluginConfiguration cachedConfig) {
        if (cachedConfig == null || cachedConfig.configMap.isEmpty()) {
            return this.configMap.keySet();
        }
        if (!this.mapsEqual(this.configMap, cachedConfig.configMap)) {
            return new HashSet<ConfigurationType>(Arrays.asList(ConfigurationType.values()));
        }
        return Collections.emptySet();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean mapsEqual(Map<ConfigurationType, String> configMapA, Map<ConfigurationType, String> configMapB) {
        if (configMapA.size() != configMapB.size()) {
            return false;
        }
        return configMapA.equals(configMapB);
    }
}

