/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.internal;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ServerEnv;
import com.ibm.ws.st.core.internal.config.validation.ICustomServerVariablesHandler;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractCustomServerVariablesHandler
implements ICustomServerVariablesHandler {
    protected abstract IProject getMappedProject(IServer var1);

    protected abstract LibertyBuildPluginConfiguration getLibertyBuildPluginConfiguration(IProject var1);

    protected abstract void addInlineVars(IProject var1, ConfigVars var2, LibertyBuildPluginConfiguration var3);

    public void addCustomServerVariables(ConfigVars configVars, IProject project) {
        LibertyBuildPluginConfiguration libertyBuildProjectConfiguration = this.getLibertyBuildPluginConfiguration(project);
        if (libertyBuildProjectConfiguration != null) {
            String bootstrapFile;
            String serverEnvFile = libertyBuildProjectConfiguration.getConfigValue(ConfigurationType.serverEnv);
            if (serverEnvFile != null) {
                try {
                    ServerEnv serverEnv = new ServerEnv(new File(serverEnvFile), null);
                    serverEnv.getVariables(configVars);
                }
                catch (IOException e) {
                    Trace.logError((String)("Could not read server.env file " + serverEnvFile), (Throwable)e);
                }
            }
            if ((bootstrapFile = libertyBuildProjectConfiguration.getConfigValue(ConfigurationType.bootstrapPropertiesFile)) != null) {
                try {
                    Bootstrap bootstrap = new Bootstrap(new File(bootstrapFile), null);
                    bootstrap.getVariables(configVars);
                }
                catch (IOException e) {
                    Trace.logError((String)("Could not read bootstrap.properties file " + bootstrapFile), (Throwable)e);
                }
            }
            this.addInlineVars(project, configVars, libertyBuildProjectConfiguration);
        }
    }

    public void addCustomServerVariables(ConfigVars configVars, WebSphereServerInfo serverInfo) {
        if (serverInfo == null) {
            return;
        }
        WebSphereServer wsServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)serverInfo);
        if (wsServer == null) {
            return;
        }
        IProject project = this.getMappedProject(wsServer.getServer());
        if (project == null) {
            return;
        }
        this.addCustomServerVariables(configVars, project);
    }
}

