/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.ui.internal.composite;

import com.ibm.ws.st.common.core.internal.RemoteServerInfo;
import com.ibm.ws.st.common.ui.internal.Messages;
import com.ibm.ws.st.common.ui.internal.commands.SetServerStringAttributeCommand;
import com.ibm.ws.st.common.ui.internal.composite.AbstractRemoteComposite;
import com.ibm.ws.st.common.ui.internal.composite.BaseRemoteComposite;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class SSHLogonComposite
extends AbstractRemoteComposite {
    IServerWorkingCopy serverWc;
    final RemoteServerInfo remoteInfo;
    protected Text sshKeyFileText;
    protected Button browseKeyFileBtn;
    protected Text sshIdText;
    protected Text sshPasswordText;
    protected Control[] sshIdPasswdCtrls = new Control[7];
    protected PropertyChangeListener propertyListener;
    BaseRemoteComposite remoteSetupComp;

    public SSHLogonComposite(Composite parent, BaseRemoteComposite remoteSetupHandler, IServerWorkingCopy serverWc, RemoteServerInfo remoteInfo) {
        super(parent);
        this.remoteSetupComp = remoteSetupHandler;
        this.serverWc = serverWc;
        this.remoteInfo = remoteInfo == null ? new RemoteServerInfo(RemoteServerInfo.RemoteServerType.Liberty) : remoteInfo;
        this.createControl();
    }

    public void createControl() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 2;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(784));
        Label curLabel = this.createLabel(this, Messages.L_RemoteServerAuth_SSH_KeyFile);
        this.sshIdPasswdCtrls[0] = curLabel;
        GridData data = new GridData(256);
        data.horizontalIndent = 10;
        curLabel.setLayoutData((Object)data);
        this.sshKeyFileText = this.createTextField(this, 0);
        this.sshIdPasswdCtrls[1] = this.sshKeyFileText;
        data = new GridData(768);
        this.sshKeyFileText.setLayoutData((Object)data);
        this.sshKeyFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SSHLogonComposite.this.remoteSetupComp.isUpdating()) {
                    return;
                }
                SSHLogonComposite.this.remoteSetupComp.setUpdating(true);
                SSHLogonComposite.this.remoteInfo.put((Object)"remoteStart_SSHKeyFile", (Object)SSHLogonComposite.this.sshKeyFileText.getText());
                SSHLogonComposite.this.remoteSetupComp.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartLogonSSHKeyFileCommandDescription, SSHLogonComposite.this.serverWc, "remoteStart_SSHKeyFile", SSHLogonComposite.this.sshKeyFileText.getText()));
                SSHLogonComposite.this.remoteSetupComp.setUpdating(false);
                SSHLogonComposite.this.remoteSetupComp.showValidationError(4);
            }
        });
        helpSystem.setHelp((Control)this.sshKeyFileText, "com.ibm.ws.st.common.ui.iege0044");
        this.browseKeyFileBtn = this.createButton(this, Messages.L_Browse, 8);
        this.sshIdPasswdCtrls[2] = this.browseKeyFileBtn;
        data = new GridData(256);
        this.browseKeyFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SSHLogonComposite.this.getShell());
                dialog.setFileName(SSHLogonComposite.this.sshKeyFileText.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null) {
                    if (SSHLogonComposite.this.remoteSetupComp.isUpdating()) {
                        return;
                    }
                    SSHLogonComposite.this.remoteSetupComp.setUpdating(true);
                    SSHLogonComposite.this.sshKeyFileText.setText(selectedFile);
                    SSHLogonComposite.this.remoteInfo.put((Object)"remoteStart_SSHKeyFile", (Object)selectedFile);
                    SSHLogonComposite.this.remoteSetupComp.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartLogonSSHKeyFileCommandDescription, SSHLogonComposite.this.serverWc, "remoteStart_SSHKeyFile", selectedFile));
                    SSHLogonComposite.this.remoteSetupComp.setUpdating(false);
                    SSHLogonComposite.this.remoteSetupComp.showValidationError(4);
                }
            }
        });
        curLabel = this.createLabel(this, Messages.L_RemoteServerAuth_SSHId);
        this.sshIdPasswdCtrls[3] = curLabel;
        data = new GridData(256);
        data.horizontalIndent = 10;
        curLabel.setLayoutData((Object)data);
        this.sshIdText = this.createTextField(this, 0);
        this.sshIdPasswdCtrls[4] = this.sshIdText;
        data = new GridData(768);
        this.sshIdText.setLayoutData((Object)data);
        this.sshIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SSHLogonComposite.this.remoteSetupComp.isUpdating()) {
                    return;
                }
                SSHLogonComposite.this.remoteSetupComp.setUpdating(true);
                SSHLogonComposite.this.remoteInfo.put((Object)"remoteStart_SSHId", (Object)SSHLogonComposite.this.sshIdText.getText());
                SSHLogonComposite.this.remoteSetupComp.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartLogonSSHIdCommandDescription, SSHLogonComposite.this.serverWc, "remoteStart_SSHId", SSHLogonComposite.this.sshIdText.getText()));
                SSHLogonComposite.this.remoteSetupComp.setUpdating(false);
                SSHLogonComposite.this.remoteSetupComp.showValidationError(4);
            }
        });
        helpSystem.setHelp((Control)this.sshIdText, "com.ibm.ws.st.common.ui.iege0045");
        this.createLabel(this, "");
        curLabel = this.createLabel(this, Messages.L_RemoteServerAuth_SSHPassphrase);
        this.sshIdPasswdCtrls[5] = curLabel;
        data = new GridData(256);
        data.horizontalIndent = 10;
        curLabel.setLayoutData((Object)data);
        this.sshPasswordText = this.createTextField(this, 0);
        this.sshIdPasswdCtrls[6] = this.sshPasswordText;
        data = new GridData(768);
        this.sshPasswordText.setLayoutData((Object)data);
        this.sshPasswordText.setEchoChar('*');
        this.sshPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SSHLogonComposite.this.remoteSetupComp.isUpdating()) {
                    return;
                }
                SSHLogonComposite.this.remoteSetupComp.setUpdating(true);
                SSHLogonComposite.this.remoteInfo.put((Object)"remoteStart_SSHPassphrase", (Object)SSHLogonComposite.this.sshPasswordText.getText());
                SSHLogonComposite.this.remoteSetupComp.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartLogonSSHPwdCommandDescription, SSHLogonComposite.this.serverWc, "remoteStart_SSHPassphrase", SSHLogonComposite.this.sshPasswordText.getText()));
                SSHLogonComposite.this.remoteSetupComp.setUpdating(false);
                SSHLogonComposite.this.remoteSetupComp.showValidationError(4);
            }
        });
        helpSystem.setHelp((Control)this.sshPasswordText, "com.ibm.ws.st.common.ui.iege0046");
    }

    public void initializeValues() {
        if (this.sshKeyFileText != null) {
            this.sshKeyFileText.setText(this.remoteInfo.getStringValue("remoteStart_SSHKeyFile"));
        }
        if (this.sshIdText != null) {
            this.sshIdText.setText(this.remoteInfo.getStringValue("remoteStart_SSHId"));
        }
        if (this.sshPasswordText != null) {
            this.sshPasswordText.setText(this.remoteInfo.getStringValue("remoteStart_SSHPassphrase"));
        }
    }

    public void clearValues() {
        this.sshKeyFileText.setText("");
        this.sshIdText.setText("");
        this.sshPasswordText.setText("");
    }

    public void setEnablement(boolean enable) {
        for (Control ctrl : this.sshIdPasswdCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(enable);
        }
    }

    public String validate() {
        String s;
        String msg = null;
        if (this.sshKeyFileText != null && ((s = this.sshKeyFileText.getText()) == null || s.trim().isEmpty())) {
            msg = Messages.E_RemoteServer_SSH_LOGON;
            return msg;
        }
        if (this.sshIdText != null && ((s = this.sshIdText.getText()) == null || s.trim().isEmpty())) {
            msg = Messages.E_RemoteServer_SSH_LOGON;
            return msg;
        }
        return msg;
    }

    public void handlePropertyChange(PropertyChangeEvent event) {
        if ("remoteStart_SSHKeyFile".equals(event.getPropertyName())) {
            this.remoteInfo.put((Object)"remoteStart_SSHKeyFile", event.getNewValue());
        } else if ("remoteStart_SSHId".equals(event.getPropertyName())) {
            String newValue = (String)event.getNewValue();
            this.remoteInfo.put((Object)"remoteStart_SSHId", (Object)newValue);
            if (newValue != null) {
                this.sshIdText.setText(newValue);
            }
        } else if ("remoteStart_SSHPassphrase".equals(event.getPropertyName())) {
            String newValue = (String)event.getNewValue();
            this.remoteInfo.put((Object)"remoteStart_SSHPassphrase", (Object)newValue);
            if (newValue != null) {
                this.sshPasswordText.setText(newValue);
            }
        }
    }

    public void cloudAlwaysUpdateTheseValues(String sshPassphrase, String sshKeyFile) {
        if (this.sshPasswordText != null) {
            this.sshPasswordText.setText(sshPassphrase);
        }
        if (this.sshKeyFileText != null) {
            this.sshKeyFileText.setText(sshKeyFile);
        }
    }
}

