/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.ui.internal.composite;

import com.ibm.ws.st.common.core.internal.RemoteServerInfo;
import com.ibm.ws.st.common.ui.internal.Messages;
import com.ibm.ws.st.common.ui.internal.Trace;
import com.ibm.ws.st.common.ui.internal.commands.SetRemoteServerOSPwdCommand;
import com.ibm.ws.st.common.ui.internal.commands.SetServerBooleanAttributeCommand;
import com.ibm.ws.st.common.ui.internal.commands.SetServerIntAttributeCommand;
import com.ibm.ws.st.common.ui.internal.commands.SetServerStringAttributeCommand;
import com.ibm.ws.st.common.ui.internal.composite.BaseRemoteComposite;
import com.ibm.ws.st.common.ui.internal.composite.SSHLogonComposite;
import com.ibm.ws.st.common.ui.internal.composite.ServerEditorRemoteStartupComposite;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.util.SocketUtil;

public abstract class AbstractRemoteServerStartupComposite
extends BaseRemoteComposite {
    IServerWorkingCopy serverWc;
    protected PropertyChangeListener propertyListener;
    ArrayList<CommandListener> commandListeners = new ArrayList(1);
    protected Button isEnableRemoteServerStartupCheckbox = null;
    protected boolean enableRemoteServerStartup = true;
    protected boolean isLocalhost = true;
    protected Text wasProfilePathText;
    protected Text libertyRuntimePathText;
    protected Text libertyConfigPathText;
    protected Button isWindowsBtn;
    protected Button isLinuxBtn;
    protected Button isMACBtn;
    protected Button isOtherBtn;
    protected List<Button> platformButtons = new ArrayList<Button>(4);
    protected Button isOSLogonBtn;
    protected Button isSSHBtn;
    protected Button browseKeyFileBtn;
    protected Text osIdText;
    public Text osPasswordText;
    public SSHLogonComposite sshComposite;
    protected Text debugPortText;
    protected Control[] installPathCtrls = new Control[4];
    protected List<Control> platformCtrls = new ArrayList<Control>(5);
    protected Control[] logonCtrls = new Control[3];
    protected Control[] osIdPasswdCtrls = new Control[4];
    protected Control[] debugCtrls = new Control[3];
    protected String[] validationErrors = new String[7];
    protected boolean isPageComplete = false;
    protected boolean enabledErrorCheck = false;
    protected static boolean isIBMJRE;
    private RemoteServerInfo.CloudType lastInstanceType = RemoteServerInfo.CloudType.NON_CLOUD;
    boolean isCloudServer;
    boolean isDockerServer;
    final RemoteServerInfo remoteInfo;
    protected boolean updating;

    public AbstractRemoteServerStartupComposite(Composite parent, IServerWorkingCopy serverWc, RemoteServerInfo remoteInfo, boolean isCloudServer) {
        this(parent, serverWc, remoteInfo, isCloudServer, false);
    }

    public AbstractRemoteServerStartupComposite(Composite parent, IServerWorkingCopy serverWc, RemoteServerInfo remoteInfo, boolean isCloudServer, boolean isDockerServer) {
        super(parent);
        this.serverWc = serverWc;
        this.remoteInfo = remoteInfo == null ? new RemoteServerInfo(RemoteServerInfo.RemoteServerType.Liberty) : remoteInfo;
        this.isCloudServer = isCloudServer;
        this.isDockerServer = isDockerServer;
        this.createControl();
    }

    public void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(256));
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        this.isEnableRemoteServerStartupCheckbox = new Button((Composite)this, 32);
        this.isEnableRemoteServerStartupCheckbox.setText(Messages.L_RemoteServerEnableStart);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.isEnableRemoteServerStartupCheckbox.setLayoutData((Object)data);
        this.isEnableRemoteServerStartupCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractRemoteServerStartupComposite.this.updating) {
                    return;
                }
                AbstractRemoteServerStartupComposite.this.updating = true;
                AbstractRemoteServerStartupComposite.this.remoteInfo.putBooleanValue("remoteStart_Enabled", AbstractRemoteServerStartupComposite.this.isEnableRemoteServerStartupCheckbox.getSelection());
                AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerBooleanAttributeCommand(Messages.L_SetRemoteServerStartupEnableCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_Enabled", AbstractRemoteServerStartupComposite.this.isEnableRemoteServerStartupCheckbox.getSelection()));
                AbstractRemoteServerStartupComposite.this.setCtrlEnablement(AbstractRemoteServerStartupComposite.this.isEnableRemoteServerStartupCheckbox.getSelection());
                AbstractRemoteServerStartupComposite.this.updating = false;
                AbstractRemoteServerStartupComposite.this.showValidationError(5);
            }
        });
        helpSystem.setHelp((Control)this.isEnableRemoteServerStartupCheckbox, "com.ibm.ws.st.common.ui.iege0048");
        if (this.isDockerServer) {
            if (this.remoteInfo.getBooleanValue("remoteStart_Enabled", true)) {
                this.isEnableRemoteServerStartupCheckbox.setSelection(true);
            }
            this.isEnableRemoteServerStartupCheckbox.setVisible(false);
            data.exclude = true;
        }
        Label curLabel = null;
        Text curText = this.createText(this, Messages.L_RemoteServerPlatform, 0, 2);
        this.platformCtrls.add((Control)curText);
        data = new GridData(256);
        curText.setLayoutData((Object)data);
        Composite platformComposite = this.createSubComposite(this, 1);
        layout = new GridLayout();
        if (!this.isDockerServer) {
            this.isWindowsBtn = this.createButton(platformComposite, Messages.L_RemoteServerPlatform_WIN, 16);
            data = new GridData(768);
            data.horizontalIndent = 10;
            this.isWindowsBtn.setLayoutData((Object)data);
            this.platformButtons.add(this.isWindowsBtn);
            this.isWindowsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractRemoteServerStartupComposite.this.updating || !AbstractRemoteServerStartupComposite.this.isWindowsBtn.getSelection()) {
                        return;
                    }
                    AbstractRemoteServerStartupComposite.this.updating = true;
                    AbstractRemoteServerStartupComposite.this.setPlatform(0);
                    AbstractRemoteServerStartupComposite.this.remoteInfo.putIntegerValue("remoteStart_Platform", 0);
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerIntAttributeCommand(Messages.L_SetRemoteServerStartPlatformCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_Platform", 0));
                    AbstractRemoteServerStartupComposite.this.showValidationError(0);
                    AbstractRemoteServerStartupComposite.this.updating = false;
                }
            });
            helpSystem.setHelp((Control)this.isWindowsBtn, "com.ibm.ws.st.common.ui.iege0047");
        }
        if (this.remoteInfo.getMode().equals((Object)RemoteServerInfo.RemoteServerType.TWAS) || this.isDockerServer) {
            this.isLinuxBtn = this.createButton(platformComposite, Messages.L_RemoteServerPlatform_LINUX, 16);
            data = new GridData(768);
            data.horizontalIndent = 10;
            this.isLinuxBtn.setLayoutData((Object)data);
            this.platformButtons.add(this.isLinuxBtn);
            this.isLinuxBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractRemoteServerStartupComposite.this.updating || !AbstractRemoteServerStartupComposite.this.isLinuxBtn.getSelection()) {
                        return;
                    }
                    AbstractRemoteServerStartupComposite.this.updating = true;
                    AbstractRemoteServerStartupComposite.this.setPlatform(1);
                    AbstractRemoteServerStartupComposite.this.remoteInfo.putIntegerValue("remoteStart_Platform", 1);
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerIntAttributeCommand(Messages.L_SetRemoteServerStartPlatformCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_Platform", 1));
                    AbstractRemoteServerStartupComposite.this.updating = false;
                    AbstractRemoteServerStartupComposite.this.showValidationError(0);
                }
            });
            helpSystem.setHelp((Control)this.isLinuxBtn, "com.ibm.ws.st.common.ui.iege0038");
        }
        if (this.isDockerServer) {
            this.isMACBtn = this.createButton(platformComposite, Messages.L_RemoteServerPlatform_MAC, 16);
            data = new GridData(768);
            data.horizontalIndent = 10;
            this.isMACBtn.setLayoutData((Object)data);
            this.platformButtons.add(this.isMACBtn);
            this.isMACBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractRemoteServerStartupComposite.this.updating || !AbstractRemoteServerStartupComposite.this.isMACBtn.getSelection()) {
                        return;
                    }
                    AbstractRemoteServerStartupComposite.this.updating = true;
                    AbstractRemoteServerStartupComposite.this.setPlatform(3);
                    AbstractRemoteServerStartupComposite.this.remoteInfo.putIntegerValue("remoteStart_Platform", 3);
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerIntAttributeCommand(Messages.L_SetRemoteServerStartPlatformCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_Platform", 3));
                    AbstractRemoteServerStartupComposite.this.updating = false;
                    AbstractRemoteServerStartupComposite.this.showValidationError(0);
                }
            });
            helpSystem.setHelp((Control)this.isMACBtn, "com.ibm.ws.st.common.ui.iege0038");
        }
        if (this.remoteInfo.getMode().equals((Object)RemoteServerInfo.RemoteServerType.Liberty) && !this.isDockerServer) {
            this.isOtherBtn = this.createButton(platformComposite, Messages.L_RemoteServerPlatform_Other, 16);
            this.isOtherBtn.setToolTipText(Messages.L_RemoteServerPlatform_OtherTooltip);
            data = new GridData(768);
            data.horizontalIndent = 10;
            this.isOtherBtn.setLayoutData((Object)data);
            this.platformButtons.add(this.isOtherBtn);
            this.isOtherBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractRemoteServerStartupComposite.this.updating || !AbstractRemoteServerStartupComposite.this.isOtherBtn.getSelection()) {
                        return;
                    }
                    AbstractRemoteServerStartupComposite.this.updating = true;
                    AbstractRemoteServerStartupComposite.this.setPlatform(2);
                    AbstractRemoteServerStartupComposite.this.remoteInfo.putIntegerValue("remoteStart_Platform", 2);
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerIntAttributeCommand(Messages.L_SetRemoteServerStartPlatformCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_Platform", 2));
                    AbstractRemoteServerStartupComposite.this.updating = false;
                    AbstractRemoteServerStartupComposite.this.showValidationError(0);
                }
            });
            helpSystem.setHelp((Control)this.isOtherBtn, "com.ibm.ws.st.common.ui.iege0038");
        }
        this.platformCtrls.addAll(this.platformButtons);
        if (!this.isDockerServer) {
            Composite pathComposite = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 2;
            layout.marginWidth = 5;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 15;
            pathComposite.setLayout((Layout)layout);
            data = new GridData(784);
            pathComposite.setLayoutData((Object)data);
            if (this.remoteInfo.getMode().equals((Object)RemoteServerInfo.RemoteServerType.TWAS)) {
                curLabel = this.createLabel(pathComposite, Messages.L_RemoteServerPath);
                this.installPathCtrls[0] = curLabel;
                data = new GridData(256);
                curLabel.setLayoutData((Object)data);
                this.wasProfilePathText = this.createTextField(pathComposite, 0);
                this.installPathCtrls[1] = this.wasProfilePathText;
                data = new GridData(768);
                this.wasProfilePathText.setLayoutData((Object)data);
                this.wasProfilePathText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (AbstractRemoteServerStartupComposite.this.updating) {
                            return;
                        }
                        AbstractRemoteServerStartupComposite.this.updating = true;
                        AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_ProfilePath", (Object)AbstractRemoteServerStartupComposite.this.wasProfilePathText.getText());
                        AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartProfilePathCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_ProfilePath", AbstractRemoteServerStartupComposite.this.wasProfilePathText.getText()));
                        AbstractRemoteServerStartupComposite.this.updating = false;
                        AbstractRemoteServerStartupComposite.this.showValidationError(1);
                    }
                });
                helpSystem.setHelp((Control)this.wasProfilePathText, "com.ibm.ws.st.common.ui.iege0039");
            } else {
                curLabel = this.createLabel(pathComposite, Messages.L_RemoteServerLibertyRuntimePath);
                this.installPathCtrls[0] = curLabel;
                data = new GridData(256);
                curLabel.setLayoutData((Object)data);
                this.libertyRuntimePathText = this.createTextField(pathComposite, 0);
                this.installPathCtrls[1] = this.libertyRuntimePathText;
                data = new GridData(768);
                this.libertyRuntimePathText.setLayoutData((Object)data);
                this.libertyRuntimePathText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (AbstractRemoteServerStartupComposite.this.updating) {
                            return;
                        }
                        AbstractRemoteServerStartupComposite.this.updating = true;
                        AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_LibertyRuntimePath", (Object)AbstractRemoteServerStartupComposite.this.libertyRuntimePathText.getText());
                        AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartRuntimePathCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_LibertyRuntimePath", AbstractRemoteServerStartupComposite.this.libertyRuntimePathText.getText()));
                        AbstractRemoteServerStartupComposite.this.updating = false;
                        AbstractRemoteServerStartupComposite.this.showValidationError(1);
                    }
                });
                helpSystem.setHelp((Control)this.libertyRuntimePathText, "com.ibm.ws.st.common.ui.iege0039");
                curLabel = this.createLabel(pathComposite, Messages.L_RemoteServerLibertyConfigPath);
                this.installPathCtrls[2] = curLabel;
                data = new GridData(256);
                curLabel.setLayoutData((Object)data);
                this.libertyConfigPathText = this.createTextField(pathComposite, 0);
                this.installPathCtrls[3] = this.libertyConfigPathText;
                data = new GridData(768);
                this.libertyConfigPathText.setLayoutData((Object)data);
                this.libertyConfigPathText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (AbstractRemoteServerStartupComposite.this.updating) {
                            return;
                        }
                        AbstractRemoteServerStartupComposite.this.updating = true;
                        AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_LibertyConfigPath", (Object)AbstractRemoteServerStartupComposite.this.libertyConfigPathText.getText());
                        AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartConfigPathCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_LibertyConfigPath", AbstractRemoteServerStartupComposite.this.libertyConfigPathText.getText()));
                        AbstractRemoteServerStartupComposite.this.updating = false;
                        AbstractRemoteServerStartupComposite.this.showValidationError(1);
                    }
                });
                helpSystem.setHelp((Control)this.libertyConfigPathText, "com.ibm.ws.st.common.ui.iege0039");
            }
        }
        curText = this.createText(this, Messages.L_RemoteServerAuthMethod, 0, 2);
        curText.setLayoutData((Object)data);
        this.logonCtrls[0] = curText;
        data = new GridData(256);
        curText.setLayoutData((Object)data);
        Composite logonComposite = this.createSubComposite(this, 1);
        this.isOSLogonBtn = this.createButton(logonComposite, Messages.L_RemoteServerAuth_OS, 16);
        this.logonCtrls[1] = this.isOSLogonBtn;
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.isOSLogonBtn.setLayoutData((Object)data);
        this.isOSLogonBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractRemoteServerStartupComposite.this.updating) {
                    return;
                }
                AbstractRemoteServerStartupComposite.this.updating = true;
                AbstractRemoteServerStartupComposite.this.setLogonCtrls(true);
                AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_LogonMethod", (Object)0);
                AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerIntAttributeCommand(Messages.L_SetRemoteServerStartLogonMethodCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_LogonMethod", 0));
                AbstractRemoteServerStartupComposite.this.updating = false;
                AbstractRemoteServerStartupComposite.this.showValidationError(2);
            }
        });
        helpSystem.setHelp((Control)this.isOSLogonBtn, "com.ibm.ws.st.common.ui.iege0040");
        Composite osLogonComposite = this.createSubComposite(logonComposite, 2);
        curLabel = this.createLabel(osLogonComposite, Messages.L_RemoteServerAuth_LogonId);
        this.osIdPasswdCtrls[0] = curLabel;
        data = new GridData(256);
        data.horizontalIndent = 10;
        curLabel.setLayoutData((Object)data);
        this.osIdText = this.createTextField(osLogonComposite, 0);
        this.osIdPasswdCtrls[1] = this.osIdText;
        data = new GridData(768);
        this.osIdText.setLayoutData((Object)data);
        this.osIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractRemoteServerStartupComposite.this.updating) {
                    return;
                }
                AbstractRemoteServerStartupComposite.this.updating = true;
                AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_OSId", (Object)AbstractRemoteServerStartupComposite.this.osIdText.getText());
                AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartLogonOSIdCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_OSId", AbstractRemoteServerStartupComposite.this.osIdText.getText()));
                AbstractRemoteServerStartupComposite.this.updating = false;
                AbstractRemoteServerStartupComposite.this.showValidationError(3);
            }
        });
        helpSystem.setHelp((Control)this.osIdText, "com.ibm.ws.st.common.ui.iege0041");
        curLabel = this.createLabel(osLogonComposite, Messages.L_RemoteServerAuth_LogonPassword);
        this.osIdPasswdCtrls[2] = curLabel;
        data = new GridData(256);
        data.horizontalIndent = 10;
        curLabel.setLayoutData((Object)data);
        this.osPasswordText = this.createTextField(osLogonComposite, 0);
        this.osIdPasswdCtrls[3] = this.osPasswordText;
        data = new GridData(768);
        this.osPasswordText.setLayoutData((Object)data);
        this.osPasswordText.setEchoChar('*');
        this.osPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractRemoteServerStartupComposite.this.updating) {
                    return;
                }
                AbstractRemoteServerStartupComposite.this.updating = true;
                AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_OSPassword", (Object)AbstractRemoteServerStartupComposite.this.osPasswordText.getText());
                if (AbstractRemoteServerStartupComposite.this.remoteInfo.getMode().equals((Object)RemoteServerInfo.RemoteServerType.Liberty)) {
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetRemoteServerOSPwdCommand(Messages.L_SetRemoteServerStartLogonOSPwdCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_OSPassword", AbstractRemoteServerStartupComposite.this.osPasswordText.getText(), AbstractRemoteServerStartupComposite.this.remoteInfo));
                } else {
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartLogonOSPwdCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_OSPassword", AbstractRemoteServerStartupComposite.this.osPasswordText.getText()));
                }
                AbstractRemoteServerStartupComposite.this.updating = false;
                AbstractRemoteServerStartupComposite.this.showValidationError(3);
            }
        });
        helpSystem.setHelp((Control)this.osPasswordText, "com.ibm.ws.st.common.ui.iege0042");
        this.isSSHBtn = this.createButton(logonComposite, Messages.L_RemoteServerAuth_SSH, 16);
        this.logonCtrls[2] = this.isSSHBtn;
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.isSSHBtn.setLayoutData((Object)data);
        this.isSSHBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractRemoteServerStartupComposite.this.updating) {
                    return;
                }
                AbstractRemoteServerStartupComposite.this.updating = true;
                AbstractRemoteServerStartupComposite.this.setLogonCtrls(false);
                AbstractRemoteServerStartupComposite.this.remoteInfo.putIntegerValue("remoteStart_LogonMethod", 1);
                AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerIntAttributeCommand(Messages.L_SetRemoteServerStartLogonMethodCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_LogonMethod", 1));
                AbstractRemoteServerStartupComposite.this.updating = false;
                AbstractRemoteServerStartupComposite.this.showValidationError(2);
            }
        });
        helpSystem.setHelp((Control)this.isSSHBtn, "com.ibm.ws.st.common.ui.iege0043");
        this.sshComposite = new SSHLogonComposite(logonComposite, this, this.serverWc, this.remoteInfo);
        if (this.remoteInfo.getMode().equals((Object)RemoteServerInfo.RemoteServerType.Liberty) && this instanceof ServerEditorRemoteStartupComposite) {
            curText = this.createText(this, Messages.L_RemoteServerDebugPortDescription, 2, 0);
            this.debugCtrls[0] = curText;
            data = new GridData(256);
            curText.setLayoutData((Object)data);
            Composite debugComposite = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 2;
            layout.marginWidth = 20;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 15;
            debugComposite.setLayout((Layout)layout);
            data = new GridData(784);
            debugComposite.setLayoutData((Object)data);
            curLabel = this.createLabel(debugComposite, Messages.L_RemoteServerDebugPortLabel);
            this.debugCtrls[1] = curLabel;
            data = new GridData(256);
            curLabel.setLayoutData((Object)data);
            this.debugPortText = this.createTextField(debugComposite, 0);
            this.debugCtrls[2] = this.debugPortText;
            data = new GridData(768);
            this.debugPortText.setLayoutData((Object)data);
            this.debugPortText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (AbstractRemoteServerStartupComposite.this.updating) {
                        return;
                    }
                    AbstractRemoteServerStartupComposite.this.updating = true;
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_debugPort", (Object)AbstractRemoteServerStartupComposite.this.debugPortText.getText());
                    AbstractRemoteServerStartupComposite.this.execute((IUndoableOperation)new SetServerStringAttributeCommand(Messages.L_SetRemoteServerStartDebugPortCommandDescription, AbstractRemoteServerStartupComposite.this.serverWc, "remoteStart_debugPort", AbstractRemoteServerStartupComposite.this.debugPortText.getText()));
                    AbstractRemoteServerStartupComposite.this.updating = false;
                    AbstractRemoteServerStartupComposite.this.showValidationError(6);
                }
            });
            helpSystem.setHelp((Control)this.debugPortText, "com.ibm.ws.st.common.ui.iege0047");
        }
    }

    public PropertyChangeListener getChangeListener() {
        if (this.propertyListener != null) {
            return null;
        }
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (AbstractRemoteServerStartupComposite.this.updating) {
                    return;
                }
                AbstractRemoteServerStartupComposite.this.updating = true;
                if ("remoteStart_Enabled".equals(event.getPropertyName())) {
                    Boolean b = (Boolean)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_Enabled", (Object)b);
                    AbstractRemoteServerStartupComposite.this.isEnableRemoteServerStartupCheckbox.setSelection(b.booleanValue());
                    AbstractRemoteServerStartupComposite.this.handleSetEnableRemoteStartup();
                } else if ("remoteStart_ProfilePath".equals(event.getPropertyName())) {
                    String newValue = (String)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_ProfilePath", (Object)newValue);
                    if (newValue != null) {
                        AbstractRemoteServerStartupComposite.this.wasProfilePathText.setText(newValue);
                    }
                } else if ("remoteStart_LibertyRuntimePath".equals(event.getPropertyName())) {
                    String newValue = (String)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_LibertyRuntimePath", (Object)newValue);
                    if (newValue != null) {
                        AbstractRemoteServerStartupComposite.this.libertyRuntimePathText.setText(newValue);
                    }
                } else if ("remoteStart_LibertyConfigPath".equals(event.getPropertyName())) {
                    String newValue = (String)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_LibertyConfigPath", (Object)newValue);
                    if (newValue != null) {
                        AbstractRemoteServerStartupComposite.this.libertyConfigPathText.setText(newValue);
                    }
                } else if ("remoteStart_Platform".equals(event.getPropertyName())) {
                    Integer platform = (Integer)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_Platform", (Object)platform);
                    AbstractRemoteServerStartupComposite.this.setPlatform(platform);
                } else if ("remoteStart_LogonMethod".equals(event.getPropertyName())) {
                    Integer method = (Integer)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_LogonMethod", (Object)method);
                    boolean isOSLogon = method == 0;
                    AbstractRemoteServerStartupComposite.this.setLogonCtrls(isOSLogon);
                } else if ("remoteStart_OSId".equals(event.getPropertyName())) {
                    String newValue = (String)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_OSId", (Object)newValue);
                    if (newValue != null) {
                        AbstractRemoteServerStartupComposite.this.osIdText.setText(newValue);
                    }
                } else if ("remoteStart_OSPassword".equals(event.getPropertyName())) {
                    String newValue = (String)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_OSPassword", (Object)newValue);
                    if (newValue != null) {
                        AbstractRemoteServerStartupComposite.this.osPasswordText.setText(newValue);
                    }
                } else if ("remoteStart_SSHKeyFile".equals(event.getPropertyName())) {
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_SSHKeyFile", event.getNewValue());
                } else if ("remoteStart_debugPort".equals(event.getPropertyName())) {
                    Integer newValue = (Integer)event.getNewValue();
                    AbstractRemoteServerStartupComposite.this.remoteInfo.put((Object)"remoteStart_debugPort", (Object)newValue);
                    if (newValue != null) {
                        AbstractRemoteServerStartupComposite.this.debugPortText.setText(newValue.toString());
                    }
                } else if ("hostname".equals(event.getPropertyName())) {
                    if (AbstractRemoteServerStartupComposite.this.enableRemoteServerStartup) {
                        String curHostName = (String)event.getNewValue();
                        AbstractRemoteServerStartupComposite.this.isLocalhost = SocketUtil.isLocalhost((String)curHostName);
                        AbstractRemoteServerStartupComposite.this.remoteInfo.putBooleanValue("remoteStart_Enabled", !AbstractRemoteServerStartupComposite.this.isLocalhost);
                        AbstractRemoteServerStartupComposite.this.isEnableRemoteServerStartupCheckbox.setEnabled(!AbstractRemoteServerStartupComposite.this.isLocalhost);
                        AbstractRemoteServerStartupComposite.this.handleSetEnableRemoteStartup();
                    } else {
                        AbstractRemoteServerStartupComposite.this.isEnableRemoteServerStartupCheckbox.setEnabled(false);
                    }
                } else {
                    AbstractRemoteServerStartupComposite.this.sshComposite.handlePropertyChange(event);
                }
                AbstractRemoteServerStartupComposite.this.showValidationError(1);
                AbstractRemoteServerStartupComposite.this.showValidationError(2);
                AbstractRemoteServerStartupComposite.this.showValidationError(3);
                AbstractRemoteServerStartupComposite.this.updating = false;
            }
        };
        return this.propertyListener;
    }

    public void setEnableRemoteServerStartup(boolean setting) {
        this.enableRemoteServerStartup = setting;
    }

    protected Composite createSubComposite(Composite rootComposite, int numColumn) {
        Composite platformComposite = new Composite(rootComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumn;
        layout.marginHeight = 2;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        platformComposite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        platformComposite.setLayoutData((Object)data);
        return platformComposite;
    }

    protected int getPlatform() {
        int i = 0;
        if (this.remoteInfo != null) {
            i = this.remoteInfo.getIntegerValue("remoteStart_Platform", 0);
        }
        return i;
    }

    protected boolean isOSLogon() {
        boolean b = true;
        if (this.remoteInfo != null) {
            int i = this.remoteInfo.getIntegerValue("remoteStart_LogonMethod", 0);
            b = i == 0;
        }
        return b;
    }

    public void initializeValues() {
        this.updating = true;
        if (this.isEnableRemoteServerStartupCheckbox != null) {
            if (this.enableRemoteServerStartup) {
                boolean isLocalhost = SocketUtil.isLocalhost((String)this.serverWc.getHost());
                boolean remoteStartSelected = !isLocalhost && this.serverWc.getAttribute("remoteStart_Enabled", true);
                this.isEnableRemoteServerStartupCheckbox.setEnabled(!isLocalhost);
                if (!this.remoteInfo.containsKey((Object)"remoteStart_Enabled")) {
                    this.remoteInfo.put((Object)"remoteStart_Enabled", (Object)remoteStartSelected);
                }
                this.isEnableRemoteServerStartupCheckbox.setSelection(this.remoteInfo.getBooleanValue("remoteStart_Enabled", remoteStartSelected));
            } else {
                this.isEnableRemoteServerStartupCheckbox.setEnabled(false);
            }
        }
        if (this.isWindowsBtn != null || this.isDockerServer && this.isLinuxBtn != null) {
            int platform = this.getPlatform();
            this.setPlatform(platform);
        }
        if (this.wasProfilePathText != null) {
            this.wasProfilePathText.setText(this.remoteInfo.getStringValue("remoteStart_ProfilePath"));
        }
        if (this.libertyRuntimePathText != null) {
            this.libertyRuntimePathText.setText(this.remoteInfo.getStringValue("remoteStart_LibertyRuntimePath"));
        }
        if (this.libertyConfigPathText != null) {
            this.libertyConfigPathText.setText(this.remoteInfo.getStringValue("remoteStart_LibertyConfigPath"));
        }
        this.setLogonCtrls(this.isOSLogon());
        if (this.osIdText != null) {
            this.osIdText.setText(this.remoteInfo.getStringValue("remoteStart_OSId"));
        }
        if (this.osPasswordText != null) {
            this.osPasswordText.setText(this.remoteInfo.getStringValue("remoteStart_OSPassword"));
            this.remoteInfo.setTempRemoteOSPassword(this.remoteInfo.getStringValue("remoteStart_OSPassword"));
        }
        if (this.sshComposite != null) {
            this.sshComposite.initializeValues();
        }
        if (this.debugPortText != null) {
            int debugPort = this.serverWc.getAttribute("remoteStart_debugPort", 7777);
            this.debugPortText.setText(Integer.toString(debugPort));
        }
        this.enabledErrorCheck = true;
        if (this.isCreatingCloudServerInstance()) {
            this.initializeForCloudServerInstance();
        }
        this.setCtrlEnablement(this.isEnableRemoteServerStartupCheckbox.getSelection());
        this.updating = false;
        this.showValidationError(1);
        this.showValidationError(2);
        this.showValidationError(3);
    }

    protected void setLogonCtrls(boolean isOSLogon) {
        for (Control c : this.osIdPasswdCtrls) {
            if (c != null) continue;
            return;
        }
        if (this.sshComposite == null) {
            return;
        }
        if (this.isOSLogonBtn == null || this.isSSHBtn == null) {
            return;
        }
        this.isOSLogonBtn.setSelection(isOSLogon);
        this.isSSHBtn.setSelection(!isOSLogon);
        for (Control c : this.osIdPasswdCtrls) {
            c.setEnabled(isOSLogon);
        }
        this.sshComposite.setEnablement(!isOSLogon);
    }

    protected String validate(int key) {
        String msg = null;
        switch (key) {
            case 5: {
                if (this.isEnableRemoteServerStartupCheckbox == null || this.isEnableRemoteServerStartupCheckbox.getSelection()) break;
                return null;
            }
            case 1: {
                this.validationErrors[key] = msg = this.validatePaths();
                break;
            }
            case 0: {
                this.validationErrors[key] = msg = this.validatePlatform();
            }
            case 2: {
                this.validationErrors[key] = msg = this.validateLogonMethod();
                if (msg != null) break;
                if (this.isOSLogonBtn != null && this.isOSLogonBtn.getSelection()) {
                    this.validationErrors[4] = null;
                    msg = this.validate(3);
                    break;
                }
                if (this.isSSHBtn == null || !this.isSSHBtn.getSelection()) break;
                this.validationErrors[3] = null;
                msg = this.validate(4);
                break;
            }
            case 3: {
                this.validationErrors[key] = msg = this.validateOSLogon();
                break;
            }
            case 4: {
                this.validationErrors[key] = msg = this.validateSSHLogon();
                break;
            }
            case 6: {
                this.validationErrors[key] = msg = this.validatePorts();
                break;
            }
        }
        if (this.isEnableRemoteServerStartupCheckbox != null && !this.isEnableRemoteServerStartupCheckbox.getSelection()) {
            return null;
        }
        if (msg == null) {
            for (int i = 0; i < this.validationErrors.length; ++i) {
                if (this.validationErrors[i] == null) continue;
                msg = this.validationErrors[i];
                break;
            }
        }
        return msg;
    }

    @Override
    protected abstract void showValidationError(int var1);

    protected String validatePaths() {
        String s;
        String msg = null;
        if (this.wasProfilePathText != null && ((s = this.wasProfilePathText.getText()) == null || s.trim().isEmpty())) {
            msg = Messages.E_RemoteServer_WAS_PATH;
        }
        if (this.libertyRuntimePathText != null && ((s = this.libertyRuntimePathText.getText()) == null || s.trim().isEmpty())) {
            msg = Messages.E_RemoteServer_Liberty_Runtime_PATH;
        }
        if (this.libertyConfigPathText != null && ((s = this.libertyConfigPathText.getText()) == null || s.trim().isEmpty())) {
            msg = Messages.E_RemoteServer_Liberty_Config_PATH;
        }
        return msg;
    }

    protected String validatePlatform() {
        String msg = null;
        if (!(this.isWindowsBtn != null && this.isWindowsBtn.getSelection() || this.isLinuxBtn != null && this.isLinuxBtn.getSelection() || this.isMACBtn != null && this.isMACBtn.getSelection() || this.isOtherBtn != null && this.isOtherBtn.getSelection())) {
            msg = Messages.E_RemoteServer_WAS_PLATFORM;
        }
        return msg;
    }

    protected String validateLogonMethod() {
        String msg = null;
        if (this.isOSLogonBtn == null || this.isSSHBtn == null || !this.isOSLogonBtn.getSelection() && !this.isSSHBtn.getSelection()) {
            msg = Messages.E_RemoteServer_LOGON_METHOD;
        }
        return msg;
    }

    protected String validateOSLogon() {
        String msg = null;
        if (this.isOSLogonBtn != null && this.isOSLogonBtn.getSelection()) {
            String s;
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "isIBMJRE=" + isIBMJRE);
            }
            if (this.osIdText != null && ((s = this.osIdText.getText()) == null || s.trim().isEmpty())) {
                msg = Messages.E_RemoteServer_OS_LOGON;
                return msg;
            }
            if (this.osPasswordText != null && ((s = this.osPasswordText.getText()) == null || s.trim().isEmpty())) {
                msg = Messages.E_RemoteServer_OS_LOGON;
                return msg;
            }
        }
        return msg;
    }

    protected String validateSSHLogon() {
        String msg = null;
        if (this.isSSHBtn != null && this.isSSHBtn.getSelection() && this.sshComposite != null) {
            msg = this.sshComposite.validate();
        }
        return msg;
    }

    protected String validatePorts() {
        String msg = null;
        if (this.debugPortText == null || !this.debugPortText.isVisible() || !this.debugPortText.getEnabled()) {
            return msg;
        }
        try {
            if (this.debugPortText.getText().isEmpty() || Integer.parseInt(this.debugPortText.getText()) <= 0) {
                msg = Messages.E_RemoteServerDebugValidation;
            }
        }
        catch (Exception e) {
            msg = Messages.E_RemoteServerDebugValidation;
        }
        return msg;
    }

    public boolean isPageComplete() {
        if (this.remoteInfo.isEmpty()) {
            return false;
        }
        if (this.wasProfilePathText != null && this.remoteInfo.getStringValue("remoteStart_ProfilePath").compareTo(this.wasProfilePathText.getText()) != 0) {
            if (this.isCloudServer) {
                this.initializeForCloudServerInstance();
            } else {
                this.reinitializeNonCloudDefaultValues();
            }
            return false;
        }
        if (this.isCloudServer && this.lastInstanceType.compareTo((Enum)RemoteServerInfo.CloudType.CLOUD) != 0) {
            return false;
        }
        if (!this.isCloudServer && this.lastInstanceType.compareTo((Enum)RemoteServerInfo.CloudType.CLOUD) == 0) {
            return false;
        }
        return this.isPageComplete;
    }

    @Override
    protected boolean isUpdating() {
        return this.updating;
    }

    @Override
    protected void setUpdating(boolean value) {
        this.updating = value;
    }

    private Text createText(Composite parent, String message, int span, int indent) {
        return this.createText(parent, message, span, indent, true);
    }

    private Text createText(Composite parent, String message, int span, int indent, boolean fillHorizontal) {
        Text txt = new Text(parent, 64);
        txt.setText(message);
        txt.setBackground(parent.getBackground());
        txt.setEditable(false);
        GridData data = null;
        data = fillHorizontal ? new GridData(768) : new GridData();
        if (span != 0) {
            data.horizontalSpan = span;
            txt.setLayoutData((Object)data);
        }
        return txt;
    }

    public boolean isCreatingCloudServerInstance() {
        if (this.isCloudServer) {
            this.lastInstanceType = RemoteServerInfo.CloudType.CLOUD;
            return true;
        }
        this.lastInstanceType = RemoteServerInfo.CloudType.NON_CLOUD;
        return false;
    }

    public void initializeForCloudServerInstance() {
        this.updating = true;
        this.isWindowsBtn.setSelection(false);
        this.isLinuxBtn.setSelection(true);
        this.isOSLogonBtn.setSelection(false);
        this.isSSHBtn.setSelection(true);
        for (Control c : this.platformCtrls) {
            if (c == null) continue;
            c.setEnabled(false);
        }
        for (Control c : this.installPathCtrls) {
            if (c == null) continue;
            c.setEnabled(true);
        }
        for (Control c : this.logonCtrls) {
            if (c == null) continue;
            c.setEnabled(false);
        }
        for (Control ctrl : this.debugCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(false);
        }
        for (Control c : this.osIdPasswdCtrls) {
            if (c == null) continue;
            c.setEnabled(false);
        }
        if (this.sshComposite != null) {
            this.sshComposite.setEnablement(false);
        }
        if (this.remoteInfo != null) {
            if (this.wasProfilePathText != null) {
                this.wasProfilePathText.setText(this.remoteInfo.getStringValue("remoteStart_ProfilePath"));
            }
            if (this.libertyRuntimePathText != null) {
                this.libertyRuntimePathText.setText(this.remoteInfo.getStringValue("remoteStart_LibertyRuntimePath"));
            }
            if (this.libertyConfigPathText != null) {
                this.libertyConfigPathText.setText(this.remoteInfo.getStringValue("remoteStart_LibertyConfigPath"));
            }
            if (this.sshComposite != null) {
                this.sshComposite.initializeValues();
            }
            if (this.osIdText != null) {
                this.osIdText.setText("");
            }
            if (this.osPasswordText != null) {
                this.osPasswordText.setText("");
            }
        }
        this.updating = false;
        this.isPageComplete = true;
    }

    public void reinitializeNonCloudDefaultValues() {
        if (this.wasProfilePathText != null) {
            this.wasProfilePathText.setText("");
        }
        if (this.libertyRuntimePathText != null) {
            this.libertyRuntimePathText.setText("");
        }
        if (this.libertyConfigPathText != null) {
            this.libertyConfigPathText.setText("");
        }
        this.sshComposite.clearValues();
        this.osIdText.setText("");
        this.osPasswordText.setText("");
        this.isSSHBtn.setSelection(false);
        this.isOSLogonBtn.setSelection(true);
        for (Control c : this.platformCtrls) {
            if (c == null) continue;
            c.setEnabled(true);
        }
        for (Control c : this.installPathCtrls) {
            if (c == null) continue;
            c.setEnabled(true);
        }
        for (Control c : this.logonCtrls) {
            if (c == null) continue;
            c.setEnabled(true);
        }
        for (Control ctrl : this.debugCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(true);
        }
        for (Control c : this.osIdPasswdCtrls) {
            if (c == null) continue;
            c.setEnabled(true);
        }
        if (this.sshComposite != null) {
            this.sshComposite.setEnablement(false);
        }
        this.showValidationError(1);
        this.showValidationError(2);
    }

    public void cloudAlwaysUpdateTheseValues(String sshPassphrase, String sshKeyFile) {
        if (this.sshComposite != null) {
            this.sshComposite.cloudAlwaysUpdateTheseValues(sshPassphrase, sshKeyFile);
        }
    }

    protected void setCtrlEnablement(boolean b) {
        if (!b || b && !this.isCreatingCloudServerInstance()) {
            for (Control c : this.platformCtrls) {
                if (c == null) continue;
                c.setEnabled(b);
            }
            for (Control c : this.installPathCtrls) {
                if (c == null) continue;
                c.setEnabled(b);
            }
            for (Control c : this.logonCtrls) {
                if (c == null) continue;
                c.setEnabled(b);
            }
            for (Control ctrl : this.debugCtrls) {
                if (ctrl == null) continue;
                ctrl.setEnabled(b);
            }
            if (!b) {
                for (Control c : this.osIdPasswdCtrls) {
                    if (c == null) continue;
                    c.setEnabled(b);
                }
                if (this.sshComposite != null) {
                    this.sshComposite.setEnablement(b);
                }
            } else {
                this.setLogonCtrls(this.isOSLogon());
            }
        }
        if (this.isCreatingCloudServerInstance() && b) {
            this.initializeForCloudServerInstance();
        }
    }

    protected void handleSetEnableRemoteStartup() {
        if (this.isEnableRemoteServerStartupCheckbox != null) {
            boolean enabled = this.isEnableRemoteServerStartupCheckbox.getSelection() && this.remoteInfo.getBooleanValue("remoteStart_Enabled", true);
            for (Object ctrl : this.installPathCtrls) {
                if (ctrl == null) continue;
                ctrl.setEnabled(enabled);
            }
            for (Control ctrl : this.platformCtrls) {
                if (ctrl == null) continue;
                ctrl.setEnabled(enabled);
            }
            for (Object ctrl : this.logonCtrls) {
                if (ctrl == null) continue;
                ctrl.setEnabled(enabled);
            }
            for (Object ctrl : this.debugCtrls) {
                if (ctrl == null) continue;
                ctrl.setEnabled(enabled);
            }
            this.handleCredentialCtrlEnablement();
        }
    }

    protected void handleCredentialCtrlEnablement() {
        boolean selected;
        boolean enabled = true;
        if (this.isEnableRemoteServerStartupCheckbox != null) {
            boolean bl = enabled = this.isEnableRemoteServerStartupCheckbox.getSelection() && this.remoteInfo.getBooleanValue("remoteStart_Enabled", true);
        }
        if (this.isOSLogonBtn != null) {
            selected = this.isOSLogonBtn.getSelection();
            for (Control ctrl : this.osIdPasswdCtrls) {
                if (ctrl == null) continue;
                ctrl.setEnabled(selected && enabled);
            }
        }
        if (this.isSSHBtn != null) {
            selected = this.isSSHBtn.getSelection();
            if (this.sshComposite != null) {
                this.sshComposite.setEnablement(selected && enabled);
            }
        }
    }

    protected void setAllReadOnly() {
        boolean enabled = false;
        if (this.isEnableRemoteServerStartupCheckbox != null) {
            this.isEnableRemoteServerStartupCheckbox.setEnabled(enabled);
        }
        for (Object ctrl : this.installPathCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(enabled);
        }
        for (Control ctrl : this.platformCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(enabled);
        }
        for (Object ctrl : this.logonCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(enabled);
        }
        for (Object ctrl : this.debugCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(enabled);
        }
        for (Object ctrl : this.osIdPasswdCtrls) {
            if (ctrl == null) continue;
            ctrl.setEnabled(enabled);
        }
        if (this.sshComposite != null) {
            this.sshComposite.setEnablement(enabled);
        }
    }

    @Override
    protected void execute(IUndoableOperation op) {
        for (CommandListener l : this.commandListeners) {
            l.handleCommand(op);
        }
    }

    public String[] getValidationErrors() {
        if (this.isEnableRemoteServerStartupCheckbox == null || !this.isEnableRemoteServerStartupCheckbox.getSelection()) {
            return new String[0];
        }
        return this.validationErrors;
    }

    protected void addCommandListener(CommandListener c) {
        this.commandListeners.add(c);
    }

    public RemoteServerInfo getRemoteServerInfo() {
        return this.remoteInfo;
    }

    protected void setPlatform(int platform) {
        boolean disableOSLogon = false;
        switch (platform) {
            case 2: {
                this.setButtons(this.isOtherBtn);
                break;
            }
            case 0: {
                this.setButtons(this.isWindowsBtn);
                if (!this.isDockerServer) break;
                disableOSLogon = true;
                break;
            }
            case 1: {
                this.setButtons(this.isLinuxBtn);
                break;
            }
            case 3: {
                this.setButtons(this.isMACBtn);
                break;
            }
            default: {
                if (this.isDockerServer) {
                    this.setButtons(this.isLinuxBtn);
                    break;
                }
                this.setButtons(this.isWindowsBtn);
            }
        }
        if (this.isSSHBtn != null && this.isOSLogonBtn != null) {
            if (disableOSLogon) {
                this.isSSHBtn.setSelection(true);
                this.isOSLogonBtn.setSelection(false);
                this.isOSLogonBtn.setEnabled(false);
            } else {
                this.isOSLogonBtn.setEnabled(true);
            }
            this.setLogonCtrls(this.isOSLogonBtn.getSelection());
        }
    }

    protected void setButtons(Button activeButton) {
        for (Button button : this.platformButtons) {
            button.setSelection(button == activeButton);
        }
    }

    static {
        block5: {
            isIBMJRE = false;
            if (System.getProperty("java.vendor").indexOf("IBM") > -1) {
                isIBMJRE = true;
            } else {
                try {
                    if (Class.forName("com.ibm.security.util.ObjectIdentifier", false, AbstractRemoteServerStartupComposite.class.getClassLoader()) != null) {
                        isIBMJRE = true;
                    }
                }
                catch (Throwable t) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)0, "The JRE does not appear to be an IBM JRE", t);
                }
            }
        }
    }

    abstract class CommandListener {
        CommandListener() {
        }

        public abstract void handleCommand(IUndoableOperation var1);
    }
}

