/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolver;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.jee.core.internal.JEEConstants;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class WebDDFeatureResolver
extends FeatureResolver {
    private static final String RES_TYPE_DATASOURCE = "javax.sql.DataSource";
    private static final String RES_TYPE_JMS = "javax.jms.";

    public void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, boolean includeAll, IProgressMonitor monitor) {
        for (IModule[] module : moduleList) {
            Iterator iterator;
            Object refs;
            WebApp webApp;
            IModule m = module[module.length - 1];
            IProject project = m.getProject();
            if (project == null) continue;
            IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)project);
            Object webAppObj = newProvider.getModelObject();
            if (webAppObj == null) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "No web app impl available");
                continue;
            }
            ArrayList<FeatureResolverFeature> features = new ArrayList<FeatureResolverFeature>();
            if (webAppObj instanceof WebApp) {
                webApp = (WebApp)webAppObj;
                if (!webApp.getDataSource().isEmpty()) {
                    features.add(JEEConstants.FEATURE_JDBC);
                } else {
                    refs = webApp.getResourceRefs();
                    iterator = refs.iterator();
                    while (iterator.hasNext()) {
                        ResourceRef ref = (ResourceRef)iterator.next();
                        if (!features.contains(JEEConstants.FEATURE_JDBC) && RES_TYPE_DATASOURCE.equals(ref.getResType())) {
                            features.add(JEEConstants.FEATURE_JDBC);
                        }
                        if (features.contains(JEEConstants.FEATURE_JMS) || ref.getResType() == null || !ref.getResType().startsWith(RES_TYPE_JMS)) continue;
                        features.add(JEEConstants.FEATURE_JMS);
                    }
                }
            } else if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                refs = webApp.getResourceRefs();
                if (refs != null) {
                    iterator = refs.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        org.eclipse.jst.j2ee.common.ResourceRef ref = (org.eclipse.jst.j2ee.common.ResourceRef)obj;
                        if (!features.contains(JEEConstants.FEATURE_JDBC) && RES_TYPE_DATASOURCE.equals(ref.getType())) {
                            features.add(JEEConstants.FEATURE_JDBC);
                        }
                        if (features.contains(JEEConstants.FEATURE_JMS) || ref.getType() == null || !ref.getType().startsWith(RES_TYPE_JMS)) continue;
                        features.add(JEEConstants.FEATURE_JMS);
                    }
                }
            } else if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not cast to any known web app impl");
            }
            for (FeatureResolverFeature feature : features) {
                FeatureResolver.checkAndAddFeature((RequiredFeatureMap)requiredFeatures, (FeatureSet)existingFeatures, (WebSphereRuntime)wr, (FeatureResolverFeature)feature, Collections.singletonList(module), (boolean)includeAll);
            }
        }
    }
}

