/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.jee.core.internal.SharedLibRefInfo;
import com.ibm.ws.st.jee.core.internal.Trace;
import com.ibm.ws.st.jee.core.internal.UtilitySharedLibInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class SharedLibertyUtils {
    static Map<String, SharedLibInfo> sharedLibInfoMap = new ConcurrentHashMap<String, SharedLibInfo>();

    public static UtilitySharedLibInfo getUtilPrjSharedLibInfo(IProject project) {
        UtilitySharedLibInfo settings = new UtilitySharedLibInfo();
        if (project != null) {
            SharedLibertyUtils.getSettings(settings, project, ".settings/com.ibm.ws.st.shared.library");
        }
        return settings;
    }

    public static SharedLibRefInfo getSharedLibRefInfo(IProject project) {
        SharedLibRefInfo settings = new SharedLibRefInfo();
        SharedLibertyUtils.getSettings(settings, project, ".settings/com.ibm.ws.st.shared.library.ref");
        return settings;
    }

    private static void getSettings(Properties settings, IProject project, String filePath) {
        IPath projLocation = project.getLocation();
        if (projLocation == null) {
            SharedLibInfo info;
            if (".settings/com.ibm.ws.st.shared.library".equals(filePath) && (info = SharedLibertyUtils.getSharedLibInfo(project)) != null) {
                settings.setProperty("com.ibm.ws.st.jee.shared.library.id", info.getLibId());
                settings.setProperty("com.ibm.ws.st.jee.shared.library.dir", info.getLibDir());
            }
            return;
        }
        SharedLibertyUtils.getSettingsFromFile(settings, project, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getSettingsFromFile(Properties settings, IProject project, String filePath) {
        File file = project.getLocation().append(filePath).toFile();
        if (file != null && file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                settings.load(in);
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "getSettings()", e);
                }
            }
            finally {
                block15: {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            if (!Trace.ENABLED) break block15;
                            Trace.trace((byte)1, "getSettings()", e);
                        }
                    }
                }
            }
        }
    }

    public static boolean isSharedLibrary(IModule module) {
        return SharedLibertyUtils.hasProjectLibSettings(module, "jst.utility", ".settings/com.ibm.ws.st.shared.library");
    }

    public static boolean isValidSharedLibrary(IModule module) {
        if (module == null) {
            return false;
        }
        String id = module.getModuleType().getId();
        if (!"jst.utility".equals(id)) {
            return false;
        }
        UtilitySharedLibInfo sharedLibInfo = SharedLibertyUtils.getUtilPrjSharedLibInfo(module.getProject());
        String libId = sharedLibInfo.getLibId();
        return libId != null && !libId.isEmpty();
    }

    public static boolean isEJBRefSharedLibrary(IModule module) {
        return SharedLibertyUtils.hasProjectLibSettings(module, "jst.ejb", ".settings/com.ibm.ws.st.shared.library.ref");
    }

    public static boolean isWebRefSharedLibrary(IModule module) {
        return SharedLibertyUtils.hasProjectLibSettings(module, "jst.web", ".settings/com.ibm.ws.st.shared.library.ref");
    }

    public static boolean isEARRefSharedLibrary(IModule module) {
        return SharedLibertyUtils.hasProjectLibSettings(module, "jst.ear", ".settings/com.ibm.ws.st.shared.library.ref");
    }

    protected static boolean hasProjectLibSettings(IModule module, String moduleTypeId, String filePath) {
        if (module == null || moduleTypeId == null || filePath == null) {
            return false;
        }
        String id = module.getModuleType().getId();
        if (!moduleTypeId.equals(id)) {
            return false;
        }
        IProject project = module.getProject();
        if (project == null) {
            return false;
        }
        if (project.getLocation() == null) {
            if (".settings/com.ibm.ws.st.shared.library".equals(filePath)) {
                return SharedLibertyUtils.getSharedLibInfo(project) != null;
            }
            return false;
        }
        IPath settingFile = project.getLocation().append(filePath);
        File file = settingFile.toFile();
        return file.exists();
    }

    public static boolean hasSharedLibSettingsFile(IProject project, String filePath) {
        if (project == null || project.getLocation() == null) {
            return false;
        }
        IPath settingFile = project.getLocation().append(filePath);
        File file = settingFile.toFile();
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings(Properties settings, IPath path) {
        if (settings == null || path == null) {
            return;
        }
        File file = path.toFile();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            settings.store(out, null);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "saveSettings()", e);
            }
        }
        finally {
            block15: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block15;
                        Trace.trace((byte)1, "saveSettings()", e);
                    }
                }
            }
        }
    }

    static void addSharedLibInfo(IProject project) {
        if (project == null || project.getLocation() == null) {
            return;
        }
        Properties props = new Properties();
        SharedLibertyUtils.getSettingsFromFile(props, project, ".settings/com.ibm.ws.st.shared.library");
        String id = props.getProperty("com.ibm.ws.st.jee.shared.library.id", "");
        String dir = props.getProperty("com.ibm.ws.st.jee.shared.library.dir", "");
        sharedLibInfoMap.put(project.getName(), new SharedLibInfo(id, dir));
    }

    static void removeSharedLibInfo(IProject project) {
        if (project != null && SharedLibertyUtils.isLastPublished(project)) {
            sharedLibInfoMap.remove(project.getName());
        }
    }

    private static SharedLibInfo getSharedLibInfo(IProject project) {
        return sharedLibInfoMap.get(project.getName());
    }

    public static boolean isPublished(IProject project) {
        return SharedLibertyUtils.getPublishCount(project) > 0;
    }

    private static boolean isLastPublished(IProject project) {
        return SharedLibertyUtils.getPublishCount(project) < 2;
    }

    private static int getPublishCount(IProject project) {
        IModule module = ServerUtil.getModule((IProject)project);
        return module == null ? 0 : ServerUtil.getServersByModule((IModule)module, null).length;
    }

    private static class SharedLibInfo {
        private final String id;
        private final String dir;

        SharedLibInfo(String id, String dir) {
            this.id = id;
            this.dir = dir;
        }

        String getLibId() {
            return this.id;
        }

        String getLibDir() {
            return this.dir;
        }
    }
}

