/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.APIVisibility;
import com.ibm.ws.st.core.internal.OutOfSyncModuleInfo;
import com.ibm.ws.st.core.internal.ServerExtension;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.jee.core.internal.DeploymentDescriptorHelper;
import com.ibm.ws.st.jee.core.internal.Messages;
import com.ibm.ws.st.jee.core.internal.SharedLibRefInfo;
import com.ibm.ws.st.jee.core.internal.SharedLibertyUtils;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModule2;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class JEEServerExtension
extends ServerExtension {
    private static final String JST_WEB = "jst.web";
    private static final String JST_WEBFRAGMENT = "jst.webfragment";
    private static final String JST_EJB = "jst.ejb";
    private static final String JST_EAR = "jst.ear";
    private static final String JST_UTILITY = "jst.utility";
    private static final String JST_JCA = "jst.connector";
    private static final String JST_APPCLIENT = "jst.appclient";
    private static final String WAR_EXTENSION = ".war";
    private static final String EJB_EXTENSION = ".jar";
    private static final String EAR_EXTENSION = ".ear";
    private static final String RAR_EXTENSION = ".rar";
    private static final String EAR_APPLICATION = "enterpriseApplication";
    private static final String WEB_APPLICATION = "webApplication";
    private static final String EJB_APPLICATION = "ejbApplication";
    private static final String RAR_APPLICATION = "resourceAdapter";
    private static final String[] staticExtension = new String[]{"bmp", "cab", "css", "doc", "exe", "gif", "htm", "html", "ico", "ini", "jhtml", "jpeg", "jpg", "js", "jsp", "jspf", "jspx", "jpg", "pdf", "png", "properties", "swf", "tif", "tiff", "ttf", "txt", "xhtml", "xls", "zip", "java"};
    private static final String EXT_CLASS = "class";

    protected static String getModuleDeployName(IModule module) {
        String moduleTypeId = module.getModuleType().getId();
        String s = null;
        IModule2 module2 = (IModule2)module.getAdapter(IModule2.class);
        if (module2 != null) {
            s = module2.getProperty("org.eclipse.wst.server.core.deployName");
        }
        if (s == null || s.isEmpty()) {
            s = module.getName();
        }
        if (JST_WEB.equals(moduleTypeId)) {
            if (!s.endsWith(WAR_EXTENSION)) {
                s = s + WAR_EXTENSION;
            }
        } else if (JST_EAR.equals(moduleTypeId)) {
            if (!s.endsWith(EAR_EXTENSION)) {
                s = s + EAR_EXTENSION;
            }
        } else if (JST_EJB.equals(moduleTypeId)) {
            if (!s.endsWith(EJB_EXTENSION)) {
                s = s + EJB_EXTENSION;
            }
        } else if (JST_JCA.equals(moduleTypeId) && !s.endsWith(RAR_EXTENSION)) {
            s = s + RAR_EXTENSION;
        }
        return s;
    }

    public IStatus canAddModule(IModule module) {
        boolean isEJB;
        boolean isEAR;
        block13: {
            String moduleTypeId = module.getModuleType().getId();
            isEAR = JST_EAR.equals(moduleTypeId);
            boolean isWeb = JST_WEB.equals(moduleTypeId);
            isEJB = JST_EJB.equals(moduleTypeId);
            boolean isRAR = JST_JCA.equals(moduleTypeId);
            if (!(isEAR || isWeb || isEJB || isRAR)) {
                return null;
            }
            try {
                String version = module.getModuleType().getVersion();
                if (isWeb || isEJB || isRAR) {
                    return this.checkPublishedModule(module);
                }
                if (!isEAR || !this.getWebSphereServer().getWebSphereRuntime().isEARSupported(version)) break block13;
                IEnterpriseApplication ear = (IEnterpriseApplication)module.loadAdapter(IEnterpriseApplication.class, null);
                IModule[] children = null;
                try {
                    children = ear.getModules();
                }
                catch (Exception e) {
                    if (Trace.ENABLED) {
                        Trace.logError("Failed to get ear moduless", e);
                    }
                    return new Status(4, "com.ibm.ws.st.jee.core", 0, Messages.errorGettingModulesInEAR, null);
                }
                boolean hasAModule = false;
                if (children != null) {
                    for (IModule child : children) {
                        String id = child.getModuleType().getId();
                        if (JST_WEB.equals(id) || JST_EJB.equals(id) || JST_JCA.equals(id) || JST_APPCLIENT.equals(id)) {
                            hasAModule = true;
                            continue;
                        }
                        if (JST_WEBFRAGMENT.equals(id) || JST_UTILITY.equals(id)) continue;
                        return new Status(4, "com.ibm.ws.st.jee.core", 0, Messages.errorNotSupportedModuleInEAR, null);
                    }
                }
                if (!hasAModule) {
                    return new Status(4, "com.ibm.ws.st.jee.core", 0, Messages.errorEARMissingRequiredModules, null);
                }
                return this.checkPublishedModule(module);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block13;
                Trace.trace((byte)1, "Module version was not a number", e);
            }
        }
        if (isEAR) {
            return new Status(4, "com.ibm.ws.st.jee.core", 0, Messages.errorEARSpecLevel, null);
        }
        if (isEJB) {
            return new Status(4, "com.ibm.ws.st.jee.core", 0, Messages.errorEJBSpecLevel, null);
        }
        return new Status(4, "com.ibm.ws.st.jee.core", 0, Messages.errorWebSpecLevel, null);
    }

    IStatus checkPublishedModule(IModule module) {
        if (this.getWebSphereServer().isExternalAppOnServer(module.getName())) {
            return new Status(2, "com.ibm.ws.st.jee.core", NLS.bind((String)Messages.warningAppIsOnServer, (Object)module.getName()));
        }
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        IEnterpriseApplication earModule;
        IModuleType moduleType = module[module.length - 1].getModuleType();
        if (moduleType != null && JST_WEB.equals(moduleType.getId())) {
            IWebModule webModule = (IWebModule)module[module.length - 1].loadAdapter(IWebModule.class, null);
            if (webModule != null) {
                return webModule.getModules();
            }
        } else if (moduleType != null && JST_EAR.equals(moduleType.getId()) && (earModule = (IEnterpriseApplication)module[0].loadAdapter(IEnterpriseApplication.class, null)) != null) {
            return earModule.getModules();
        }
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IModule[] ms;
        String moduleTypeId = module.getModuleType().getId();
        if (JST_EAR.equals(moduleTypeId)) {
            IStatus status = this.canAddModule(module);
            if (status == null || !status.isOK()) {
                throw new CoreException(status);
            }
            return new IModule[]{module};
        }
        if (JST_WEB.equals(moduleTypeId)) {
            ArrayList<IModule> modules = this.getWebRootModules(module);
            return modules.toArray(new IModule[modules.size()]);
        }
        if (JST_EJB.equals(moduleTypeId)) {
            ArrayList<IModule> modules = this.getEJBRootModules(module);
            return modules.toArray(new IModule[modules.size()]);
        }
        if (JST_WEBFRAGMENT.equals(moduleTypeId)) {
            IModule[] ms2;
            HashSet<IModule> modules = new HashSet<IModule>();
            for (IModule m : ms2 = J2EEUtil.getWebModules((IModule)module, null)) {
                modules.addAll(this.getWebRootModules(m));
            }
            return modules.toArray(new IModule[modules.size()]);
        }
        if (JST_JCA.equals(moduleTypeId)) {
            IModule[] ms3;
            ArrayList<IModule> modules = new ArrayList<IModule>();
            IStatus status = this.canAddModule(module);
            if (status == null || status.getSeverity() == 4) {
                throw new CoreException(status);
            }
            for (IModule m : ms3 = J2EEUtil.getEnterpriseApplications((IModule)module, null)) {
                modules.add(m);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
            if (jeeModule != null && !jeeModule.isBinary()) {
                modules.add(module);
            }
            return modules.toArray(new IModule[modules.size()]);
        }
        HashSet<IModule> modules = new HashSet<IModule>();
        for (IModule m : ms = J2EEUtil.getWebModules((IModule)module, null)) {
            modules.add(m);
        }
        for (IModule m : ms = J2EEUtil.getEnterpriseApplications((IModule)module, null)) {
            modules.add(m);
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    public boolean modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        ConfigurationFile config = this.getWebSphereServer().getConfiguration();
        ConfigurationFile.Application[] appsInConfig = config.getApplications();
        for (IModule module : add) {
            SharedLibRefInfo settings;
            String moduleTypeId = module.getModuleType().getId();
            if (JST_WEB.equals(moduleTypeId)) {
                this.handleExistingAppEntryInConfigAndDropins(module, appsInConfig);
                IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, monitor);
                String contextRoot = null;
                if (webModule != null) {
                    String cn = webModule.getContextRoot();
                    if (!module.getName().equals(cn)) {
                        contextRoot = cn;
                    }
                }
                HashMap<String, String> attributes = null;
                if (contextRoot != null) {
                    attributes = new HashMap<String, String>();
                    WebSphereServerInfo serverInfo = this.getWebSphereServerInfo();
                    if (serverInfo != null && serverInfo.getSchemaHelper().isSupportedApplicationElement(WEB_APPLICATION)) {
                        attributes.put("contextRoot", contextRoot);
                    } else {
                        attributes.put("context-root", contextRoot);
                    }
                }
                if (this.shouldExcludeAddingModuleToConfig(module)) continue;
                if (SharedLibertyUtils.isWebRefSharedLibrary(module)) {
                    SharedLibRefInfo settings2 = SharedLibertyUtils.getSharedLibRefInfo(module.getProject());
                    config.addApplication(module.getName(), WEB_APPLICATION, JEEServerExtension.getModuleDeployName(module), attributes, settings2.getLibRefs(), APIVisibility.getAPIVisibilityFromProperties((Properties)settings2));
                    continue;
                }
                config.addApplication(module.getName(), WEB_APPLICATION, JEEServerExtension.getModuleDeployName(module), attributes, null, APIVisibility.getDefaults());
                continue;
            }
            if (JST_EJB.equals(moduleTypeId)) {
                this.handleExistingAppEntryInConfigAndDropins(module, appsInConfig);
                if (SharedLibertyUtils.isEJBRefSharedLibrary(module)) {
                    settings = SharedLibertyUtils.getSharedLibRefInfo(module.getProject());
                    config.addApplication(module.getName(), EJB_APPLICATION, JEEServerExtension.getModuleDeployName(module), null, settings.getLibRefs(), APIVisibility.getAPIVisibilityFromProperties((Properties)settings));
                    continue;
                }
                config.addApplication(module.getName(), EJB_APPLICATION, JEEServerExtension.getModuleDeployName(module), null, null, APIVisibility.getDefaults());
                continue;
            }
            if (JST_EAR.equals(moduleTypeId)) {
                this.handleExistingAppEntryInConfigAndDropins(module, appsInConfig);
                if (SharedLibertyUtils.isEARRefSharedLibrary(module)) {
                    settings = SharedLibertyUtils.getSharedLibRefInfo(module.getProject());
                    config.addApplication(module.getName(), EAR_APPLICATION, JEEServerExtension.getModuleDeployName(module), null, settings.getLibRefs(), APIVisibility.getAPIVisibilityFromProperties((Properties)settings));
                    continue;
                }
                config.addApplication(module.getName(), EAR_APPLICATION, JEEServerExtension.getModuleDeployName(module), null, null, APIVisibility.getDefaults());
                continue;
            }
            if (!JST_JCA.equals(moduleTypeId)) continue;
            this.handleExistingAppEntryInConfigAndDropins(module, appsInConfig);
            config.addApplication(module.getName(), RAR_APPLICATION, JEEServerExtension.getModuleDeployName(module), null, null, APIVisibility.getDefaults());
        }
        for (IModule module : remove) {
            config.removeApplication(module.getName());
        }
        return true;
    }

    private static boolean earModuleHasDD(IModule earModule) {
        if (earModule == null || earModule.getProject() == null) {
            return false;
        }
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earModule.getProject());
            if (edit.getApplication() == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return true;
    }

    private static String getContextRootFromEARWebModule(IModule earModule, IModule webModule) {
        String contextRoot = null;
        IWebModule wm = JEEServerExtension.getWebModule(webModule);
        contextRoot = wm != null && (!(wm instanceof J2EEFlexProjDeployable) || wm instanceof J2EEFlexProjDeployable && JEEServerExtension.earModuleHasDD(earModule)) ? wm.getContextRoot(earModule) : DeploymentDescriptorHelper.getWebContextRootFromEAR(DeploymentDescriptorHelper.getComponentRoot(earModule.getProject()), JEEServerExtension.getModuleDeployName(webModule));
        return contextRoot;
    }

    public URL getModuleRootURL(IModule module) {
        IModule webModule = module;
        try {
            IWebModule wm;
            IModule[] modules;
            IServer orig;
            WebSphereServer serv = this.getWebSphereServer();
            ConfigurationFile configFile = serv.getConfiguration();
            IServer server = this.getServer();
            if (server.isWorkingCopy() && (orig = ((IServerWorkingCopy)server).getOriginal()) != null) {
                server = orig;
            }
            if ((modules = server.getModules()).length == 0) {
                return null;
            }
            boolean found = false;
            IModule earModule = null;
            block2: for (IModule m : modules) {
                IModule[] childModules;
                IEnterpriseApplication ear;
                if (m.equals(webModule)) {
                    found = true;
                    break;
                }
                if (JST_WEB.equals(m.getModuleType().getId())) {
                    if (!this.isChildOfWeb(m, webModule)) continue;
                    found = true;
                    webModule = m;
                    break;
                }
                if (!JST_EAR.equals(m.getModuleType().getId()) || (ear = (IEnterpriseApplication)m.loadAdapter(IEnterpriseApplication.class, null)) == null) continue;
                for (IModule m2 : childModules = ear.getModules()) {
                    if (webModule == m2) {
                        found = true;
                        earModule = m;
                        break block2;
                    }
                    if (!JST_WEB.equals(m2.getModuleType().getId()) || !this.isChildOfWeb(m2, webModule)) continue;
                    found = true;
                    earModule = m;
                    webModule = m2;
                    break block2;
                }
            }
            if (!found) {
                return null;
            }
            String contextRoot = null;
            if (earModule != null) {
                contextRoot = JEEServerExtension.getContextRootFromEARWebModule(earModule, webModule);
            } else if (configFile != null) {
                ConfigurationFile.Application[] applications;
                for (ConfigurationFile.Application app : applications = configFile.getApplications()) {
                    if (!webModule.getName().equals(app.getName())) continue;
                    contextRoot = app.getContextRoot();
                    break;
                }
            }
            if (contextRoot == null) {
                contextRoot = DeploymentDescriptorHelper.getContextRootFromExtXml(DeploymentDescriptorHelper.getComponentRoot(webModule.getProject()));
            }
            if (contextRoot == null) {
                contextRoot = DeploymentDescriptorHelper.getContextRootFromExtXmi(DeploymentDescriptorHelper.getComponentRoot(webModule.getProject()));
            }
            if (contextRoot == null && (wm = JEEServerExtension.getWebModule(webModule)) != null) {
                contextRoot = wm.getContextRoot();
            }
            if (contextRoot == null) {
                contextRoot = webModule.getName();
            }
            String url = this.getServerBaseWebURL();
            url = contextRoot.startsWith("/") ? url + contextRoot : url + "/" + contextRoot;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return new URL(url);
        }
        catch (Exception e) {
            Trace.logError("Could not get root URL for module: " + module.getName(), e);
            return null;
        }
    }

    public boolean isPublishRequired(IModule[] modules, IResourceDelta delta) {
        String extension;
        if (modules.length == 0) {
            return false;
        }
        WebSphereServerBehaviour behaviour = (WebSphereServerBehaviour)this.getServer().loadAdapter(WebSphereServerBehaviour.class, null);
        if (behaviour == null) {
            return true;
        }
        boolean inPublishedModules = false;
        for (IModule module : modules) {
            List modulesOnServer = behaviour.getPublishedModules();
            for (IModule[] pModule : modulesOnServer) {
                String id = pModule[0].getModuleType().getId();
                if (!JST_EAR.equals(id) && !JST_WEB.equals(id) && !JST_EJB.equals(id) && !JST_UTILITY.equals(id) && !JST_JCA.equals(id) || !module.equals(pModule[pModule.length - 1])) continue;
                inPublishedModules = true;
                break;
            }
            if (inPublishedModules) break;
        }
        if (!inPublishedModules) {
            return false;
        }
        boolean looseConfig = this.getWebSphereServer().getServer().getAttribute("looseConfig", false);
        if (!looseConfig) {
            return true;
        }
        if (delta.getFullPath().segmentCount() >= 2) {
            IPath path = delta.getFullPath();
            if (path.segment(1).equalsIgnoreCase(".settings")) {
                if (delta.getFullPath().segmentCount() >= 3) {
                    return path.segment(2).equalsIgnoreCase("org.eclipse.wst.common.component");
                }
                return false;
            }
            if (path.segment(1).equalsIgnoreCase(".apt_generated")) {
                return false;
            }
        }
        if ((extension = delta.getResource().getFileExtension()) == null) {
            return true;
        }
        if (this.matchExtension(extension)) {
            return false;
        }
        return !EXT_CLASS.equalsIgnoreCase(extension) || !"debug".equals(this.getWebSphereServer().getServer().getMode());
    }

    public OutOfSyncModuleInfo checkModuleConfigOutOfSync(IModule module) {
        OutOfSyncModuleInfo info = super.checkModuleConfigOutOfSync(module);
        if (info != null) {
            return info;
        }
        ArrayList<ConfigurationFile.LibRef> addRefs = new ArrayList<ConfigurationFile.LibRef>(2);
        ArrayList<ConfigurationFile.LibRef> removeRefs = new ArrayList<ConfigurationFile.LibRef>(2);
        ArrayList<ConfigurationFile.LibRef> changeRefs = new ArrayList<ConfigurationFile.LibRef>(2);
        boolean apiVisibilityMismatch = false;
        String apiVisibility = null;
        if (this.isSharedLibUsed(module)) {
            EnumSet settingsAPIVisibility;
            ConfigurationFile configFile = this.getConfiguration();
            ConfigurationFile.Application[] apps = configFile.getApplications();
            ConfigurationFile.Application matchedApp = null;
            for (ConfigurationFile.Application app : apps) {
                if (!app.getName().equals(module.getName())) continue;
                matchedApp = app;
                break;
            }
            if (matchedApp == null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Could not find a matching application " + module.getName(), null);
                }
                return null;
            }
            SharedLibRefInfo settings = SharedLibertyUtils.getSharedLibRefInfo(module.getProject());
            List<ConfigurationFile.LibRef> moduleLibRefs = settings.getLibRefs();
            List appLibRefs = matchedApp.getSharedLibRefs();
            List<String> configSharedLibIds = this.idArrayToList(configFile.getSharedLibraryIds());
            EnumSet matchedAppAPIVisibility = matchedApp.getAPIVisibility();
            boolean bl = apiVisibilityMismatch = !matchedAppAPIVisibility.equals(settingsAPIVisibility = APIVisibility.getAPIVisibilityFromProperties((Properties)settings));
            if (apiVisibilityMismatch) {
                apiVisibility = APIVisibility.generateAttributeValue((EnumSet)settingsAPIVisibility);
            }
            if (appLibRefs == null || appLibRefs.isEmpty()) {
                if (!moduleLibRefs.isEmpty()) {
                    addRefs.addAll(moduleLibRefs);
                }
            } else {
                addRefs.addAll(moduleLibRefs);
                for (ConfigurationFile.LibRef ref : appLibRefs) {
                    int index = ConfigurationFile.LibRef.getListIndex(moduleLibRefs, (String)ref.id);
                    if (index >= 0) {
                        addRefs.remove(moduleLibRefs.get(index));
                        if (ref.type == moduleLibRefs.get((int)index).type) continue;
                        changeRefs.add(ref);
                        continue;
                    }
                    if (configSharedLibIds.contains(ref.id)) continue;
                    removeRefs.add(ref);
                }
            }
        }
        if (addRefs.isEmpty() && removeRefs.isEmpty() && changeRefs.isEmpty() && !apiVisibilityMismatch) {
            return null;
        }
        return new OutOfSyncModuleLibRefInfo(this.refListToString(addRefs), this.refListToString(removeRefs), this.refListToString(changeRefs), apiVisibility);
    }

    private List<String> idArrayToList(String[] ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        ArrayList<String> idList = new ArrayList<String>(ids.length);
        for (String id : ids) {
            idList.add(id);
        }
        return idList;
    }

    private boolean isSharedLibUsed(IModule module) {
        String moduleTypeId = module.getModuleType().getId();
        if (JST_WEB.equals(moduleTypeId)) {
            return SharedLibertyUtils.isWebRefSharedLibrary(module);
        }
        if (JST_EAR.equals(moduleTypeId)) {
            return SharedLibertyUtils.isEARRefSharedLibrary(module);
        }
        return false;
    }

    private String refListToString(List<ConfigurationFile.LibRef> refList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ConfigurationFile.LibRef ref : refList) {
            if (ref.id.trim().isEmpty()) continue;
            if (first) {
                sb.append(ref.id);
                first = false;
                continue;
            }
            sb.append(',').append(ref.id);
        }
        return sb.toString();
    }

    private boolean matchExtension(String inS) {
        for (String s : staticExtension) {
            if (!s.equalsIgnoreCase(inS)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<IModule> getWebRootModules(IModule webModule) throws CoreException {
        IModule[] ms;
        ArrayList<IModule> roots = new ArrayList<IModule>();
        IStatus status = this.canAddModule(webModule);
        if (status == null || status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        for (IModule m : ms = J2EEUtil.getEnterpriseApplications((IModule)webModule, null)) {
            roots.add(m);
        }
        IJ2EEModule jeeModule = (IJ2EEModule)webModule.loadAdapter(IJ2EEModule.class, null);
        if (jeeModule != null && !jeeModule.isBinary()) {
            roots.add(webModule);
        }
        return roots;
    }

    private ArrayList<IModule> getEJBRootModules(IModule ejbModule) throws CoreException {
        IJ2EEModule jeeModule;
        IModule[] ms;
        IStatus status = this.canAddModule(ejbModule);
        if (status == null || status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        ArrayList<IModule> roots = new ArrayList<IModule>();
        for (IModule m : ms = J2EEUtil.getEnterpriseApplications((IModule)ejbModule, null)) {
            roots.add(m);
        }
        WebSphereServerInfo serverInfo = this.getWebSphereServerInfo();
        if (serverInfo != null && serverInfo.getSchemaHelper().isSupportedApplicationElement(EJB_APPLICATION) && (jeeModule = (IJ2EEModule)ejbModule.loadAdapter(IJ2EEModule.class, null)) != null && !jeeModule.isBinary()) {
            roots.add(ejbModule);
        }
        return roots;
    }

    private boolean isChildOfWeb(IModule webModule, IModule child) {
        IWebModule web = (IWebModule)webModule.loadAdapter(IWebModule.class, null);
        if (web != null) {
            IModule[] children;
            for (IModule m : children = web.getModules()) {
                if (!m.equals(child)) continue;
                return true;
            }
        }
        return false;
    }

    private static IWebModule getWebModule(IModule module) {
        return JEEServerExtension.isWebModule(module) ? (IWebModule)module.loadAdapter(IWebModule.class, null) : null;
    }

    private static boolean isWebModule(IModule module) {
        if (module == null) {
            return false;
        }
        return JST_WEB.equals(module.getModuleType().getId());
    }

    static class OutOfSyncModuleLibRefInfo
    extends OutOfSyncModuleInfo {
        private final String addIds;
        private final String removeIds;
        private final String changeIds;
        private final String apiVisibility;

        OutOfSyncModuleLibRefInfo(String addIds, String removeIds, String changeIds, String apiVisibility) {
            super(OutOfSyncModuleInfo.Type.SHARED_LIB_REF_MISMATCH);
            this.addIds = addIds;
            this.removeIds = removeIds;
            this.changeIds = changeIds;
            this.apiVisibility = apiVisibility;
        }

        public String getPropertyValue(OutOfSyncModuleInfo.Property key) {
            if (key == OutOfSyncModuleInfo.Property.LIB_REF_IDS_ADD) {
                return this.addIds;
            }
            if (key == OutOfSyncModuleInfo.Property.LIB_REF_IDS_REMOVE) {
                return this.removeIds;
            }
            if (key == OutOfSyncModuleInfo.Property.LIB_REF_IDS_CHANGE) {
                return this.changeIds;
            }
            if (key == OutOfSyncModuleInfo.Property.LIB_REF_API_VISIBILITY) {
                return this.apiVisibility;
            }
            return super.getPropertyValue(key);
        }
    }
}

