/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.ApplicationPublisher;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.PublishUnit;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.looseconfig.DeploymentAssemblyUtil;
import com.ibm.ws.st.jee.core.internal.JEEServerExtension;
import com.ibm.ws.st.jee.core.internal.Messages;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.PublishHelper;

public class JEEPublisher
extends ApplicationPublisher {
    private static final String JST_WEB = "jst.web";
    private static final String JST_EAR = "jst.ear";
    private static final String JST_UTILITY = "jst.utility";
    private static final String JST_WEBFRAGMENT = "jst.webfragment";
    private static final String JST_EJB = "jst.ejb";
    private static final String JST_JCA = "jst.connector";
    private static final String JST_APPCLIENT = "jst.appclient";
    private Properties moduleURICachedMap = null;
    private static String MODULE_URI_CACHE_FILE_NAME = "jeeModuleUri.map";

    private void loadModuleURICache() {
        if (this.moduleURICachedMap == null) {
            this.moduleURICachedMap = new Properties();
        }
        IPath filePath = this.getWebSphereServerBehaviour().getTempDirectory().append(MODULE_URI_CACHE_FILE_NAME);
        FileUtil.loadProperties((Properties)this.moduleURICachedMap, (IPath)filePath);
    }

    private IPath getDeployPath(IModule[] module, boolean shared) {
        IPath overridePath;
        WebSphereServerBehaviour webSphereServerBehaviour = this.getWebSphereServerBehaviour();
        IPath path = webSphereServerBehaviour.getRootPublishFolder(shared);
        if (this.isLooseConfig() && (overridePath = this.getAppsPathOverride()) != null) {
            path = overridePath;
        }
        if (module.length == 0) {
            return path;
        }
        IJ2EEModule jeeModule = (IJ2EEModule)module[module.length - 1].loadAdapter(IJ2EEModule.class, null);
        String moduleTypeId = module[module.length - 1].getModuleType().getId();
        if (module.length >= 2 && (jeeModule != null && jeeModule.isBinary() || JST_UTILITY.equals(moduleTypeId) || JST_WEBFRAGMENT.equals(moduleTypeId))) {
            String uri = this.getModuleURI(module);
            IModule[] parentModule = new IModule[module.length - 1];
            for (int i = 0; i < parentModule.length; ++i) {
                parentModule[i] = module[i];
            }
            IPath parentPath = this.getDeployPath(parentModule, false);
            if (uri == null) {
                if (this.moduleURICachedMap == null) {
                    this.loadModuleURICache();
                }
                uri = this.moduleURICachedMap.getProperty(FileUtil.genModuleURICacheKey((IModule[])module));
            }
            if (uri == null) {
                Trace.logError("Can't get the module uri of " + module[module.length - 1].getName(), null);
                uri = module[module.length - 1].getName();
            }
            path = parentPath.append(uri);
        } else if (module.length >= 2) {
            IModule[] parentModule = new IModule[module.length - 1];
            for (int i = 0; i < parentModule.length; ++i) {
                parentModule[i] = module[i];
            }
            IPath parentPath = this.getDeployPath(parentModule, false);
            IProject parentProject = parentModule[parentModule.length - 1].getProject();
            String targetInArchive = DeploymentAssemblyUtil.getDeployPath((IProject)parentProject, (String)module[module.length - 1].getName());
            path = targetInArchive != null ? parentPath.append(targetInArchive) : parentPath.append(this.getModuleDeployName(module[module.length - 1]));
        } else {
            for (IModule m : module) {
                path = path.append(this.getModuleDeployName(m));
            }
        }
        return path;
    }

    private String getModuleURI(IModule[] module) {
        if (module == null || module.length < 2) {
            return null;
        }
        if (JST_EAR.equals(module[0].getModuleType().getId())) {
            IEnterpriseApplication ear = (IEnterpriseApplication)module[module.length - 2].loadAdapter(IEnterpriseApplication.class, null);
            if (ear != null) {
                return ear.getURI(module[module.length - 1]);
            }
        } else {
            IWebModule web = (IWebModule)module[module.length - 2].loadAdapter(IWebModule.class, null);
            if (web != null) {
                return web.getURI(module[module.length - 1]);
            }
        }
        return null;
    }

    protected IStatus publishModule(int kind, PublishUnit unit, IProgressMonitor monitor) {
        int appChangeKind;
        IModule[] module = unit.getModule();
        int size = module.length;
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (1 == unit.getDeltaKind()) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Module added: " + unit.getModuleName());
            }
            this.cacheModuleURI(module);
        }
        if (!this.isLooseConfig()) {
            PublishHelper helper = new PublishHelper(this.getWebSphereServer().getWorkAreaTempPath().toFile());
            String moduleTypeId = module[size - 1].getModuleType().getId();
            IJ2EEModule jeeModule = (IJ2EEModule)module[size - 1].loadAdapter(IJ2EEModule.class, monitor);
            if (JST_EAR.equals(moduleTypeId)) {
                this.publishDir(kind, unit.getDeltaKind(), module, this.getDeployPath(module, false), helper, status, monitor);
            } else if (JST_WEB.equals(moduleTypeId) || JST_EJB.equals(moduleTypeId) || JST_WEBFRAGMENT.equals(moduleTypeId) || JST_JCA.equals(moduleTypeId) || JST_APPCLIENT.equals(moduleTypeId)) {
                if (jeeModule != null) {
                    if (jeeModule.isBinary() || JST_WEBFRAGMENT.equals(moduleTypeId)) {
                        this.publishJar(kind, unit.getDeltaKind(), module, jeeModule.isBinary(), helper, status, monitor);
                    } else {
                        this.publishDir(kind, unit.getDeltaKind(), module, this.getDeployPath(module, false), helper, status, monitor);
                    }
                } else if (module[size - 1] instanceof DeletedModule) {
                    boolean skipDelete = false;
                    PublishUnit parent = unit.getParent();
                    if (parent != null) {
                        for (PublishUnit sibling : parent.getChildren()) {
                            if (sibling.getModule().length != size || sibling.getModule()[size - 1] == module[size - 1] || !this.getModuleDeployName(sibling.getModule()[size - 1]).equals(this.getModuleDeployName(module[size - 1])) || sibling.getDeltaKind() == 3) continue;
                            skipDelete = true;
                            break;
                        }
                    }
                    if (!skipDelete) {
                        this.deleteModuleResourcesFromServer(module, helper, status, monitor);
                    }
                }
            } else if (module.length > 1 && JST_UTILITY.equals(moduleTypeId)) {
                if (jeeModule != null && jeeModule.isBinary()) {
                    this.publishJar(kind, unit.getDeltaKind(), module, true, helper, status, monitor);
                } else {
                    this.publishJar(kind, unit.getDeltaKind(), module, false, helper, status, monitor);
                }
            }
        }
        if ((appChangeKind = this.getApplicationChangeKind(unit)) != 1 && appChangeKind != 3 && unit.getDeltaKind() != 0) {
            this.computeModuleDelta(module, unit.getDeltaKind());
        }
        if (3 == unit.getDeltaKind()) {
            this.removeCachedModuleURI(module);
        }
        return JEEPublisher.combineModulePublishStatus(status, (String)module[size - 1].getName());
    }

    private void deleteModuleResourcesFromServer(IModule[] module, PublishHelper helper, List<IStatus> status, IProgressMonitor monitor) {
        IPath path = this.getDeployPath(module, false);
        File file = path.toFile();
        if (file.exists()) {
            if (file.isFile()) {
                if (!file.delete()) {
                    status.add((IStatus)new Status(4, "com.ibm.ws.st.jee.core", NLS.bind((String)Messages.errorDeleteFile, (Object)path.toOSString())));
                    return;
                }
            } else {
                IStatus[] stat = PublishHelper.deleteDirectory((File)file, (IProgressMonitor)monitor);
                JEEPublisher.addArrayStatusToList(status, (IStatus[])stat);
            }
        }
    }

    private void cacheModuleURI(IModule[] module) {
        if (module == null || module.length == 1) {
            return;
        }
        if (this.moduleURICachedMap == null) {
            this.loadModuleURICache();
        }
        String key = FileUtil.genModuleURICacheKey((IModule[])module);
        String uri = this.getModuleURI(module);
        if (uri != null) {
            this.moduleURICachedMap.put(key, uri);
        } else {
            Trace.logError("Can't get the uri for module:" + key, null);
        }
    }

    private void removeCachedModuleURI(IModule[] module) {
        if (module == null || module.length == 1) {
            return;
        }
        if (this.moduleURICachedMap == null) {
            this.loadModuleURICache();
        }
        String key = FileUtil.genModuleURICacheKey((IModule[])module);
        this.moduleURICachedMap.remove(key);
    }

    private void computeModuleDelta(IModule[] module, int deltaKind) {
        IModuleResourceDelta[] rDeltas;
        IPath deployPath = null;
        boolean isLooseConfig = this.isLooseConfig();
        if (deltaKind == 3 && module.length != 1 && isLooseConfig) {
            return;
        }
        if (!isLooseConfig) {
            deployPath = this.getDeployPath(module, false);
        }
        if (!isLooseConfig && deployPath != null) {
            if (deltaKind == 1) {
                this.getAddedResourceList().add(deployPath.toOSString());
            } else if (deltaKind == 3) {
                this.getRemovedResourceList().add(deployPath.toOSString());
            }
        }
        if ((rDeltas = this.getWebSphereServerBehaviour().getPublishedResourceDelta(module)) != null && rDeltas.length != 0) {
            String moduleTypeId = module[module.length - 1].getModuleType().getId();
            if (!isLooseConfig && (JST_UTILITY.equals(moduleTypeId) || JST_WEBFRAGMENT.equals(moduleTypeId))) {
                this.getChangedResourceList().add(this.getDeployPath(module, false).toOSString());
            } else {
                IJ2EEModule jeeModule;
                if (!isLooseConfig && (jeeModule = (IJ2EEModule)module[module.length - 1].loadAdapter(IJ2EEModule.class, null)) != null && jeeModule.isBinary() && deployPath != null && deployPath.segmentCount() > 1) {
                    deployPath = deployPath.removeLastSegments(1);
                }
                this.computeDeltaResources(deployPath, rDeltas);
            }
        }
    }

    private void publishJar(int kind, int deltaKind, IModule[] module, boolean isBinary, PublishHelper helper, List<IStatus> status, IProgressMonitor monitor) {
        IPath folder;
        File dir;
        IModuleResourceDelta[] delta;
        IPath path = this.getDeployPath(module, false);
        WebSphereServer serv = this.getWebSphereServer();
        if (kind == 4 || deltaKind == 3 || !serv.isPublishToRuntime()) {
            File file = path.toFile();
            if (file.exists() && file.isFile() && !file.delete()) {
                status.add((IStatus)new Status(4, "com.ibm.ws.st.jee.core", NLS.bind((String)Messages.errorDeleteFile, (Object)path.toOSString())));
                return;
            }
            if (deltaKind == 3 || !serv.isPublishToRuntime()) {
                return;
            }
        }
        WebSphereServerBehaviour servBehaviour = this.getWebSphereServerBehaviour();
        if (kind != 4 && kind != 2 && ((delta = servBehaviour.getPublishedResourceDelta(module)) == null || delta.length == 0)) {
            return;
        }
        if (path.segmentCount() > 1 && !(dir = (folder = path.removeLastSegments(1)).toFile()).exists() && !dir.mkdirs()) {
            status.add((IStatus)new Status(4, "com.ibm.ws.st.jee.core", NLS.bind((String)Messages.errorCreateFolder, (Object)folder.toOSString())));
            return;
        }
        if (monitor.isCanceled()) {
            status.add(Status.CANCEL_STATUS);
            return;
        }
        File dir2 = path.toFile();
        if (dir2.exists() && dir2.isDirectory()) {
            PublishHelper.deleteDirectory((File)dir2, null);
        }
        IModuleResource[] mr = servBehaviour.getResources(module);
        IStatus[] stat = isBinary ? helper.publishToPath(mr, path, monitor) : helper.publishZip(mr, path, monitor);
        JEEPublisher.addArrayStatusToList(status, (IStatus[])stat);
    }

    public void prePublishApplication(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        IModule[] module = unit.getModule();
        if (module.length == 1 && unit.getDeltaKind() == 1) {
            String appName = module[0].getName();
            if (this.getWebSphereServerBehaviour().getOverriddenAppsInServerXML().contains(appName) || this.getWebSphereServerBehaviour().getOverriddenDropinsApps().contains(appName)) {
                this.removeExternalAppFiles(module[0], NLS.bind((String)Messages.taskRemoveExteneralApp, (Object)appName), monitor);
            }
        }
        this.clearAddedResourceList();
        this.clearRemovedResourceList();
        this.clearChangedResourceList();
    }

    public void postPublishApplication(int kind, PublishUnit app, MultiStatus status, IProgressMonitor monitor) {
        super.postPublishApplication(kind, app, status, monitor);
        if (this.moduleURICachedMap == null) {
            return;
        }
        IPath filePath = this.getWebSphereServerBehaviour().getTempDirectory().append(MODULE_URI_CACHE_FILE_NAME);
        FileUtil.saveCachedProperties((Properties)this.moduleURICachedMap, (IPath)filePath);
    }

    protected String getModuleDeployName(IModule module) {
        return JEEServerExtension.getModuleDeployName(module);
    }

    public boolean requireConsoleOutputBeforePublishComplete(int kind, PublishUnit unit, MultiStatus status, IProgressMonitor monitor) {
        int kind2 = unit.getDeltaKind();
        if (kind2 == 1 || kind2 == 3) {
            return true;
        }
        if (this.getAddedResourceList().isEmpty() && this.getRemovedResourceList().isEmpty() && this.getChangedResourceList().isEmpty()) {
            return false;
        }
        return this.checkFileExtension(this.getAddedResourceList()) || this.checkFileExtension(this.getChangedResourceList()) || this.checkFileExtension(this.getRemovedResourceList());
    }
}

